<?php
/**
 * Title Shortcode
 */

if( !function_exists( 'zuperla_ext_vce_title_shortcode' ) ) {

	function zuperla_ext_vce_title_shortcode( $atts, $content ) {

		$output = $data = $el_class = '';

		extract(
			shortcode_atts(
				array(
					'title' => '',
					'heading_tag' => 'h3',
					'heading' => 'h3',
					'custom_font_family' => '',
					'gradient_color' => '',
					'gradient_color_1' => 'primary-1',
					'gradient_color_2' => 'primary-2',
					'increase_heading' => '100',
					'line_type' => 'no-line',
					'line_width' => '50',
					'line_height' => '2',
					'line_color' => 'primary-1',
					'inherit_align' => 'inherit',
					'animation' => '',
					'animation_delay' => '200',
					'animation_duration' => 'normal',
					'margin_bottom' => '',
					'el_class' => '',
				),
				$atts
			)
		);

		$style = zuperla_ext_vce_build_margin_bottom_style( $margin_bottom );

		$title_classes = array( 'eut-element', 'eut-title' );

		array_push( $title_classes, 'eut-align-' . $inherit_align );

		if ( !empty( $animation ) ) {
			array_push( $title_classes, 'eut-animated-item' );
			array_push( $title_classes, $animation);
			array_push( $title_classes, 'eut-duration-' . $animation_duration );
			$data = ' data-delay="' . esc_attr( $animation_delay ) . '"';
		}

		if ( !empty( $heading ) ) {
			array_push( $title_classes, 'eut-' . $heading );
		}

		if ( !empty( $custom_font_family ) ) {
			array_push( $title_classes, 'eut-' . $custom_font_family );
		}

		if ( !empty( $el_class ) ) {
			array_push( $title_classes, $el_class );
		}

		if( '100' != $increase_heading ){
			array_push( $title_classes, 'eut-increase-heading' );
			array_push( $title_classes, 'eut-heading-' . $increase_heading );
		}

		if ( !empty( $gradient_color ) ) {
			$uid = uniqid();
			array_push( $title_classes, 'eut-title-gradient' );
			array_push( $title_classes, 'eut-title-' . $uid );

			$colors = array();
			if ( function_exists( 'zuperla_eutf_get_color_array' ) ) {
				$colors = zuperla_eutf_get_color_array();
			}

			$gradient_color_1 = zuperla_ext_vce_array_value( $colors, $gradient_color_1, '#000000');
			$gradient_color_2 = zuperla_ext_vce_array_value( $colors, $gradient_color_2, '#000000');

			$gradient_css = array();
			$gradient_css[] = 'color: ' . esc_attr( $gradient_color_1 );
			$gradient_css[] = 'background-image: -moz-linear-gradient(-45deg, ' . esc_attr( $gradient_color_1 ) . ' 0%, ' . esc_attr( $gradient_color_2 ) . ' 100%)';
			$gradient_css[] = 'background-image: -webkit-linear-gradient(-45deg, ' . esc_attr( $gradient_color_1 ) . ' 0%, ' . esc_attr( $gradient_color_2 ) . ' 100%)';
			$gradient_css[] = 'background-image: linear-gradient(135deg, ' . esc_attr( $gradient_color_1 ) . ' 0%, ' . esc_attr( $gradient_color_2 ) . ' 100%)';

			$output .= '<style type="text/css">';
			$output .= '.eut-title-gradient.eut-title-' . $uid . ' > span {';
			$output .= implode( ';', $gradient_css ) . ';';
			$output .= '}';
			$output .= '</style>';
		}

		$title_class_string = implode( ' ', $title_classes );

		$output .= '<' . tag_escape( $heading_tag ) . ' class="' . esc_attr( $title_class_string ) . '" style="' . $style . '"' . $data . '>';
		$output .= '<span>';
		$output .= zuperla_ext_vce_auto_br( $content );
		if( 'line' == $line_type ) {
			$line_style = '';
			$line_style .= 'width: '.(preg_match('/(px|em|\%|pt|cm)$/', $line_width) ? $line_width : $line_width.'px').';';
			$line_style .= 'height: '. $line_height. 'px;';
			$output .= '<span class="eut-title-line eut-bg-' . esc_attr( $line_color ) . '" style="' . esc_attr( $line_style ) . '"></span>';
		}
		$output .= '</span>';
		$output .= '</' . tag_escape( $heading_tag ) . '>';

		return $output;
	}
	add_shortcode( 'zuperla_title', 'zuperla_ext_vce_title_shortcode' );

}

/**
 * Add shortcode to Visual Composer
 */

if( !function_exists( 'zuperla_ext_vce_title_shortcode_params' ) ) {
	function zuperla_ext_vce_title_shortcode_params( $tag ) {
		return array(
			"name" => esc_html__( "Title", "zuperla-extension" ),
			"description" => esc_html__( "Add a title in many and diverse ways", "zuperla-extension" ),
			"base" => $tag,
			"class" => "",
			"icon"      => "icon-wpb-eut-title",
			"category" => esc_html__( "Content", "js_composer" ),
			"params" => array(
				array(
					"type" => "textarea_html",
					"heading" => esc_html__( "Title Content", "zuperla-extension" ),
					"param_name" => "content",
					"value" => "Sample Title",
					"description" => esc_html__( "Enter your title here.", "zuperla-extension" ),
					"save_always" => true,
					"admin_label" => true,
				),
				zuperla_ext_vce_get_heading_tag( "h3" ),
				zuperla_ext_vce_get_heading( "h3" ),
				zuperla_ext_vce_get_heading_increase(),
				zuperla_ext_vce_get_custom_font_family(),
				zuperla_ext_vce_get_gradient_color(),
				zuperla_ext_vce_get_gradient_color_1(),
				zuperla_ext_vce_get_gradient_color_2(),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Line type", "zuperla-extension" ),
					"param_name" => "line_type",
					"value" => array(
						esc_html__( "No Line", "zuperla-extension" ) => 'no-line',
						esc_html__( "With Line", "zuperla-extension" ) => 'line',
					),
					"description" => '',
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Line Width", "zuperla-extension" ),
					"param_name" => "line_width",
					"value" => "50",
					"description" => esc_html__( "Enter the width for your line (Note: CSS measurement units allowed).", "zuperla-extension" ),
					"dependency" => array( 'element' => "line_type", 'value' => array( 'line' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Line Height", "zuperla-extension" ),
					"param_name" => "line_height",
					"value" => "2",
					"std" => "2",
					"value" => array( '1', '2', '3', '4' , '5', '6', '7', '8', '9' , '10' ),
					"description" => esc_html__( "Enter the hight for your line in px.", "zuperla-extension" ),
					"dependency" => array( 'element' => "line_type", 'value' => array( 'line' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Line Color", "zuperla-extension" ),
					"param_name" => "line_color",
					"param_holder_class" => "eut-colored-dropdown",
					"value" => array(
						esc_html__( "Primary 1", "zuperla-extension" ) => 'primary-1',
						esc_html__( "Primary 2", "zuperla-extension" ) => 'primary-2',
						esc_html__( "Primary 3", "zuperla-extension" ) => 'primary-3',
						esc_html__( "Primary 4", "zuperla-extension" ) => 'primary-4',
						esc_html__( "Primary 5", "zuperla-extension" ) => 'primary-5',
						esc_html__( "Primary 6", "zuperla-extension" ) => 'primary-6',
						esc_html__( "Green", "zuperla-extension" ) => 'green',
						esc_html__( "Orange", "zuperla-extension" ) => 'orange',
						esc_html__( "Red", "zuperla-extension" ) => 'red',
						esc_html__( "Blue", "zuperla-extension" ) => 'blue',
						esc_html__( "Aqua", "zuperla-extension" ) => 'aqua',
						esc_html__( "Purple", "zuperla-extension" ) => 'purple',
						esc_html__( "Black", "zuperla-extension" ) => 'black',
						esc_html__( "Grey", "zuperla-extension" ) => 'grey',
						esc_html__( "White", "zuperla-extension" ) => 'white',
					),
					"description" => esc_html__( "Color for the line.", "zuperla-extension" ),
					"dependency" => array( 'element' => "line_type", 'value' => array( 'line' ) ),
				),
				zuperla_ext_vce_add_inherit_align(),
				zuperla_ext_vce_add_animation(),
				zuperla_ext_vce_add_animation_delay(),
				zuperla_ext_vce_add_animation_duration(),
				zuperla_ext_vce_add_margin_bottom(),
				zuperla_ext_vce_add_el_class(),
			),
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'zuperla_title', 'zuperla_ext_vce_title_shortcode_params' );
} else if( function_exists( 'vc_map' ) ) {
	$attributes = zuperla_ext_vce_title_shortcode_params( 'zuperla_title' );
	vc_map( $attributes );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
