<?php
/**
 * Testimonial Shortcode
 */

if( !function_exists( 'zuperla_ext_vce_testimonial_shortcode' ) ) {

	function zuperla_ext_vce_testimonial_shortcode( $attr, $content ) {

		$allow_filter = $class_fullwidth = $slider_data = $output = $el_class = '';

		extract(
			shortcode_atts(
				array(
					'categories' => '',
					'exclude_posts' => '',
					'include_posts' => '',
					'testimonial_mode' => 'carousel',
					'zuperla_image_mode' => 'portrait',
					'columns_large_screen' => '3',
					'columns' => '3',
					'columns_tablet_landscape' => '2',
					'columns_tablet_portrait' => '2',
					'columns_mobile' => '1',
					'item_gutter' => 'yes',
					'gutter_size' => '40',
					'items_to_show' => '20',
					'order_by' => 'date',
					'order' => 'DESC',
					'disable_pagination' => '',
					'show_image' => 'no',
					'margin_bottom' => '',
					'slideshow_speed' => '3000',
					'pagination_speed' => '400',
					'carousel_pagination' => 'yes',
					'pagination_color' => 'dark',
					'transition' => 'slide',
					'auto_play' => 'yes',
					'pause_hover' => 'no',
					'auto_height' => 'no',
					'animation' => 'eut-zoom-in',
					'align' => 'left',
					'text_style' => 'none',
					'content_bg' => 'white',
					'el_class' => '',
				),
				$attr
			)
		);

		$testimonial_classes = array( 'eut-element', 'eut-testimonial' );

		$style = zuperla_ext_vce_build_margin_bottom_style( $margin_bottom );

		$data_string = '';

		switch( $testimonial_mode ) {
			case 'masonry':
				$data_string = ' data-columns="' . esc_attr( $columns ) . '" data-columns-large-screen="' . esc_attr( $columns_large_screen ) . '" data-columns-tablet-landscape="' . esc_attr( $columns_tablet_landscape ) . '" data-columns-tablet-portrait="' . esc_attr( $columns_tablet_portrait ) . '" data-columns-mobile="' . esc_attr( $columns_mobile ) . '" data-layout="masonry"';
				if ( 'yes' == $item_gutter ) {
					$data_string .= ' data-gutter-size="' . esc_attr( $gutter_size ) . '"';
				}
				if ( 'yes' == $item_gutter ) {
					array_push( $testimonial_classes, 'eut-with-gap' );
				}
				array_push( $testimonial_classes, 'eut-layout-3' );
				array_push( $testimonial_classes, 'eut-isotope' );
				break;
			case 'zuperla-style':
				$data_string = ' data-slider-autoplay="' . esc_attr( $auto_play ) . '" data-slider-speed="' . esc_attr( $slideshow_speed ) . '" data-slider-pause="' . esc_attr( $pause_hover ) . '" data-pagination-speed="' . esc_attr( $pagination_speed ) . '"';
				$data_string .= ' data-pagination="' . esc_attr( $carousel_pagination ) . '"';
				array_push( $testimonial_classes, 'eut-layout-2' );
				array_push( $testimonial_classes, 'eut-paraller-wrapper' );
				array_push( $testimonial_classes, 'eut-carousel-pagination-1' );
				array_push( $testimonial_classes, 'eut-carousel-element' );
				array_push( $testimonial_classes, 'owl-carousel' );
				$disable_pagination = 'yes';
				break;
			case 'carousel':
			default:
				$data_string = ' data-slider-transition="' . esc_attr( $transition ) . '" data-slider-autoplay="' . esc_attr( $auto_play ) . '" data-slider-speed="' . esc_attr( $slideshow_speed ) . '" data-slider-pause="' . esc_attr( $pause_hover ) . '" data-pagination-speed="' . esc_attr( $pagination_speed ) . '" data-slider-autoheight="' . esc_attr( $auto_height ) . '"';
				$data_string .= ' data-pagination="' . esc_attr( $carousel_pagination ) . '"';
				$data_string .= ' data-pagination-color="' . esc_attr( $pagination_color ) . '"';
				array_push( $testimonial_classes, 'eut-carousel-element' );
				array_push( $testimonial_classes, 'owl-carousel' );
				array_push( $testimonial_classes, 'eut-layout-1' );
				array_push( $testimonial_classes, 'eut-align-' . $align );
				if ( 'none' != $text_style ) {
					array_push( $testimonial_classes, 'eut-' . $text_style );
				}
				array_push( $testimonial_classes, 'eut-carousel-pagination-1' );
				$disable_pagination = 'yes';
				break;

		}

		if ( !empty ( $el_class ) ) {
			array_push( $testimonial_classes, $el_class);
		}

		$testimonial_class_string = implode( ' ', $testimonial_classes );

		$testimonial_cat = "";

		if ( !empty( $categories ) ) {
			$testimonial_category_list = explode( ",", $categories );
			foreach ( $testimonial_category_list as $testimonial_list ) {
				$testimonial_term = get_term( $testimonial_list, 'testimonial_category' );
				$testimonial_cat = $testimonial_cat.$testimonial_term->slug . ', ';
			}
		}

		$paged = 1;

		if ( 'yes' != $disable_pagination ) {
			if ( get_query_var( 'paged' ) ) {
				$paged = get_query_var( 'paged' );
			} elseif ( get_query_var( 'page' ) ) {
				$paged = get_query_var( 'page' );
			}
		}

		$exclude_ids = array();
		if( !empty( $exclude_posts ) ){
			$exclude_ids = explode( ',', $exclude_posts );
		}

		$include_ids = array();
		if( !empty( $include_posts ) ){
			$include_ids = explode( ',', $include_posts );
			$args = array(
				'post_type' => 'testimonial',
				'post_status'=>'publish',
				'paged' => $paged,
				'post__in' => $include_ids,
				'posts_per_page' => $items_to_show,
				'orderby' => $order_by,
				'order' => $order,
			);
		} else {
			$args = array(
				'post_type' => 'testimonial',
				'post_status'=>'publish',
				'paged' => $paged,
				'testimonial_category' => $testimonial_cat,
				'post__not_in' => $exclude_ids,
				'posts_per_page' => $items_to_show,
				'orderby' => $order_by,
				'order' => $order,
			);
		}

		$image_size = 'thumbnail';

		$query = new WP_Query( $args );

		ob_start();

		if ( $query->have_posts() ) :

		?>
			<div class="<?php echo esc_attr( $testimonial_class_string ); ?>" style="<?php echo $style; ?>"<?php echo $data_string; ?>>

				<?php if ( 'masonry' == $testimonial_mode ) { ?>
				<div class="eut-isotope-container">
				<?php } ?>

		<?php
		while ( $query->have_posts() ) : $query->the_post();


		$name =  zuperla_ext_vce_post_meta( '_zuperla_eutf_testimonial_name' );
		$identity =  zuperla_ext_vce_post_meta( '_zuperla_eutf_testimonial_identity' );

		if ( !empty( $name ) && !empty( $identity ) ) {
			$identity = ' - ' . $identity;
		}

			if ( 'carousel' == $testimonial_mode ) {
		?>
				<div <?php post_class( 'eut-testimonial-element' ); ?>>
					<?php if ( 'yes' == $show_image && has_post_thumbnail() ) { ?>
							<div class="eut-testimonial-thumb"><?php the_post_thumbnail( $image_size ); ?></div>
					<?php } ?>
					<div class="eut-testimonial-content">
						<?php the_content(); ?>
						<?php if ( !empty( $name ) || !empty( $identity ) ) { ?>
						<div class="eut-small-text eut-heading-color eut-testimonial-name"><?php echo esc_html( $name ); ?><span class="eut-identity"><?php echo esc_html( $identity ); ?></span></div>
						<?php } ?>
					</div>
				</div>
		<?php
			} else if ( 'masonry' == $testimonial_mode ) {

		?>
				<div <?php post_class( 'eut-isotope-item eut-testimonial-item' ); ?>>
					<div class="eut-isotope-item-inner <?php echo esc_attr( $animation ); ?>">
						<div class="eut-testimonial-element eut-box-item eut-bg-<?php echo esc_attr( $content_bg ); ?>">
							<div class="eut-testimonial-content">
								<?php the_content(); ?>
							</div>
							<div class="eut-testimonial-author">
								<?php if ( 'yes' == $show_image && has_post_thumbnail() ) { ?>
										<div class="eut-testimonial-thumb"><?php the_post_thumbnail( $image_size ); ?></div>
								<?php } ?>
								<?php if ( !empty( $name ) || !empty( $identity ) ) { ?>
								<div class="eut-small-text eut-heading-color eut-testimonial-name"><?php echo esc_html( $name ); ?><span class="eut-text-primary-1"><?php echo esc_html( $identity ); ?></span></div>
								<?php } ?>
							</div>
						</div>
					</div>
				</div>

		<?php
			} else {
				$image_size = zuperla_ext_vce_get_image_size( $zuperla_image_mode );
		?>
				<div <?php post_class( 'eut-testimonial-element' ); ?>>
					<div class="eut-testimonial-thumb">
					<?php
						if( has_post_thumbnail() ) {
							the_post_thumbnail( $image_size );
						} else {
							echo zuperla_ext_vce_get_fallback_image( $image_size );
						}
					?>
					</div>
					<i class="eut-testimonial-icon eut-icon-quote eut-bg-primary-1 eut-paraller" data-limit="2x"></i>
					<div class="eut-testimonial-content eut-box-item eut-bg-<?php echo esc_attr( $content_bg ); ?> eut-paraller" data-limit="1x">
						<?php the_content(); ?>
						<?php if ( !empty( $name ) || !empty( $identity ) ) { ?>
						<div class="eut-small-text eut-heading-color eut-testimonial-name"><?php echo esc_html( $name ); ?><span class="eut-text-primary-1"><?php echo esc_html( $identity ); ?></span></div>
						<?php } ?>
					</div>
				</div>
		<?php
			}

		endwhile;

		?>
				<?php if ( 'masonry' == $testimonial_mode ) { ?>
				</div>
				<?php } ?>
<?php
			if ( 'yes' != $disable_pagination ) {
				$total = $query->max_num_pages;
				$big = 999999999; // need an unlikely integer
				if( $total > 1 )  {
					 echo '<div class="eut-pagination eut-pagination-text eut-heading-color">';

					 if( get_option('permalink_structure') ) {
						 $format = 'page/%#%/';
					 } else {
						 $format = '&paged=%#%';
					 }
					 echo paginate_links(array(
						'base'			=> str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
						'format'		=> $format,
						'current'		=> max( 1, $paged ),
						'total'			=> $total,
						'mid_size'		=> 2,
						'type'			=> 'list',
						'prev_text'	=> '<i class="eut-icon-nav-left"></i>',
						'next_text'	=> '<i class="eut-icon-nav-right"></i>',
						'add_args' => false,
					 ));
					 echo '</div>';
				}
			}
?>
			</div>

		<?php
		else :
		endif;
		wp_reset_postdata();

		return ob_get_clean();

	}
	add_shortcode( 'zuperla_testimonial', 'zuperla_ext_vce_testimonial_shortcode' );

}

/**
 * Add shortcode to Visual Composer
 */

if( !function_exists( 'zuperla_ext_vce_testimonial_shortcode_params' ) ) {
	function zuperla_ext_vce_testimonial_shortcode_params( $tag ) {
		return array(
			"name" => esc_html__( "Testimonial", "zuperla-extension" ),
			"description" => esc_html__( "Add a captivating testimonial slider", "zuperla-extension" ),
			"base" => $tag,
			"class" => "",
			"icon"      => "icon-wpb-eut-testimonial",
			"category" => esc_html__( "Content", "js_composer" ),
			"params" => array(
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Testimonial Mode", "zuperla-extension" ),
					"param_name" => "testimonial_mode",
					"value" => array(
						esc_html__( "Carousel", "zuperla-extension" ) => 'carousel',
						esc_html__( "Masonry", "zuperla-extension" ) => 'masonry',
					),
					"description" => esc_html__( "Select your testimonial type.", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Large Screen Columns", "zuperla-extension" ),
					"param_name" => "columns_large_screen",
					"value" => array( '2', '3', '4', '5' ),
					"std" => '3',
					"description" => esc_html__( "Select column on large devices.", "zuperla-extension" ),
					"dependency" => array( 'element' => "testimonial_mode", 'value' => array( 'masonry' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Columns", "zuperla-extension" ),
					"param_name" => "columns",
					"value" => array( '2', '3', '4', '5' ),
					"std" => '3',
					"description" => esc_html__( "Select number of columns.", "zuperla-extension" ),
					"dependency" => array( 'element' => "testimonial_mode", 'value' => array( 'masonry' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Tablet Landscape Columns", "zuperla-extension" ),
					"param_name" => "columns_tablet_landscape",
					"value" => array( '2', '3', '4' ),
					"std" => '2',
					"description" => esc_html__( "Select responsive column on tablet devices, landscape orientation.", "zuperla-extension" ),
					"dependency" => array( 'element' => "testimonial_mode", 'value' => array( 'masonry' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Tablet Portrait Columns", "zuperla-extension" ),
					"param_name" => "columns_tablet_portrait",
					"value" => array( '2', '3', '4' ),
					"std" => '2',
					"description" => esc_html__( "Select responsive column on tablet devices, portrait orientation.", "zuperla-extension" ),
					"dependency" => array( 'element' => "testimonial_mode", 'value' => array( 'masonry' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Mobile Columns", "zuperla-extension" ),
					"param_name" => "columns_mobile",
					"value" => array( '1', '2' ),
					"std" => '1',
					"description" => esc_html__( "Select responsive column on mobile devices.", "zuperla-extension" ),
					"dependency" => array( 'element' => "testimonial_mode", 'value' => array( 'masonry' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Gutter between images", "zuperla-extension" ),
					"param_name" => "item_gutter",
					"value" => array(
						esc_html__( "Yes", "zuperla-extension" ) => 'yes',
						esc_html__( "No", "zuperla-extension" ) => 'no',
					),
					"description" => esc_html__( "Add gutter among images.", "zuperla-extension" ),
					"dependency" => array( 'element' => "testimonial_mode", 'value' => array( 'masonry' ) ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Gutter Size", "zuperla-extension" ),
					"param_name" => "gutter_size",
					"value" => '40',
					"dependency" => array( 'element' => "item_gutter", 'value' => array( 'yes' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "CSS Animation", "zuperla-extension"),
					"param_name" => "animation",
					"value" => array(
						esc_html__( "No", "zuperla-extension" ) => '',
						esc_html__( "Fade In", "zuperla-extension" ) => "eut-fade-in",
						esc_html__( "Fade In Up", "zuperla-extension" ) => "eut-fade-in-up",
						esc_html__( "Fade In Down", "zuperla-extension" ) => "eut-fade-in-down",
						esc_html__( "Fade In Left", "zuperla-extension" ) => "eut-fade-in-left",
						esc_html__( "Fade In Right", "zuperla-extension" ) => "eut-fade-in-right",
						esc_html__( "Zoom In", "zuperla-extension" ) => "eut-zoom-in",
					),
					"dependency" => array( 'element' => "testimonial_mode", 'value' => array( 'masonry' ) ),
					"description" => esc_html__("Select type of animation if you want this element to be animated when it enters into the browsers viewport. Note: Works only in modern browsers.", "zuperla-extension" ),
					"std" => "eut-zoom-in",
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Items to show", "zuperla-extension" ),
					"param_name" => "items_to_show",
					"value" => '20',
					"description" => esc_html__( "Maximum Testimonial Items to Show", "zuperla-extension" ),
				),
				array(
					"type" => 'checkbox',
					"heading" => esc_html__( "Disable Pagination", "zuperla-extension" ),
					"param_name" => "disable_pagination",
					"description" => esc_html__( "If selected, pagination will not be shown.", "zuperla-extension" ),
					"value" => array( esc_html__( "Disable Pagination.", "zuperla-extension" ) => 'yes' ),
					"dependency" => array( 'element' => "testimonial_mode", 'value' => array( 'masonry' ) ),
				),
				zuperla_ext_vce_add_order_by(),
				zuperla_ext_vce_add_order(),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Testimonial Image Size", "zuperla-extension" ),
					"param_name" => "zuperla_image_mode",
					'value' => array(
						esc_html__( 'Square Small Crop', 'zuperla-extension' ) => 'square',
						esc_html__( 'Landscape Small Crop', 'zuperla-extension' ) => 'landscape',
						esc_html__( 'Portrait Small Crop', 'zuperla-extension' ) => 'portrait',
						esc_html__( 'Resize ( Large )', 'zuperla-extension' ) => 'large',
						esc_html__( 'Resize ( Medium Large )', 'zuperla-extension' ) => 'medium_large',
					),
					'std' => 'portrait',
					"description" => esc_html__( "Select your Testimonial Image Size.", "zuperla-extension" ),
					"dependency" => array( 'element' => "testimonial_mode", 'value' => array( 'zuperla-style' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Show Featured Image", "zuperla-extension" ),
					"param_name" => "show_image",
					"value" => array(
						esc_html__( "No", "zuperla-extension" ) => 'no',
						esc_html__( "Yes", "zuperla-extension" ) => 'yes',
					),
					"dependency" => array( 'element' => "testimonial_mode", 'value' => array( 'carousel', 'masonry' ) ),
					"std" => 'no',
				),
				array(
					"type" => 'dropdown',
					"heading" => esc_html__( "Content Background", "zuperla-extension" ),
					"param_name" => "content_bg",
					"description" => esc_html__( "Selected background color for your testimonial content.", "zuperla-extension" ),
					"value" => array(
						esc_html__( "None", "zuperla-extension" ) => 'none',
						esc_html__( "White", "zuperla-extension" ) => 'white',
						esc_html__( "Black", "zuperla-extension" ) => 'black',
					),
					'std' => 'white',
					"dependency" => array( 'element' => "testimonial_mode", 'value' => array( 'masonry', 'zuperla-style' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Autoplay", "zuperla-extension" ),
					"param_name" => "auto_play",
					"value" => array(
						esc_html__( "Yes", "zuperla-extension" ) => 'yes',
						esc_html__( "No", "zuperla-extension" ) => 'no',
					),
					"dependency" => array( 'element' => "testimonial_mode", 'value' => array( 'carousel', 'zuperla-style' ) ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Slideshow Speed", "zuperla-extension" ),
					"param_name" => "slideshow_speed",
					"value" => '3000',
					"description" => esc_html__( "Slideshow Speed in ms.", "zuperla-extension" ),
					"dependency" => array( 'element' => "testimonial_mode", 'value' => array( 'carousel', 'zuperla-style' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Transition", "zuperla-extension" ),
					"param_name" => "transition",
					"value" => array(
						esc_html__( "Slide", "zuperla-extension" ) => 'slide',
						esc_html__( "Fade", "zuperla-extension" ) => 'fade',
					),
					"description" => esc_html__( "Transition Effect.", "zuperla-extension" ),
					"dependency" => array( 'element' => "testimonial_mode", 'value' => array( 'carousel' ) ),
				),
				array(
					"type" => 'checkbox',
					"heading" => esc_html__( "Pause on Hover", "zuperla-extension" ),
					"param_name" => "pause_hover",
					"value" => array( esc_html__( "If selected, testimonial will be paused on hover", "zuperla-extension" ) => 'yes' ),
					"dependency" => array( 'element' => "testimonial_mode", 'value' => array( 'carousel', 'zuperla-style' ) ),
				),
				array(
					"type" => 'checkbox',
					"heading" => esc_html__( "Auto Height", "zuperla-extension" ),
					"param_name" => "auto_height",
					"value" => array( esc_html__( "Select if you want smooth auto height", "zuperla-extension" ) => 'yes' ),
					"dependency" => array( 'element' => "testimonial_mode", 'value' => array( 'carousel' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Carousel Pagination", "zuperla-extension" ),
					"param_name" => "carousel_pagination",
					"value" => array(
						esc_html__( "Yes", "zuperla-extension" ) => 'yes',
						esc_html__( "No", "zuperla-extension" ) => 'no',
					),
					"std" => "yes",
					"dependency" => array( 'element' => "testimonial_mode", 'value' => array( 'carousel', 'zuperla-style' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Pagination Color", "zuperla-extension" ),
					"param_name" => "pagination_color",
					'value' => array(
						esc_html__( 'Dark' , 'zuperla-extension' ) => 'dark',
						esc_html__( 'Light' , 'zuperla-extension' ) => 'light',
					),
					"description" => esc_html__( "Select the Pagination color.", "zuperla-extension" ),
					"dependency" => array( 'element' => "carousel_pagination", 'value' => array( 'yes' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Text Style", "zuperla-extension" ),
					"param_name" => "text_style",
					"value" => array(
						esc_html__( "None", "zuperla-extension" ) => '',
						esc_html__( "Leader", "zuperla-extension" ) => 'leader-text',
						esc_html__( "Subtitle", "zuperla-extension" ) => 'subtitle',
						esc_html__( "Quote", "zuperla-extension" ) => 'quote-text',
					),
					"description" => 'Select your text style',
					"dependency" => array( 'element' => "testimonial_mode", 'value' => array( 'carousel' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Alignment", "zuperla-extension" ),
					"param_name" => "align",
					"value" => array(
						esc_html__( "Left", "zuperla-extension" ) => 'left',
						esc_html__( "Right", "zuperla-extension" ) => 'right',
						esc_html__( "Center", "zuperla-extension" ) => 'center',
					),
					"description" => '',
					"dependency" => array( 'element' => "testimonial_mode", 'value' => array( 'carousel' ) ),
				),
				zuperla_ext_vce_add_margin_bottom(),
				zuperla_ext_vce_add_el_class(),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Exclude Posts", "zuperla-extension" ),
					"param_name" => "exclude_posts",
					"value" => '',
					"description" => esc_html__( "Type the post ids you want to exclude separated by comma ( , ).", "zuperla-extension" ),
					"group" => esc_html__( "Categories", "zuperla-extension" ),
				),
				array(
					"type" => "zuperla_ext_multi_checkbox",
					"heading" => __("Testimonial Categories", "zuperla-extension" ),
					"param_name" => "categories",
					"value" => zuperla_ext_vce_get_testimonial_categories(),
					"description" => esc_html__( "Select all or multiple categories.", "zuperla-extension" ),
					"group" => esc_html__( "Categories", "zuperla-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__("Include Specific Posts", "zuperla-extension" ),
					"param_name" => "include_posts",
					"value" => '',
					"description" => esc_html__( "Type the specific post ids you want to include separated by comma ( , ). Note: If you define specific post ids, Exclude Posts and Categories will have no effect.", "zuperla-extension" ),
					"group" => esc_html__( "Categories", "zuperla-extension" ),
				),
			),
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'zuperla_testimonial', 'zuperla_ext_vce_testimonial_shortcode_params' );
} else if( function_exists( 'vc_map' ) ) {
	$attributes = zuperla_ext_vce_testimonial_shortcode_params( 'zuperla_testimonial' );
	vc_map( $attributes );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
