<?php
/**
 * Language selector Shortcode
 */

if( !function_exists( 'zuperla_ext_vce_language_selector_shortcode' ) ) {

	function zuperla_ext_vce_language_selector_shortcode( $atts, $content ) {

		$output = $data = $el_class = '';

		extract(
			shortcode_atts(
				array(
					'align' => 'left',
					'animation' => '',
					'animation_delay' => '200',
					'animation_duration' => 'normal',
					'margin_bottom' => '',
					'el_class' => '',
				),
				$atts
			)
		);


		$language_selector_classes = array( 'eut-element', 'eut-language-element', 'eut-align-' . $align );

		if ( !empty( $animation ) ) {
			array_push( $language_selector_classes, 'eut-animated-item' );
			array_push( $language_selector_classes, $animation);
			array_push( $language_selector_classes, 'eut-duration-' . $animation_duration );
			$data = ' data-delay="' . esc_attr( $animation_delay ) . '"';
		}
		if ( !empty( $el_class ) ) {
			array_push( $language_selector_classes, $el_class);
		}
		$language_selector_class_string = implode( ' ', $language_selector_classes );

		$style = zuperla_ext_vce_build_margin_bottom_style( $margin_bottom );
		ob_start();

		?>
			<div class="<?php echo esc_attr( $language_selector_class_string ); ?>" style="<?php echo $style; ?>"<?php echo $data; ?>>
			<?php
				if( function_exists( 'zuperla_eutf_print_language_modal_selector' ) ) {
					zuperla_eutf_print_language_modal_selector();
				}
			?>
			</div>
		<?php

		return ob_get_clean();

	}
	add_shortcode( 'zuperla_language_selector', 'zuperla_ext_vce_language_selector_shortcode' );

}

/**
 * Add shortcode to Visual Composer
 */

if( !function_exists( 'zuperla_ext_vce_language_selector_shortcode_params' ) ) {
	function zuperla_ext_vce_language_selector_shortcode_params( $tag ) {

		return array(
			"name" => esc_html__( "Language Selector", "zuperla-extension" ),
			"description" => esc_html__( "Place your language selector", "zuperla-extension" ),
			"base" => $tag,
			"class" => "",
			"icon"      => "icon-wpb-eut-languages",
			"category" => esc_html__( "Content", "js_composer" ),
			"params" => array(
				zuperla_ext_vce_add_align(),
				zuperla_ext_vce_add_animation(),
				zuperla_ext_vce_add_animation_delay(),
				zuperla_ext_vce_add_animation_duration(),
				zuperla_ext_vce_add_margin_bottom(),
				zuperla_ext_vce_add_el_class(),
			),
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'zuperla_language_selector', 'zuperla_ext_vce_language_selector_shortcode_params' );
} else if( function_exists( 'vc_map' ) ) {
	$attributes = zuperla_ext_vce_language_selector_shortcode_params( 'zuperla_language_selector' );
	vc_map( $attributes );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
