<?php
/**
 * Counter Shortcode
 */

if( !function_exists( 'zuperla_ext_vce_counter_shortcode' ) ) {

	function zuperla_ext_vce_counter_shortcode( $atts, $content ) {

		$output = $link_start = $link_end = $retina_data = $data = $el_class = '';

		extract(
			shortcode_atts(
				array(
					'counter_start_val' => '0',
					'counter_end_val' => '100',
					'counter_prefix' => '',
					'counter_prefix_space' => '',
					'counter_suffix' => '',
					'counter_suffix_space' => '',
					'counter_decimal_points' => '0',
					'counter_decimal_separator' => '.',
					'counter_color' => 'primary-1',
					'counter_heading' => 'h2',
					'counter_custom_font_family' => '',
					'increase_counter_heading' => '100',
					'counter_thousands_separator_vis' => '',
					'counter_thousands_separator' => ',',
					'title' => '',
					'heading_tag' => 'h3',
					'heading' => 'h3',
					'custom_font_family' => '',
					'icon_library' => 'fontawesome',
					'icon_fontawesome' => 'fa fa-adjust',
					'icon_openiconic' => 'vc-oi vc-oi-dial',
					'icon_typicons' => 'typcn typcn-adjust-brightness',
					'icon_entypo' => 'entypo-icon entypo-icon-note',
					'icon_linecons' => 'vc_li vc_li-heart',
					'icon_simplelineicons' => 'smp-icon-user',
					'icon_etlineicons' => 'et-icon-mobile',
					'icon_type' => '',
					'icon_svg' => '',
					'icon_svg_animation_duration' => '100',
					'icon_size' => 'medium',
					'icon_color' => 'primary-1',
					'inherit_align' => 'inherit',
					'animation' => '',
					'animation_delay' => '200',
					'animation_duration' => 'normal',
					'margin_bottom' => '',
					'el_class' => '',
				),
				$atts
			)
		);

		$title_classes = array( 'eut-counter-title' );
		$title_classes[]  = 'eut-' . $heading;
		if ( !empty( $custom_font_family ) ) {
			$title_classes[]  = 'eut-' . $custom_font_family;
		}
		$title_class_string = implode( ' ', $title_classes );
		$counter_classes = array( 'eut-element' );

		array_push( $counter_classes, 'eut-counter' );
		array_push( $counter_classes, 'eut-align-' . $inherit_align );

		if ( !empty( $animation ) ) {
			array_push( $counter_classes, 'eut-animated-item' );
			array_push( $counter_classes, $animation);
			array_push( $counter_classes, 'eut-duration-' . $animation_duration );
			$data = ' data-delay="' . esc_attr( $animation_delay ) . '"';
		}

		if ( !empty ( $el_class ) ) {
			array_push( $counter_classes, $el_class);
		}

		$counter_class_string = implode( ' ', $counter_classes );


		$counter_number = array( 'eut-counter-item' );

		array_push( $counter_number, 'eut-' . $counter_heading );
		array_push( $counter_number, 'eut-text-' . $counter_color );

		if ( !empty( $counter_custom_font_family ) ) {
			array_push( $counter_number, 'eut-' . $counter_custom_font_family );
		}

		if( '100' != $increase_counter_heading ){
			array_push( $counter_number, 'eut-increase-heading' );
			array_push( $counter_number, 'eut-heading-' . $increase_counter_heading );
		}

		$counter_number_class_string = implode( ' ', $counter_number );


		$icon_classes = array();

		if ( 'icon' == $icon_type ) {

			$icon_class = isset( ${"icon_" . $icon_library} ) ? esc_attr( ${"icon_" . $icon_library} ) : 'fa fa-adjust';
			if ( function_exists( 'vc_icon_element_fonts_enqueue' ) ) {
				vc_icon_element_fonts_enqueue( $icon_library );
			}
			array_push( $icon_classes, $icon_class );
			array_push( $icon_classes, 'eut-text-' . $icon_color );
			array_push( $icon_classes, 'eut-' . $icon_size );
		}

		$icon_class_string = implode( ' ', $icon_classes );


		$style = zuperla_ext_vce_build_margin_bottom_style( $margin_bottom );


		$output .= '<div class="' . esc_attr( $counter_class_string ) . '" style="' . $style . '"' . $data . '>';

		if ( 'icon' == $icon_type ) {
			$output .= '  <div class="eut-counter-icon">';
			$output .= '  <i class="' . esc_attr( $icon_class_string ) . '"></i>';
			$output .= '  </div>';
		} else if( 'icon_svg' == $icon_type ) {
			$empty_image_url = ZUPERLA_EXT_PLUGIN_DIR_URL .'assets/images/empty/default-icon.svg';

			if ( !empty( $icon_svg ) ) {
				$img_id = preg_replace('/[^\d]/', '', $icon_svg);
				$img_src = wp_get_attachment_image_src( $img_id, 'full' );
				$img_url = $img_src[0];
				$parts = pathinfo( $img_url );
				if ( !isset( $parts['extension'] ) || 'svg' != $parts['extension'] ) {
					$img_url = $empty_image_url;
				}
			} else {
				$img_url = $empty_image_url;
			}		
			$output .= '<div class="eut-counter-icon eut-' . $icon_size . '">';
			$output .= '<div id="' . uniqid('eut-svg-') . '" data-file="' . esc_url( $img_url ) . '" data-duration="' . esc_attr( $icon_svg_animation_duration ) . '" class="eut-svg-icon eut-text-' . esc_attr( $icon_color ) . '"></div>';
			$output .= '</div>';
		}

		if( 'yes' == $counter_prefix_space && !empty( $counter_prefix )  ) {
			$counter_prefix = $counter_prefix . ' ';
		}

		if( 'yes' == $counter_suffix_space && !empty( $counter_suffix ) ) {
			$counter_suffix = ' ' . $counter_suffix;
		}
		
		$counter_attributes = array();
		$counter_attributes[] = 'data-thousands-separator-vis="' . esc_attr( $counter_thousands_separator_vis ) . '"';
		$counter_attributes[] = 'data-thousands-separator="' . esc_attr( $counter_thousands_separator ) . '"';
		$counter_attributes[] = 'data-prefix="' . esc_attr( $counter_prefix ) . '"';
		$counter_attributes[] = 'data-suffix="' . esc_attr( $counter_suffix ) . '"';
		$counter_attributes[] = 'data-start-val="' . esc_attr( $counter_start_val ) . '"';
		$counter_attributes[] = 'data-end-val="' . esc_attr( $counter_end_val ) . '"';
		$counter_attributes[] = 'data-decimal-points="' . esc_attr( $counter_decimal_points ) . '"';
		$counter_attributes[] = 'data-decimal-separator="' . esc_attr( $counter_decimal_separator ) . '"';
		$counter_attributes[] = '';		

		$output .= '  <div class="eut-counter-content">';
		$output .= '    <div class="' . esc_attr( $counter_number_class_string ) . '">';
		$output .= '      <span ' . implode( ' ', $counter_attributes ) . '>' . $counter_start_val. '</span>';
		$output .= '    </div>';
		$output .= '	<' . tag_escape( $heading_tag ) . ' class="' . esc_attr( $title_class_string ) . '">' . $title. '</' . tag_escape( $heading_tag ) . '>';
		$output .= '  </div>';

		$output .= '</div>';

		return $output;
	}
	add_shortcode( 'zuperla_counter', 'zuperla_ext_vce_counter_shortcode' );

}

/**
 * Add shortcode to Visual Composer
 */

if( !function_exists( 'zuperla_ext_vce_counter_shortcode_params' ) ) {
	function zuperla_ext_vce_counter_shortcode_params( $tag ) {
		return array(
			"name" => esc_html__( "Counter", "zuperla-extension" ),
			"description" => esc_html__( "Add a counter with icon and title", "zuperla-extension" ),
			"base" => $tag,
			"class" => "",
			"icon"      => "icon-wpb-eut-counter",
			"category" => esc_html__( "Content", "js_composer" ),
			"params" => array(
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Counter Start Number", "zuperla-extension" ),
					"param_name" => "counter_start_val",
					"value" => "0",
					"description" => esc_html__( "Enter counter start number.", "zuperla-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Counter End Number", "zuperla-extension" ),
					"param_name" => "counter_end_val",
					"value" => "100",
					"description" => esc_html__( "Enter counter end number.", "zuperla-extension" ),
				),
				array(
					"type" => 'checkbox',
					"heading" => esc_html__( "Counter Thousands Separator Visiblility", "zuperla-extension" ),
					"param_name" => "counter_thousands_separator_vis",
					"description" => esc_html__( "If selected, thousands separator will not be shown.", "zuperla-extension" ),
					"value" => array( esc_html__( "Disable Thousands Separator.", "zuperla-extension" ) => 'yes' ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Counter Thousands Separator", "zuperla-extension" ),
					"param_name" => "counter_thousands_separator",
					"value" => ",",
					"description" => esc_html__( "Enter thousands separator.", "zuperla-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Counter Decimal Points", "zuperla-extension" ),
					"param_name" => "counter_decimal_points",
					"value" => "0",
					"description" => esc_html__( "Number of decimal points.", "zuperla-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Counter Decimal Separator", "zuperla-extension" ),
					"param_name" => "counter_decimal_separator",
					"value" => ".",
					"description" => esc_html__( "Enter decimal separator.", "zuperla-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Counter Prefix", "zuperla-extension" ),
					"param_name" => "counter_prefix",
					"value" => "",
					"description" => esc_html__( "Enter counter prefix.", "zuperla-extension" ),
				),
				array(
					"type" => 'checkbox',
					"heading" => esc_html__( "Prefix space", "zuperla-extension" ),
					"param_name" => "counter_prefix_space",
					"description" => esc_html__( "Add space after prefix", "zuperla-extension" ),
					"value" => array( esc_html__( "Add space", "zuperla-extension" ) => 'yes' ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Counter Suffix", "zuperla-extension" ),
					"param_name" => "counter_suffix",
					"value" => "",
					"description" => esc_html__( "Enter counter suffix.", "zuperla-extension" ),
				),
				array(
					"type" => 'checkbox',
					"heading" => esc_html__( "Suffix space", "zuperla-extension" ),
					"param_name" => "counter_suffix_space",
					"description" => esc_html__( "Add space before suffix", "zuperla-extension" ),
					"value" => array( esc_html__( "Add space", "zuperla-extension" ) => 'yes' ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Counter Color", "zuperla-extension" ),
					"param_name" => "counter_color",
					"param_holder_class" => "eut-colored-dropdown",
					"value" => array(
						esc_html__( "Primary 1", "zuperla-extension" ) => 'primary-1',
						esc_html__( "Primary 2", "zuperla-extension" ) => 'primary-2',
						esc_html__( "Primary 3", "zuperla-extension" ) => 'primary-3',
						esc_html__( "Primary 4", "zuperla-extension" ) => 'primary-4',
						esc_html__( "Primary 5", "zuperla-extension" ) => 'primary-5',
						esc_html__( "Primary 6", "zuperla-extension" ) => 'primary-6',
						esc_html__( "Green", "zuperla-extension" ) => 'green',
						esc_html__( "Orange", "zuperla-extension" ) => 'orange',
						esc_html__( "Red", "zuperla-extension" ) => 'red',
						esc_html__( "Blue", "zuperla-extension" ) => 'blue',
						esc_html__( "Aqua", "zuperla-extension" ) => 'aqua',
						esc_html__( "Purple", "zuperla-extension" ) => 'purple',
						esc_html__( "Black", "zuperla-extension" ) => 'black',
						esc_html__( "Grey", "zuperla-extension" ) => 'grey',
						esc_html__( "White", "zuperla-extension" ) => 'white',
					),
					"description" => esc_html__( "Color of the counter.", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Counter Size/Typography", "zuperla-extension" ),
					"param_name" => "counter_heading",
					"value" => array(
						esc_html__( "h1", "zuperla-extension" ) => 'h1',
						esc_html__( "h2", "zuperla-extension" ) => 'h2',
						esc_html__( "h3", "zuperla-extension" ) => 'h3',
						esc_html__( "h4", "zuperla-extension" ) => 'h4',
						esc_html__( "h5", "zuperla-extension" ) => 'h5',
						esc_html__( "h6", "zuperla-extension" ) => 'h6',
						esc_html__( "Leader Text", "zuperla-extension" ) => 'leader-text',
						esc_html__( "Subtitle Text", "zuperla-extension" ) => 'subtitle-text',
						esc_html__( "Small Text", "zuperla-extension" ) => 'small-text',
						esc_html__( "Link Text", "zuperla-extension" ) => 'link-text',
					),
					"description" => esc_html__( "Select counter text size.", "zuperla-extension" ),
					"std" => 'h2',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Increase Counter Size", "zuperla-extension" ),
					"param_name" => "increase_counter_heading",
					"value" => array(
						esc_html__( "100%", "zuperla-extension" ) => '100',
						esc_html__( "120%", "zuperla-extension" ) => '120',
						esc_html__( "140%", "zuperla-extension" ) => '140',
						esc_html__( "160%", "zuperla-extension" ) => '160',
						esc_html__( "180%", "zuperla-extension" ) => '180',
						esc_html__( "200%", "zuperla-extension" ) => '200',
						esc_html__( "250%", "zuperla-extension" ) => '250',
						esc_html__( "300%", "zuperla-extension" ) => '300',
					),
					"description" => esc_html__( "Set the percentage you want to increase your Headings size.", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Counter Custom Font Family", "zuperla-extension" ),
					"param_name" => "counter_custom_font_family",
					"value" => array(
						esc_html__( "Same as Typography", "zuperla-extension" ) => '',
						esc_html__( "Custom Font Family 1", "zuperla-extension" ) => 'custom-font-1',
						esc_html__( "Custom Font Family 2", "zuperla-extension" ) => 'custom-font-2',
						esc_html__( "Custom Font Family 3", "zuperla-extension" ) => 'custom-font-3',
						esc_html__( "Custom Font Family 4", "zuperla-extension" ) => 'custom-font-4',

					),
					"description" => esc_html__( "Select a different font family, defined in Theme Options - Typography Options - Extras - Custom Font Family", "zuperla-extension" ),
					"std" => '',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Icon type", "zuperla-extension" ),
					"param_name" => "icon_type",
					"value" => array(
						esc_html__( "No Icon", "zuperla-extension" ) => '',
						esc_html__( "Icon", "zuperla-extension" ) => 'icon',
						esc_html__( "Animated SVG", "zuperla-extension" ) => 'icon_svg',
					),
					"description" => '',
				),
				array(
					"type" => "attach_image",
					"heading" => esc_html__( "Icon SVG", "zuperla-extension" ),
					"param_name" => "icon_svg",
					"value" => '',
					"description" => esc_html__( "Select an svg icon. Note: SVG mime type must be enabled in WordPress", "zuperla-extension" ),
					"dependency" => array( 'element' => "icon_type", 'value' => array( 'icon_svg' ) ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__('SVG Animation Duration', 'zuperla-extension'),
					"param_name" => "icon_svg_animation_duration",
					"value" => '100',
					"description" => esc_html__( "Add delay in milliseconds.", "zuperla-extension" ),
					"dependency" => array( 'element' => "icon_type", 'value' => array( 'icon_svg' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Icon size", "zuperla-extension" ),
					"param_name" => "icon_size",
					"value" => array(
						esc_html__( "Extra Large", "zuperla-extension" ) => 'extra-large',
						esc_html__( "Large", "zuperla-extension" ) => 'large',
						esc_html__( "Medium", "zuperla-extension" ) => 'medium',
						esc_html__( "Small", "zuperla-extension" ) => 'small',
					),
					"std" => 'medium',
					"description" => '',
					"dependency" => array( 'element' => 'icon_type', 'value_not_equal_to' => array( '' ) ),
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Icon library', 'zuperla-extension' ),
					'value' => array(
						esc_html__( 'Font Awesome', 'zuperla-extension' ) => 'fontawesome',
						esc_html__( 'Open Iconic', 'zuperla-extension' ) => 'openiconic',
						esc_html__( 'Typicons', 'zuperla-extension' ) => 'typicons',
						esc_html__( 'Entypo', 'zuperla-extension' ) => 'entypo',
						esc_html__( 'Linecons', 'zuperla-extension' ) => 'linecons',
						esc_html__( 'Simple Line Icons', 'zuperla-extension' ) => 'simplelineicons',
						esc_html__( 'Elegant Line Icons', 'zuperla-extension' ) => 'etlineicons',
					),
					'param_name' => 'icon_library',
					'description' => esc_html__( 'Select icon library.', 'zuperla-extension' ),
					"dependency" => array( 'element' => "icon_type", 'value' => array( 'icon' ) ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => esc_html__( 'Icon', 'zuperla-extension' ),
					'param_name' => 'icon_fontawesome',
					'value' => 'fa fa-adjust',
					'settings' => array(
						'emptyIcon' => false, // default true, display an "EMPTY" icon?
						'iconsPerPage' => 200, // default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value' => 'fontawesome',
					),
					'description' => esc_html__( 'Select icon from library.', 'zuperla-extension' ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => esc_html__( 'Icon', 'zuperla-extension' ),
					'param_name' => 'icon_openiconic',
					'value' => 'vc-oi vc-oi-dial',
					'settings' => array(
						'emptyIcon' => false, // default true, display an "EMPTY" icon?
						'type' => 'openiconic',
						'iconsPerPage' => 200, // default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value' => 'openiconic',
					),
					'description' => esc_html__( 'Select icon from library.', 'zuperla-extension' ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => esc_html__( 'Icon', 'zuperla-extension' ),
					'param_name' => 'icon_typicons',
					'value' => 'typcn typcn-adjust-brightness',
					'settings' => array(
						'emptyIcon' => false, // default true, display an "EMPTY" icon?
						'type' => 'typicons',
						'iconsPerPage' => 200, // default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value' => 'typicons',
					),
					'description' => esc_html__( 'Select icon from library.', 'zuperla-extension' ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => esc_html__( 'Icon', 'zuperla-extension' ),
					'param_name' => 'icon_entypo',
					'value' => 'entypo-icon entypo-icon-note',
					'settings' => array(
						'emptyIcon' => false, // default true, display an "EMPTY" icon?
						'type' => 'entypo',
						'iconsPerPage' => 300, // default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value' => 'entypo',
					),
				),
				array(
					'type' => 'iconpicker',
					'heading' => esc_html__( 'Icon', 'zuperla-extension' ),
					'param_name' => 'icon_linecons',
					'value' => 'vc_li vc_li-heart',
					'settings' => array(
						'emptyIcon' => false, // default true, display an "EMPTY" icon?
						'type' => 'linecons',
						'iconsPerPage' => 200, // default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value' => 'linecons',
					),
					'description' => esc_html__( 'Select icon from library.', 'zuperla-extension' ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => esc_html__( 'Icon', 'zuperla-extension' ),
					'param_name' => 'icon_simplelineicons',
					'value' => 'smp-icon-user',
					'settings' => array(
						'emptyIcon' => false, // default true, display an "EMPTY" icon?
						'type' => 'simplelineicons',
						'iconsPerPage' => 200, // default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value' => 'simplelineicons',
					),
					'description' => esc_html__( 'Select icon from library.', 'zuperla-extension' ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => esc_html__( 'Icon', 'zuperla-extension' ),
					'param_name' => 'icon_etlineicons',
					'value' => 'et-icon-mobile',
					'settings' => array(
						'emptyIcon' => false, // default true, display an "EMPTY" icon?
						'type' => 'etlineicons',
						'iconsPerPage' => 100,
					),
					'dependency' => array(
						'element' => 'icon_library',
						'value' => 'etlineicons',
					),
					'description' => esc_html__( 'Select icon from library.', 'zuperla-extension' ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Icon Color", "zuperla-extension" ),
					"param_name" => "icon_color",
					"param_holder_class" => "eut-colored-dropdown",
					"value" => array(
						esc_html__( "Primary 1", "zuperla-extension" ) => 'primary-1',
						esc_html__( "Primary 2", "zuperla-extension" ) => 'primary-2',
						esc_html__( "Primary 3", "zuperla-extension" ) => 'primary-3',
						esc_html__( "Primary 4", "zuperla-extension" ) => 'primary-4',
						esc_html__( "Primary 5", "zuperla-extension" ) => 'primary-5',
						esc_html__( "Primary 6", "zuperla-extension" ) => 'primary-6',
						esc_html__( "Green", "zuperla-extension" ) => 'green',
						esc_html__( "Orange", "zuperla-extension" ) => 'orange',
						esc_html__( "Red", "zuperla-extension" ) => 'red',
						esc_html__( "Blue", "zuperla-extension" ) => 'blue',
						esc_html__( "Aqua", "zuperla-extension" ) => 'aqua',
						esc_html__( "Purple", "zuperla-extension" ) => 'purple',
						esc_html__( "Black", "zuperla-extension" ) => 'black',
						esc_html__( "Grey", "zuperla-extension" ) => 'grey',
						esc_html__( "White", "zuperla-extension" ) => 'white',
					),
					"description" => esc_html__( "Color of the icon.", "zuperla-extension" ),
					"dependency" => array( 'element' => "icon_type", 'value' => array( 'icon', 'icon_svg' ) ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Title", "zuperla-extension" ),
					"param_name" => "title",
					"value" => "Sample Title",
					"description" => esc_html__( "Enter counter title.", "zuperla-extension" ),
					"save_always" => true,
				),
				zuperla_ext_vce_get_heading_tag( "h3" ),
				zuperla_ext_vce_get_heading( "h3" ),
				zuperla_ext_vce_get_custom_font_family(),
				zuperla_ext_vce_add_inherit_align(),
				zuperla_ext_vce_add_animation(),
				zuperla_ext_vce_add_animation_delay(),
				zuperla_ext_vce_add_animation_duration(),
				zuperla_ext_vce_add_margin_bottom(),
				zuperla_ext_vce_add_el_class(),
			),
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'zuperla_counter', 'zuperla_ext_vce_counter_shortcode_params' );
} else if( function_exists( 'vc_map' ) ) {
	$attributes = zuperla_ext_vce_counter_shortcode_params( 'zuperla_counter' );
	vc_map( $attributes );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
