<?php
/**
 * Content Slider Shortcode
 */

if( !function_exists( 'zuperla_ext_vce_content_slider_shortcode' ) ) {

	function zuperla_ext_vce_content_slider_shortcode( $atts, $content ) {

		$output = $el_class = $data_string = $auto_excerpt = '';

		extract(
			shortcode_atts(
				array(
					'categories' => '',
					'portfolio_categories' => '',
					'product_categories' => '',
					'exclude_posts' => '',
					'include_posts' => '',
					'post_type' => 'post',
					'parallax' => 'no',
					'image_mode' => 'landscape',
					'heading_tag' => 'h3',
					'heading' => 'h5',
					'custom_font_family' => '',
					'read_more_title' => 'Read More',
					'slideshow_speed' => '3500',
					'navigation_type' => '1',
					'navigation_color' => 'dark',
					'pause_hover' => 'no',
					'auto_play' => 'yes',
					'auto_height' => 'no',
					'hide_author' => '',
					'hide_date' => '',
					'hide_like' => '',
					'posts_per_page' => '4',
					'order_by' => 'date',
					'order' => 'DESC',
					'margin_bottom' => '',
					'el_class' => '',
				),
				$atts
			)
		);

		$style = zuperla_ext_vce_build_margin_bottom_style( $margin_bottom );


		$post_type_class = '';
		if ( 'portfolio' == $post_type ) {
			$post_type_class = 'eut-portfolio-slider';
		} elseif ( 'product' == $post_type ) {
			$post_type_class = 'eut-product-slider';
		} else {
			$post_type_class = 'eut-blog-slider';
		}

		$content_slider_classes = array( 'eut-element', 'eut-slider', 'eut-content-slider', 'eut-layout-2', 'eut-paraller-wrapper' );
		if ( !empty ( $el_class ) ) {
			$content_slider_classes[] = $el_class;
		}
		$content_slider_classes[] = $post_type_class;
		$content_slider_class_string = implode( ' ', $content_slider_classes );

		$exclude_ids = array();
		if( !empty( $exclude_posts ) ){
			$exclude_ids = explode( ',', $exclude_posts );
		}

		$include_ids = array();
		if( !empty( $include_posts ) ){
			$include_ids = explode( ',', $include_posts );
		}

		if ( 'portfolio' == $post_type ) {

			$portfolio_cat = "";
			$portfolio_category_ids = array();

			if( ! empty( $portfolio_categories ) ) {
				$portfolio_category_ids = explode( ",", $portfolio_categories );
				foreach ( $portfolio_category_ids as $category_id ) {
					$category_term = get_term( $category_id, 'portfolio_category' );
					if ( isset( $category_term) ) {
						$portfolio_cat = $portfolio_cat.$category_term->slug . ', ';
					}
				}
			}

			if( !empty( $include_posts ) ){
				$args = array(
					'post_type' => 'portfolio',
					'post_status'=>'publish',
					'paged' => 1,
					'post__in' => $include_ids,
					'posts_per_page' => $posts_per_page,
					'orderby' => $order_by,
					'order' => $order,
				);
			} else {
				$args = array(
					'post_type' => 'portfolio',
					'post_status'=>'publish',
					'paged' => 1,
					'portfolio_category' => $portfolio_cat,
					'posts_per_page' => $posts_per_page,
					'post__not_in' => $exclude_ids,
					'orderby' => $order_by,
					'order' => $order,
				);
			}

		} elseif ( 'product' == $post_type ) {
			$product_cat = "";
			$product_category_ids = array();

			if( ! empty( $product_categories ) ) {
				$product_category_ids = explode( ",", $product_categories );
				foreach ( $product_category_ids as $category_id ) {
					$category_term = get_term( $category_id, 'product_cat' );
					if ( isset( $category_term) ) {
						$product_cat = $product_cat.$category_term->slug . ', ';
					}
				}
			}

			if( !empty( $include_posts ) ){
				$args = array(
					'post_type' => 'product',
					'post_status'=>'publish',
					'posts_per_page' => $posts_per_page,
					'post__in' => $include_ids,
					'paged' => 1,
					'orderby' => $order_by,
					'order' => $order,
				);
			} else {
				$args = array(
					'post_type' => 'product',
					'post_status'=>'publish',
					'posts_per_page' => $posts_per_page,
					'post__not_in' => $exclude_ids,
					'product_cat' => $product_cat,
					'paged' => 1,
					'orderby' => $order_by,
					'order' => $order,
				);
			}
		} else {
			if( !empty( $include_posts ) ){
				$args = array(
					'post_type' => 'post',
					'post_status'=>'publish',
					'posts_per_page' => $posts_per_page,
					'post__in' => $include_ids,
					'paged' => 1,
					'ignore_sticky_posts' => 1,
					'orderby' => $order_by,
					'order' => $order,
				);
			} else {
				$args = array(
					'post_type' => 'post',
					'post_status'=>'publish',
					'posts_per_page' => $posts_per_page,
					'cat' => $categories,
					'post__not_in' => $exclude_ids,
					'paged' => 1,
					'ignore_sticky_posts' => 1,
					'orderby' => $order_by,
					'order' => $order,
				);
			}
		}

		$image_mode_size = zuperla_ext_vce_get_image_size( $image_mode );

		$wrapper_attributes = array();
		$wrapper_attributes[] = 'class="eut-slider-element owl-carousel eut-add-counter eut-carousel-element"';
		$wrapper_attributes[] = 'data-slider-speed="' . esc_attr( $slideshow_speed ) . '"';
		$wrapper_attributes[] = 'data-slider-pause="' . esc_attr( $pause_hover ) . '"';
		$wrapper_attributes[] = 'data-slider-autoplay="' . esc_attr( $auto_play ) . '"';
		$wrapper_attributes[] = 'data-slider-autoheight="' . esc_attr( $auto_height ) . '"';
		$wrapper_attributes[] = ' data-pagination-color="' . esc_attr( $navigation_color ) . '"';

		$image_html = zuperla_ext_vce_get_fallback_image( $image_mode_size );

		$parallax_class = '';
		if ( 'yes' == $parallax ) {
			$parallax_class = 'eut-paraller';
		}

		$title_classes = array( 'eut-title' );
		$title_classes[]  = 'eut-' . $heading;
		if ( !empty( $custom_font_family ) ) {
			$title_classes[]  = 'eut-' . $custom_font_family;
		}
		$title_class_string = implode( ' ', $title_classes );

		$query = new WP_Query( $args );

		ob_start();

		if ( $query->have_posts() ) :

?>
		<div class="<?php echo esc_attr( $content_slider_class_string ); ?>" style="<?php echo $style; ?>">
			<div class="eut-element eut-carousel-wrapper">
				<?php echo zuperla_ext_vce_element_navigation( $navigation_type, $navigation_color ); ?>
				<div <?php echo implode( ' ', $wrapper_attributes ); ?>>

<?php
		while ( $query->have_posts() ) : $query->the_post();
			$post_id = get_the_ID();
?>
					<div class="eut-slider-item">
						<figure>
							<div class="eut-media">
								<?php if ( has_post_thumbnail() ) { ?>
									<?php the_post_thumbnail( $image_mode_size ); ?>
								<?php } else { ?>
									<?php echo $image_html; ?>
								<?php } ?>
							</div>
						</figure>
						<div class="eut-slider-content <?php echo esc_attr( $parallax_class ); ?>" data-limit="1x">
							<div class="eut-slider-content-wrapper">
								<?php the_title( '<' . tag_escape( $heading_tag ) . ' class="' . esc_attr( $title_class_string ) . '">', '</' . tag_escape( $heading_tag ) . '>' ); ?>
								<?php if( 'post' == $post_type ) { ?>

										<ul class="eut-post-meta">
										<?php if ( 'yes' != $hide_author ) { ?>
												<li class="eut-post-author"><?php the_author(); ?></li>
										<?php } ?>
										<?php if ( 'yes' != $hide_date ) { ?>
											<?php echo zuperla_ext_vce_print_list_date(); ?>
										<?php } ?>
										<?php
											if( 'yes' != $hide_like && function_exists( 'zuperla_eutf_social_like' ) ) {
												zuperla_eutf_social_like( $post_type );
											}
										?>
										</ul>
										<div class="eut-description"><?php echo zuperla_ext_vce_excerpt( '15' ); ?></div>
								<?php } else { ?>
									<div class="eut-description"><?php echo zuperla_ext_vce_excerpt( '15' ); ?></div>
								<?php } ?>
								<a href="<?php echo esc_url( get_permalink( $post_id ) ); ?>" class="eut-read-more eut-link-text"><?php echo esc_html( $read_more_title ); ?></a>
							</div>
						</div>
					</div>
<?php
		endwhile;
?>
				</div>
			</div>
		</div>
<?php
		else :
		endif;

		wp_reset_postdata();

		return ob_get_clean();


	}
	add_shortcode( 'zuperla_content_slider', 'zuperla_ext_vce_content_slider_shortcode' );

}

/**
 * Add shortcode to Visual Composer
 */

if( !function_exists( 'zuperla_ext_vce_content_slider_shortcode_params' ) ) {
	function zuperla_ext_vce_content_slider_shortcode_params( $tag ) {
		return array(
			"name" => esc_html__( "Slider with Content", "zuperla-extension" ),
			"description" => esc_html__( "Display a slider with content", "zuperla-extension" ),
			"base" => $tag,
			"class" => "",
			"icon"      => "icon-wpb-eut-content-slider",
			"category" => esc_html__( "Content", "js_composer" ),
			"params" => array(
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Post Type", "zuperla-extension" ),
					"param_name" => "post_type",
					'value' => array(
						esc_html__( 'Post', 'zuperla-extension' ) => 'post',
						esc_html__( 'Portfolio', 'zuperla-extension' ) => 'portfolio',
						esc_html__( 'Product', 'zuperla-extension' ) => 'product',
					),
					"description" => esc_html__( "Select the post type.", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Number of Posts", "zuperla-extension" ),
					"param_name" => "posts_per_page",
					"value" => array( '2','3','4','5','6','7','8' ),
					"description" => esc_html__( "Enter how many posts you want to display.", "zuperla-extension" ),
					"std" => '4',
				),
				zuperla_ext_vce_get_heading_tag( "h3" ),
				zuperla_ext_vce_get_heading( "h5" ),
				zuperla_ext_vce_get_custom_font_family(),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Image Size", "zuperla-extension" ),
					"param_name" => "image_mode",
					'value' => array(
						esc_html__( 'Square Small Crop', 'zuperla-extension' ) => 'square',
						esc_html__( 'Landscape Small Crop', 'zuperla-extension' ) => 'landscape',
						esc_html__( 'Portrait Small Crop', 'zuperla-extension' ) => 'portrait',
						esc_html__( 'Resize ( Large )', 'zuperla-extension' ) => 'large',
						esc_html__( 'Resize ( Medium Large )', 'zuperla-extension' ) => 'medium_large',
					),
					"std" => "landscape",
					"description" => esc_html__( "Select your Image size.", "zuperla-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Read More Title", "zuperla-extension" ),
					"param_name" => "read_more_title",
					"value" => "",
					"description" => esc_html__( "Enter the title for your link.", "zuperla-extension" ),
				),
/* 				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Parallax", "zuperla-extension" ),
					"param_name" => "parallax",
					"value" => array(
						esc_html__( "Yes", "zuperla-extension" ) => 'yes',
						esc_html__( "No", "zuperla-extension" ) => 'no',
					),
					"std" => "no",
				), */
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Autoplay", "zuperla-extension" ),
					"param_name" => "auto_play",
					"value" => array(
						esc_html__( "Yes", "zuperla-extension" ) => 'yes',
						esc_html__( "No", "zuperla-extension" ) => 'no',
					),
				),
				zuperla_ext_vce_add_slideshow_speed(),
				array(
					"type" => 'checkbox',
					"heading" => esc_html__( "Pause on Hover", "zuperla-extension" ),
					"param_name" => "pause_hover",
					"value" => array( esc_html__( "If selected, slider will be paused on hover", "zuperla-extension" ) => 'yes' ),
				),
				zuperla_ext_vce_add_auto_height(),
				zuperla_ext_vce_add_navigation_type(),
				zuperla_ext_vce_add_navigation_color(),
				zuperla_ext_vce_add_order_by(),
				zuperla_ext_vce_add_order(),
				zuperla_ext_vce_add_margin_bottom(),
				zuperla_ext_vce_add_el_class(),
				array(
					"type" => 'checkbox',
					"heading" => esc_html__( "Hide Author", "zuperla-extension" ),
					"param_name" => "hide_author",
					"description" => esc_html__( "If selected, blog overview will not show author.", "zuperla-extension" ),
					"value" => array( esc_html__( "Hide Author.", "zuperla-extension" ) => 'yes' ),
					"dependency" => array( 'element' => "post_type", 'value' => array( 'post' ) ),
					"group" => esc_html__( "Extras", "zuperla-extension" ),
				),
				array(
					"type" => 'checkbox',
					"heading" => esc_html__( "Hide Date", "zuperla-extension" ),
					"param_name" => "hide_date",
					"description" => esc_html__( "If selected, blog overview will not show date.", "zuperla-extension" ),
					"value" => array( esc_html__( "Hide Date.", "zuperla-extension" ) => 'yes' ),
					"dependency" => array( 'element' => "post_type", 'value' => array( 'post' ) ),
					"group" => esc_html__( "Extras", "zuperla-extension" ),
				),
				array(
					"type" => 'checkbox',
					"heading" => esc_html__( "Hide Like", "zuperla-extension" ),
					"param_name" => "hide_like",
					"description" => esc_html__( "If selected, blog overview will not show like.", "zuperla-extension" ),
					"value" => array( esc_html__( "Hide Like.", "zuperla-extension" ) => 'yes' ),
					"dependency" => array( 'element' => "post_type", 'value' => array( 'post' ) ),
					"group" => esc_html__( "Extras", "zuperla-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Exclude Posts", "zuperla-extension" ),
					"param_name" => "exclude_posts",
					"value" => '',
					"description" => esc_html__( "Type the post ids you want to exclude separated by comma ( , ).", "zuperla-extension" ),
					"group" => esc_html__( "Categories", "zuperla-extension" ),
				),
				array(
					"type" => "zuperla_ext_multi_checkbox",
					"heading" => esc_html__( "Categories", "zuperla-extension" ),
					"param_name" => "categories",
					"value" => zuperla_ext_vce_get_post_categories(),
					"description" => esc_html__( "Select all or multiple categories.", "zuperla-extension" ),
					"dependency" => array( 'element' => "post_type", 'value' => array( 'post' ) ),
					"group" => esc_html__( "Categories", "zuperla-extension" ),
				),
				array(
					"type" => "zuperla_ext_multi_checkbox",
					"heading" => __("Portfolio Categories", "zuperla-extension" ),
					"param_name" => "portfolio_categories",
					"value" => zuperla_ext_vce_get_portfolio_categories(),
					"description" => esc_html__( "Select all or multiple categories.", "zuperla-extension" ),
					"dependency" => array( 'element' => "post_type", 'value' => array( 'portfolio' ) ),
					"group" => esc_html__( "Categories", "zuperla-extension" ),
				),
				array(
					"type" => "zuperla_ext_multi_checkbox",
					"heading" => __("Product Categories", "zuperla-extension" ),
					"param_name" => "product_categories",
					"value" => zuperla_ext_vce_get_product_categories(),
					"description" => esc_html__( "Select all or multiple categories.", "zuperla-extension" ),
					"dependency" => array( 'element' => "post_type", 'value' => array( 'product' ) ),
					"group" => esc_html__( "Categories", "zuperla-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__("Include Specific Posts", "zuperla-extension" ),
					"param_name" => "include_posts",
					"value" => '',
					"description" => esc_html__( "Type the specific post ids you want to include separated by comma ( , ). Note: If you define specific post ids, Exclude Posts and Categories will have no effect.", "zuperla-extension" ),
					"group" => esc_html__( "Categories", "zuperla-extension" ),
				),
			),
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'zuperla_content_slider', 'zuperla_ext_vce_content_slider_shortcode_params' );
} else if( function_exists( 'vc_map' ) ) {
	$attributes = zuperla_ext_vce_content_slider_shortcode_params( 'zuperla_content_slider' );
	vc_map( $attributes );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
