<?php
/**
 * Single Product Meta
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $post, $product;

$product_get_id = method_exists( $product, 'get_id' ) ? $product->get_id() : $product->id;

?>

<div class="product_meta">

	<?php do_action( 'woocommerce_product_meta_start' ); ?>

	<?php if ( wc_product_sku_enabled() && ( $product->get_sku() || $product->is_type( 'variable' ) ) ) : ?>
		<?php ( $sku = $product->get_sku() ) ? $sku : __( 'N/A', 'woocommerce' ); ?>

		<span class="eut-single-product-meta sku_wrapper"><span class="eut-small-text"><?php esc_html_e( 'SKU:', 'woocommerce' ); ?></span> <span class="sku eut-small-text"><?php echo wp_kses_post( $sku ); ?></span></span>

	<?php endif; ?>

	<div class="eut-single-product-meta eut-categories eut-small-text">
	<?php
		if ( function_exists( 'wc_get_product_category_list' ) ) {
			echo wc_get_product_category_list( $product_get_id, ', ', '<span class="posted_in"><span>' . _n( 'Category:', 'Categories:', count( $product->get_category_ids() ), 'woocommerce' ) . '</span> ', '</span>' );
		} else {
			$cat_count = 0;
			$cats = get_the_terms( $post->ID, 'product_cat' );
			if ( !empty( $cats ) ) {
				$cat_count = count( $cats );
			}
			echo get_the_term_list( $product_get_id, 'product_cat', '<span class="posted_in"><span>' . _n( 'Category:', 'Categories:', $cat_count, 'woocommerce' ) . '</span> ', ', ', '</span>');
		}
	?>
	</div>

	<?php do_action( 'woocommerce_product_meta_end' ); ?>

</div>
