<?php
/*
 *	Euthemians Visual Composer Shortcode Extensions
 *
 * 	@author		Euthemians Team
 * 	@URI		http://euthemians.com
 */


if ( function_exists( 'vc_add_param' ) ) {

	//Generic css aniation for elements


	$zuperla_eutf_add_animation = array(
		"type" => "dropdown",
		"heading" => esc_html__("CSS Animation", 'zuperla' ),
		"param_name" => "animation",
		"admin_label" => true,
		"value" => array(
			esc_html__( "No", "zuperla" ) => '',
			esc_html__( "Fade In", "zuperla" ) => "eut-fade-in",
			esc_html__( "Fade In Up", "zuperla" ) => "eut-fade-in-up",
			esc_html__( "Fade In Up Big", "zuperla" ) => "eut-fade-in-up-big",
			esc_html__( "Fade In Down", "zuperla" ) => "eut-fade-in-down",
			esc_html__( "Fade In Down Big", "zuperla" ) => "eut-fade-in-down-big",
			esc_html__( "Fade In Left", "zuperla" ) => "eut-fade-in-left",
			esc_html__( "Fade In Left Big", "zuperla" ) => "eut-fade-in-left-big",
			esc_html__( "Fade In Right", "zuperla" ) => "eut-fade-in-right",
			esc_html__( "Fade In Right Big", "zuperla" ) => "eut-fade-in-right-big",
			esc_html__( "Zoom In", "zuperla" ) => "eut-zoom-in",
		),
		"description" => esc_html__("Select type of animation if you want this element to be animated when it enters into the browsers viewport. Note: Works only in modern browsers.", 'zuperla' ),
	);

	$zuperla_eutf_add_animation_delay = array(
		"type" => "textfield",
		"heading" => esc_html__( 'Css Animation Delay', 'zuperla' ),
		"param_name" => "animation_delay",
		"value" => '200',
		"description" => esc_html__( "Add delay in milliseconds.", 'zuperla' ),
	);

	$zuperla_eutf_add_animation_duration = array(
		"type" => "dropdown",
		"heading" => esc_html__("CSS Animation Duration", 'zuperla' ),
		"param_name" => "animation_duration",
		"value" => array(
			esc_html__( "Very Fast", "zuperla" ) => "very-fast",
			esc_html__( "Fast", "zuperla" ) => "fast",
			esc_html__( "Normal", "zuperla" ) => "normal",
			esc_html__( "Slow", "zuperla" ) => "slow",
			esc_html__( "Very Slow", "zuperla" ) => "very-slow",
		),
		"std" => 'normal',
		"description" => esc_html__("Select the duration for your animated element.", 'zuperla' ),
	);

	$zuperla_eutf_add_margin_bottom = array(
		"type" => "textfield",
		"heading" => esc_html__( 'Bottom margin', 'zuperla' ),
		"param_name" => "margin_bottom",
		"description" => esc_html__( "You can use px, em, %, etc. or enter just number and it will use pixels.", 'zuperla' ),
	);

	$zuperla_eutf_add_el_class = array(
		"type" => "textfield",
		"heading" => esc_html__("Extra class name", 'zuperla' ),
		"param_name" => "el_class",
		"description" => esc_html__( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", 'zuperla' ),
	);
	$zuperla_eutf_add_el_wrapper_class = array(
		"type" => "textfield",
		"heading" => esc_html__("Wrapper class name", 'zuperla' ),
		"param_name" => "el_wrapper_class",
		"description" => esc_html__( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", 'zuperla' ),
	);

	$zuperla_eutf_add_el_id =array(
		'type' => 'el_id',
		'heading' => __( 'Element ID', 'zuperla' ),
		'param_name' => 'el_id',
		'description' => esc_html__( 'Enter element ID (Note: make sure it is unique and valid).', 'zuperla' ),
	);

	$zuperla_eutf_column_width_list = array(
		esc_html__( '1 column - 1/12', 'zuperla' ) => '1/12',
		esc_html__( '2 columns - 1/6', 'zuperla' ) => '1/6',
		esc_html__( '3 columns - 1/4', 'zuperla' ) => '1/4',
		esc_html__( '4 columns - 1/3', 'zuperla' ) => '1/3',
		esc_html__( '5 columns - 5/12', 'zuperla' ) => '5/12',
		esc_html__( '6 columns - 1/2', 'zuperla' ) => '1/2',
		esc_html__( '7 columns - 7/12', 'zuperla' ) => '7/12',
		esc_html__( '8 columns - 2/3', 'zuperla' ) => '2/3',
		esc_html__( '9 columns - 3/4', 'zuperla' ) => '3/4',
		esc_html__( '10 columns - 5/6', 'zuperla' ) => '5/6',
		esc_html__( '11 columns - 11/12', 'zuperla' ) => '11/12',
		esc_html__( '12 columns - 1/1', 'zuperla' ) => '1/1'
	);

	$zuperla_eutf_column_desktop_hide_list = array(
		esc_html__( 'Default value from width attribute', 'zuperla') => '',
		esc_html__( 'Hide', 'zuperla' ) => 'hide',
	);

	$zuperla_eutf_column_width_tablet_list = array(
		esc_html__( 'Default value from width attribute', 'zuperla') => '',
		esc_html__( 'Hide', 'zuperla' ) => 'hide',
		esc_html__( '1 column - 1/12', 'zuperla' ) => '1-12',
		esc_html__( '2 columns - 1/6', 'zuperla' ) => '1-6',
		esc_html__( '3 columns - 1/4', 'zuperla' ) => '1-4',
		esc_html__( '4 columns - 1/3', 'zuperla' ) => '1-3',
		esc_html__( '5 columns - 5/12', 'zuperla' ) => '5-12',
		esc_html__( '6 columns - 1/2', 'zuperla' ) => '1-2',
		esc_html__( '7 columns - 7/12', 'zuperla' ) => '7-12',
		esc_html__( '8 columns - 2/3', 'zuperla' ) => '2-3',
		esc_html__( '9 columns - 3/4', 'zuperla' ) => '3-4',
		esc_html__( '10 columns - 5/6', 'zuperla' ) => '5-6',
		esc_html__( '11 columns - 11/12', 'zuperla' ) => '11-12',
		esc_html__( '12 columns - 1/1', 'zuperla' ) => '1',
	);

	$zuperla_eutf_column_width_tablet_sm_list = array(
		esc_html__( 'Inherit from Tablet Landscape', 'zuperla') => '',
		esc_html__( 'Hide', 'zuperla' ) => 'hide',
		esc_html__( '1 column - 1/12', 'zuperla' ) => '1-12',
		esc_html__( '2 columns - 1/6', 'zuperla' ) => '1-6',
		esc_html__( '3 columns - 1/4', 'zuperla' ) => '1-4',
		esc_html__( '4 columns - 1/3', 'zuperla' ) => '1-3',
		esc_html__( '5 columns - 5/12', 'zuperla' ) => '5-12',
		esc_html__( '6 columns - 1/2', 'zuperla' ) => '1-2',
		esc_html__( '7 columns - 7/12', 'zuperla' ) => '7-12',
		esc_html__( '8 columns - 2/3', 'zuperla' ) => '2-3',
		esc_html__( '9 columns - 3/4', 'zuperla' ) => '3-4',
		esc_html__( '10 columns - 5/6', 'zuperla' ) => '5-6',
		esc_html__( '11 columns - 11/12', 'zuperla' ) => '11-12',
		esc_html__( '12 columns - 1/1', 'zuperla' ) => '1',
	);
	$zuperla_eutf_column_mobile_width_list = array(
		esc_html__( 'Default value 12 columns - 1/1', 'zuperla' ) => '',
		esc_html__( 'Hide', 'zuperla' ) => 'hide',
		esc_html__( '3 columns - 1/4', 'zuperla' ) => '1-4',
		esc_html__( '4 columns - 1/3', 'zuperla' ) => '1-3',
		esc_html__( '6 columns - 1/2', 'zuperla' ) => '1-2',
		esc_html__( '12 columns - 1/1', 'zuperla' ) => '1',
	);

	//Add additional column options for Page Builder 5.5
	if ( defined( 'WPB_VC_VERSION' ) && version_compare( WPB_VC_VERSION, '5.5', '>=' ) ) {
		$zuperla_eutf_extra_list = array(
			esc_html__( '20% - 1/5', 'zuperla' ) => '1/5',
			esc_html__( '40% - 2/5', 'zuperla' ) => '2/5',
			esc_html__( '60% - 3/5', 'zuperla' ) => '3/5',
			esc_html__( '80% - 4/5', 'zuperla' ) => '4/5',
		);
		$zuperla_eutf_column_width_list = array_merge( $zuperla_eutf_column_width_list, $zuperla_eutf_extra_list);

		$zuperla_eutf_extra_list_simplified = array(
			esc_html__( '20% - 1/5', 'zuperla' ) => '1-5',
			esc_html__( '40% - 2/5', 'zuperla' ) => '2-5',
			esc_html__( '60% - 3/5', 'zuperla' ) => '3-5',
			esc_html__( '80% - 4/5', 'zuperla' ) => '4-5',
		);
		$zuperla_eutf_column_width_tablet_list = array_merge( $zuperla_eutf_column_width_tablet_list, $zuperla_eutf_extra_list_simplified );
		$zuperla_eutf_column_width_tablet_sm_list = array_merge( $zuperla_eutf_column_width_tablet_sm_list, $zuperla_eutf_extra_list_simplified );
		$zuperla_eutf_column_mobile_width_list = array_merge( $zuperla_eutf_column_mobile_width_list, $zuperla_eutf_extra_list_simplified );
	}

	$zuperla_eutf_column_gap_list = array(
		esc_html__( 'No Gap', 'zuperla' ) => 'none',
		esc_html__( '5px', 'zuperla' ) => '5',
		esc_html__( '10px', 'zuperla' ) => '10',
		esc_html__( '15px', 'zuperla' ) => '15',
		esc_html__( '20px', 'zuperla' ) => '20',
		esc_html__( '25px', 'zuperla' ) => '25',
		esc_html__( '30px', 'zuperla' ) => '30',
		esc_html__( '35px', 'zuperla' ) => '35',
		esc_html__( '40px', 'zuperla' ) => '40',
		esc_html__( '45px', 'zuperla' ) => '45',
		esc_html__( '50px', 'zuperla' ) => '50',
		esc_html__( '55px', 'zuperla' ) => '55',
		esc_html__( '60px', 'zuperla' ) => '60',
	);

	$zuperla_eutf_position_list = array(
		esc_html__( "None", 'zuperla' ) => '',
		esc_html__( "1x", 'zuperla' ) => '1x',
		esc_html__( "2x", 'zuperla' ) => '2x',
		esc_html__( "3x", 'zuperla' ) => '3x',
		esc_html__( "4x", 'zuperla' ) => '4x',
		esc_html__( "5x", 'zuperla' ) => '5x',
		esc_html__( "6x", 'zuperla' ) => '6x',
		esc_html__( "-1x", 'zuperla' ) => 'minus-1x',
		esc_html__( "-2x", 'zuperla' ) => 'minus-2x',
		esc_html__( "-3x", 'zuperla' ) => 'minus-3x',
		esc_html__( "-4x", 'zuperla' ) => 'minus-4x',
		esc_html__( "-5x", 'zuperla' ) => 'minus-5x',
		esc_html__( "-6x", 'zuperla' ) => 'minus-6x',
	);

	$zuperla_eutf_separator_list = array(
		esc_html__( "None", 'zuperla' ) => '',
		esc_html__( "Triangle", 'zuperla' ) => 'triangle-separator',
		esc_html__( "Large Triangle", 'zuperla' ) => 'large-triangle-separator',
		esc_html__( "Curve", 'zuperla' ) => 'curve-separator',
		esc_html__( "Curve Left", 'zuperla' ) => 'curve-left-separator',
		esc_html__( "Curve Right", 'zuperla' ) => 'curve-right-separator',
		esc_html__( "Tilt Left", 'zuperla' ) => 'tilt-left-separator',
		esc_html__( "Tilt Right", 'zuperla' ) => 'tilt-right-separator',
		esc_html__( "Round Split", 'zuperla' ) => 'round-split-separator',
		esc_html__( "Torn Paper", 'zuperla' ) => 'torn-paper-separator',
	);

	$zuperla_eutf_separator_size_list = array(
		esc_html__( "Small", 'zuperla' ) => '30px',
		esc_html__( "Medium", 'zuperla' ) => '60px',
		esc_html__( "Large", 'zuperla' ) => '90px',
		esc_html__( "Extra Large", 'zuperla' ) => '120px',
		esc_html__( "Section Height", 'zuperla' ) => '100%',
	);

	//Title Headings/Tags
	if( !function_exists( 'zuperla_eutf_get_heading_tag' ) ) {
		function zuperla_eutf_get_heading_tag( $std = '' ) {
			return	array(
				"type" => "dropdown",
				"heading" => esc_html__( "Title Tag", "zuperla" ),
				"param_name" => "heading_tag",
				"value" => array(
					esc_html__( "h1", "zuperla" ) => 'h1',
					esc_html__( "h2", "zuperla" ) => 'h2',
					esc_html__( "h3", "zuperla" ) => 'h3',
					esc_html__( "h4", "zuperla" ) => 'h4',
					esc_html__( "h5", "zuperla" ) => 'h5',
					esc_html__( "h6", "zuperla" ) => 'h6',
					esc_html__( "div", "zuperla" ) => 'div',
				),
				"description" => esc_html__( "Title Tag for SEO", "zuperla" ),
				"std" => $std,
				"group" => esc_html__( "Titles & Styles", "zuperla" ),
			);
		}
	}

	if( !function_exists( 'zuperla_eutf_get_heading' ) ) {
		function zuperla_eutf_get_heading( $std = '' ) {
			return	array(
				"type" => "dropdown",
				"heading" => esc_html__( "Title Size/Typography", "zuperla" ),
				"param_name" => "heading",
				"value" => array(
					esc_html__( "h1", "zuperla" ) => 'h1',
					esc_html__( "h2", "zuperla" ) => 'h2',
					esc_html__( "h3", "zuperla" ) => 'h3',
					esc_html__( "h4", "zuperla" ) => 'h4',
					esc_html__( "h5", "zuperla" ) => 'h5',
					esc_html__( "h6", "zuperla" ) => 'h6',
					esc_html__( "Leader Text", "zuperla" ) => 'leader-text',
					esc_html__( "Subtitle Text", "zuperla" ) => 'subtitle-text',
					esc_html__( "Small Text", "zuperla" ) => 'small-text',
					esc_html__( "Link Text", "zuperla" ) => 'link-text',
				),
				"description" => esc_html__( "Title size and typography, defined in Theme Options - Typography Options", "zuperla" ),
				"std" => $std,
				"group" => esc_html__( "Titles & Styles", "zuperla" ),
			);
		}
	}
	if( !function_exists( 'zuperla_eutf_get_custom_font_family' ) ) {
		function zuperla_eutf_get_custom_font_family( $std = '' ) {
			return	array(
				"type" => "dropdown",
				"heading" => esc_html__( "Custom Font Family", "zuperla" ),
				"param_name" => "custom_font_family",
				"value" => array(
					esc_html__( "Same as Typography", "zuperla" ) => '',
					esc_html__( "Custom Font Family 1", "zuperla" ) => 'custom-font-1',
					esc_html__( "Custom Font Family 2", "zuperla" ) => 'custom-font-2',
					esc_html__( "Custom Font Family 3", "zuperla" ) => 'custom-font-3',
					esc_html__( "Custom Font Family 4", "zuperla" ) => 'custom-font-4',

				),
				"description" => esc_html__( "Select a different font family, defined in Theme Options - Typography Options - Extras - Custom Font Family", "zuperla" ),
				"std" => $std,
				"group" => esc_html__( "Titles & Styles", "zuperla" ),
			);
		}
	}


	vc_add_param('vc_tta_tabs', zuperla_eutf_get_heading_tag('h3') );
	vc_add_param('vc_tta_tabs', zuperla_eutf_get_heading('h6') );
	vc_add_param('vc_tta_tabs', zuperla_eutf_get_custom_font_family() );
	vc_add_param('vc_tta_tour', zuperla_eutf_get_heading_tag('h3') );
	vc_add_param('vc_tta_tour', zuperla_eutf_get_heading('h6') );
	vc_add_param('vc_tta_tour', zuperla_eutf_get_custom_font_family() );
	vc_add_param('vc_tta_accordion', zuperla_eutf_get_heading_tag('h3') );
	vc_add_param('vc_tta_accordion', zuperla_eutf_get_heading('h6') );
	vc_add_param('vc_tta_accordion', zuperla_eutf_get_custom_font_family() );

	vc_add_param( "vc_row",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Row Type", 'zuperla' ),
			"param_name" => "section_type",
			"value" => array(
				esc_html__( "Full Width Background", 'zuperla' ) => 'fullwidth-background',
				esc_html__( "Full Width Content", 'zuperla' ) => 'fullwidth',
				esc_html__( "Container Width", 'zuperla' ) => 'container-width',
			),
			"description" => esc_html__( "Select row type", 'zuperla' ),
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Row Height", 'zuperla' ),
			"param_name" => "height_ratio",
			"value" => array(
				esc_html__( "Auto", 'zuperla' ) => 'auto',
				esc_html__( "10%", 'zuperla' ) => '10',
				esc_html__( "20%", 'zuperla' ) => '20',
				esc_html__( "30%", 'zuperla' ) => '30',
				esc_html__( "40%", 'zuperla' ) => '40',
				esc_html__( "50%", 'zuperla' ) => '50',
				esc_html__( "60%", 'zuperla' ) => '60',
				esc_html__( "70%", 'zuperla' ) => '70',
				esc_html__( "80%", 'zuperla' ) => '80',
				esc_html__( "90%", 'zuperla' ) => '90',
				esc_html__( "100%", 'zuperla' ) => '100',
			),
			"description" => esc_html__( "Select your row height", 'zuperla' ),
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => "textfield",
			"heading" => esc_html__( "Row Min Height", 'zuperla' ),
			"param_name" => "min_height",
			"description" => esc_html__( "Set the row minimum height in pixel.", 'zuperla' ),
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Top padding", 'zuperla' ),
			"param_name" => "padding_top_multiplier",
			"value" => array(
				esc_html__( "None", 'zuperla' ) => '',
				esc_html__( "1x", 'zuperla' ) => '1x',
				esc_html__( "2x", 'zuperla' ) => '2x',
				esc_html__( "3x", 'zuperla' ) => '3x',
				esc_html__( "4x", 'zuperla' ) => '4x',
				esc_html__( "5x", 'zuperla' ) => '5x',
				esc_html__( "6x", 'zuperla' ) => '6x',
				esc_html__( "Custom", 'zuperla' ) => 'custom',
			),
			"std" => '1x',
			"description" => esc_html__( "Select padding top for your section.", 'zuperla' ),
		)
	);
	vc_add_param( "vc_row",
		array(
			"type" => "textfield",
			"heading" => esc_html__( "Custom Top padding", 'zuperla' ),
			"param_name" => "padding_top",
			"dependency" => array(
				'element' => 'padding_top_multiplier',
				'value' => array( 'custom' )
			),
			"description" => esc_html__( "You can use px, em, %, etc. or enter just number and it will use pixels.", 'zuperla' ),
		)
	);
	vc_add_param( "vc_row",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Bottom padding", 'zuperla' ),
			"param_name" => "padding_bottom_multiplier",
			"value" => array(
				esc_html__( "None", 'zuperla' ) => '',
				esc_html__( "1x", 'zuperla' ) => '1x',
				esc_html__( "2x", 'zuperla' ) => '2x',
				esc_html__( "3x", 'zuperla' ) => '3x',
				esc_html__( "4x", 'zuperla' ) => '4x',
				esc_html__( "5x", 'zuperla' ) => '5x',
				esc_html__( "6x", 'zuperla' ) => '6x',
				esc_html__( "Custom", 'zuperla' ) => 'custom',
			),
			"std" => '1x',
			"description" => esc_html__( "Select padding bottom for your section.", 'zuperla' ),
		)
	);
	vc_add_param( "vc_row",
		array(
			"type" => "textfield",
			"heading" => esc_html__( "Custom Bottom padding", 'zuperla' ),
			"param_name" => "padding_bottom",
			"dependency" => array(
				'element' => 'padding_bottom_multiplier',
				'value' => array( 'custom' )
			),
			"description" => esc_html__( "You can use px, em, %, etc. or enter just number and it will use pixels.", 'zuperla' ),
		)
	);
	vc_add_param( "vc_row",
		array(
		"type" => "textfield",
		"heading" => esc_html__( 'Bottom margin', 'zuperla' ),
		"param_name" => "rc_margin_bottom",
		"description" => esc_html__( "You can use px, em, %, etc. or enter just number and it will use pixels.", 'zuperla' ),
		)
	);
	vc_add_param( "vc_row",	
		array(
			'type' => 'checkbox',
			'heading' => esc_html__( 'Disable row', 'zuperla' ),
			'param_name' => 'disable_element',
			'description' => esc_html__( 'If checked the row won\'t be visible on the public side of your website. You can switch it back any time.', 'zuperla' ),
			'value' => array( esc_html__( 'Yes', 'zuperla' ) => 'yes' ),
		)
	);	

	vc_add_param( "vc_row",
		array(
			"type" => "textfield",
			"heading" => esc_html__('Section ID', 'zuperla' ),
			"param_name" => "section_id",
			"description" => esc_html__("If you wish you can type an id to use it as bookmark.", 'zuperla' ),
		)
	);

	vc_add_param( "vc_row", $zuperla_eutf_add_el_class );
	vc_add_param( "vc_row", $zuperla_eutf_add_el_wrapper_class );

	vc_add_param( "vc_row",
		array(
			"type" => "colorpicker",
			"heading" => esc_html__('Font Color', 'zuperla' ),
			"param_name" => "rc_font_color",
			"description" => esc_html__("Select font color", 'zuperla' ),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Heading Color", 'zuperla' ),
			"param_name" => "rc_heading_color",
			"param_holder_class" => "eut-colored-dropdown",
			"value" => array(
				esc_html__( "Default", 'zuperla' ) => '',
				esc_html__( "Dark", 'zuperla' ) => 'dark',
				esc_html__( "Light", 'zuperla' ) => 'light',
				esc_html__( "Primary 1", 'zuperla' ) => 'primary-1',
				esc_html__( "Primary 2", 'zuperla' ) => 'primary-2',
				esc_html__( "Primary 3", 'zuperla' ) => 'primary-3',
				esc_html__( "Primary 4", 'zuperla' ) => 'primary-4',
				esc_html__( "Primary 5", 'zuperla' ) => 'primary-5',
				esc_html__( "Primary 6", 'zuperla' ) => 'primary-6',
				esc_html__( "Green", 'zuperla' ) => 'green',
				esc_html__( "Orange", 'zuperla' ) => 'orange',
				esc_html__( "Red", 'zuperla' ) => 'red',
				esc_html__( "Blue", 'zuperla' ) => 'blue',
				esc_html__( "Aqua", 'zuperla' ) => 'aqua',
				esc_html__( "Purple", 'zuperla' ) => 'purple',
				esc_html__( "Grey", 'zuperla' ) => 'grey',
			),
			"description" => esc_html__( "Select heading color", 'zuperla' ),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => 'dropdown',
			"heading" => esc_html__( "Background Type", 'zuperla' ),
			"param_name" => "rc_bg_type",
			"description" => esc_html__( "Select Background type", 'zuperla' ),
			"value" => array(
				esc_html__( "None", 'zuperla' ) => '',
				esc_html__( "Color", 'zuperla' ) => 'color',
				esc_html__( "Gradient Color", 'zuperla' ) => 'gradient',
				esc_html__( "Image", 'zuperla' ) => 'image',
				esc_html__( "Hosted Video", 'zuperla' ) => 'hosted_video',
				esc_html__( "YouTube Video", 'zuperla' ) => 'video',
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);

	vc_add_param( "vc_row",
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'YouTube link', 'zuperla' ),
			'param_name' => 'rc_bg_video_url',
			'value' => 'https://www.youtube.com/watch?v=C9tsrkRSw-Q',
			// default video url
			'description' => esc_html__( 'Add YouTube link.', 'zuperla' ),
			'dependency' => array(
				'element' => 'rc_bg_type',
				'value' => 'video',
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Video Popup Button", 'zuperla' ),
			"param_name" => "rc_bg_video_button",
			"value" => array(
				esc_html__( 'None', 'zuperla' ) => '',
				esc_html__( 'Devices only', 'zuperla' ) => 'device',
				esc_html__( 'Always visible', 'zuperla' ) => 'all',
			),
			"description" => esc_html__( "Select video popup button behavior", 'zuperla' ),
			'dependency' => array(
				'element' => 'rc_bg_type',
				'value' => 'video',
			),
			"std" => 'center-center',
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Video Button Position", 'zuperla' ),
			"param_name" => "rc_bg_video_button_position",
			"value" => array(
				esc_html__( 'Left Top', 'zuperla' ) => 'left-top',
				esc_html__( 'Left Bottom', 'zuperla' ) => 'left-bottom',
				esc_html__( 'Center Center', 'zuperla' ) => 'center-center',
				esc_html__( 'Right Top', 'zuperla' ) => 'right-top',
				esc_html__( 'Right Bottom', 'zuperla' ) => 'right-bottom',
			),
			"description" => esc_html__( "Select position for video popup", 'zuperla' ),
			'dependency' => array(
				'element' => 'rc_bg_video_button',
				'value_not_equal_to' => array( '' )
			),
			"std" => 'center-center',
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => "colorpicker",
			"heading" => esc_html__( "Custom Background Color", 'zuperla' ),
			"param_name" => "rc_bg_color",
			"description" => esc_html__( "Select background color for your row", 'zuperla' ),
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'color' )
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => "colorpicker",
			"heading" => esc_html__( "Custom Color 1", 'zuperla' ),
			"param_name" => "rc_bg_gradient_color_1",
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'gradient' )
			),
			"std" => 'rgba(3,78,144,0.9)',
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => "colorpicker",
			"heading" => esc_html__( "Custom Color 2", 'zuperla' ),
			"param_name" => "rc_bg_gradient_color_2",
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'gradient' )
			),
			"std" => 'rgba(25,180,215,0.9)',
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);
	vc_add_param( "vc_row",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Gradient Direction", 'zuperla' ),
			"param_name" => "rc_bg_gradient_direction",
			"value" => array(
				esc_html__( "Left to Right", 'zuperla' ) => '90',
				esc_html__( "Left Top to Right Bottom", 'zuperla' ) => '135',
				esc_html__( "Left Bottom to Right Top", 'zuperla' ) => '45',
				esc_html__( "Bottom to Top", 'zuperla' ) => '180',
			),
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'gradient' )
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => "attach_image",
			"heading" => esc_html__('Background Image', 'zuperla' ),
			"param_name" => "rc_bg_image",
			"value" => '',
			"description" => esc_html__("Select background image for your row. Used also as fallback for video.", 'zuperla' ),
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'image', 'hosted_video', 'video' )
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);
	vc_add_param( "vc_row",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Background Image Type", 'zuperla' ),
			"param_name" => "rc_bg_image_type",
			"value" => array(
				esc_html__( "Default", 'zuperla' ) => '',
				esc_html__( "Parallax", 'zuperla' ) => 'parallax',
				esc_html__( "Horizontal Parallax Left to Right", 'zuperla' ) => 'horizontal-parallax-lr',
				esc_html__( "Horizontal Parallax Right to Left", 'zuperla' ) => 'horizontal-parallax-rl',
				esc_html__( "Animated", 'zuperla' ) => 'animated',
				esc_html__( "Horizontal Animation", 'zuperla' ) => 'horizontal',
				esc_html__( "Fixed Image", 'zuperla' ) => 'fixed',
				esc_html__( "Image usage as Pattern", 'zuperla' ) => 'pattern'
			),
			"description" => esc_html__( "Select how a background image will be displayed", 'zuperla' ),
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'image' )
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);
	vc_add_param( "vc_row",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Background Image Size", 'zuperla' ),
			"param_name" => "rc_bg_image_size",
			"value" => array(
				esc_html__( "--Inherit--", 'zuperla' ) => '',
				esc_html__( "Responsive", 'zuperla' ) => 'responsive',
				esc_html__( "Extra Extra Large", 'zuperla' ) => 'extra-extra-large',
				esc_html__( "Full", 'zuperla' ) => 'full',
			),
			"description" => esc_html__( "Select the size of your background image", 'zuperla' ),
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'image' )
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);
	vc_add_param( "vc_row",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Background Image Vertical Position", 'zuperla' ),
			"param_name" => "rc_bg_image_vertical_position",
			"value" => array(
				esc_html__( "Top", 'zuperla' ) => 'top',
				esc_html__( "Center", 'zuperla' ) => 'center',
				esc_html__( "Bottom", 'zuperla' ) => 'bottom',
			),
			"description" => esc_html__( "Select vertical position for background image", 'zuperla' ),
			"dependency" => array(
				'element' => 'rc_bg_image_type',
				'value' => array( 'horizontal-parallax-lr', 'horizontal-parallax-rl', 'horizontal' )
			),
			"std" => 'center',
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);
	vc_add_param( "vc_row",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Background  Position", 'zuperla' ),
			"param_name" => "rc_bg_position",
			"value" => array(
				esc_html__( 'Left Top', 'zuperla' ) => 'left-top',
				esc_html__( 'Left Center', 'zuperla' ) => 'left-center',
				esc_html__( 'Left Bottom', 'zuperla' ) => 'left-bottom',
				esc_html__( 'Center Top', 'zuperla' ) => 'center-top',
				esc_html__( 'Center Center', 'zuperla' ) => 'center-center',
				esc_html__( 'Center Bottom', 'zuperla' ) => 'center-bottom',
				esc_html__( 'Right Top', 'zuperla' ) => 'right-top',
				esc_html__( 'Right Center', 'zuperla' ) => 'right-center',
				esc_html__( 'Right Bottom', 'zuperla' ) => 'right-bottom',
			),
			"description" => esc_html__( "Select position for background image", 'zuperla' ),
			"dependency" => array(
				'element' => 'rc_bg_image_type',
				'value' => array( '', 'animated' )
			),
			"std" => 'center-center',
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);
	vc_add_param( "vc_row",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Background Position ( Tablet Portrait )", 'zuperla' ),
			"param_name" => "rc_bg_tablet_sm_position",
			"value" => array(
				esc_html__( 'Inherit from above', 'zuperla' ) => '',
				esc_html__( 'Left Top', 'zuperla' ) => 'left-top',
				esc_html__( 'Left Center', 'zuperla' ) => 'left-center',
				esc_html__( 'Left Bottom', 'zuperla' ) => 'left-bottom',
				esc_html__( 'Center Top', 'zuperla' ) => 'center-top',
				esc_html__( 'Center Center', 'zuperla' ) => 'center-center',
				esc_html__( 'Center Bottom', 'zuperla' ) => 'center-bottom',
				esc_html__( 'Right Top', 'zuperla' ) => 'right-top',
				esc_html__( 'Right Center', 'zuperla' ) => 'right-center',
				esc_html__( 'Right Bottom', 'zuperla' ) => 'right-bottom',
			),
			"description" => esc_html__( "Tablet devices with portrait orientation and below.", 'zuperla' ),
			"dependency" => array(
				'element' => 'rc_bg_image_type',
				'value' => array( '', 'animated' )
			),
			"std" => '',
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);
	vc_add_param( "vc_row",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Parallax Sensor", 'zuperla' ),
			"param_name" => "rc_bg_parallax_threshold",
			"value" => array(
				esc_html__( "Low", 'zuperla' ) => '0.1',
				esc_html__( "Normal", 'zuperla' ) => '0.3',
				esc_html__( "High", 'zuperla' ) => '0.5',
				esc_html__( "Max", 'zuperla' ) => '0.8',
			),
			"description" => esc_html__( "Define the appearance for the parallax effect. Note that you get greater image zoom when you increase the parallax sensor.", 'zuperla' ),
			"dependency" => array(
				'element' => 'rc_bg_image_type',
				'value' => array( 'parallax', 'horizontal-parallax-lr', 'horizontal-parallax-rl' )
			),
			"std" => '0.3',
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);
	vc_add_param( "vc_row",
		array(
			"type" => "textfield",
			"heading" => esc_html__("WebM File URL", 'zuperla'),
			"param_name" => "rc_bg_video_webm",
			"description" => esc_html__( "Fill WebM and mp4 format for browser compatibility", 'zuperla' ),
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'hosted_video' )
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);
	vc_add_param( "vc_row",
		array(
			"type" => "textfield",
			"heading" => esc_html__( "MP4 File URL", 'zuperla' ),
			"param_name" => "rc_bg_video_mp4",
			"description" => esc_html__( "Fill mp4 format URL", 'zuperla' ),
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'hosted_video' )
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);
	vc_add_param( "vc_row",
		array(
			"type" => "textfield",
			"heading" => esc_html__( "OGV File URL", 'zuperla' ),
			"param_name" => "rc_bg_video_ogv",
			"description" => esc_html__( "Fill OGV format URL ( optional )", 'zuperla' ),
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'hosted_video' )
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);
	vc_add_param( "vc_row",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Loop", 'zuperla' ),
			"param_name" => "rc_bg_video_loop",
			"value" => array(
				esc_html__( "Yes", 'zuperla' ) => 'yes',
				esc_html__( "No", 'zuperla' ) => 'no',
			),
			"std" => 'yes',
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'hosted_video' )
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);
	vc_add_param( "vc_row",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Allow on devices", 'zuperla' ),
			"param_name" => "rc_bg_video_device",
			"value" => array(
				esc_html__( "No", 'zuperla' ) => 'no',
				esc_html__( "Yes", 'zuperla' ) => 'yes',

			),
			"std" => 'no',
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'hosted_video' )
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);
	vc_add_param( "vc_row",
		array(
			"type" => 'checkbox',
			"heading" => esc_html__( "Pattern overlay", 'zuperla'),
			"param_name" => "rc_bg_pattern_overlay",
			"description" => esc_html__( "If selected, a pattern will be added.", 'zuperla' ),
			"value" => Array(esc_html__( "Add pattern", 'zuperla' ) => 'yes'),
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'image', 'hosted_video', 'video' )
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);
	vc_add_param( "vc_row",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Color overlay", 'zuperla' ),
			"param_name" => "rc_bg_color_overlay",
			"param_holder_class" => "eut-colored-dropdown",
			"value" => array(
				esc_html__( "None", 'zuperla' ) => '',
				esc_html__( "Dark", 'zuperla' ) => 'dark',
				esc_html__( "Light", 'zuperla' ) => 'light',
				esc_html__( "Primary 1", 'zuperla' ) => 'primary-1',
				esc_html__( "Primary 2", 'zuperla' ) => 'primary-2',
				esc_html__( "Primary 3", 'zuperla' ) => 'primary-3',
				esc_html__( "Primary 4", 'zuperla' ) => 'primary-4',
				esc_html__( "Primary 5", 'zuperla' ) => 'primary-5',
				esc_html__( "Primary 6", 'zuperla' ) => 'primary-6',
				esc_html__( "Custom", 'zuperla' ) => 'custom',
				esc_html__( "Gradient", 'zuperla' ) => 'gradient',
			),
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'image', 'hosted_video', 'video' )
			),
			"description" => esc_html__( "A color overlay for the media", 'zuperla' ),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => "colorpicker",
			"heading" => esc_html__('Custom Color Overlay', 'zuperla' ),
			"param_name" => "rc_bg_color_overlay_custom",
			"dependency" => array(
				'element' => 'rc_bg_color_overlay',
				'value' => array( 'custom' )
			),
			"std" => 'rgba(255,255,255,0.1)',
			"description" => esc_html__("Select custom color overlay", 'zuperla' ),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => "colorpicker",
			"heading" => esc_html__('Gradient Color Overlay 1', 'zuperla' ),
			"param_name" => "rc_bg_gradient_overlay_custom_1",
			"dependency" => array(
				'element' => 'rc_bg_color_overlay',
				'value' => array( 'gradient' )
			),
			"std" => 'rgba(3,78,144,0.9)',
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => "colorpicker",
			"heading" => esc_html__('Gradient Color Overlay 2', 'zuperla' ),
			"param_name" => "rc_bg_gradient_overlay_custom_2",
			"dependency" => array(
				'element' => 'rc_bg_color_overlay',
				'value' => array( 'gradient' )
			),
			"std" => 'rgba(25,180,215,0.9)',
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Gradient Direction", 'zuperla' ),
			"param_name" => "rc_bg_gradient_overlay_direction",
			"value" => array(
				esc_html__( "Left to Right", 'zuperla' ) => '90',
				esc_html__( "Left Top to Right Bottom", 'zuperla' ) => '135',
				esc_html__( "Left Bottom to Right Top", 'zuperla' ) => '45',
				esc_html__( "Bottom to Top", 'zuperla' ) => '180',
			),
			"dependency" => array(
				'element' => 'rc_bg_color_overlay',
				'value' => array( 'gradient' )
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Opacity overlay", 'zuperla' ),
			"param_name" => "rc_bg_opacity_overlay",
			"value" => array( '10', '20', '30' ,'40', '50', '60', '70', '80' ,'90' ),
			"std" => '10',
			"description" => esc_html__( "Opacity of the overlay", 'zuperla' ),
			"dependency" => array(
				'element' => 'rc_bg_color_overlay',
				'value' => array( 'dark', 'light', 'primary-1', 'primary-2', 'primary-3', 'primary-4', 'primary-5', 'primary-6' )
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Columns Gap", 'zuperla' ),
			"param_name" => "columns_gap",
			'value' => $zuperla_eutf_column_gap_list,
			"description" => esc_html__( "Select gap between columns in row.", 'zuperla' ),
			"group" => esc_html__( "Inner Columns", 'zuperla' ),
			"std" => '50',
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => 'checkbox',
			"heading" => esc_html__( "Equal Column Height", 'zuperla' ),
			"param_name" => "equal_column_height",
			"description" => esc_html__( "Select if you need the same height for the columns of this row. Recommended for multiple columns with different background colors.", 'zuperla' ),
			"value" => Array(esc_html__( "Equal Height Columns", 'zuperla' ) => 'equal'),
			"group" => esc_html__( "Inner Columns", 'zuperla' ),
		)
	);

	vc_add_param( "vc_row",
		array(
			'type' => 'checkbox',
			'heading' => esc_html__( 'Reverse columns in RTL', 'zuperla' ),
			'param_name' => 'rtl_reverse',
			'description' => esc_html__( 'If checked columns will be reversed in RTL.', 'zuperla' ),
			'value' => array( esc_html__( 'Yes', 'zuperla' ) => 'yes' ),
			"group" => esc_html__( "Inner Columns", 'zuperla' ),
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => 'zuperla_param_label',
			"heading" => esc_html__( "Visibility", 'zuperla'),
			"param_name" => "label_visibility",
			'value' => '',
			'std' => '',
			"description" => esc_html__( "If selected, row will be hidden on desktops/laptops and devices.", 'zuperla' ),
			'group' => esc_html__( "Responsiveness", 'zuperla' ),
		)
	);
	vc_add_param( "vc_row",
		array(
			"type" => 'checkbox',
			"heading" => esc_html__( "Desktop Visibility", 'zuperla'),
			"param_name" => "desktop_visibility",
			"value" => Array(esc_html__( "Hide", 'zuperla' ) => 'hide'),
			'edit_field_class' => 'vc_col-sm-6',
			'group' => esc_html__( "Responsiveness", 'zuperla' ),
		)
	);
	vc_add_param( "vc_row",
		array(
			"type" => 'checkbox',
			"heading" => esc_html__( "Tablet Landscape Visibility", 'zuperla'),
			"param_name" => "tablet_visibility",
			"value" => Array(esc_html__( "Hide", 'zuperla' ) => 'hide'),
			'edit_field_class' => 'vc_col-sm-6',
			'group' => esc_html__( "Responsiveness", 'zuperla' ),
		)
	);
	vc_add_param( "vc_row",
		array(
			"type" => 'checkbox',
			"heading" => esc_html__( "Tablet Portrait Visibility", 'zuperla'),
			"param_name" => "tablet_sm_visibility",
			"value" => Array(esc_html__( "Hide", 'zuperla' ) => 'hide'),
			'edit_field_class' => 'vc_col-sm-6',
			'group' => esc_html__( "Responsiveness", 'zuperla' ),
		)
	);
	vc_add_param( "vc_row",
		array(
			"type" => 'checkbox',
			"heading" => esc_html__( "Mobile Visibility", 'zuperla'),
			"param_name" => "mobile_visibility",
			"value" => Array(esc_html__( "Hide", 'zuperla' ) => 'hide'),
			'edit_field_class' => 'vc_col-sm-6',
			'group' => esc_html__( "Responsiveness", 'zuperla' ),
		)
	);
	vc_add_param( "vc_row",
		array(
			"type" => 'zuperla_param_label',
			"heading" => esc_html__( "Columns Vertical Gap", 'zuperla'),
			"param_name" => "label_columns_vertical_gap",
			'value' => '',
			'std' => '',
			"description" => esc_html__( "Select the vertical gap for the columns of this row on Tablets (Landscape, Portrait) and mobiles. This will affect once the columns have 100% width ( 1/1 ).", 'zuperla' ),
			'group' => esc_html__( "Responsiveness", 'zuperla' ),
		)
	);
	vc_add_param( "vc_row",
		array(
			"type" => "dropdown",
			"heading" => __( "Tablet Landscape", 'zuperla' ),
			"param_name" => "tablet_columns_vertical_gap",
			'value' => $zuperla_eutf_column_gap_list,
			'group' => esc_html__( "Responsiveness", 'zuperla' ),
			"std" => 'none',
			'edit_field_class' => 'vc_col-sm-4',
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => "dropdown",
			"heading" => __( "Tablet Portrait", 'zuperla' ),
			"param_name" => "tablet_sm_columns_vertical_gap",
			'value' => $zuperla_eutf_column_gap_list,
			'group' => esc_html__( "Responsiveness", 'zuperla' ),
			"std" => 'none',
			'edit_field_class' => 'vc_col-sm-4',
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => "dropdown",
			"heading" => __( "Mobile", 'zuperla' ),
			"param_name" => "mobile_columns_vertical_gap",
			'value' => $zuperla_eutf_column_gap_list,
			'group' => esc_html__( "Responsiveness", 'zuperla' ),
			"std" => '30',
			'edit_field_class' => 'vc_col-sm-4',
		)
	);
	vc_add_param( "vc_row",
		array(
			"type" => 'zuperla_param_label',
			"heading" => esc_html__( "Equal Column Height", 'zuperla'),
			"param_name" => "label_equal_column_height",
			"description" => esc_html__( "Select if you wish to keep or disable the Equal Column Height.", 'zuperla' ),
			'value' => '',
			'std' => '',
			"dependency" => array(
				'element' => 'equal_column_height',
				'value' => array( 'equal' )
			),
			'group' => esc_html__( "Responsiveness", 'zuperla' ),
		)
	);
	vc_add_param( "vc_row",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Tablet Landscape", 'zuperla' ),
			"param_name" => "tablet_landscape_equal_column_height",
			"value" => array(
				esc_html__( "Default values", 'zuperla' ) => '',
				esc_html__( "None", 'zuperla' ) => 'false',
			),
			"dependency" => array(
				'element' => 'equal_column_height',
				'value' => array( 'equal' )
			),
			'group' => esc_html__( "Responsiveness", 'zuperla' ),
			'edit_field_class' => 'vc_col-sm-4',
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Tablet Portrait", 'zuperla' ),
			"param_name" => "tablet_portrait_equal_column_height",
			"value" => array(
				esc_html__( "Default values", 'zuperla' ) => '',
				esc_html__( "None", 'zuperla' ) => 'false',
			),
			"dependency" => array(
				'element' => 'equal_column_height',
				'value' => array( 'equal' )
			),
			'group' => esc_html__( "Responsiveness", 'zuperla' ),
			'edit_field_class' => 'vc_col-sm-4',
		)
	);
	vc_add_param( "vc_row",
		array(
			"type" => 'zuperla_param_label',
			"heading" => esc_html__( "Row Height", 'zuperla'),
			"param_name" => "label_height_ratio",
			'value' => '',
			'std' => '',
			"description" => esc_html__( "Select if you wish to keep or disable the Row height.", 'zuperla' ),
			"dependency" => array(
				'element' => 'height_ratio',
				'value_not_equal_to' => array( 'auto' )
			),
			'group' => esc_html__( "Responsiveness", 'zuperla' ),
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Tablet Landscape", 'zuperla' ),
			"param_name" => "tablet_height_ratio",
			"value" => array(
				esc_html__( "Inherit", 'zuperla' ) => 'inherit',
				esc_html__( "Auto", 'zuperla' ) => '0',
				esc_html__( "10%", 'zuperla' ) => '10',
				esc_html__( "20%", 'zuperla' ) => '20',
				esc_html__( "30%", 'zuperla' ) => '30',
				esc_html__( "40%", 'zuperla' ) => '40',
				esc_html__( "50%", 'zuperla' ) => '50',
				esc_html__( "60%", 'zuperla' ) => '60',
				esc_html__( "70%", 'zuperla' ) => '70',
				esc_html__( "80%", 'zuperla' ) => '80',
				esc_html__( "90%", 'zuperla' ) => '90',
				esc_html__( "100%", 'zuperla' ) => '100',
			),
			"dependency" => array(
				'element' => 'height_ratio',
				'value_not_equal_to' => array( 'auto' )
			),
			'group' => esc_html__( "Responsiveness", 'zuperla' ),
			'edit_field_class' => 'vc_col-sm-4',
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Tablet Portrait", 'zuperla' ),
			"param_name" => "tablet_sm_height_ratio",
			"value" => array(
				esc_html__( "Inherit", 'zuperla' ) => 'inherit',
				esc_html__( "Auto", 'zuperla' ) => '0',
				esc_html__( "10%", 'zuperla' ) => '10',
				esc_html__( "20%", 'zuperla' ) => '20',
				esc_html__( "30%", 'zuperla' ) => '30',
				esc_html__( "40%", 'zuperla' ) => '40',
				esc_html__( "50%", 'zuperla' ) => '50',
				esc_html__( "60%", 'zuperla' ) => '60',
				esc_html__( "70%", 'zuperla' ) => '70',
				esc_html__( "80%", 'zuperla' ) => '80',
				esc_html__( "90%", 'zuperla' ) => '90',
				esc_html__( "100%", 'zuperla' ) => '100',
			),
			"dependency" => array(
				'element' => 'height_ratio',
				'value_not_equal_to' => array( 'auto' )
			),
			'group' => esc_html__( "Responsiveness", 'zuperla' ),
			'edit_field_class' => 'vc_col-sm-4',
			'std' => '0',
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Mobile", 'zuperla' ),
			"param_name" => "mobile_height_ratio",
			"value" => array(
				esc_html__( "Inherit", 'zuperla' ) => 'inherit',
				esc_html__( "Auto", 'zuperla' ) => '0',
				esc_html__( "10%", 'zuperla' ) => '10',
				esc_html__( "20%", 'zuperla' ) => '20',
				esc_html__( "30%", 'zuperla' ) => '30',
				esc_html__( "40%", 'zuperla' ) => '40',
				esc_html__( "50%", 'zuperla' ) => '50',
				esc_html__( "60%", 'zuperla' ) => '60',
				esc_html__( "70%", 'zuperla' ) => '70',
				esc_html__( "80%", 'zuperla' ) => '80',
				esc_html__( "90%", 'zuperla' ) => '90',
				esc_html__( "100%", 'zuperla' ) => '100',
			),
			"dependency" => array(
				'element' => 'height_ratio',
				'value_not_equal_to' => array( 'auto' )
			),
			'group' => esc_html__( "Responsiveness", 'zuperla' ),
			'edit_field_class' => 'vc_col-sm-4',
			'std' => '0',
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => 'dropdown',
			"heading" => esc_html__( "Top Separator", 'zuperla' ),
			"param_name" => "separator_top",
			"description" => esc_html__( "Select Top Separator type", 'zuperla' ),
			"value" => $zuperla_eutf_separator_list,
			"group" => esc_html__( "Separators", 'zuperla' ),
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => 'dropdown',
			"heading" => esc_html__( "Top Separator Size", 'zuperla' ),
			"param_name" => "separator_top_size",
			"description" => esc_html__( "Select Top Separator type", 'zuperla' ),
			"value" => $zuperla_eutf_separator_size_list,
			"std" => '90px',
			"dependency" => array(
				'element' => 'separator_top',
				'value_not_equal_to' => array( '' )
			),
			"group" => esc_html__( "Separators", 'zuperla' ),
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => "colorpicker",
			"heading" => esc_html__('Top Separator Color', 'zuperla' ),
			"param_name" => "separator_top_color",
			"dependency" => array(
				'element' => 'separator_top',
				'value_not_equal_to' => array( '' )
			),
			"std" => '#ffffff',
			"description" => esc_html__("Select top separator color", 'zuperla' ),
			"group" => esc_html__( "Separators", 'zuperla' ),
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => 'dropdown',
			"heading" => esc_html__( "Bottom Separator", 'zuperla' ),
			"param_name" => "separator_bottom",
			"description" => esc_html__( "Select Bottom Separator type", 'zuperla' ),
			"value" => $zuperla_eutf_separator_list,
			"group" => esc_html__( "Separators", 'zuperla' ),
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => 'dropdown',
			"heading" => esc_html__( "Bottom Separator Size", 'zuperla' ),
			"param_name" => "separator_bottom_size",
			"description" => esc_html__( "Select Bottom Separator type", 'zuperla' ),
			"value" => $zuperla_eutf_separator_size_list,
			"std" => '90px',
			"dependency" => array(
				'element' => 'separator_bottom',
				'value_not_equal_to' => array( '' )
			),
			"group" => esc_html__( "Separators", 'zuperla' ),
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => "colorpicker",
			"heading" => esc_html__('Bottom Separator Color', 'zuperla' ),
			"param_name" => "separator_bottom_color",
			"dependency" => array(
				'element' => 'separator_bottom',
				'value_not_equal_to' => array( '' )
			),
			"std" => '#ffffff',
			"description" => esc_html__("Select bottom separator color", 'zuperla' ),
			"group" => esc_html__( "Separators", 'zuperla' ),
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Header Style", 'zuperla' ),
			"param_name" => "scroll_header_style",
			"value" => array(
				esc_html__( "Dark", 'zuperla' ) => 'dark',
				esc_html__( "Light", 'zuperla' ) => 'light',
				esc_html__( "Default", 'zuperla' ) => 'default',
			),
			"std" => 'dark',
			"description" => esc_html__( "Select header style", 'zuperla' ),
			"group" => esc_html__( "Scrolling Section Options", 'zuperla' ),
		)
	);

	vc_add_param( "vc_row",
		array(
			"type" => "textfield",
			"heading" => esc_html__('Scrolling Section Title', 'zuperla' ),
			"param_name" => "scroll_section_title",
			"description" => esc_html__("If you wish you can type a title for the side dot navigation.", 'zuperla' ),
			"group" => esc_html__( "Scrolling Section Options", 'zuperla' ),
		)
	);

	vc_add_param( "vc_row_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Row Height", 'zuperla' ),
			"param_name" => "height_ratio",
			"value" => array(
				esc_html__( "Auto", 'zuperla' ) => 'auto',
				esc_html__( "10%", 'zuperla' ) => '10',
				esc_html__( "20%", 'zuperla' ) => '20',
				esc_html__( "30%", 'zuperla' ) => '30',
				esc_html__( "40%", 'zuperla' ) => '40',
				esc_html__( "50%", 'zuperla' ) => '50',
				esc_html__( "60%", 'zuperla' ) => '60',
				esc_html__( "70%", 'zuperla' ) => '70',
				esc_html__( "80%", 'zuperla' ) => '80',
				esc_html__( "90%", 'zuperla' ) => '90',
				esc_html__( "100%", 'zuperla' ) => '100',
			),
			"description" => esc_html__( "Select your row height", 'zuperla' ),
		)
	);

	vc_add_param( "vc_row_inner",
		array(
			"type" => "textfield",
			"heading" => esc_html__( "Row Min Height", 'zuperla' ),
			"param_name" => "min_height",
			"description" => esc_html__( "Set the row minimum height in pixel.", 'zuperla' ),
		)
	);

	vc_add_param( "vc_row_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Top padding", 'zuperla' ),
			"param_name" => "padding_top_multiplier",
			"value" => array(
				esc_html__( "None", 'zuperla' ) => '',
				esc_html__( "1x", 'zuperla' ) => '1x',
				esc_html__( "2x", 'zuperla' ) => '2x',
				esc_html__( "3x", 'zuperla' ) => '3x',
				esc_html__( "4x", 'zuperla' ) => '4x',
				esc_html__( "5x", 'zuperla' ) => '5x',
				esc_html__( "6x", 'zuperla' ) => '6x',
				esc_html__( "Custom", 'zuperla' ) => 'custom',
			),
			"std" => '1x',
			"description" => esc_html__( "Select padding top for your section.", 'zuperla' ),
		)
	);
	vc_add_param( "vc_row_inner",
		array(
			"type" => "textfield",
			"heading" => esc_html__( "Custom Top padding", 'zuperla' ),
			"param_name" => "padding_top",
			"dependency" => array(
				'element' => 'padding_top_multiplier',
				'value' => array( 'custom' )
			),
			"description" => esc_html__( "You can use px, em, %, etc. or enter just number and it will use pixels.", 'zuperla' ),
		)
	);
	vc_add_param( "vc_row_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Bottom padding", 'zuperla' ),
			"param_name" => "padding_bottom_multiplier",
			"value" => array(
				esc_html__( "None", 'zuperla' ) => '',
				esc_html__( "1x", 'zuperla' ) => '1x',
				esc_html__( "2x", 'zuperla' ) => '2x',
				esc_html__( "3x", 'zuperla' ) => '3x',
				esc_html__( "4x", 'zuperla' ) => '4x',
				esc_html__( "5x", 'zuperla' ) => '5x',
				esc_html__( "6x", 'zuperla' ) => '6x',
				esc_html__( "Custom", 'zuperla' ) => 'custom',
			),
			"std" => '1x',
			"description" => esc_html__( "Select padding bottom for your section.", 'zuperla' ),
		)
	);
	vc_add_param( "vc_row_inner",
		array(
			"type" => "textfield",
			"heading" => esc_html__( "Custom Bottom padding", 'zuperla' ),
			"param_name" => "padding_bottom",
			"dependency" => array(
				'element' => 'padding_bottom_multiplier',
				'value' => array( 'custom' )
			),
			"description" => esc_html__( "You can use px, em, %, etc. or enter just number and it will use pixels.", 'zuperla' ),
		)
	);
	vc_add_param( "vc_row_inner",
		array(
		"type" => "textfield",
		"heading" => esc_html__( 'Bottom margin', 'zuperla' ),
		"param_name" => "rc_margin_bottom",
		"description" => esc_html__( "You can use px, em, %, etc. or enter just number and it will use pixels.", 'zuperla' ),
		)
	);
	
	vc_add_param( "vc_row_inner",	
		array(
			'type' => 'checkbox',
			'heading' => esc_html__( 'Disable row', 'zuperla' ),
			'param_name' => 'disable_element',
			'description' => esc_html__( 'If checked the row won\'t be visible on the public side of your website. You can switch it back any time.', 'zuperla' ),
			'value' => array( esc_html__( 'Yes', 'zuperla' ) => 'yes' ),
		)
	);	

	vc_add_param( "vc_row_inner", $zuperla_eutf_add_el_id );
	vc_add_param( "vc_row_inner", $zuperla_eutf_add_el_class );
	vc_add_param( "vc_row_inner", $zuperla_eutf_add_el_wrapper_class );

	vc_add_param( "vc_row_inner",
		array(
			"type" => "colorpicker",
			"heading" => esc_html__('Font Color', 'zuperla' ),
			"param_name" => "rc_font_color",
			"description" => esc_html__("Select font color", 'zuperla' ),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);

	vc_add_param( "vc_row_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Heading Color", 'zuperla' ),
			"param_name" => "rc_heading_color",
			"param_holder_class" => "eut-colored-dropdown",
			"value" => array(
				esc_html__( "Default", 'zuperla' ) => '',
				esc_html__( "Dark", 'zuperla' ) => 'dark',
				esc_html__( "Light", 'zuperla' ) => 'light',
				esc_html__( "Primary 1", 'zuperla' ) => 'primary-1',
				esc_html__( "Primary 2", 'zuperla' ) => 'primary-2',
				esc_html__( "Primary 3", 'zuperla' ) => 'primary-3',
				esc_html__( "Primary 4", 'zuperla' ) => 'primary-4',
				esc_html__( "Primary 5", 'zuperla' ) => 'primary-5',
				esc_html__( "Primary 6", 'zuperla' ) => 'primary-6',
				esc_html__( "Green", 'zuperla' ) => 'green',
				esc_html__( "Orange", 'zuperla' ) => 'orange',
				esc_html__( "Red", 'zuperla' ) => 'red',
				esc_html__( "Blue", 'zuperla' ) => 'blue',
				esc_html__( "Aqua", 'zuperla' ) => 'aqua',
				esc_html__( "Purple", 'zuperla' ) => 'purple',
				esc_html__( "Grey", 'zuperla' ) => 'grey',
			),
			"description" => esc_html__( "Select heading color", 'zuperla' ),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);

	vc_add_param( "vc_row_inner",
		array(
			"type" => 'dropdown',
			"heading" => esc_html__( "Background Type", 'zuperla' ),
			"param_name" => "rc_bg_type",
			"description" => esc_html__( "Select Background type", 'zuperla' ),
			"value" => array(
				esc_html__( "None", 'zuperla' ) => '',
				esc_html__( "Color", 'zuperla' ) => 'color',
				esc_html__( "Gradient Color", 'zuperla' ) => 'gradient',
				esc_html__( "Image", 'zuperla' ) => 'image',
				esc_html__( "Hosted Video", 'zuperla' ) => 'hosted_video',
				esc_html__( "YouTube Video", 'zuperla' ) => 'video',
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);

	vc_add_param( "vc_row_inner",
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'YouTube link', 'zuperla' ),
			'param_name' => 'rc_bg_video_url',
			'value' => 'https://www.youtube.com/watch?v=C9tsrkRSw-Q',
			// default video url
			'description' => esc_html__( 'Add YouTube link.', 'zuperla' ),
			'dependency' => array(
				'element' => 'rc_bg_type',
				'value' => 'video',
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);

	vc_add_param( "vc_row_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Video Popup Button", 'zuperla' ),
			"param_name" => "rc_bg_video_button",
			"value" => array(
				esc_html__( 'None', 'zuperla' ) => '',
				esc_html__( 'Devices only', 'zuperla' ) => 'device',
				esc_html__( 'Always visible', 'zuperla' ) => 'all',
			),
			"description" => esc_html__( "Select video popup button behavior", 'zuperla' ),
			'dependency' => array(
				'element' => 'rc_bg_type',
				'value' => 'video',
			),
			"std" => 'center-center',
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);

	vc_add_param( "vc_row_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Video Button Position", 'zuperla' ),
			"param_name" => "rc_bg_video_button_position",
			"value" => array(
				esc_html__( 'Left Top', 'zuperla' ) => 'left-top',
				esc_html__( 'Left Bottom', 'zuperla' ) => 'left-bottom',
				esc_html__( 'Center Center', 'zuperla' ) => 'center-center',
				esc_html__( 'Right Top', 'zuperla' ) => 'right-top',
				esc_html__( 'Right Bottom', 'zuperla' ) => 'right-bottom',
			),
			"description" => esc_html__( "Select position for video popup", 'zuperla' ),
			'dependency' => array(
				'element' => 'rc_bg_video_button',
				'value_not_equal_to' => array( '' )
			),
			"std" => 'center-center',
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);

	vc_add_param( "vc_row_inner",
		array(
			"type" => "colorpicker",
			"heading" => esc_html__( "Custom Background Color", 'zuperla' ),
			"param_name" => "rc_bg_color",
			"description" => esc_html__( "Select background color for your row", 'zuperla' ),
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'color' )
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);

	vc_add_param( "vc_row_inner",
		array(
			"type" => "colorpicker",
			"heading" => esc_html__( "Custom Color 1", 'zuperla' ),
			"param_name" => "rc_bg_gradient_color_1",
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'gradient' )
			),
			"std" => 'rgba(3,78,144,0.9)',
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);

	vc_add_param( "vc_row_inner",
		array(
			"type" => "colorpicker",
			"heading" => esc_html__( "Custom Color 2", 'zuperla' ),
			"param_name" => "rc_bg_gradient_color_2",
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'gradient' )
			),
			"std" => 'rgba(25,180,215,0.9)',
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);
	vc_add_param( "vc_row_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Gradient Direction", 'zuperla' ),
			"param_name" => "rc_bg_gradient_direction",
			"value" => array(
				esc_html__( "Left to Right", 'zuperla' ) => '90',
				esc_html__( "Left Top to Right Bottom", 'zuperla' ) => '135',
				esc_html__( "Left Bottom to Right Top", 'zuperla' ) => '45',
				esc_html__( "Bottom to Top", 'zuperla' ) => '180',
			),
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'gradient' )
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);


	vc_add_param( "vc_row_inner",
		array(
			"type" => "attach_image",
			"heading" => esc_html__('Background Image', 'zuperla' ),
			"param_name" => "rc_bg_image",
			"value" => '',
			"description" => esc_html__("Select background image for your row. Used also as fallback for video.", 'zuperla' ),
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'image', 'hosted_video', 'video' )
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);
	vc_add_param( "vc_row_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Background Image Type", 'zuperla' ),
			"param_name" => "rc_bg_image_type",
			"value" => array(
				esc_html__( "Default", 'zuperla' ) => '',
				esc_html__( "Parallax", 'zuperla' ) => 'parallax',
				esc_html__( "Horizontal Parallax Left to Right", 'zuperla' ) => 'horizontal-parallax-lr',
				esc_html__( "Horizontal Parallax Right to Left", 'zuperla' ) => 'horizontal-parallax-rl',
				esc_html__( "Animated", 'zuperla' ) => 'animated',
				esc_html__( "Horizontal Animation", 'zuperla' ) => 'horizontal',
				esc_html__( "Fixed Image", 'zuperla' ) => 'fixed',
				esc_html__( "Image usage as Pattern", 'zuperla' ) => 'pattern'
			),
			"description" => esc_html__( "Select how a background image will be displayed", 'zuperla' ),
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'image' )
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);
	vc_add_param( "vc_row_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Background Image Size", 'zuperla' ),
			"param_name" => "rc_bg_image_size",
			"value" => array(
				esc_html__( "--Inherit--", 'zuperla' ) => '',
				esc_html__( "Responsive", 'zuperla' ) => 'responsive',
				esc_html__( "Extra Extra Large", 'zuperla' ) => 'extra-extra-large',
				esc_html__( "Full", 'zuperla' ) => 'full',
			),
			"description" => esc_html__( "Select the size of your background image", 'zuperla' ),
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'image' )
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);
	vc_add_param( "vc_row_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Background Image Vertical Position", 'zuperla' ),
			"param_name" => "rc_bg_image_vertical_position",
			"value" => array(
				esc_html__( "Top", 'zuperla' ) => 'top',
				esc_html__( "Center", 'zuperla' ) => 'center',
				esc_html__( "Bottom", 'zuperla' ) => 'bottom',
			),
			"description" => esc_html__( "Select vertical position for background image", 'zuperla' ),
			"dependency" => array(
				'element' => 'rc_bg_image_type',
				'value' => array( 'horizontal-parallax-lr', 'horizontal-parallax-rl', 'horizontal' )
			),
			"std" => 'center',
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);
	vc_add_param( "vc_row_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Background  Position", 'zuperla' ),
			"param_name" => "rc_bg_position",
			"value" => array(
				esc_html__( 'Left Top', 'zuperla' ) => 'left-top',
				esc_html__( 'Left Center', 'zuperla' ) => 'left-center',
				esc_html__( 'Left Bottom', 'zuperla' ) => 'left-bottom',
				esc_html__( 'Center Top', 'zuperla' ) => 'center-top',
				esc_html__( 'Center Center', 'zuperla' ) => 'center-center',
				esc_html__( 'Center Bottom', 'zuperla' ) => 'center-bottom',
				esc_html__( 'Right Top', 'zuperla' ) => 'right-top',
				esc_html__( 'Right Center', 'zuperla' ) => 'right-center',
				esc_html__( 'Right Bottom', 'zuperla' ) => 'right-bottom',
			),
			"description" => esc_html__( "Select position for background image", 'zuperla' ),
			"dependency" => array(
				'element' => 'rc_bg_image_type',
				'value' => array( '', 'animated' )
			),
			"std" => 'center-center',
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);
	vc_add_param( "vc_row_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Background Position ( Tablet Portrait )", 'zuperla' ),
			"param_name" => "rc_bg_tablet_sm_position",
			"value" => array(
				esc_html__( 'Inherit from above', 'zuperla' ) => '',
				esc_html__( 'Left Top', 'zuperla' ) => 'left-top',
				esc_html__( 'Left Center', 'zuperla' ) => 'left-center',
				esc_html__( 'Left Bottom', 'zuperla' ) => 'left-bottom',
				esc_html__( 'Center Top', 'zuperla' ) => 'center-top',
				esc_html__( 'Center Center', 'zuperla' ) => 'center-center',
				esc_html__( 'Center Bottom', 'zuperla' ) => 'center-bottom',
				esc_html__( 'Right Top', 'zuperla' ) => 'right-top',
				esc_html__( 'Right Center', 'zuperla' ) => 'right-center',
				esc_html__( 'Right Bottom', 'zuperla' ) => 'right-bottom',
			),
			"description" => esc_html__( "Tablet devices with portrait orientation and below.", 'zuperla' ),
			"dependency" => array(
				'element' => 'rc_bg_image_type',
				'value' => array( '', 'animated' )
			),
			"std" => '',
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);
	vc_add_param( "vc_row_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Parallax Sensor", 'zuperla' ),
			"param_name" => "rc_bg_parallax_threshold",
			"value" => array(
				esc_html__( "Low", 'zuperla' ) => '0.1',
				esc_html__( "Normal", 'zuperla' ) => '0.3',
				esc_html__( "High", 'zuperla' ) => '0.5',
				esc_html__( "Max", 'zuperla' ) => '0.8',
			),
			"description" => esc_html__( "Define the appearance for the parallax effect. Note that you get greater image zoom when you increase the parallax sensor.", 'zuperla' ),
			"dependency" => array(
				'element' => 'rc_bg_image_type',
				'value' => array( 'parallax', 'horizontal-parallax-lr', 'horizontal-parallax-rl' )
			),
			"std" => '0.3',
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);
	vc_add_param( "vc_row_inner",
		array(
			"type" => "textfield",
			"heading" => esc_html__("WebM File URL", 'zuperla'),
			"param_name" => "rc_bg_video_webm",
			"description" => esc_html__( "Fill WebM and mp4 format for browser compatibility", 'zuperla' ),
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'hosted_video' )
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);
	vc_add_param( "vc_row_inner",
		array(
			"type" => "textfield",
			"heading" => esc_html__( "MP4 File URL", 'zuperla' ),
			"param_name" => "rc_bg_video_mp4",
			"description" => esc_html__( "Fill mp4 format URL", 'zuperla' ),
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'hosted_video' )
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);
	vc_add_param( "vc_row_inner",
		array(
			"type" => "textfield",
			"heading" => esc_html__( "OGV File URL", 'zuperla' ),
			"param_name" => "rc_bg_video_ogv",
			"description" => esc_html__( "Fill OGV format URL ( optional )", 'zuperla' ),
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'hosted_video' )
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);
	vc_add_param( "vc_row_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Loop", 'zuperla' ),
			"param_name" => "rc_bg_video_loop",
			"value" => array(
				esc_html__( "Yes", 'zuperla' ) => 'yes',
				esc_html__( "No", 'zuperla' ) => 'no',
			),
			"std" => 'yes',
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'hosted_video' )
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);
	vc_add_param( "vc_row_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Allow on devices", 'zuperla' ),
			"param_name" => "rc_bg_video_device",
			"value" => array(
				esc_html__( "No", 'zuperla' ) => 'no',
				esc_html__( "Yes", 'zuperla' ) => 'yes',

			),
			"std" => 'no',
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'hosted_video' )
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);
	vc_add_param( "vc_row_inner",
		array(
			"type" => 'checkbox',
			"heading" => esc_html__( "Pattern overlay", 'zuperla'),
			"param_name" => "rc_bg_pattern_overlay",
			"description" => esc_html__( "If selected, a pattern will be added.", 'zuperla' ),
			"value" => Array(esc_html__( "Add pattern", 'zuperla' ) => 'yes'),
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'image', 'hosted_video', 'video' )
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);
	vc_add_param( "vc_row_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Color overlay", 'zuperla' ),
			"param_name" => "rc_bg_color_overlay",
			"param_holder_class" => "eut-colored-dropdown",
			"value" => array(
				esc_html__( "None", 'zuperla' ) => '',
				esc_html__( "Dark", 'zuperla' ) => 'dark',
				esc_html__( "Light", 'zuperla' ) => 'light',
				esc_html__( "Primary 1", 'zuperla' ) => 'primary-1',
				esc_html__( "Primary 2", 'zuperla' ) => 'primary-2',
				esc_html__( "Primary 3", 'zuperla' ) => 'primary-3',
				esc_html__( "Primary 4", 'zuperla' ) => 'primary-4',
				esc_html__( "Primary 5", 'zuperla' ) => 'primary-5',
				esc_html__( "Primary 6", 'zuperla' ) => 'primary-6',
				esc_html__( "Custom", 'zuperla' ) => 'custom',
				esc_html__( "Gradient", 'zuperla' ) => 'gradient',
			),
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'image', 'hosted_video', 'video' )
			),
			"description" => esc_html__( "A color overlay for the media", 'zuperla' ),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);

	vc_add_param( "vc_row_inner",
		array(
			"type" => "colorpicker",
			"heading" => esc_html__('Custom Color Overlay', 'zuperla' ),
			"param_name" => "rc_bg_color_overlay_custom",
			"dependency" => array(
				'element' => 'rc_bg_color_overlay',
				'value' => array( 'custom' )
			),
			"std" => 'rgba(255,255,255,0.1)',
			"description" => esc_html__("Select custom color overlay", 'zuperla' ),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);

	vc_add_param( "vc_row_inner",
		array(
			"type" => "colorpicker",
			"heading" => esc_html__('Gradient Color Overlay 1', 'zuperla' ),
			"param_name" => "rc_bg_gradient_overlay_custom_1",
			"dependency" => array(
				'element' => 'rc_bg_color_overlay',
				'value' => array( 'gradient' )
			),
			"std" => 'rgba(3,78,144,0.9)',
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);

	vc_add_param( "vc_row_inner",
		array(
			"type" => "colorpicker",
			"heading" => esc_html__('Gradient Color Overlay 2', 'zuperla' ),
			"param_name" => "rc_bg_gradient_overlay_custom_2",
			"dependency" => array(
				'element' => 'rc_bg_color_overlay',
				'value' => array( 'gradient' )
			),
			"std" => 'rgba(25,180,215,0.9)',
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);

	vc_add_param( "vc_row_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Gradient Direction", 'zuperla' ),
			"param_name" => "rc_bg_gradient_overlay_direction",
			"value" => array(
				esc_html__( "Left to Right", 'zuperla' ) => '90',
				esc_html__( "Left Top to Right Bottom", 'zuperla' ) => '135',
				esc_html__( "Left Bottom to Right Top", 'zuperla' ) => '45',
				esc_html__( "Bottom to Top", 'zuperla' ) => '180',
			),
			"dependency" => array(
				'element' => 'rc_bg_color_overlay',
				'value' => array( 'gradient' )
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);

	vc_add_param( "vc_row_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Opacity overlay", 'zuperla' ),
			"param_name" => "rc_bg_opacity_overlay",
			"value" => array( '10', '20', '30' ,'40', '50', '60', '70', '80' ,'90' ),
			"std" => '10',
			"description" => esc_html__( "Opacity of the overlay", 'zuperla' ),
			"dependency" => array(
				'element' => 'rc_bg_color_overlay',
				'value' => array( 'dark', 'light', 'primary-1', 'primary-2', 'primary-3', 'primary-4', 'primary-5', 'primary-6' )
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);

/*
	vc_add_param( "vc_row_inner",
		array(
			'type' => 'css_editor',
			'heading' => esc_html__( 'CSS box', 'zuperla' ),
			'param_name' => 'css',
			'group' => esc_html__( 'Design Options', 'zuperla' ),
		)
	);
*/

	vc_add_param( "vc_row_inner",
		array(
			"type" => "dropdown",
			"heading" => __( "Columns Gap", 'zuperla' ),
			"param_name" => "columns_gap",
			'value' => $zuperla_eutf_column_gap_list,
			"description" => __( "Select gap between columns in row.", 'zuperla' ),
			"group" => esc_html__( "Inner Columns", 'zuperla' ),
			"std" => '50',
		)
	);

	vc_add_param( "vc_row_inner",
		array(
			"type" => 'checkbox',
			"heading" => esc_html__( "Equal Column Height", 'zuperla' ),
			"param_name" => "equal_column_height",
			"description" => esc_html__( "Select if you need the same height for the columns of this row. Recommended for multiple columns with different background colors.", 'zuperla' ),
			"value" => Array(esc_html__( "Equal Height Columns", 'zuperla' ) => 'equal'),
			"group" => esc_html__( "Inner Columns", 'zuperla' ),
		)
	);

	vc_add_param( "vc_row_inner",
		array(
			'type' => 'checkbox',
			'heading' => esc_html__( 'Reverse columns in RTL', 'zuperla' ),
			'param_name' => 'rtl_reverse',
			'description' => esc_html__( 'If checked columns will be reversed in RTL.', 'zuperla' ),
			'value' => array( esc_html__( 'Yes', 'zuperla' ) => 'yes' ),
			"group" => esc_html__( "Inner Columns", 'zuperla' ),
		)
	);

	vc_add_param( "vc_row_inner",
		array(
			"type" => 'zuperla_param_label',
			"heading" => esc_html__( "Visibility", 'zuperla'),
			"param_name" => "label_visibility",
			'value' => '',
			'std' => '',
			"description" => esc_html__( "If selected, row will be hidden on desktops/laptops and devices.", 'zuperla' ),
			'group' => esc_html__( "Responsiveness", 'zuperla' ),
		)
	);
	vc_add_param( "vc_row_inner",
		array(
			"type" => 'checkbox',
			"heading" => esc_html__( "Desktop Visibility", 'zuperla'),
			"param_name" => "desktop_visibility",
			"value" => Array(esc_html__( "Hide", 'zuperla' ) => 'hide'),
			'edit_field_class' => 'vc_col-sm-6',
			'group' => esc_html__( "Responsiveness", 'zuperla' ),
		)
	);
	vc_add_param( "vc_row_inner",
		array(
			"type" => 'checkbox',
			"heading" => esc_html__( "Tablet Landscape Visibility", 'zuperla'),
			"param_name" => "tablet_visibility",
			"value" => Array(esc_html__( "Hide", 'zuperla' ) => 'hide'),
			'edit_field_class' => 'vc_col-sm-6',
			'group' => esc_html__( "Responsiveness", 'zuperla' ),
		)
	);
	vc_add_param( "vc_row_inner",
		array(
			"type" => 'checkbox',
			"heading" => esc_html__( "Tablet Portrait Visibility", 'zuperla'),
			"param_name" => "tablet_sm_visibility",
			"value" => Array(esc_html__( "Hide", 'zuperla' ) => 'hide'),
			'edit_field_class' => 'vc_col-sm-6',
			'group' => esc_html__( "Responsiveness", 'zuperla' ),
		)
	);
	vc_add_param( "vc_row_inner",
		array(
			"type" => 'checkbox',
			"heading" => esc_html__( "Mobile Visibility", 'zuperla'),
			"param_name" => "mobile_visibility",
			"value" => Array(esc_html__( "Hide", 'zuperla' ) => 'hide'),
			'edit_field_class' => 'vc_col-sm-6',
			'group' => esc_html__( "Responsiveness", 'zuperla' ),
		)
	);
	vc_add_param( "vc_row_inner",
		array(
			"type" => 'zuperla_param_label',
			"heading" => esc_html__( "Columns Vertical Gap", 'zuperla'),
			"param_name" => "label_columns_vertical_gap",
			'value' => '',
			'std' => '',
			"description" => esc_html__( "Select the vertical gap for the columns of this row on Tablets (Landscape, Portrait) and mobiles. This will affect once the columns have 100% width ( 1/1 ).", 'zuperla' ),
			'group' => esc_html__( "Responsiveness", 'zuperla' ),
		)
	);
	vc_add_param( "vc_row_inner",
		array(
			"type" => "dropdown",
			"heading" => __( "Tablet Landscape", 'zuperla' ),
			"param_name" => "tablet_columns_vertical_gap",
			'value' => $zuperla_eutf_column_gap_list,
			'group' => esc_html__( "Responsiveness", 'zuperla' ),
			"std" => 'none',
			'edit_field_class' => 'vc_col-sm-4',
		)
	);

	vc_add_param( "vc_row_inner",
		array(
			"type" => "dropdown",
			"heading" => __( "Tablet Portrait", 'zuperla' ),
			"param_name" => "tablet_sm_columns_vertical_gap",
			'value' => $zuperla_eutf_column_gap_list,
			'group' => esc_html__( "Responsiveness", 'zuperla' ),
			"std" => 'none',
			'edit_field_class' => 'vc_col-sm-4',
		)
	);

	vc_add_param( "vc_row_inner",
		array(
			"type" => "dropdown",
			"heading" => __( "Mobile", 'zuperla' ),
			"param_name" => "mobile_columns_vertical_gap",
			'value' => $zuperla_eutf_column_gap_list,
			'group' => esc_html__( "Responsiveness", 'zuperla' ),
			"std" => '30',
			'edit_field_class' => 'vc_col-sm-4',
		)
	);
	vc_add_param( "vc_row_inner",
		array(
			"type" => 'zuperla_param_label',
			"heading" => esc_html__( "Equal Column Height", 'zuperla'),
			"param_name" => "label_equal_column_height",
			"description" => esc_html__( "Select if you wish to keep or disable the Equal Column Height.", 'zuperla' ),
			'value' => '',
			'std' => '',
			"dependency" => array(
				'element' => 'equal_column_height',
				'value' => array( 'equal' )
			),
			'group' => esc_html__( "Responsiveness", 'zuperla' ),
		)
	);
	vc_add_param( "vc_row_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Tablet Landscape", 'zuperla' ),
			"param_name" => "tablet_landscape_equal_column_height",
			"value" => array(
				esc_html__( "Default values", 'zuperla' ) => '',
				esc_html__( "None", 'zuperla' ) => 'false',
			),
			"dependency" => array(
				'element' => 'equal_column_height',
				'value' => array( 'equal' )
			),
			'group' => esc_html__( "Responsiveness", 'zuperla' ),
			'edit_field_class' => 'vc_col-sm-4',
		)
	);

	vc_add_param( "vc_row_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Tablet Portrait", 'zuperla' ),
			"param_name" => "tablet_portrait_equal_column_height",
			"value" => array(
				esc_html__( "Default values", 'zuperla' ) => '',
				esc_html__( "None", 'zuperla' ) => 'false',
			),
			"dependency" => array(
				'element' => 'equal_column_height',
				'value' => array( 'equal' )
			),
			'group' => esc_html__( "Responsiveness", 'zuperla' ),
			'edit_field_class' => 'vc_col-sm-4',
		)
	);
	vc_add_param( "vc_row_inner",
		array(
			"type" => 'zuperla_param_label',
			"heading" => esc_html__( "Row Height", 'zuperla'),
			"param_name" => "label_height_ratio",
			'value' => '',
			'std' => '',
			"description" => esc_html__( "Select if you wish to keep or disable the Row height.", 'zuperla' ),
			"dependency" => array(
				'element' => 'height_ratio',
				'value_not_equal_to' => array( 'auto' )
			),
			'group' => esc_html__( "Responsiveness", 'zuperla' ),
		)
	);

	vc_add_param( "vc_row_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Tablet Landscape", 'zuperla' ),
			"param_name" => "tablet_height_ratio",
			"value" => array(
				esc_html__( "Inherit", 'zuperla' ) => 'inherit',
				esc_html__( "Auto", 'zuperla' ) => '0',
				esc_html__( "10%", 'zuperla' ) => '10',
				esc_html__( "20%", 'zuperla' ) => '20',
				esc_html__( "30%", 'zuperla' ) => '30',
				esc_html__( "40%", 'zuperla' ) => '40',
				esc_html__( "50%", 'zuperla' ) => '50',
				esc_html__( "60%", 'zuperla' ) => '60',
				esc_html__( "70%", 'zuperla' ) => '70',
				esc_html__( "80%", 'zuperla' ) => '80',
				esc_html__( "90%", 'zuperla' ) => '90',
				esc_html__( "100%", 'zuperla' ) => '100',
			),
			"dependency" => array(
				'element' => 'height_ratio',
				'value_not_equal_to' => array( 'auto' )
			),
			'group' => esc_html__( "Responsiveness", 'zuperla' ),
			'edit_field_class' => 'vc_col-sm-4',
		)
	);

	vc_add_param( "vc_row_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Tablet Portrait", 'zuperla' ),
			"param_name" => "tablet_sm_height_ratio",
			"value" => array(
				esc_html__( "Inherit", 'zuperla' ) => 'inherit',
				esc_html__( "Auto", 'zuperla' ) => '0',
				esc_html__( "10%", 'zuperla' ) => '10',
				esc_html__( "20%", 'zuperla' ) => '20',
				esc_html__( "30%", 'zuperla' ) => '30',
				esc_html__( "40%", 'zuperla' ) => '40',
				esc_html__( "50%", 'zuperla' ) => '50',
				esc_html__( "60%", 'zuperla' ) => '60',
				esc_html__( "70%", 'zuperla' ) => '70',
				esc_html__( "80%", 'zuperla' ) => '80',
				esc_html__( "90%", 'zuperla' ) => '90',
				esc_html__( "100%", 'zuperla' ) => '100',
			),
			"dependency" => array(
				'element' => 'height_ratio',
				'value_not_equal_to' => array( 'auto' )
			),
			'group' => esc_html__( "Responsiveness", 'zuperla' ),
			'edit_field_class' => 'vc_col-sm-4',
			'std' => '0',
		)
	);

	vc_add_param( "vc_row_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Mobile", 'zuperla' ),
			"param_name" => "mobile_height_ratio",
			"value" => array(
				esc_html__( "Inherit", 'zuperla' ) => 'inherit',
				esc_html__( "Auto", 'zuperla' ) => '0',
				esc_html__( "10%", 'zuperla' ) => '10',
				esc_html__( "20%", 'zuperla' ) => '20',
				esc_html__( "30%", 'zuperla' ) => '30',
				esc_html__( "40%", 'zuperla' ) => '40',
				esc_html__( "50%", 'zuperla' ) => '50',
				esc_html__( "60%", 'zuperla' ) => '60',
				esc_html__( "70%", 'zuperla' ) => '70',
				esc_html__( "80%", 'zuperla' ) => '80',
				esc_html__( "90%", 'zuperla' ) => '90',
				esc_html__( "100%", 'zuperla' ) => '100',
			),
			"dependency" => array(
				'element' => 'height_ratio',
				'value_not_equal_to' => array( 'auto' )
			),
			'group' => esc_html__( "Responsiveness", 'zuperla' ),
			'edit_field_class' => 'vc_col-sm-4',
			'std' => '0',
		)
	);

	vc_add_param( "vc_column",
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( "Column Width", 'zuperla' ),
			'param_name' => 'width',
			'value' => $zuperla_eutf_column_width_list,
			'description' => esc_html__( "Select column width.", 'zuperla' ),
			'std' => '1/1',
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Content Width", 'zuperla' ),
			"param_name" => "content_width",
			"value" => array(
				esc_html__( "5%", 'zuperla' ) => '5',
				esc_html__( "10%", 'zuperla' ) => '10',
				esc_html__( "15%", 'zuperla' ) => '15',
				esc_html__( "20%", 'zuperla' ) => '20',
				esc_html__( "25%", 'zuperla' ) => '25',
				esc_html__( "30%", 'zuperla' ) => '30',
				esc_html__( "35%", 'zuperla' ) => '35',
				esc_html__( "40%", 'zuperla' ) => '40',
				esc_html__( "45%", 'zuperla' ) => '45',
				esc_html__( "50%", 'zuperla' ) => '50',
				esc_html__( "55%", 'zuperla' ) => '55',
				esc_html__( "60%", 'zuperla' ) => '60',
				esc_html__( "65%", 'zuperla' ) => '65',
				esc_html__( "70%", 'zuperla' ) => '70',
				esc_html__( "75%", 'zuperla' ) => '75',
				esc_html__( "80%", 'zuperla' ) => '80',
				esc_html__( "85%", 'zuperla' ) => '85',
				esc_html__( "90%", 'zuperla' ) => '90',
				esc_html__( "95%", 'zuperla' ) => '95',
				esc_html__( "100%", 'zuperla' ) => '100',
			),
			"description" => esc_html__( "Select the content width.", 'zuperla' ),
			'std' => '100',
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Horizontal Content Position", 'zuperla' ),
			"param_name" => "horizontal_content_position",
			"value" => array(
				esc_html__( "Left", 'zuperla' ) => 'left',
				esc_html__( "Center", 'zuperla' ) => 'center',
				esc_html__( "Right", 'zuperla' ) => 'right',
			),
			"dependency" => array(
				'element' => 'content_width',
				'value_not_equal_to' => array( '100' )
			),
			"description" => esc_html__( "Select the horizontal position of the content.", 'zuperla' ),
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Vertical Content Position", 'zuperla' ),
			"param_name" => "vertical_content_position",
			"value" => array(
				esc_html__( "Top", 'zuperla' ) => 'top',
				esc_html__( "Middle", 'zuperla' ) => 'middle',
				esc_html__( "Bottom", 'zuperla' ) => 'bottom',
			),
			"description" => esc_html__( "Select the vertical position of the content.", 'zuperla' ),
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Column 100% Height", 'zuperla' ),
			"description" => esc_html__( "Select if you need this column to have 100% height of the parent row.", 'zuperla' ),
			"param_name" => "full_height",
			"value" => array(
				esc_html__( "No", 'zuperla' ) => 'no',
				esc_html__( "Yes", 'zuperla' ) => 'yes',
			),
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Text Align", 'zuperla' ),
			"param_name" => "text_align",
			"value" => array(
				esc_html__( "Left", 'zuperla' ) => 'left',
				esc_html__( "Center", 'zuperla' ) => 'center',
				esc_html__( "Right", 'zuperla' ) => 'right',
			),
			"description" => esc_html__( "Select the text align of the content.", 'zuperla' ),
		)
	);

	vc_add_param( "vc_column", $zuperla_eutf_add_el_id );
	vc_add_param( "vc_column", $zuperla_eutf_add_el_class );
	vc_add_param( "vc_column", $zuperla_eutf_add_el_wrapper_class );


	vc_add_param( "vc_column",
		array(
			"type" => "colorpicker",
			"heading" => esc_html__('Font Color', 'zuperla' ),
			"param_name" => "rc_font_color",
			"description" => esc_html__("Select font color", 'zuperla' ),
			'group' => esc_html__( "Style", 'zuperla' ),
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Heading Color", 'zuperla' ),
			"param_name" => "rc_heading_color",
			"param_holder_class" => "eut-colored-dropdown",
			"value" => array(
				esc_html__( "Default", 'zuperla' ) => '',
				esc_html__( "Dark", 'zuperla' ) => 'dark',
				esc_html__( "Light", 'zuperla' ) => 'light',
				esc_html__( "Primary 1", 'zuperla' ) => 'primary-1',
				esc_html__( "Primary 2", 'zuperla' ) => 'primary-2',
				esc_html__( "Primary 3", 'zuperla' ) => 'primary-3',
				esc_html__( "Primary 4", 'zuperla' ) => 'primary-4',
				esc_html__( "Primary 5", 'zuperla' ) => 'primary-5',
				esc_html__( "Primary 6", 'zuperla' ) => 'primary-6',
				esc_html__( "Green", 'zuperla' ) => 'green',
				esc_html__( "Orange", 'zuperla' ) => 'orange',
				esc_html__( "Red", 'zuperla' ) => 'red',
				esc_html__( "Blue", 'zuperla' ) => 'blue',
				esc_html__( "Aqua", 'zuperla' ) => 'aqua',
				esc_html__( "Purple", 'zuperla' ) => 'purple',
				esc_html__( "Grey", 'zuperla' ) => 'grey',
			),
			"description" => esc_html__( "Select heading color", 'zuperla' ),
			'group' => esc_html__( "Style", 'zuperla' ),
		)
	);
	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Shadow", 'zuperla' ),
			"param_name" => "rc_shadow",
			"value" => array(
				esc_html__( "None", 'zuperla' ) => '',
				esc_html__( "Small", "zuperla" ) => 'small',
				esc_html__( "Medium", "zuperla" ) => 'medium',
				esc_html__( "Large", "zuperla" ) => 'large',
			),
			"description" => esc_html__( "Add Shadow", 'zuperla' ),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => 'dropdown',
			"heading" => esc_html__( "Background Type", 'zuperla' ),
			"param_name" => "rc_bg_type",
			"description" => esc_html__( "Select Background type", 'zuperla' ),
			"value" => array(
				esc_html__( "None", 'zuperla' ) => '',
				esc_html__( "Color", 'zuperla' ) => 'color',
				esc_html__( "Gradient Color", 'zuperla' ) => 'gradient',
				esc_html__( "Image", 'zuperla' ) => 'image',
				esc_html__( "Hosted Video", 'zuperla' ) => 'hosted_video',
				esc_html__( "YouTube Video", 'zuperla' ) => 'video',
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);

	vc_add_param( "vc_column",
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'YouTube link', 'zuperla' ),
			'param_name' => 'rc_bg_video_url',
			'value' => 'https://www.youtube.com/watch?v=C9tsrkRSw-Q',
			// default video url
			'description' => esc_html__( 'Add YouTube link.', 'zuperla' ),
			'dependency' => array(
				'element' => 'rc_bg_type',
				'value' => 'video',
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Video Popup Button", 'zuperla' ),
			"param_name" => "rc_bg_video_button",
			"value" => array(
				esc_html__( 'None', 'zuperla' ) => '',
				esc_html__( 'Devices only', 'zuperla' ) => 'device',
				esc_html__( 'Always visible', 'zuperla' ) => 'all',
			),
			"description" => esc_html__( "Select video popup button behavior", 'zuperla' ),
			'dependency' => array(
				'element' => 'rc_bg_type',
				'value' => 'video',
			),
			"std" => 'center-center',
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Video Button Position", 'zuperla' ),
			"param_name" => "rc_bg_video_button_position",
			"value" => array(
				esc_html__( 'Left Top', 'zuperla' ) => 'left-top',
				esc_html__( 'Left Bottom', 'zuperla' ) => 'left-bottom',
				esc_html__( 'Center Center', 'zuperla' ) => 'center-center',
				esc_html__( 'Right Top', 'zuperla' ) => 'right-top',
				esc_html__( 'Right Bottom', 'zuperla' ) => 'right-bottom',
			),
			"description" => esc_html__( "Select position for video popup", 'zuperla' ),
			'dependency' => array(
				'element' => 'rc_bg_video_button',
				'value_not_equal_to' => array( '' )
			),
			"std" => 'center-center',
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "colorpicker",
			"heading" => esc_html__( "Custom Background Color", 'zuperla' ),
			"param_name" => "rc_bg_color",
			"description" => esc_html__( "Select background color for your row", 'zuperla' ),
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'color' )
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "colorpicker",
			"heading" => esc_html__( "Custom Color 1", 'zuperla' ),
			"param_name" => "rc_bg_gradient_color_1",
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'gradient' )
			),
			"std" => 'rgba(3,78,144,0.9)',
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "colorpicker",
			"heading" => esc_html__( "Custom Color 2", 'zuperla' ),
			"param_name" => "rc_bg_gradient_color_2",
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'gradient' )
			),
			"std" => 'rgba(25,180,215,0.9)',
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);
	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Gradient Direction", 'zuperla' ),
			"param_name" => "rc_bg_gradient_direction",
			"value" => array(
				esc_html__( "Left to Right", 'zuperla' ) => '90',
				esc_html__( "Left Top to Right Bottom", 'zuperla' ) => '135',
				esc_html__( "Left Bottom to Right Top", 'zuperla' ) => '45',
				esc_html__( "Bottom to Top", 'zuperla' ) => '180',
			),
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'gradient' )
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);


	vc_add_param( "vc_column",
		array(
			"type" => "attach_image",
			"heading" => esc_html__('Background Image', 'zuperla' ),
			"param_name" => "rc_bg_image",
			"value" => '',
			"description" => esc_html__("Select background image for your row. Used also as fallback for video.", 'zuperla' ),
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'image', 'hosted_video', 'video' )
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);
	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Background Image Type", 'zuperla' ),
			"param_name" => "rc_bg_image_type",
			"value" => array(
				esc_html__( "Default", 'zuperla' ) => '',
				esc_html__( "Parallax", 'zuperla' ) => 'parallax',
				esc_html__( "Horizontal Parallax Left to Right", 'zuperla' ) => 'horizontal-parallax-lr',
				esc_html__( "Horizontal Parallax Right to Left", 'zuperla' ) => 'horizontal-parallax-rl',
				esc_html__( "Animated", 'zuperla' ) => 'animated',
				esc_html__( "Horizontal Animation", 'zuperla' ) => 'horizontal',
				esc_html__( "Fixed Image", 'zuperla' ) => 'fixed',
				esc_html__( "Image usage as Pattern", 'zuperla' ) => 'pattern'
			),
			"description" => esc_html__( "Select how a background image will be displayed", 'zuperla' ),
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'image' )
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);
	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Background Image Size", 'zuperla' ),
			"param_name" => "rc_bg_image_size",
			"value" => array(
				esc_html__( "--Inherit--", 'zuperla' ) => '',
				esc_html__( "Responsive", 'zuperla' ) => 'responsive',
				esc_html__( "Extra Extra Large", 'zuperla' ) => 'extra-extra-large',
				esc_html__( "Full", 'zuperla' ) => 'full',
			),
			"description" => esc_html__( "Select the size of your background image", 'zuperla' ),
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'image' )
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);
	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Background Image Vertical Position", 'zuperla' ),
			"param_name" => "rc_bg_image_vertical_position",
			"value" => array(
				esc_html__( "Top", 'zuperla' ) => 'top',
				esc_html__( "Center", 'zuperla' ) => 'center',
				esc_html__( "Bottom", 'zuperla' ) => 'bottom',
			),
			"description" => esc_html__( "Select vertical position for background image", 'zuperla' ),
			"dependency" => array(
				'element' => 'rc_bg_image_type',
				'value' => array( 'horizontal-parallax-lr', 'horizontal-parallax-rl', 'horizontal' )
			),
			"std" => 'center',
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);
	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Background  Position", 'zuperla' ),
			"param_name" => "rc_bg_position",
			"value" => array(
				esc_html__( 'Left Top', 'zuperla' ) => 'left-top',
				esc_html__( 'Left Center', 'zuperla' ) => 'left-center',
				esc_html__( 'Left Bottom', 'zuperla' ) => 'left-bottom',
				esc_html__( 'Center Top', 'zuperla' ) => 'center-top',
				esc_html__( 'Center Center', 'zuperla' ) => 'center-center',
				esc_html__( 'Center Bottom', 'zuperla' ) => 'center-bottom',
				esc_html__( 'Right Top', 'zuperla' ) => 'right-top',
				esc_html__( 'Right Center', 'zuperla' ) => 'right-center',
				esc_html__( 'Right Bottom', 'zuperla' ) => 'right-bottom',
			),
			"description" => esc_html__( "Select position for background image", 'zuperla' ),
			"dependency" => array(
				'element' => 'rc_bg_image_type',
				'value' => array( '', 'animated' )
			),
			"std" => 'center-center',
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);
	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Background Position ( Tablet Portrait )", 'zuperla' ),
			"param_name" => "rc_bg_tablet_sm_position",
			"value" => array(
				esc_html__( 'Inherit from above', 'zuperla' ) => '',
				esc_html__( 'Left Top', 'zuperla' ) => 'left-top',
				esc_html__( 'Left Center', 'zuperla' ) => 'left-center',
				esc_html__( 'Left Bottom', 'zuperla' ) => 'left-bottom',
				esc_html__( 'Center Top', 'zuperla' ) => 'center-top',
				esc_html__( 'Center Center', 'zuperla' ) => 'center-center',
				esc_html__( 'Center Bottom', 'zuperla' ) => 'center-bottom',
				esc_html__( 'Right Top', 'zuperla' ) => 'right-top',
				esc_html__( 'Right Center', 'zuperla' ) => 'right-center',
				esc_html__( 'Right Bottom', 'zuperla' ) => 'right-bottom',
			),
			"description" => esc_html__( "Tablet devices with portrait orientation and below.", 'zuperla' ),
			"dependency" => array(
				'element' => 'rc_bg_image_type',
				'value' => array( '', 'animated' )
			),
			"std" => '',
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);
	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Parallax Sensor", 'zuperla' ),
			"param_name" => "rc_bg_parallax_threshold",
			"value" => array(
				esc_html__( "Low", 'zuperla' ) => '0.1',
				esc_html__( "Normal", 'zuperla' ) => '0.3',
				esc_html__( "High", 'zuperla' ) => '0.5',
				esc_html__( "Max", 'zuperla' ) => '0.8',
			),
			"description" => esc_html__( "Define the appearance for the parallax effect. Note that you get greater image zoom when you increase the parallax sensor.", 'zuperla' ),
			"dependency" => array(
				'element' => 'rc_bg_image_type',
				'value' => array( 'parallax', 'horizontal-parallax-lr', 'horizontal-parallax-rl' )
			),
			"std" => '0.3',
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);
	vc_add_param( "vc_column",
		array(
			"type" => "textfield",
			"heading" => esc_html__("WebM File URL", 'zuperla'),
			"param_name" => "rc_bg_video_webm",
			"description" => esc_html__( "Fill WebM and mp4 format for browser compatibility", 'zuperla' ),
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'hosted_video' )
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);
	vc_add_param( "vc_column",
		array(
			"type" => "textfield",
			"heading" => esc_html__( "MP4 File URL", 'zuperla' ),
			"param_name" => "rc_bg_video_mp4",
			"description" => esc_html__( "Fill mp4 format URL", 'zuperla' ),
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'hosted_video' )
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);
	vc_add_param( "vc_column",
		array(
			"type" => "textfield",
			"heading" => esc_html__( "OGV File URL", 'zuperla' ),
			"param_name" => "rc_bg_video_ogv",
			"description" => esc_html__( "Fill OGV format URL ( optional )", 'zuperla' ),
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'hosted_video' )
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);
	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Loop", 'zuperla' ),
			"param_name" => "rc_bg_video_loop",
			"value" => array(
				esc_html__( "Yes", 'zuperla' ) => 'yes',
				esc_html__( "No", 'zuperla' ) => 'no',
			),
			"std" => 'yes',
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'hosted_video' )
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);
	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Allow on devices", 'zuperla' ),
			"param_name" => "rc_bg_video_device",
			"value" => array(
				esc_html__( "No", 'zuperla' ) => 'no',
				esc_html__( "Yes", 'zuperla' ) => 'yes',

			),
			"std" => 'no',
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'hosted_video' )
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);
	vc_add_param( "vc_column",
		array(
			"type" => 'checkbox',
			"heading" => esc_html__( "Pattern overlay", 'zuperla'),
			"param_name" => "rc_bg_pattern_overlay",
			"description" => esc_html__( "If selected, a pattern will be added.", 'zuperla' ),
			"value" => Array(esc_html__( "Add pattern", 'zuperla' ) => 'yes'),
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'image', 'hosted_video', 'video' )
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);
	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Color overlay", 'zuperla' ),
			"param_name" => "rc_bg_color_overlay",
			"param_holder_class" => "eut-colored-dropdown",
			"value" => array(
				esc_html__( "None", 'zuperla' ) => '',
				esc_html__( "Dark", 'zuperla' ) => 'dark',
				esc_html__( "Light", 'zuperla' ) => 'light',
				esc_html__( "Primary 1", 'zuperla' ) => 'primary-1',
				esc_html__( "Primary 2", 'zuperla' ) => 'primary-2',
				esc_html__( "Primary 3", 'zuperla' ) => 'primary-3',
				esc_html__( "Primary 4", 'zuperla' ) => 'primary-4',
				esc_html__( "Primary 5", 'zuperla' ) => 'primary-5',
				esc_html__( "Primary 6", 'zuperla' ) => 'primary-6',
				esc_html__( "Custom", 'zuperla' ) => 'custom',
				esc_html__( "Gradient", 'zuperla' ) => 'gradient',
			),
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'image', 'hosted_video', 'video' )
			),
			"description" => esc_html__( "A color overlay for the media", 'zuperla' ),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "colorpicker",
			"heading" => esc_html__('Custom Color Overlay', 'zuperla' ),
			"param_name" => "rc_bg_color_overlay_custom",
			"dependency" => array(
				'element' => 'rc_bg_color_overlay',
				'value' => array( 'custom' )
			),
			"std" => 'rgba(255,255,255,0.1)',
			"description" => esc_html__("Select custom color overlay", 'zuperla' ),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "colorpicker",
			"heading" => esc_html__('Gradient Color Overlay 1', 'zuperla' ),
			"param_name" => "rc_bg_gradient_overlay_custom_1",
			"dependency" => array(
				'element' => 'rc_bg_color_overlay',
				'value' => array( 'gradient' )
			),
			"std" => 'rgba(3,78,144,0.9)',
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "colorpicker",
			"heading" => esc_html__('Gradient Color Overlay 2', 'zuperla' ),
			"param_name" => "rc_bg_gradient_overlay_custom_2",
			"dependency" => array(
				'element' => 'rc_bg_color_overlay',
				'value' => array( 'gradient' )
			),
			"std" => 'rgba(25,180,215,0.9)',
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Gradient Direction", 'zuperla' ),
			"param_name" => "rc_bg_gradient_overlay_direction",
			"value" => array(
				esc_html__( "Left to Right", 'zuperla' ) => '90',
				esc_html__( "Left Top to Right Bottom", 'zuperla' ) => '135',
				esc_html__( "Left Bottom to Right Top", 'zuperla' ) => '45',
				esc_html__( "Bottom to Top", 'zuperla' ) => '180',
			),
			"dependency" => array(
				'element' => 'rc_bg_color_overlay',
				'value' => array( 'gradient' )
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Opacity overlay", 'zuperla' ),
			"param_name" => "rc_bg_opacity_overlay",
			"value" => array( '10', '20', '30' ,'40', '50', '60', '70', '80' ,'90' ),
			"std" => '10',
			"description" => esc_html__( "Opacity of the overlay", 'zuperla' ),
			"dependency" => array(
				'element' => 'rc_bg_color_overlay',
				'value' => array( 'dark', 'light', 'primary-1', 'primary-2', 'primary-3', 'primary-4', 'primary-5', 'primary-6' )
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);


	vc_add_param( "vc_column",
		array(
			'type' => 'css_editor',
			'heading' => esc_html__( 'CSS box', 'zuperla' ),
			'param_name' => 'css',
			'group' => esc_html__( 'Design Options', 'zuperla' ),
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Column Effect", 'zuperla' ),
			"param_name" => "column_effect",
			"value" => array(
				esc_html__( "None", 'zuperla' ) => 'none',
				esc_html__( "Vertical Parallax", 'zuperla' ) => 'vertical-parallax',
			),
			"description" => esc_html__( "Select column effect behaviour. Notice that the Mouse Move Effect does not affect on devices.", 'zuperla' ),
			'group' => esc_html__( 'Effect & Positions', 'zuperla' ),
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Column Effect Total Range", 'zuperla' ),
			"param_name" => "column_effect_limit",
			"value" => array(
				esc_html__( "1x", 'zuperla' ) => '1x',
				esc_html__( "2x", 'zuperla' ) => '2x',
				esc_html__( "3x", 'zuperla' ) => '3x',
				esc_html__( "4x", 'zuperla' ) => '4x',
				esc_html__( "5x", 'zuperla' ) => '5x',
				esc_html__( "6x", 'zuperla' ) => '6x',
				esc_html__( "None", 'zuperla' ) => 'none',
			),
			"dependency" => array(
				'element' => 'column_effect',
				'value_not_equal_to' => array( 'none' )
			),
			"description" => esc_html__( "Select column effect total range of motion. None allows column to move with complete freedom.", 'zuperla' ),
			'edit_field_class' => 'vc_col-sm-6',
			'group' => esc_html__( 'Effect & Positions', 'zuperla' ),
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Column Effect Invert Motion", 'zuperla' ),
			"param_name" => "column_effect_invert",
			"value" => array(
				esc_html__( "No", 'zuperla' ) => 'false',
				esc_html__( "Yes", 'zuperla' ) => 'true',
			),
			"dependency" => array(
				'element' => 'column_effect',
				'value_not_equal_to' => array( 'none' )
			),
			"description" => esc_html__( "Select if you want to enable invert motion effect on this column.", 'zuperla' ),
			'edit_field_class' => 'vc_col-sm-6',
			'group' => esc_html__( 'Effect & Positions', 'zuperla' ),
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Change Column Position", 'zuperla' ),
			"param_name" => "column_custom_position",
			"value" => array(
				esc_html__( "No", 'zuperla' ) => 'no',
				esc_html__( "Yes", 'zuperla' ) => 'yes',
			),
			'group' => esc_html__( 'Effect & Positions', 'zuperla' ),
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( 'Top Position', 'zuperla' ),
			"param_name" => "position_top",
			"value" => $zuperla_eutf_position_list,
			"description" => esc_html__( "Select the top position of the column.", 'zuperla' ),
			'group' => esc_html__( 'Effect & Positions', 'zuperla' ),
			"dependency" => array(
				'element' => 'column_custom_position',
				'value' => array( 'yes' )
			),
			'edit_field_class' => 'vc_col-sm-6',
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( 'Bottom Position', 'zuperla' ),
			"param_name" => "position_bottom",
			"value" => $zuperla_eutf_position_list,
			"description" => esc_html__( "Select the bottom position of the column.", 'zuperla' ),
			'group' => esc_html__( 'Effect & Positions', 'zuperla' ),
			"dependency" => array(
				'element' => 'column_custom_position',
				'value' => array( 'yes' )
			),
			'edit_field_class' => 'vc_col-sm-6',
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Left Position", 'zuperla' ),
			"param_name" => "position_left",
			"value" => $zuperla_eutf_position_list,
			"description" => esc_html__( "Select the left position of the column.", 'zuperla' ),
			'group' => esc_html__( 'Effect & Positions', 'zuperla' ),
			"dependency" => array(
				'element' => 'column_custom_position',
				'value' => array( 'yes' )
			),
			'edit_field_class' => 'vc_col-sm-6',
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( 'Right Position', 'zuperla' ),
			"param_name" => "position_right",
			"value" => $zuperla_eutf_position_list,
			"description" => esc_html__( "Select the right position of the column.", 'zuperla' ),
			'group' => esc_html__( 'Effect & Positions', 'zuperla' ),
			"dependency" => array(
				'element' => 'column_custom_position',
				'value' => array( 'yes' )
			),
			'edit_field_class' => 'vc_col-sm-6',
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "textfield",
			"heading" => esc_html__( 'Z index', 'zuperla' ),
			"param_name" => "z_index",
			"description" => esc_html__( "Enter a number for column's z-index. Default value is 1, recommended to be larger than this.", 'zuperla' ),
			'group' => esc_html__( 'Effect & Positions', 'zuperla' ),
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => 'zuperla_param_label',
			"heading" => esc_html__( "Column Width", 'zuperla'),
			"param_name" => "label_column_width",
			'value' => '',
			'std' => '',
			"description" => esc_html__( "Define your column width for desktops/laptops and devices. Width attribute is defined under General tab.", 'zuperla' ),
			'group' => esc_html__( 'Width & Responsiveness', 'zuperla' ),
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Desktop", 'zuperla' ),
			"param_name" => "desktop_hide",
			"value" => $zuperla_eutf_column_desktop_hide_list,
			"description" => esc_html__( "Define your column width for Desktop.", 'zuperla' ),
			'edit_field_class' => 'vc_col-sm-6',
			'group' => esc_html__( 'Width & Responsiveness', 'zuperla' ),
		)
	);
	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Tablet Landscape", 'zuperla' ),
			"param_name" => "tablet_width",
			"value" => $zuperla_eutf_column_width_tablet_list,
			"description" => esc_html__( "Define your column width for Tablet Landscape.", 'zuperla' ),
			'edit_field_class' => 'vc_col-sm-6',
			'group' => esc_html__( 'Width & Responsiveness', 'zuperla' ),
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Tablet Portrait", 'zuperla' ),
			"param_name" => "tablet_sm_width",
			"value" => $zuperla_eutf_column_width_tablet_sm_list,
			"description" => esc_html__( "Define your column width for Tablet Portrait.", 'zuperla' ),
			'edit_field_class' => 'vc_col-sm-6',
			'group' => esc_html__( 'Width & Responsiveness', 'zuperla' ),
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Mobile", 'zuperla' ),
			"param_name" => "mobile_width",
			"value" => $zuperla_eutf_column_mobile_width_list,
			"description" => esc_html__( "Define your column width for Mobile.", 'zuperla' ),
			'edit_field_class' => 'vc_col-sm-6',
			'group' => esc_html__( 'Width & Responsiveness', 'zuperla' ),
		)
	);


	vc_add_param( "vc_column",
		array(
			"type" => 'zuperla_param_label',
			"heading" => esc_html__( "Content Width", 'zuperla'),
			"param_name" => "label_content_width",
			'value' => '',
			'std' => '',
			"description" => esc_html__( "Define your column content width for devices. Default is defined under General > Content Width.", 'zuperla' ),
			"dependency" => array(
				'element' => 'content_width',
				'value_not_equal_to' => array( '100' )
			),
			'group' => esc_html__( 'Width & Responsiveness', 'zuperla' ),
		)
	);

	vc_add_param( "vc_column",
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( "Tablet Landscape", 'zuperla' ),
			'param_name' => 'tablet_content_width',
			"value" => array(
				esc_html__( "Default", 'zuperla' ) => 'inherit',
				esc_html__( "Reset", 'zuperla' ) => 'reset',
			),
			"dependency" => array(
				'element' => 'content_width',
				'value_not_equal_to' => array( '100' )
			),
			"description" => esc_html__( "Define your content width for Tablet Landscape.", 'zuperla' ),
			'edit_field_class' => 'vc_col-sm-4',
			'group' => esc_html__( "Width & Responsiveness", 'zuperla' ),
		)
	);

	vc_add_param( "vc_column",
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( "Tablet Portrait", 'zuperla' ),
			'param_name' => 'tablet_sm_content_width',
			"value" => array(
				esc_html__( "Default", 'zuperla' ) => 'inherit',
				esc_html__( "Reset", 'zuperla' ) => 'reset',
			),
			"dependency" => array(
				'element' => 'content_width',
				'value_not_equal_to' => array( '100' )
			),
			"description" => esc_html__( "Define your content width for Tablet Portrait.", 'zuperla' ),
			'edit_field_class' => 'vc_col-sm-4',
			'group' => esc_html__( "Width & Responsiveness", 'zuperla' ),
		)
	);

	vc_add_param( "vc_column",
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( "Mobile", 'zuperla' ),
			'param_name' => 'mobile_content_width',
			"value" => array(
				esc_html__( "Default", 'zuperla' ) => 'inherit',
				esc_html__( "Reset", 'zuperla' ) => 'reset',
			),
			"dependency" => array(
				'element' => 'content_width',
				'value_not_equal_to' => array( '100' )
			),
			"description" => esc_html__( "Define your content width for Mobile.", 'zuperla' ),
			'edit_field_class' => 'vc_col-sm-4',
			'group' => esc_html__( "Width & Responsiveness", 'zuperla' ),
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => 'zuperla_param_label',
			"heading" => esc_html__( "Column Effect", 'zuperla'),
			"param_name" => "label_column_effect",
			'value' => '',
			'std' => '',
			"description" => esc_html__( "Define your column effect for devices. Default values are defined under Effect & Positions > Column Effect.", 'zuperla' ),
			"dependency" => array(
				'element' => 'column_effect',
				'value' => array( 'vertical-parallax' )
			),
			'group' => esc_html__( 'Width & Responsiveness', 'zuperla' ),
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Tablet Landscape", 'zuperla' ),
			"param_name" => "tablet_landscape_column_effect",
			"value" => array(
				esc_html__( "Default values", 'zuperla' ) => '',
				esc_html__( "Disable Effect", 'zuperla' ) => 'none',
			),
			"description" => esc_html__( "Define your column effect for Tablet Landscape.", 'zuperla' ),
			'group' => esc_html__( 'Width & Responsiveness', 'zuperla' ),
			"dependency" => array(
				'element' => 'column_effect',
				'value' => array( 'vertical-parallax' )
			),
			'edit_field_class' => 'vc_col-sm-4',
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Tablet Portrait", 'zuperla' ),
			"param_name" => "tablet_portrait_column_effect",
			"value" => array(
				esc_html__( "Default values", 'zuperla' ) => '',
				esc_html__( "Disable Effect", 'zuperla' ) => 'none',
			),
			"description" => esc_html__( "Define your column effect for Tablet Portrait.", 'zuperla' ),
			'group' => esc_html__( 'Width & Responsiveness', 'zuperla' ),
			"dependency" => array(
				'element' => 'column_effect',
				'value' => array( 'vertical-parallax' )
			),
			'edit_field_class' => 'vc_col-sm-4',
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Mobile", 'zuperla' ),
			"param_name" => "mobile_column_effect",
			"value" => array(
				esc_html__( "Default values", 'zuperla' ) => '',
				esc_html__( "Disable Effect", 'zuperla' ) => 'none',
			),
			"description" => esc_html__( "Define your column effect for Mobile.", 'zuperla' ),
			'group' => esc_html__( 'Width & Responsiveness', 'zuperla' ),
			"dependency" => array(
				'element' => 'column_effect',
				'value' => array( 'vertical-parallax' )
			),
			'edit_field_class' => 'vc_col-sm-4',
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => 'zuperla_param_label',
			"heading" => esc_html__( "Column Positions", 'zuperla'),
			"param_name" => "label_column_positions",
			'value' => '',
			'std' => '',
			"description" => esc_html__( "Define your column positions for devices. Default values are defined under Effect & Positions > Change Column Position.", 'zuperla' ),
			"dependency" => array(
				'element' => 'column_custom_position',
				'value' => array( 'yes' )
			),
			'group' => esc_html__( 'Width & Responsiveness', 'zuperla' ),
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Tablet Landscape", 'zuperla' ),
			"param_name" => "tablet_landscape_column_positions",
			"value" => array(
				esc_html__( "Default values", 'zuperla' ) => '',
				esc_html__( "Reset Positions", 'zuperla' ) => 'none',
			),
			"description" => esc_html__( "Define your column positions for Tablet Landscape.", 'zuperla' ),
			'group' => esc_html__( 'Width & Responsiveness', 'zuperla' ),
			"dependency" => array(
				'element' => 'column_custom_position',
				'value' => array( 'yes' )
			),
			'edit_field_class' => 'vc_col-sm-4',
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Tablet Portrait", 'zuperla' ),
			"param_name" => "tablet_portrait_column_positions",
			"value" => array(
				esc_html__( "Default values", 'zuperla' ) => '',
				esc_html__( "Reset Positions", 'zuperla' ) => 'none',
			),
			"description" => esc_html__( "Define your column positions for Tablet Portrait.", 'zuperla' ),
			'group' => esc_html__( 'Width & Responsiveness', 'zuperla' ),
			"dependency" => array(
				'element' => 'column_custom_position',
				'value' => array( 'yes' )
			),
			'edit_field_class' => 'vc_col-sm-4',
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Mobile", 'zuperla' ),
			"param_name" => "mobile_column_positions",
			"value" => array(
				esc_html__( "Default values", 'zuperla' ) => '',
				esc_html__( "Reset Positions", 'zuperla' ) => 'none',
			),
			"description" => esc_html__( "Define your column positions for Mobile.", 'zuperla' ),
			'group' => esc_html__( 'Width & Responsiveness', 'zuperla' ),
			"dependency" => array(
				'element' => 'column_custom_position',
				'value' => array( 'yes' )
			),
			'edit_field_class' => 'vc_col-sm-4',
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => 'zuperla_param_label',
			"heading" => esc_html__( "Text Align", 'zuperla'),
			"param_name" => "label_text_align",
			'value' => '',
			'std' => '',
			"description" => esc_html__( "Define your text align for devices. Default values are defined under General > Text Align.", 'zuperla' ),
			'group' => esc_html__( 'Width & Responsiveness', 'zuperla' ),
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Tablet Landscape", 'zuperla' ),
			"param_name" => "tablet_text_align",
			"value" => array(
				esc_html__( "Default values", 'zuperla' ) => '',
				esc_html__( "Left", 'zuperla' ) => 'left',
				esc_html__( "Center", 'zuperla' ) => 'center',
				esc_html__( "Right", 'zuperla' ) => 'right',
			),
			'group' => esc_html__( 'Width & Responsiveness', 'zuperla' ),
			'edit_field_class' => 'vc_col-sm-4',
			"description" => esc_html__( "Define your text align for Tablet Landscape.", 'zuperla' ),
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Tablet Portrait", 'zuperla' ),
			"param_name" => "tablet_sm_text_align",
			"value" => array(
				esc_html__( "Default values", 'zuperla' ) => '',
				esc_html__( "Left", 'zuperla' ) => 'left',
				esc_html__( "Center", 'zuperla' ) => 'center',
				esc_html__( "Right", 'zuperla' ) => 'right',
			),
			'group' => esc_html__( 'Width & Responsiveness', 'zuperla' ),
			'edit_field_class' => 'vc_col-sm-4',
			"description" => esc_html__( "Define your text align for Tablet Portrait.", 'zuperla' ),
		)
	);

	vc_add_param( "vc_column",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Mobile", 'zuperla' ),
			"param_name" => "mobile_text_align",
			"value" => array(
				esc_html__( "Default values", 'zuperla' ) => '',
				esc_html__( "Left", 'zuperla' ) => 'left',
				esc_html__( "Center", 'zuperla' ) => 'center',
				esc_html__( "Right", 'zuperla' ) => 'right',
			),
			'group' => esc_html__( 'Width & Responsiveness', 'zuperla' ),
			'edit_field_class' => 'vc_col-sm-4',
			"description" => esc_html__( "Define your text align for Tablet Mobile.", 'zuperla' ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( "Column Width", 'zuperla' ),
			'param_name' => 'width',
			'value' => $zuperla_eutf_column_width_list,
			'description' => esc_html__( "Select column width.", 'zuperla' ),
			'std' => '1/1',
		)
	);



	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Content Width", 'zuperla' ),
			"param_name" => "content_width",
			"value" => array(
				esc_html__( "5%", 'zuperla' ) => '5',
				esc_html__( "10%", 'zuperla' ) => '10',
				esc_html__( "15%", 'zuperla' ) => '15',
				esc_html__( "20%", 'zuperla' ) => '20',
				esc_html__( "25%", 'zuperla' ) => '25',
				esc_html__( "30%", 'zuperla' ) => '30',
				esc_html__( "35%", 'zuperla' ) => '35',
				esc_html__( "40%", 'zuperla' ) => '40',
				esc_html__( "45%", 'zuperla' ) => '45',
				esc_html__( "50%", 'zuperla' ) => '50',
				esc_html__( "55%", 'zuperla' ) => '55',
				esc_html__( "60%", 'zuperla' ) => '60',
				esc_html__( "65%", 'zuperla' ) => '65',
				esc_html__( "70%", 'zuperla' ) => '70',
				esc_html__( "75%", 'zuperla' ) => '75',
				esc_html__( "80%", 'zuperla' ) => '80',
				esc_html__( "85%", 'zuperla' ) => '85',
				esc_html__( "90%", 'zuperla' ) => '90',
				esc_html__( "95%", 'zuperla' ) => '95',
				esc_html__( "100%", 'zuperla' ) => '100',
			),
			"description" => esc_html__( "Select the content width.", 'zuperla' ),
			'std' => '100',
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Horizontal Content Position", 'zuperla' ),
			"param_name" => "horizontal_content_position",
			"value" => array(
				esc_html__( "Left", 'zuperla' ) => 'left',
				esc_html__( "Center", 'zuperla' ) => 'center',
				esc_html__( "Right", 'zuperla' ) => 'right',
			),
			"dependency" => array(
				'element' => 'content_width',
				'value_not_equal_to' => array( '100' )
			),
			"description" => esc_html__( "Select the horizontal position of the content.", 'zuperla' ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Vertical Content Position", 'zuperla' ),
			"param_name" => "vertical_content_position",
			"value" => array(
				esc_html__( "Top", 'zuperla' ) => 'top',
				esc_html__( "Middle", 'zuperla' ) => 'middle',
				esc_html__( "Bottom", 'zuperla' ) => 'bottom',
			),
			"description" => esc_html__( "Select the vertical position of the content.", 'zuperla' ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Column 100% Height", 'zuperla' ),
			"description" => esc_html__( "Select if you need this column to have 100% height of the parent row.", 'zuperla' ),
			"param_name" => "full_height",
			"value" => array(
				esc_html__( "No", 'zuperla' ) => 'no',
				esc_html__( "Yes", 'zuperla' ) => 'yes',
			),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Text Align", 'zuperla' ),
			"param_name" => "text_align",
			"value" => array(
				esc_html__( "Left", 'zuperla' ) => 'left',
				esc_html__( "Center", 'zuperla' ) => 'center',
				esc_html__( "Right", 'zuperla' ) => 'right',
			),
			"description" => esc_html__( "Select the text align of the content.", 'zuperla' ),
		)
	);

	vc_add_param( "vc_column_inner", $zuperla_eutf_add_el_id );
	vc_add_param( "vc_column_inner", $zuperla_eutf_add_el_class );
	vc_add_param( "vc_column_inner", $zuperla_eutf_add_el_wrapper_class );


	vc_add_param( "vc_column_inner",
		array(
			"type" => "colorpicker",
			"heading" => esc_html__('Font Color', 'zuperla' ),
			"param_name" => "rc_font_color",
			"description" => esc_html__("Select font color", 'zuperla' ),
			'group' => esc_html__( "Style", 'zuperla' ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Heading Color", 'zuperla' ),
			"param_name" => "rc_heading_color",
			"param_holder_class" => "eut-colored-dropdown",
			"value" => array(
				esc_html__( "Default", 'zuperla' ) => '',
				esc_html__( "Dark", 'zuperla' ) => 'dark',
				esc_html__( "Light", 'zuperla' ) => 'light',
				esc_html__( "Primary 1", 'zuperla' ) => 'primary-1',
				esc_html__( "Primary 2", 'zuperla' ) => 'primary-2',
				esc_html__( "Primary 3", 'zuperla' ) => 'primary-3',
				esc_html__( "Primary 4", 'zuperla' ) => 'primary-4',
				esc_html__( "Primary 5", 'zuperla' ) => 'primary-5',
				esc_html__( "Primary 6", 'zuperla' ) => 'primary-6',
				esc_html__( "Green", 'zuperla' ) => 'green',
				esc_html__( "Orange", 'zuperla' ) => 'orange',
				esc_html__( "Red", 'zuperla' ) => 'red',
				esc_html__( "Blue", 'zuperla' ) => 'blue',
				esc_html__( "Aqua", 'zuperla' ) => 'aqua',
				esc_html__( "Purple", 'zuperla' ) => 'purple',
				esc_html__( "Grey", 'zuperla' ) => 'grey',
			),
			"description" => esc_html__( "Select heading color", 'zuperla' ),
			'group' => esc_html__( "Style", 'zuperla' ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Shadow", 'zuperla' ),
			"param_name" => "rc_shadow",
			"value" => array(
				esc_html__( "None", 'zuperla' ) => '',
				esc_html__( "Small", "zuperla" ) => 'small',
				esc_html__( "Medium", "zuperla" ) => 'medium',
				esc_html__( "Large", "zuperla" ) => 'large',
			),
			"description" => esc_html__( "Add Shadow", 'zuperla' ),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => 'dropdown',
			"heading" => esc_html__( "Background Type", 'zuperla' ),
			"param_name" => "rc_bg_type",
			"description" => esc_html__( "Select Background type", 'zuperla' ),
			"value" => array(
				esc_html__( "None", 'zuperla' ) => '',
				esc_html__( "Color", 'zuperla' ) => 'color',
				esc_html__( "Gradient Color", 'zuperla' ) => 'gradient',
				esc_html__( "Image", 'zuperla' ) => 'image',
				esc_html__( "Hosted Video", 'zuperla' ) => 'hosted_video',
				esc_html__( "YouTube Video", 'zuperla' ) => 'video',
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'YouTube link', 'zuperla' ),
			'param_name' => 'rc_bg_video_url',
			'value' => 'https://www.youtube.com/watch?v=C9tsrkRSw-Q',
			// default video url
			'description' => esc_html__( 'Add YouTube link.', 'zuperla' ),
			'dependency' => array(
				'element' => 'rc_bg_type',
				'value' => 'video',
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Video Popup Button", 'zuperla' ),
			"param_name" => "rc_bg_video_button",
			"value" => array(
				esc_html__( 'None', 'zuperla' ) => '',
				esc_html__( 'Devices only', 'zuperla' ) => 'device',
				esc_html__( 'Always visible', 'zuperla' ) => 'all',
			),
			"description" => esc_html__( "Select video popup button behavior", 'zuperla' ),
			'dependency' => array(
				'element' => 'rc_bg_type',
				'value' => 'video',
			),
			"std" => 'center-center',
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "colorpicker",
			"heading" => esc_html__( "Custom Color 1", 'zuperla' ),
			"param_name" => "rc_bg_gradient_color_1",
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'gradient' )
			),
			"std" => 'rgba(3,78,144,0.9)',
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "colorpicker",
			"heading" => esc_html__( "Custom Color 2", 'zuperla' ),
			"param_name" => "rc_bg_gradient_color_2",
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'gradient' )
			),
			"std" => 'rgba(25,180,215,0.9)',
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);
	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Gradient Direction", 'zuperla' ),
			"param_name" => "rc_bg_gradient_direction",
			"value" => array(
				esc_html__( "Left to Right", 'zuperla' ) => '90',
				esc_html__( "Left Top to Right Bottom", 'zuperla' ) => '135',
				esc_html__( "Left Bottom to Right Top", 'zuperla' ) => '45',
				esc_html__( "Bottom to Top", 'zuperla' ) => '180',
			),
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'gradient' )
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Video Button Position", 'zuperla' ),
			"param_name" => "rc_bg_video_button_position",
			"value" => array(
				esc_html__( 'Left Top', 'zuperla' ) => 'left-top',
				esc_html__( 'Left Bottom', 'zuperla' ) => 'left-bottom',
				esc_html__( 'Center Center', 'zuperla' ) => 'center-center',
				esc_html__( 'Right Top', 'zuperla' ) => 'right-top',
				esc_html__( 'Right Bottom', 'zuperla' ) => 'right-bottom',
			),
			"description" => esc_html__( "Select position for video popup", 'zuperla' ),
			'dependency' => array(
				'element' => 'rc_bg_video_button',
				'value_not_equal_to' => array( '' )
			),
			"std" => 'center-center',
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "colorpicker",
			"heading" => esc_html__( "Custom Background Color", 'zuperla' ),
			"param_name" => "rc_bg_color",
			"description" => esc_html__( "Select background color for your row", 'zuperla' ),
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'color' )
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);


	vc_add_param( "vc_column_inner",
		array(
			"type" => "attach_image",
			"heading" => esc_html__('Background Image', 'zuperla' ),
			"param_name" => "rc_bg_image",
			"value" => '',
			"description" => esc_html__("Select background image for your row. Used also as fallback for video.", 'zuperla' ),
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'image', 'hosted_video', 'video' )
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);
	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Background Image Type", 'zuperla' ),
			"param_name" => "rc_bg_image_type",
			"value" => array(
				esc_html__( "Default", 'zuperla' ) => '',
				esc_html__( "Parallax", 'zuperla' ) => 'parallax',
				esc_html__( "Horizontal Parallax Left to Right", 'zuperla' ) => 'horizontal-parallax-lr',
				esc_html__( "Horizontal Parallax Right to Left", 'zuperla' ) => 'horizontal-parallax-rl',
				esc_html__( "Animated", 'zuperla' ) => 'animated',
				esc_html__( "Horizontal Animation", 'zuperla' ) => 'horizontal',
				esc_html__( "Fixed Image", 'zuperla' ) => 'fixed',
				esc_html__( "Image usage as Pattern", 'zuperla' ) => 'pattern'
			),
			"description" => esc_html__( "Select how a background image will be displayed", 'zuperla' ),
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'image' )
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);
	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Background Image Size", 'zuperla' ),
			"param_name" => "rc_bg_image_size",
			"value" => array(
				esc_html__( "--Inherit--", 'zuperla' ) => '',
				esc_html__( "Responsive", 'zuperla' ) => 'responsive',
				esc_html__( "Extra Extra Large", 'zuperla' ) => 'extra-extra-large',
				esc_html__( "Full", 'zuperla' ) => 'full',
			),
			"description" => esc_html__( "Select the size of your background image", 'zuperla' ),
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'image' )
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);
	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Background Image Vertical Position", 'zuperla' ),
			"param_name" => "rc_bg_image_vertical_position",
			"value" => array(
				esc_html__( "Top", 'zuperla' ) => 'top',
				esc_html__( "Center", 'zuperla' ) => 'center',
				esc_html__( "Bottom", 'zuperla' ) => 'bottom',
			),
			"description" => esc_html__( "Select vertical position for background image", 'zuperla' ),
			"dependency" => array(
				'element' => 'rc_bg_image_type',
				'value' => array( 'horizontal-parallax-lr', 'horizontal-parallax-rl', 'horizontal' )
			),
			"std" => 'center',
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);
	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Background  Position", 'zuperla' ),
			"param_name" => "rc_bg_position",
			"value" => array(
				esc_html__( 'Left Top', 'zuperla' ) => 'left-top',
				esc_html__( 'Left Center', 'zuperla' ) => 'left-center',
				esc_html__( 'Left Bottom', 'zuperla' ) => 'left-bottom',
				esc_html__( 'Center Top', 'zuperla' ) => 'center-top',
				esc_html__( 'Center Center', 'zuperla' ) => 'center-center',
				esc_html__( 'Center Bottom', 'zuperla' ) => 'center-bottom',
				esc_html__( 'Right Top', 'zuperla' ) => 'right-top',
				esc_html__( 'Right Center', 'zuperla' ) => 'right-center',
				esc_html__( 'Right Bottom', 'zuperla' ) => 'right-bottom',
			),
			"description" => esc_html__( "Select position for background image", 'zuperla' ),
			"dependency" => array(
				'element' => 'rc_bg_image_type',
				'value' => array( '', 'animated' )
			),
			"std" => 'center-center',
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);
	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Background Position ( Tablet Portrait )", 'zuperla' ),
			"param_name" => "rc_bg_tablet_sm_position",
			"value" => array(
				esc_html__( 'Inherit from above', 'zuperla' ) => '',
				esc_html__( 'Left Top', 'zuperla' ) => 'left-top',
				esc_html__( 'Left Center', 'zuperla' ) => 'left-center',
				esc_html__( 'Left Bottom', 'zuperla' ) => 'left-bottom',
				esc_html__( 'Center Top', 'zuperla' ) => 'center-top',
				esc_html__( 'Center Center', 'zuperla' ) => 'center-center',
				esc_html__( 'Center Bottom', 'zuperla' ) => 'center-bottom',
				esc_html__( 'Right Top', 'zuperla' ) => 'right-top',
				esc_html__( 'Right Center', 'zuperla' ) => 'right-center',
				esc_html__( 'Right Bottom', 'zuperla' ) => 'right-bottom',
			),
			"description" => esc_html__( "Tablet devices with portrait orientation and below.", 'zuperla' ),
			"dependency" => array(
				'element' => 'rc_bg_image_type',
				'value' => array( '', 'animated' )
			),
			"std" => '',
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);
	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Parallax Sensor", 'zuperla' ),
			"param_name" => "rc_bg_parallax_threshold",
			"value" => array(
				esc_html__( "Low", 'zuperla' ) => '0.1',
				esc_html__( "Normal", 'zuperla' ) => '0.3',
				esc_html__( "High", 'zuperla' ) => '0.5',
				esc_html__( "Max", 'zuperla' ) => '0.8',
			),
			"description" => esc_html__( "Define the appearance for the parallax effect. Note that you get greater image zoom when you increase the parallax sensor.", 'zuperla' ),
			"dependency" => array(
				'element' => 'rc_bg_image_type',
				'value' => array( 'parallax', 'horizontal-parallax-lr', 'horizontal-parallax-rl' )
			),
			"std" => '0.3',
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);
	vc_add_param( "vc_column_inner",
		array(
			"type" => "textfield",
			"heading" => esc_html__("WebM File URL", 'zuperla'),
			"param_name" => "rc_bg_video_webm",
			"description" => esc_html__( "Fill WebM and mp4 format for browser compatibility", 'zuperla' ),
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'hosted_video' )
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);
	vc_add_param( "vc_column_inner",
		array(
			"type" => "textfield",
			"heading" => esc_html__( "MP4 File URL", 'zuperla' ),
			"param_name" => "rc_bg_video_mp4",
			"description" => esc_html__( "Fill mp4 format URL", 'zuperla' ),
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'hosted_video' )
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);
	vc_add_param( "vc_column_inner",
		array(
			"type" => "textfield",
			"heading" => esc_html__( "OGV File URL", 'zuperla' ),
			"param_name" => "rc_bg_video_ogv",
			"description" => esc_html__( "Fill OGV format URL ( optional )", 'zuperla' ),
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'hosted_video' )
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);
	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Loop", 'zuperla' ),
			"param_name" => "rc_bg_video_loop",
			"value" => array(
				esc_html__( "Yes", 'zuperla' ) => 'yes',
				esc_html__( "No", 'zuperla' ) => 'no',
			),
			"std" => 'yes',
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'hosted_video' )
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);
	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Allow on devices", 'zuperla' ),
			"param_name" => "rc_bg_video_device",
			"value" => array(
				esc_html__( "No", 'zuperla' ) => 'no',
				esc_html__( "Yes", 'zuperla' ) => 'yes',

			),
			"std" => 'no',
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'hosted_video' )
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);
	vc_add_param( "vc_column_inner",
		array(
			"type" => 'checkbox',
			"heading" => esc_html__( "Pattern overlay", 'zuperla'),
			"param_name" => "rc_bg_pattern_overlay",
			"description" => esc_html__( "If selected, a pattern will be added.", 'zuperla' ),
			"value" => Array(esc_html__( "Add pattern", 'zuperla' ) => 'yes'),
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'image', 'hosted_video', 'video' )
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);
	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Color overlay", 'zuperla' ),
			"param_name" => "rc_bg_color_overlay",
			"param_holder_class" => "eut-colored-dropdown",
			"value" => array(
				esc_html__( "None", 'zuperla' ) => '',
				esc_html__( "Dark", 'zuperla' ) => 'dark',
				esc_html__( "Light", 'zuperla' ) => 'light',
				esc_html__( "Primary 1", 'zuperla' ) => 'primary-1',
				esc_html__( "Primary 2", 'zuperla' ) => 'primary-2',
				esc_html__( "Primary 3", 'zuperla' ) => 'primary-3',
				esc_html__( "Primary 4", 'zuperla' ) => 'primary-4',
				esc_html__( "Primary 5", 'zuperla' ) => 'primary-5',
				esc_html__( "Primary 6", 'zuperla' ) => 'primary-6',
				esc_html__( "Custom", 'zuperla' ) => 'custom',
				esc_html__( "Gradient", 'zuperla' ) => 'gradient',
			),
			"dependency" => array(
				'element' => 'rc_bg_type',
				'value' => array( 'image', 'hosted_video', 'video' )
			),
			"description" => esc_html__( "A color overlay for the media", 'zuperla' ),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "colorpicker",
			"heading" => esc_html__('Custom Color Overlay', 'zuperla' ),
			"param_name" => "rc_bg_color_overlay_custom",
			"dependency" => array(
				'element' => 'rc_bg_color_overlay',
				'value' => array( 'custom' )
			),
			"std" => 'rgba(255,255,255,0.1)',
			"description" => esc_html__("Select custom color overlay", 'zuperla' ),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "colorpicker",
			"heading" => esc_html__('Gradient Color Overlay 1', 'zuperla' ),
			"param_name" => "rc_bg_gradient_overlay_custom_1",
			"dependency" => array(
				'element' => 'rc_bg_color_overlay',
				'value' => array( 'gradient' )
			),
			"std" => 'rgba(3,78,144,0.9)',
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "colorpicker",
			"heading" => esc_html__('Gradient Color Overlay 2', 'zuperla' ),
			"param_name" => "rc_bg_gradient_overlay_custom_2",
			"dependency" => array(
				'element' => 'rc_bg_color_overlay',
				'value' => array( 'gradient' )
			),
			"std" => 'rgba(25,180,215,0.9)',
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Gradient Direction", 'zuperla' ),
			"param_name" => "rc_bg_gradient_overlay_direction",
			"value" => array(
				esc_html__( "Left to Right", 'zuperla' ) => '90',
				esc_html__( "Left Top to Right Bottom", 'zuperla' ) => '135',
				esc_html__( "Left Bottom to Right Top", 'zuperla' ) => '45',
				esc_html__( "Bottom to Top", 'zuperla' ) => '180',
			),
			"dependency" => array(
				'element' => 'rc_bg_color_overlay',
				'value' => array( 'gradient' )
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Opacity overlay", 'zuperla' ),
			"param_name" => "rc_bg_opacity_overlay",
			"value" => array( '10', '20', '30' ,'40', '50', '60', '70', '80' ,'90' ),
			"std" => '10',
			"description" => esc_html__( "Opacity of the overlay", 'zuperla' ),
			"dependency" => array(
				'element' => 'rc_bg_color_overlay',
				'value' => array( 'dark', 'light', 'primary-1', 'primary-2', 'primary-3', 'primary-4', 'primary-5', 'primary-6' )
			),
			"group" => esc_html__( "Style", 'zuperla' ),
		)
	);


	vc_add_param( "vc_column_inner",
		array(
			'type' => 'css_editor',
			'heading' => esc_html__( 'CSS box', 'zuperla' ),
			'param_name' => 'css',
			'group' => esc_html__( 'Design Options', 'zuperla' ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Column Effect", 'zuperla' ),
			"param_name" => "column_effect",
			"value" => array(
				esc_html__( "None", 'zuperla' ) => 'none',
				esc_html__( "Vertical Parallax", 'zuperla' ) => 'vertical-parallax',
			),
			"description" => esc_html__( "Select column effect behaviour. Notice that the Mouse Move Effect does not affect on devices.", 'zuperla' ),
			'group' => esc_html__( 'Effect & Positions', 'zuperla' ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Column Effect Total Range", 'zuperla' ),
			"param_name" => "column_effect_limit",
			"value" => array(
				esc_html__( "1x", 'zuperla' ) => '1x',
				esc_html__( "2x", 'zuperla' ) => '2x',
				esc_html__( "3x", 'zuperla' ) => '3x',
				esc_html__( "4x", 'zuperla' ) => '4x',
				esc_html__( "5x", 'zuperla' ) => '5x',
				esc_html__( "6x", 'zuperla' ) => '6x',
				esc_html__( "None", 'zuperla' ) => 'none',
			),
			"dependency" => array(
				'element' => 'column_effect',
				'value_not_equal_to' => array( 'none' )
			),
			"description" => esc_html__( "Select column effect total range of motion. None allows column to move with complete freedom.", 'zuperla' ),
			'edit_field_class' => 'vc_col-sm-6',
			'group' => esc_html__( 'Effect & Positions', 'zuperla' ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Column Effect Invert Motion", 'zuperla' ),
			"param_name" => "column_effect_invert",
			"value" => array(
				esc_html__( "No", 'zuperla' ) => 'false',
				esc_html__( "Yes", 'zuperla' ) => 'true',
			),
			"dependency" => array(
				'element' => 'column_effect',
				'value_not_equal_to' => array( 'none' )
			),
			"description" => esc_html__( "Select if you want to enable invert motion effect on this column.", 'zuperla' ),
			'edit_field_class' => 'vc_col-sm-6',
			'group' => esc_html__( 'Effect & Positions', 'zuperla' ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Change Column Position", 'zuperla' ),
			"param_name" => "column_custom_position",
			"value" => array(
				esc_html__( "No", 'zuperla' ) => 'no',
				esc_html__( "Yes", 'zuperla' ) => 'yes',
			),
			'group' => esc_html__( 'Effect & Positions', 'zuperla' ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( 'Top Position', 'zuperla' ),
			"param_name" => "position_top",
			"value" => $zuperla_eutf_position_list,
			"description" => esc_html__( "Select the top position of the column.", 'zuperla' ),
			'group' => esc_html__( 'Effect & Positions', 'zuperla' ),
			"dependency" => array(
				'element' => 'column_custom_position',
				'value' => array( 'yes' )
			),
			'edit_field_class' => 'vc_col-sm-6',
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( 'Bottom Position', 'zuperla' ),
			"param_name" => "position_bottom",
			"value" => $zuperla_eutf_position_list,
			"description" => esc_html__( "Select the bottom position of the column.", 'zuperla' ),
			'group' => esc_html__( 'Effect & Positions', 'zuperla' ),
			"dependency" => array(
				'element' => 'column_custom_position',
				'value' => array( 'yes' )
			),
			'edit_field_class' => 'vc_col-sm-6',
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Left Position", 'zuperla' ),
			"param_name" => "position_left",
			"value" => $zuperla_eutf_position_list,
			"description" => esc_html__( "Select the left position of the column.", 'zuperla' ),
			'group' => esc_html__( 'Effect & Positions', 'zuperla' ),
			"dependency" => array(
				'element' => 'column_custom_position',
				'value' => array( 'yes' )
			),
			'edit_field_class' => 'vc_col-sm-6',
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( 'Right Position', 'zuperla' ),
			"param_name" => "position_right",
			"value" => $zuperla_eutf_position_list,
			"description" => esc_html__( "Select the right position of the column.", 'zuperla' ),
			'group' => esc_html__( 'Effect & Positions', 'zuperla' ),
			"dependency" => array(
				'element' => 'column_custom_position',
				'value' => array( 'yes' )
			),
			'edit_field_class' => 'vc_col-sm-6',
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "textfield",
			"heading" => esc_html__( 'Z index', 'zuperla' ),
			"param_name" => "z_index",
			"description" => esc_html__( "Enter a number for column's z-index. Default value is 1, recommended to be larger than this.", 'zuperla' ),
			'group' => esc_html__( 'Effect & Positions', 'zuperla' ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => 'zuperla_param_label',
			"heading" => esc_html__( "Column Width", 'zuperla'),
			"param_name" => "label_column_width",
			'value' => '',
			'std' => '',
			"description" => esc_html__( "Define your column width for desktops/laptops and devices. Width attribute is defined under General tab.", 'zuperla' ),
			'group' => esc_html__( 'Width & Responsiveness', 'zuperla' ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Desktop", 'zuperla' ),
			"param_name" => "desktop_hide",
			"value" => $zuperla_eutf_column_desktop_hide_list,
			"description" => esc_html__( "Define your column width for Desktop.", 'zuperla' ),
			'edit_field_class' => 'vc_col-sm-6',
			'group' => esc_html__( 'Width & Responsiveness', 'zuperla' ),
		)
	);
	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Tablet Landscape", 'zuperla' ),
			"param_name" => "tablet_width",
			"value" => $zuperla_eutf_column_width_tablet_list,
			"description" => esc_html__( "Define your column width for Tablet Landscape.", 'zuperla' ),
			'edit_field_class' => 'vc_col-sm-6',
			'group' => esc_html__( 'Width & Responsiveness', 'zuperla' ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Tablet Portrait", 'zuperla' ),
			"param_name" => "tablet_sm_width",
			"value" => $zuperla_eutf_column_width_tablet_sm_list,
			"description" => esc_html__( "Define your column width for Tablet Portrait.", 'zuperla' ),
			'edit_field_class' => 'vc_col-sm-6',
			'group' => esc_html__( 'Width & Responsiveness', 'zuperla' ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Mobile", 'zuperla' ),
			"param_name" => "mobile_width",
			"value" => $zuperla_eutf_column_mobile_width_list,
			"description" => esc_html__( "Define your column width for Mobile.", 'zuperla' ),
			'edit_field_class' => 'vc_col-sm-6',
			'group' => esc_html__( 'Width & Responsiveness', 'zuperla' ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => 'zuperla_param_label',
			"heading" => esc_html__( "Content Width", 'zuperla'),
			"param_name" => "label_content_width",
			'value' => '',
			'std' => '',
			"description" => esc_html__( "Define your column content width for devices. Default is defined under General > Content Width.", 'zuperla' ),
			"dependency" => array(
				'element' => 'content_width',
				'value_not_equal_to' => array( '100' )
			),
			'group' => esc_html__( 'Width & Responsiveness', 'zuperla' ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( "Tablet Landscape", 'zuperla' ),
			'param_name' => 'tablet_content_width',
			"value" => array(
				esc_html__( "Default", 'zuperla' ) => 'inherit',
				esc_html__( "Reset", 'zuperla' ) => 'reset',
			),
			"dependency" => array(
				'element' => 'content_width',
				'value_not_equal_to' => array( '100' )
			),
			"description" => esc_html__( "Define your content width for Tablet Landscape.", 'zuperla' ),
			'edit_field_class' => 'vc_col-sm-4',
			'group' => esc_html__( "Width & Responsiveness", 'zuperla' ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( "Tablet Portrait", 'zuperla' ),
			'param_name' => 'tablet_sm_content_width',
			"value" => array(
				esc_html__( "Default", 'zuperla' ) => 'inherit',
				esc_html__( "Reset", 'zuperla' ) => 'reset',
			),
			"dependency" => array(
				'element' => 'content_width',
				'value_not_equal_to' => array( '100' )
			),
			"description" => esc_html__( "Define your content width for Tablet Portrait.", 'zuperla' ),
			'edit_field_class' => 'vc_col-sm-4',
			'group' => esc_html__( "Width & Responsiveness", 'zuperla' ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( "Mobile", 'zuperla' ),
			'param_name' => 'mobile_content_width',
			"value" => array(
				esc_html__( "Default", 'zuperla' ) => 'inherit',
				esc_html__( "Reset", 'zuperla' ) => 'reset',
			),
			"dependency" => array(
				'element' => 'content_width',
				'value_not_equal_to' => array( '100' )
			),
			"description" => esc_html__( "Define your content width for Mobile.", 'zuperla' ),
			'edit_field_class' => 'vc_col-sm-4',
			'group' => esc_html__( "Width & Responsiveness", 'zuperla' ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => 'zuperla_param_label',
			"heading" => esc_html__( "Column Effect", 'zuperla'),
			"param_name" => "label_column_effect",
			'value' => '',
			'std' => '',
			"description" => esc_html__( "Define your column effect for devices. Default values are defined under Effect & Positions > Column Effect.", 'zuperla' ),
			"dependency" => array(
				'element' => 'column_effect',
				'value' => array( 'vertical-parallax' )
			),
			'group' => esc_html__( 'Width & Responsiveness', 'zuperla' ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Tablet Landscape", 'zuperla' ),
			"param_name" => "tablet_landscape_column_effect",
			"value" => array(
				esc_html__( "Default values", 'zuperla' ) => '',
				esc_html__( "Disable Effect", 'zuperla' ) => 'none',
			),
			"description" => esc_html__( "Define your column effect for Tablet Landscape.", 'zuperla' ),
			'group' => esc_html__( 'Width & Responsiveness', 'zuperla' ),
			"dependency" => array(
				'element' => 'column_effect',
				'value' => array( 'vertical-parallax' )
			),
			'edit_field_class' => 'vc_col-sm-4',
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Tablet Portrait", 'zuperla' ),
			"param_name" => "tablet_portrait_column_effect",
			"value" => array(
				esc_html__( "Default values", 'zuperla' ) => '',
				esc_html__( "Disable Effect", 'zuperla' ) => 'none',
			),
			"description" => esc_html__( "Define your column effect for Tablet Portrait.", 'zuperla' ),
			'group' => esc_html__( 'Width & Responsiveness', 'zuperla' ),
			"dependency" => array(
				'element' => 'column_effect',
				'value' => array( 'vertical-parallax' )
			),
			'edit_field_class' => 'vc_col-sm-4',
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Mobile", 'zuperla' ),
			"param_name" => "mobile_column_effect",
			"value" => array(
				esc_html__( "Default values", 'zuperla' ) => '',
				esc_html__( "Disable Effect", 'zuperla' ) => 'none',
			),
			"description" => esc_html__( "Define your column effect for Mobile.", 'zuperla' ),
			'group' => esc_html__( 'Width & Responsiveness', 'zuperla' ),
			"dependency" => array(
				'element' => 'column_effect',
				'value' => array( 'vertical-parallax' )
			),
			'edit_field_class' => 'vc_col-sm-4',
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => 'zuperla_param_label',
			"heading" => esc_html__( "Column Positions", 'zuperla'),
			"param_name" => "label_column_positions",
			'value' => '',
			'std' => '',
			"description" => esc_html__( "Define your column positions for devices. Default values are defined under Effect & Positions > Change Column Position.", 'zuperla' ),
			"dependency" => array(
				'element' => 'column_custom_position',
				'value' => array( 'yes' )
			),
			'group' => esc_html__( 'Width & Responsiveness', 'zuperla' ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Tablet Landscape", 'zuperla' ),
			"param_name" => "tablet_landscape_column_positions",
			"value" => array(
				esc_html__( "Default values", 'zuperla' ) => '',
				esc_html__( "Reset Positions", 'zuperla' ) => 'none',
			),
			"description" => esc_html__( "Define your column positions for Tablet Landscape.", 'zuperla' ),
			'group' => esc_html__( 'Width & Responsiveness', 'zuperla' ),
			"dependency" => array(
				'element' => 'column_custom_position',
				'value' => array( 'yes' )
			),
			'edit_field_class' => 'vc_col-sm-4',
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Tablet Portrait", 'zuperla' ),
			"param_name" => "tablet_portrait_column_positions",
			"value" => array(
				esc_html__( "Default values", 'zuperla' ) => '',
				esc_html__( "Reset Positions", 'zuperla' ) => 'none',
			),
			"description" => esc_html__( "Define your column positions for Tablet Portrait.", 'zuperla' ),
			'group' => esc_html__( 'Width & Responsiveness', 'zuperla' ),
			"dependency" => array(
				'element' => 'column_custom_position',
				'value' => array( 'yes' )
			),
			'edit_field_class' => 'vc_col-sm-4',
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Mobile", 'zuperla' ),
			"param_name" => "mobile_column_positions",
			"value" => array(
				esc_html__( "Default values", 'zuperla' ) => '',
				esc_html__( "Reset Positions", 'zuperla' ) => 'none',
			),
			"description" => esc_html__( "Define your column positions for Mobile.", 'zuperla' ),
			'group' => esc_html__( 'Width & Responsiveness', 'zuperla' ),
			"dependency" => array(
				'element' => 'column_custom_position',
				'value' => array( 'yes' )
			),
			'edit_field_class' => 'vc_col-sm-4',
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => 'zuperla_param_label',
			"heading" => esc_html__( "Text Align", 'zuperla'),
			"param_name" => "label_text_align",
			'value' => '',
			'std' => '',
			"description" => esc_html__( "Define your text align for devices. Default values are defined under General > Text Align.", 'zuperla' ),
			'group' => esc_html__( 'Width & Responsiveness', 'zuperla' ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Tablet Landscape", 'zuperla' ),
			"param_name" => "tablet_text_align",
			"value" => array(
				esc_html__( "Default values", 'zuperla' ) => '',
				esc_html__( "Left", 'zuperla' ) => 'left',
				esc_html__( "Center", 'zuperla' ) => 'center',
				esc_html__( "Right", 'zuperla' ) => 'right',
			),
			'group' => esc_html__( 'Width & Responsiveness', 'zuperla' ),
			'edit_field_class' => 'vc_col-sm-4',
			"description" => esc_html__( "Define your text align for Tablet Landscape.", 'zuperla' ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Tablet Portrait", 'zuperla' ),
			"param_name" => "tablet_sm_text_align",
			"value" => array(
				esc_html__( "Default values", 'zuperla' ) => '',
				esc_html__( "Left", 'zuperla' ) => 'left',
				esc_html__( "Center", 'zuperla' ) => 'center',
				esc_html__( "Right", 'zuperla' ) => 'right',
			),
			'group' => esc_html__( 'Width & Responsiveness', 'zuperla' ),
			'edit_field_class' => 'vc_col-sm-4',
			"description" => esc_html__( "Define your text align for Tablet Portrait.", 'zuperla' ),
		)
	);

	vc_add_param( "vc_column_inner",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Mobile", 'zuperla' ),
			"param_name" => "mobile_text_align",
			"value" => array(
				esc_html__( "Default values", 'zuperla' ) => '',
				esc_html__( "Left", 'zuperla' ) => 'left',
				esc_html__( "Center", 'zuperla' ) => 'center',
				esc_html__( "Right", 'zuperla' ) => 'right',
			),
			'group' => esc_html__( 'Width & Responsiveness', 'zuperla' ),
			'edit_field_class' => 'vc_col-sm-4',
			"description" => esc_html__( "Define your text align for Tablet Mobile.", 'zuperla' ),
		)
	);

	vc_add_param( "vc_widget_sidebar",
		array(
			'type' => 'hidden',
			'param_name' => 'title',
			'value' => '',
		)
	);

	if ( defined( 'WPB_VC_VERSION' ) && version_compare( WPB_VC_VERSION, '4.6', '>=') ) {

		vc_add_param( "vc_tta_tabs",
			array(
				'type' => 'hidden',
				'param_name' => 'no_fill_content_area',
				'value' => '',
			)
		);

		vc_add_param( "vc_tta_tabs",
			array(
				'type' => 'hidden',
				'param_name' => 'tab_position',
				'value' => 'top',
			)
		);

		vc_add_param( "vc_tta_accordion",
			array(
				'type' => 'hidden',
				'param_name' => 'no_fill',
				'value' => '',
			)
		);

		vc_add_param( "vc_tta_tour",
			array(
				'type' => 'hidden',
				'param_name' => 'no_fill_content_area',
				'value' => '',
			)
		);
	}

	vc_add_param( "vc_column_text",
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Text Style", 'zuperla' ),
			"param_name" => "text_style",
			"value" => array(
				esc_html__( "None", 'zuperla' ) => '',
				esc_html__( "Leader", 'zuperla' ) => 'leader-text',
				esc_html__( "Subtitle", 'zuperla' ) => 'subtitle',
				esc_html__( "Link Text", 'zuperla' ) => 'link-text',
				esc_html__( "Small Text", 'zuperla' ) => 'small-text',
			),
			"description" => esc_html__( "Select your text style", 'zuperla' ),
		)
	);
	vc_add_param( "vc_column_text", $zuperla_eutf_add_animation );
	vc_add_param( "vc_column_text", $zuperla_eutf_add_animation_delay );
	vc_add_param( "vc_column_text", $zuperla_eutf_add_animation_duration );


}

//Omit closing PHP tag to avoid accidental whitespace output errors.
