<?php

/*
*	Theme update functions
*
 * 	@version	1.0
 * 	@author		Euthemians Team
 * 	@URI		http://euthemians.com
*/

/**
 * Display theme update notices in the admin area
 */
function zuperla_eutf_admin_notices() {

	$message = '';
	if ( is_super_admin() ) {

		if ( ( defined( 'ZUPERLA_EXT_VERSION' ) && version_compare( '2.0', ZUPERLA_EXT_VERSION, '>' ) ) && !get_user_meta( get_current_user_id(), 'zuperla_eutf_dismissed_notice_update_plugins', true ) ) {

		$plugins_link = 'admin.php?page=zuperla-tgmpa-install-plugins';
			$message = esc_html__( "Note: Zuperla v2 is a major theme release so be sure to update the required plugins, especially Zuperla Extension, to avoid any compatibility issues.", 'zuperla' ) .
						" <a href='" . esc_url( admin_url() . $plugins_link ) . "'>" . esc_html__( "Theme Plugins", 'zuperla' ) . "</a>";
			$message .=  '<br/><span><a href="' .esc_url( wp_nonce_url( add_query_arg( 'zuperla-eutf-dismiss', 'dismiss_update_plugins_notice' ), 'zuperla-eutf-dismiss-' . esc_attr( get_current_user_id() ) ) ) . '" class="dismiss-notice" target="_parent">' . esc_html__( "Dismiss this notice", 'zuperla' ) . '</a><span>';
			add_settings_error(
				'eut-theme-update-message',
				'plugins_update_required',
				$message,
				'updated'
			);
			if ( 'options-general' !== $GLOBALS['current_screen']->parent_base ) {
				settings_errors( 'eut-theme-update-message' );
			}

		}

		if ( !class_exists( 'Envato_Market' ) && !get_user_meta( get_current_user_id(), 'zuperla_eutf_dismissed_notice_envato_market', true ) ) {

			$envato_market_link = 'admin.php?page=zuperla-tgmpa-install-plugins';
			$message = esc_html__( "Note:", "zuperla" ) . " " . esc_html__( "Envato official solution is recommended for theme updates using the new Envato Market API.", 'zuperla' ) .
					"<br/>" . esc_html__( "You can now update the theme using the", 'zuperla' ) . " " . "<a href='" . esc_url( admin_url() . $envato_market_link ) . "'>" . esc_html__( "Envato Market", 'zuperla' ) . "</a>" . " ". esc_html__( "plugin", 'zuperla' ) . "." .
					" " . esc_html__( "For more information read the related article in our", 'zuperla' ) . " " . "<a href='//docs.eurhemians.com/tutorials/envato-market-wordpress-plugin-for-theme-updates/' target='_blank'>" . esc_html__( "documentation", 'zuperla' ) . "</a>.";

			$message .=  '<br/><span><a href="' .esc_url( wp_nonce_url( add_query_arg( 'zuperla-eutf-dismiss', 'dismiss_envato_market_notice' ), 'zuperla-eutf-dismiss-' . esc_attr( get_current_user_id() ) ) ) . '" class="dismiss-notice" target="_parent">' . esc_html__( "Dismiss this notice", 'zuperla' ) . '</a><span>';

			add_settings_error(
				'eut-envato-market-message',
				'plugins_update_required',
				$message,
				'updated'
			);
			if ( 'options-general' !== $GLOBALS['current_screen']->parent_base ) {
				settings_errors( 'eut-envato-market-message' );
			}

		}

	}

}
add_action( 'admin_notices', 'zuperla_eutf_admin_notices' );

/**
 * Dismiss notices and update user meta data
 */
function zuperla_eutf_notice_dismiss() {
	if ( isset( $_GET['zuperla-eutf-dismiss'] ) && check_admin_referer( 'zuperla-eutf-dismiss-' . get_current_user_id() ) ) {
		$dismiss = $_GET['zuperla-eutf-dismiss'];
		if ( 'dismiss_envato_market_notice' == $dismiss ) {
			update_user_meta( get_current_user_id(), 'zuperla_eutf_dismissed_notice_envato_market' , 1 );
		} else if ( 'dismiss_update_plugins_notice' == $dismiss ) {
			update_user_meta( get_current_user_id(), 'zuperla_eutf_dismissed_notice_update_plugins' , 1 );
		}
	}
}
add_action( 'admin_head', 'zuperla_eutf_notice_dismiss' );

/**
 * Delete metadata for admin notices when switching themes
 */
function zuperla_eutf_update_dismiss() {
	delete_metadata( 'user', null, 'zuperla_eutf_dismissed_notice_envato_market', null, true );
	delete_metadata( 'user', null, 'zuperla_eutf_dismissed_notice_update_plugins', null, true );
}
add_action( 'switch_theme', 'zuperla_eutf_update_dismiss' );


//Omit closing PHP tag to avoid accidental whitespace output errors.
