<?php
/*
*	Helper Functions for meta options ( Post / Page / Portfolio / Product )
*
* 	@author		Euthemians Team
* 	@URI		http://euthemians.com
*/


/**
 * Functions to print global metaboxes
 */
add_action( 'save_post', 'zuperla_eutf_generic_options_save_postdata', 10, 2 );

/**
 * Page Options Metabox
 */
function zuperla_eutf_page_options_box( $post ) {

	global $zuperla_eutf_button_color_selection;

	$post_type = get_post_type( $post->ID );
	$zuperla_eutf_page_title_selection = array(
		'' => esc_html__( '-- Inherit --', 'zuperla' ),
		'custom' => esc_html__( 'Custom Advanced Title', 'zuperla' ),
	);
	$zuperla_eutf_area_colors_info = esc_html__( 'Inherit : Appearance - Customize', 'zuperla' );
	$zuperla_eutf_theme_options_info_text_empty = $zuperla_eutf_desc_info = "";

	switch( $post_type ) {
		case 'tribe_events':
			$zuperla_eutf_theme_options_info = esc_html__( 'Inherit : Theme Options - Events Calendar Options - Single Event Settings.', 'zuperla' );
		break;
		case 'portfolio':
			$zuperla_eutf_theme_options_info = esc_html__( 'Inherit : Theme Options - Portfolio Options.', 'zuperla' );
			$zuperla_eutf_theme_options_info_text_empty =  esc_html__('If empty, text is configured from: Theme Options - Portfolio Options.', 'zuperla' );
			$zuperla_eutf_desc_info = esc_html__( 'Enter your portfolio description.', 'zuperla' );
		break;
		case 'post':
			$zuperla_eutf_theme_options_info = esc_html__( 'Inherit : Theme Options - Blog Options - Single Post.', 'zuperla' );
			$zuperla_eutf_theme_options_info_text_empty =  esc_html__('If empty, text is configured from: Theme Options - Blog Options - Single Post.', 'zuperla' );
			$zuperla_eutf_desc_info = esc_html__( 'Enter your post description( Not available in Simple Title ).', 'zuperla' );
			$zuperla_eutf_page_title_selection = array(
				'' => esc_html__( '-- Inherit --', 'zuperla' ),
				'custom' => esc_html__( 'Custom Advanced Title', 'zuperla' ),
				'simple' => esc_html__( 'Simple Title', 'zuperla' ),
			);
		break;
		case 'product':
			$zuperla_eutf_area_colors_info = esc_html__( 'Inherit : Appearance - Customize - Colors - Shop/Product - Colors - Product Area.', 'zuperla' );
			$zuperla_eutf_theme_options_info = esc_html__( 'Inherit : Theme Options - WooCommerce Options - Single Product.', 'zuperla' );
			$zuperla_eutf_theme_options_info_text_empty =  esc_html__('If empty, text is configured from: Theme Options - WooCommerce Options - Single Product.', 'zuperla' );
			$zuperla_eutf_desc_info = esc_html__( 'Enter your product description( Not available in Simple Title ).', 'zuperla' );
			$zuperla_eutf_page_title_selection = array(
				'' => esc_html__( '-- Inherit --', 'zuperla' ),
				'custom' => esc_html__( 'Custom Advanced Title', 'zuperla' ),
				'simple' => esc_html__( 'Simple Title', 'zuperla' ),
			);
		break;
		case 'page':
		default:
			$zuperla_eutf_theme_options_info = esc_html__( 'Inherit : Theme Options - Page Options.', 'zuperla' );
			$zuperla_eutf_theme_options_info_text_empty =  esc_html__('If empty, text is configured from: Theme Options - Page Options.', 'zuperla' );
			$zuperla_eutf_desc_info = esc_html__( 'Enter your page description.', 'zuperla' );
		break;
	}

	$zuperla_eutf_page_padding_selection = array(
		'' => esc_html__( '-- Inherit --', 'zuperla' ),
		'none' => esc_html__( 'None', 'zuperla' ),
		'1x' => esc_html__( '1x', 'zuperla' ),
		'2x' => esc_html__( '2x', 'zuperla' ),
		'3x' => esc_html__( '3x', 'zuperla' ),
		'4x' => esc_html__( '4x', 'zuperla' ),
		'5x' => esc_html__( '5x', 'zuperla' ),
		'6x' => esc_html__( '6x', 'zuperla' ),
	);

	$zuperla_eutf_page_padding_selection_extra = array(
		'' => esc_html__( '-- Inherit --', 'zuperla' ),
		'none' => esc_html__( 'None', 'zuperla' ),
		'1x' => esc_html__( '1x', 'zuperla' ),
		'2x' => esc_html__( '2x', 'zuperla' ),
		'3x' => esc_html__( '3x', 'zuperla' ),
		'4x' => esc_html__( '4x', 'zuperla' ),
		'5x' => esc_html__( '5x', 'zuperla' ),
		'6x' => esc_html__( '6x', 'zuperla' ),
		'custom' => esc_html__( 'Custom', 'zuperla' ),
	);

	wp_nonce_field( 'zuperla_eutf_nonce_page_save', '_zuperla_eutf_nonce_page_save' );


	$zuperla_eutf_custom_title_options = get_post_meta( $post->ID, '_zuperla_eutf_custom_title_options', true );
	$zuperla_eutf_content_skin_options = get_post_meta( $post->ID, '_zuperla_eutf_content_skin_options', true );

	$zuperla_eutf_description = get_post_meta( $post->ID, '_zuperla_eutf_description', true );


	//Product Area
	$zuperla_eutf_area_colors = get_post_meta( $post->ID, '_zuperla_eutf_area_colors', true );
	$zuperla_eutf_area_section_type = get_post_meta( $post->ID, '_zuperla_eutf_area_section_type', true );
	$zuperla_eutf_area_padding_top_multiplier = get_post_meta( $post->ID, '_zuperla_eutf_area_padding_top_multiplier', true );
	$zuperla_eutf_area_padding_bottom_multiplier = get_post_meta( $post->ID, '_zuperla_eutf_area_padding_bottom_multiplier', true );
	$zuperla_eutf_area_image_id = get_post_meta( $post->ID, '_zuperla_eutf_area_image_id', true );


	//Layout Fields
	$zuperla_eutf_padding_top_multiplier = get_post_meta( $post->ID, '_zuperla_eutf_padding_top_multiplier', true );
	$zuperla_eutf_padding_bottom_multiplier = get_post_meta( $post->ID, '_zuperla_eutf_padding_bottom_multiplier', true );
	$zuperla_eutf_padding_top = get_post_meta( $post->ID, '_zuperla_eutf_padding_top', true );
	$zuperla_eutf_padding_bottom = get_post_meta( $post->ID, '_zuperla_eutf_padding_bottom', true );
	$zuperla_eutf_layout = get_post_meta( $post->ID, '_zuperla_eutf_layout', true );
	$zuperla_eutf_sidebar = get_post_meta( $post->ID, '_zuperla_eutf_sidebar', true );
	$zuperla_eutf_fixed_sidebar = get_post_meta( $post->ID, '_zuperla_eutf_fixed_sidebar', true );
	$zuperla_eutf_post_content_width = get_post_meta( $post->ID, '_zuperla_eutf_post_content_width', true ); //Post/Product/Event Only
	$zuperla_eutf_content_skin = get_post_meta( $post->ID, '_zuperla_eutf_content_skin', true );

	//Sliding Area
	$zuperla_eutf_sidearea_visibility = get_post_meta( $post->ID, '_zuperla_eutf_sidearea_visibility', true );
	$zuperla_eutf_sidearea_sidebar = get_post_meta( $post->ID, '_zuperla_eutf_sidearea_sidebar', true );

	//Scrolling Page
	$zuperla_eutf_scrolling_page = get_post_meta( $post->ID, '_zuperla_eutf_scrolling_page', true );
	$zuperla_eutf_responsive_scrolling = get_post_meta( $post->ID, '_zuperla_eutf_responsive_scrolling', true );
	$zuperla_eutf_scrolling_lock_anchors = get_post_meta( $post->ID, '_zuperla_eutf_scrolling_lock_anchors', true );
	$zuperla_eutf_scrolling_direction = get_post_meta( $post->ID, '_zuperla_eutf_scrolling_direction', true );
	$zuperla_eutf_scrolling_loop = get_post_meta( $post->ID, '_zuperla_eutf_scrolling_loop', true );
	$zuperla_eutf_scrolling_speed = get_post_meta( $post->ID, '_zuperla_eutf_scrolling_speed', true );

	//Header - Main Menu Fields
	$zuperla_eutf_header_overlapping = get_post_meta( $post->ID, '_zuperla_eutf_header_overlapping', true );
	$zuperla_eutf_header_style = get_post_meta( $post->ID, '_zuperla_eutf_header_style', true );
	$zuperla_eutf_main_navigation_menu = get_post_meta( $post->ID, '_zuperla_eutf_main_navigation_menu', true );
	$zuperla_eutf_responsive_navigation_menu = get_post_meta( $post->ID, '_zuperla_eutf_responsive_navigation_menu', true );
	$zuperla_eutf_sticky_header_type = get_post_meta( $post->ID, '_zuperla_eutf_sticky_header_type', true );
	$zuperla_eutf_menu_type = get_post_meta( $post->ID, '_zuperla_eutf_menu_type', true );
	$zuperla_eutf_responsive_header_overlapping = get_post_meta( $post->ID, '_zuperla_eutf_responsive_header_overlapping', true );

	//Extras
	$zuperla_eutf_details_title = get_post_meta( $post->ID, '_zuperla_eutf_details_title', true ); //Portfolio Only
	$zuperla_eutf_details = get_post_meta( $post->ID, '_zuperla_eutf_details', true ); //Portfolio Only

	$zuperla_eutf_details_link_text = get_post_meta( $post->ID, '_zuperla_eutf_details_link_text', true ); //Portfolio Only
	$zuperla_eutf_details_link_url = get_post_meta( $post->ID, '_zuperla_eutf_details_link_url', true ); //Portfolio Only
	$zuperla_eutf_details_link_new_window = get_post_meta( $post->ID, '_zuperla_eutf_details_link_new_window', true ); //Portfolio Only
	$zuperla_eutf_details_link_extra_class = get_post_meta( $post->ID, '_zuperla_eutf_details_link_extra_class', true ); //Portfolio Only
	$zuperla_eutf_social_bar_layout = get_post_meta( $post->ID, '_zuperla_eutf_social_bar_layout', true ); //Portfolio Only

	$zuperla_eutf_backlink_id = get_post_meta( $post->ID, '_zuperla_eutf_backlink_id', true ); //Portfolio. Post, Product

	$zuperla_eutf_anchor_navigation_menu = get_post_meta( $post->ID, '_zuperla_eutf_anchor_navigation_menu', true );
	$zuperla_eutf_theme_loader = get_post_meta( $post->ID, '_zuperla_eutf_theme_loader', true );

	//Visibility Fields
	$zuperla_eutf_disable_top_bar = get_post_meta( $post->ID, '_zuperla_eutf_disable_top_bar', true );
	$zuperla_eutf_disable_logo = get_post_meta( $post->ID, '_zuperla_eutf_disable_logo', true );
	$zuperla_eutf_disable_menu = get_post_meta( $post->ID, '_zuperla_eutf_disable_menu', true );
	$zuperla_eutf_disable_menu_items = get_post_meta( $post->ID, '_zuperla_eutf_disable_menu_items', true );
	$zuperla_eutf_disable_breadcrumbs = get_post_meta( $post->ID, '_zuperla_eutf_disable_breadcrumbs', true );
	$zuperla_eutf_disable_title = get_post_meta( $post->ID, '_zuperla_eutf_disable_title', true );
	$zuperla_eutf_disable_media = get_post_meta( $post->ID, '_zuperla_eutf_disable_media', true ); //Post Only
	$zuperla_eutf_disable_content = get_post_meta( $post->ID, '_zuperla_eutf_disable_content', true ); //Page Only
	$zuperla_eutf_disable_recent_entries = get_post_meta( $post->ID, '_zuperla_eutf_disable_recent_entries', true );//Portfolio Only
	$zuperla_eutf_disable_back_to_top = get_post_meta( $post->ID, '_zuperla_eutf_disable_back_to_top', true );

	$zuperla_eutf_bottom_bar_area = get_post_meta( $post->ID, '_zuperla_eutf_bottom_bar_area', true );
	$zuperla_eutf_footer_widgets_visibility = get_post_meta( $post->ID, '_zuperla_eutf_footer_widgets_visibility', true );
	$zuperla_eutf_footer_bar_visibility = get_post_meta( $post->ID, '_zuperla_eutf_footer_bar_visibility', true );

?>

	<!--  METABOXES -->
	<div class="eut-metabox-content">

		<!-- TABS -->
		<div class="eut-tabs">

			<ul class="eut-tab-links">
				<li class="active"><a href="#eut-page-option-tab-header"><?php esc_html_e( 'Header / Main Menu', 'zuperla' ); ?></a></li>
				<li><a href="#eut-page-option-tab-title"><?php esc_html_e( 'Title / Description', 'zuperla' ); ?></a></li>
				<?php if( 'product' == $post_type ) { ?>
				<li><a href="#eut-page-option-tab-section-area"><?php esc_html_e( 'Product Area', 'zuperla' ); ?></a></li>
				<?php } ?>
				<li><a href="#eut-page-option-tab-layout"><?php esc_html_e( 'Content / Sidebars', 'zuperla' ); ?></a></li>
				<li><a href="#eut-page-option-tab-sliding-area"><?php esc_html_e( 'Sliding Area', 'zuperla' ); ?></a></li>
				<?php if( 'page' == $post_type ) { ?>
				<li><a href="#eut-page-option-tab-scrolling-sections"><?php esc_html_e( 'Scrolling Sections', 'zuperla' ); ?></a></li>
				<?php } ?>
				<li><a href="#eut-page-option-tab-bottom-footer-areas"><?php esc_html_e( 'Bottom / Footer Areas', 'zuperla' ); ?></a></li>
				<li><a href="#eut-page-option-tab-extras"><?php esc_html_e( 'Extras', 'zuperla' ); ?></a></li>
				<li><a href="#eut-page-option-tab-visibility"><?php esc_html_e( 'Visibility', 'zuperla' ); ?></a></li>
			</ul>
			<div class="eut-tab-content">

				<div id="eut-page-option-tab-header" class="eut-tab-item active">
					<?php

						//Header Overlapping Option
						zuperla_eutf_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_zuperla_eutf_header_overlapping',
								'id' => '_zuperla_eutf_header_overlapping',
								'value' => $zuperla_eutf_header_overlapping,
								'options' => array(
									'' => esc_html__( '-- Inherit --', 'zuperla' ),
									'yes' => esc_html__( 'Yes', 'zuperla' ),
									'no' => esc_html__( 'No', 'zuperla' ),
								),
								'label' => array(
									"title" => esc_html__( 'Header Overlapping', 'zuperla' ),
									"desc" => esc_html__( 'Select if you want to overlap your page header', 'zuperla' ),
									"info" => $zuperla_eutf_theme_options_info,
								),
							)
						);

						//Header Style Option
						zuperla_eutf_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_zuperla_eutf_header_style',
								'id' => '_zuperla_eutf_header_style',
								'value' => $zuperla_eutf_header_style,
								'options' => array(
									'' => esc_html__( '-- Inherit --', 'zuperla' ),
									'default' => esc_html__( 'Default', 'zuperla' ),
									'dark' => esc_html__( 'Dark', 'zuperla' ),
									'light' => esc_html__( 'Light', 'zuperla' ),
								),
								'label' => array(
									"title" => esc_html__( 'Header Style', 'zuperla' ),
									"desc" => esc_html__( 'With this option you can change the coloring of your header. In case that you use Slider in Feature Section, select the header style per slide/image.', 'zuperla' ),
									"info" => $zuperla_eutf_theme_options_info,
								),
							)
						);

						//Main Navigation Menu Option
						zuperla_eutf_print_admin_option_wrapper_start(
							array(
								'type' => 'select',
								'label' => array(
									"title" => esc_html__( 'Main Navigation Menu', 'zuperla' ),
									"desc" => esc_html__( 'Select alternative main navigation menu.', 'zuperla' ),
									"info" => esc_html__( 'Inherit : Menus - Theme Locations - Header Menu.', 'zuperla' ),
								),
							)
						);
						zuperla_eutf_print_menu_selection( $zuperla_eutf_main_navigation_menu, 'eut-main-navigation-menu', '_zuperla_eutf_main_navigation_menu', 'default' );
						zuperla_eutf_print_admin_option_wrapper_end();

						//Responsive Navigation Menu Option
						zuperla_eutf_print_admin_option_wrapper_start(
							array(
								'type' => 'select',
								'label' => array(
									"title" => esc_html__( 'Responsive Navigation Menu', 'zuperla' ),
									"desc" => esc_html__( 'Select alternative responsive navigation menu.', 'zuperla' ),
									"info" => esc_html__( 'Inherit : Menus - Theme Locations - Responsive Menu.', 'zuperla' ),
								),
							)
						);
						zuperla_eutf_print_menu_selection( $zuperla_eutf_responsive_navigation_menu, 'eut-responsive-navigation-menu', '_zuperla_eutf_responsive_navigation_menu', 'default' );
						zuperla_eutf_print_admin_option_wrapper_end();

						//Menu Type
						zuperla_eutf_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_zuperla_eutf_menu_type',
								'id' => '_zuperla_eutf_menu_type',
								'value' => $zuperla_eutf_menu_type,
								'options' => array(
									'' => esc_html__( '-- Inherit --', 'zuperla' ),
									'classic' => esc_html__( 'Classic', 'zuperla' ),
									'button' => esc_html__( 'Button Style', 'zuperla' ),
									'underline' => esc_html__( 'Underline', 'zuperla' ),
									'hidden' => esc_html__( 'Hidden', 'zuperla' ),
									'advanced-hidden' => esc_html__( 'Advanced Hidden', 'zuperla' ),
								),
								'label' => array(
									"title" => esc_html__( 'Menu Type', 'zuperla' ),
									"desc" => esc_html__( 'With this option you can select the type of the menu ( Not available for Side Header Mode ).', 'zuperla' ),
									"info" => esc_html__( 'Inherit : Theme Options - Header Options.', 'zuperla' ),
								),
							)
						);

						//Sticky Header Type
						zuperla_eutf_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_zuperla_eutf_sticky_header_type',
								'id' => '_zuperla_eutf_sticky_header_type',
								'value' => $zuperla_eutf_sticky_header_type,
								'options' => array(
									'' => esc_html__( '-- Inherit --', 'zuperla' ),
									'none' => esc_html__( '-- None --', 'zuperla' ),
									'simple' => esc_html__( 'Simple', 'zuperla' ),
									'shrink' => esc_html__( 'Shrink', 'zuperla' ),
									'scrollup' => esc_html__( 'Scroll Up', 'zuperla' ),
								),
								'label' => array(
									"title" => esc_html__( 'Sticky Header Type', 'zuperla' ),
									"desc" => esc_html__( 'With this option you can select the type of sticky header.', 'zuperla' ),
									"info" => esc_html__( 'Inherit : Theme Options - Header Options - Sticky Header Options.', 'zuperla' ),
								),
							)
						);

						//Responsive Header Overlapping Option
						zuperla_eutf_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_zuperla_eutf_responsive_header_overlapping',
								'id' => '_zuperla_eutf_responsive_header_overlapping',
								'value' => $zuperla_eutf_responsive_header_overlapping,
								'options' => array(
									'' => esc_html__( '-- Inherit --', 'zuperla' ),
									'yes' => esc_html__( 'Yes', 'zuperla' ),
									'no' => esc_html__( 'No', 'zuperla' ),
								),
								'label' => array(
									"title" => esc_html__( 'Responsive Header Overlapping', 'zuperla' ),
									"desc" => esc_html__( 'Select if you want to overlap your responsive header', 'zuperla' ),
									"info" => esc_html__( 'Inherit : Theme Options - Header Options - Responsive Header Options.', 'zuperla' ),
								),
							)
						);
					?>
				</div>
				<div id="eut-page-option-tab-title" class="eut-tab-item">
					<?php

						echo '<div id="_zuperla_eutf_page_title">';

						zuperla_eutf_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_zuperla_eutf_disable_title',
								'id' => '_zuperla_eutf_disable_title',
								'value' => $zuperla_eutf_disable_title,
								'options' => array(
									'' => esc_html__( 'Visible', 'zuperla' ),
									'yes' => esc_html__( 'Hidden', 'zuperla' ),

								),
								'label' => array(
									"title" => esc_html__( 'Title/Description Visibility', 'zuperla' ),
									"desc" => esc_html__( 'Select if you want to hide your title and decription .', 'zuperla' ),
								),
								'group_id' => '_zuperla_eutf_page_title',
							)
						);
						if( 'tribe_events' != $post_type ) {
							//Description Option
							zuperla_eutf_print_admin_option(
								array(
									'type' => 'textarea',
									'name' => '_zuperla_eutf_description',
									'id' => '_zuperla_eutf_description',
									'value' => $zuperla_eutf_description,
									'label' => array(
										'title' => esc_html__( 'Description', 'zuperla' ),
										'desc' => $zuperla_eutf_desc_info,
									),
									'width' => 'fullwidth',
									'rows' => 2,
								)
							);
						}

						//Custom Title Option

						zuperla_eutf_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_zuperla_eutf_page_title_custom',
								'id' => '_zuperla_eutf_page_title_custom',
								'value' => zuperla_eutf_array_value( $zuperla_eutf_custom_title_options, 'custom' ),
								'options' => $zuperla_eutf_page_title_selection,
								'label' => array(
									"title" => esc_html__( 'Title Options', 'zuperla' ),
									"info" => $zuperla_eutf_theme_options_info,
								),
								'group_id' => '_zuperla_eutf_page_title',
								'highlight' => 'highlight',
								'dependency' =>
								'[
									{ "id" : "_zuperla_eutf_disable_title", "values" : [""] }
								]',
							)
						);



						global $zuperla_eutf_area_height;
						zuperla_eutf_print_admin_option(
							array(
								'type' => 'select',
								'options' => $zuperla_eutf_area_height,
								'name' => '_zuperla_eutf_page_title_height',
								'id' => '_zuperla_eutf_page_title_height',
								'value' => zuperla_eutf_array_value( $zuperla_eutf_custom_title_options, 'height', '40' ),
								'label' => array(
									"title" => esc_html__( 'Title Area Height', 'zuperla' ),
								),
								'dependency' =>
								'[
									{ "id" : "_zuperla_eutf_page_title_custom", "values" : ["custom"] },
									{ "id" : "_zuperla_eutf_disable_title", "values" : [""] }
								]',
							)
						);
						zuperla_eutf_print_admin_option(
							array(
								'type' => 'textfield',
								'name' => '_zuperla_eutf_page_title_min_height',
								'id' => '_zuperla_eutf_page_title_min_height',
								'value' => zuperla_eutf_array_value( $zuperla_eutf_custom_title_options, 'min_height', '200' ),
								'label' => array(
									"title" => esc_html__( 'Title Area Minimum Height in px', 'zuperla' ),
								),
								'dependency' =>
								'[
									{ "id" : "_zuperla_eutf_page_title_custom", "values" : ["custom"] },
									{ "id" : "_zuperla_eutf_disable_title", "values" : [""] }
								]',
							)
						);

						zuperla_eutf_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_zuperla_eutf_page_title_container_size',
								'id' => '_zuperla_eutf_page_title_container_size',
								'options' => array(
									'' => esc_html__( 'Default', 'zuperla' ),
									'large' => esc_html__( 'Large', 'zuperla' ),
								),
								'value' => zuperla_eutf_array_value( $zuperla_eutf_custom_title_options, 'container_size' ),
								'label' => array(
									"title" => esc_html__( 'Container Size', 'zuperla' ),
								),
								'dependency' =>
								'[
									{ "id" : "_zuperla_eutf_page_title_custom", "values" : ["custom"] },
									{ "id" : "_zuperla_eutf_disable_title", "values" : [""] }
								]',
							)
						);

						zuperla_eutf_print_admin_option(
							array(
								'type' => 'select-colorpicker',
								'name' => '_zuperla_eutf_page_title_bg_color',
								'id' => '_zuperla_eutf_page_title_bg_color',
								'value' => zuperla_eutf_array_value( $zuperla_eutf_custom_title_options, 'bg_color', 'dark' ),
								'value2' => zuperla_eutf_array_value( $zuperla_eutf_custom_title_options, 'bg_color_custom', '#000000' ),
								'default_value2' => '#000000',
								'label' => array(
									"title" => esc_html__( 'Background Color', 'zuperla' ),
								),
								'dependency' =>
								'[
									{ "id" : "_zuperla_eutf_page_title_custom", "values" : ["custom"] },
									{ "id" : "_zuperla_eutf_disable_title", "values" : [""] }
								]',
								'multiple' => 'multi',
								'type_usage' => 'section-bg',
							)
						);

						zuperla_eutf_print_admin_option(
							array(
								'type' => 'select-colorpicker',
								'name' => '_zuperla_eutf_page_title_content_bg_color',
								'id' => '_zuperla_eutf_page_title_content_bg_color',
								'value' => zuperla_eutf_array_value( $zuperla_eutf_custom_title_options, 'content_bg_color', 'none' ),
								'value2' => zuperla_eutf_array_value( $zuperla_eutf_custom_title_options, 'content_bg_color_custom', '#ffffff' ),
								'default_value2' => '#ffffff',
								'label' => array(
									"title" => esc_html__( 'Content Background Color', 'zuperla' ),
								),
								'dependency' =>
								'[
									{ "id" : "_zuperla_eutf_page_title_custom", "values" : ["custom"] },
									{ "id" : "_zuperla_eutf_disable_title", "values" : [""] }
								]',
								'multiple' => 'multi',
								'type_usage' => 'title-content-bg',
							)
						);

						if( 'post' == $post_type ) {
							zuperla_eutf_print_admin_option(
								array(
									'type' => 'select-colorpicker',
									'name' => '_zuperla_eutf_page_title_subheading_color',
									'id' => '_zuperla_eutf_page_title_subheading_color',
									'value' => zuperla_eutf_array_value( $zuperla_eutf_custom_title_options, 'subheading_color', 'light' ),
									'value2' => zuperla_eutf_array_value( $zuperla_eutf_custom_title_options, 'subheading_color_custom', '#ffffff' ),
									'default_value2' => '#ffffff',
									'label' => array(
										"title" => esc_html__( 'Categories/Meta Color', 'zuperla' ),
									),
									'dependency' =>
									'[
										{ "id" : "_zuperla_eutf_page_title_custom", "values" : ["custom"] },
										{ "id" : "_zuperla_eutf_disable_title", "values" : [""] }
									]',
									'multiple' => 'multi',
								)
							);
						}

						zuperla_eutf_print_admin_option(
							array(
								'type' => 'select-colorpicker',
								'name' => '_zuperla_eutf_page_title_title_color',
								'id' => '_zuperla_eutf_page_title_title_color',
								'value' => zuperla_eutf_array_value( $zuperla_eutf_custom_title_options, 'title_color', 'light' ),
								'value2' => zuperla_eutf_array_value( $zuperla_eutf_custom_title_options, 'title_color_custom', '#ffffff' ),
								'default_value2' => '#ffffff',
								'label' => array(
									"title" => esc_html__( 'Title Color', 'zuperla' ),
								),
								'dependency' =>
								'[
									{ "id" : "_zuperla_eutf_page_title_custom", "values" : ["custom"] },
									{ "id" : "_zuperla_eutf_disable_title", "values" : [""] }
								]',
								'multiple' => 'multi',
							)
						);

						zuperla_eutf_print_admin_option(
							array(
								'type' => 'select-colorpicker',
								'name' => '_zuperla_eutf_page_title_caption_color',
								'id' => '_zuperla_eutf_page_title_caption_color',
								'value' => zuperla_eutf_array_value( $zuperla_eutf_custom_title_options, 'caption_color', 'light' ),
								'value2' => zuperla_eutf_array_value( $zuperla_eutf_custom_title_options, 'caption_color_custom', '#ffffff' ),
								'default_value2' => '#ffffff',
								'label' => array(
									"title" => esc_html__( 'Description Color', 'zuperla' ),
								),
								'dependency' =>
								'[
									{ "id" : "_zuperla_eutf_page_title_custom", "values" : ["custom"] },
									{ "id" : "_zuperla_eutf_disable_title", "values" : [""] }
								]',
								'multiple' => 'multi',
							)
						);

						zuperla_eutf_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_zuperla_eutf_page_title_content_size',
								'id' => '_zuperla_eutf_page_title_content_size',
								'value' => zuperla_eutf_array_value( $zuperla_eutf_custom_title_options, 'content_size', 'large' ),
								'options' => array(
									'large' => esc_html__( 'Large', 'zuperla' ),
									'medium' => esc_html__( 'Medium', 'zuperla' ),
									'small' => esc_html__( 'Small', 'zuperla' ),
								),
								'label' => esc_html__( 'Content Size', 'zuperla' ),
								'dependency' =>
								'[
									{ "id" : "_zuperla_eutf_page_title_custom", "values" : ["custom"] },
									{ "id" : "_zuperla_eutf_disable_title", "values" : [""] }
								]',
							)
						);

						zuperla_eutf_print_admin_option(
							array(
								'type' => 'select-align',
								'name' => '_zuperla_eutf_page_title_content_alignment',
								'id' => '_zuperla_eutf_page_title_content_alignment',
								'value' => zuperla_eutf_array_value( $zuperla_eutf_custom_title_options, 'content_alignment', 'center' ),
								'label' => esc_html__( 'Content Alignment', 'zuperla' ),
								'dependency' =>
								'[
									{ "id" : "_zuperla_eutf_page_title_custom", "values" : ["custom"] },
									{ "id" : "_zuperla_eutf_disable_title", "values" : [""] }
								]',
							)
						);


						global $zuperla_eutf_media_bg_position_selection;
						zuperla_eutf_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_zuperla_eutf_page_title_content_position',
								'id' => '_zuperla_eutf_page_title_content_position',
								'value' => zuperla_eutf_array_value( $zuperla_eutf_custom_title_options, 'content_position', 'center-center' ),
								'options' => $zuperla_eutf_media_bg_position_selection,
								'label' => array(
									"title" => esc_html__( 'Content Position', 'zuperla' ),
								),
								'dependency' =>
								'[
									{ "id" : "_zuperla_eutf_page_title_custom", "values" : ["custom"] },
									{ "id" : "_zuperla_eutf_disable_title", "values" : [""] }
								]',
							)
						);

						zuperla_eutf_print_admin_option(
							array(
								'type' => 'select-text-animation',
								'name' => '_zuperla_eutf_page_title_content_animation',
								'value' => zuperla_eutf_array_value( $zuperla_eutf_custom_title_options, 'content_animation', 'fade-in' ),
								'label' => esc_html__( 'Content Animation', 'zuperla' ),
								'dependency' =>
								'[
									{ "id" : "_zuperla_eutf_page_title_custom", "values" : ["custom"] },
									{ "id" : "_zuperla_eutf_disable_title", "values" : [""] }
								]',
							)
						);


						zuperla_eutf_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_zuperla_eutf_page_title_bg_mode',
								'id' => '_zuperla_eutf_page_title_bg_mode',
								'value' => zuperla_eutf_array_value( $zuperla_eutf_custom_title_options, 'bg_mode'),
								'options' => array(
									'' => esc_html__( 'Color Only', 'zuperla' ),
									'featured' => esc_html__( 'Featured Image', 'zuperla' ),
									'custom' => esc_html__( 'Custom Image', 'zuperla' ),

								),
								'label' => array(
									"title" => esc_html__( 'Background Mode', 'zuperla' ),
								),
								'group_id' => '_zuperla_eutf_page_title',
								'dependency' =>
								'[
									{ "id" : "_zuperla_eutf_page_title_custom", "values" : ["custom"] },
									{ "id" : "_zuperla_eutf_disable_title", "values" : [""] }

								]',
							)
						);
						zuperla_eutf_print_admin_option(
							array(
								'type' => 'select-image',
								'name' => '_zuperla_eutf_page_title_bg_image_id',
								'id' => '_zuperla_eutf_page_title_bg_image_id',
								'value' => zuperla_eutf_array_value( $zuperla_eutf_custom_title_options, 'bg_image_id'),
								'label' => array(
									"title" => esc_html__( 'Background Image', 'zuperla' ),
								),
								'width' => 'fullwidth',
								'dependency' =>
								'[
									{ "id" : "_zuperla_eutf_page_title_custom", "values" : ["custom"] },
									{ "id" : "_zuperla_eutf_page_title_bg_mode", "values" : ["custom"] },
									{ "id" : "_zuperla_eutf_disable_title", "values" : [""] }

								]',
							)
						);
						zuperla_eutf_print_admin_option(
							array(
								'type' => 'select-bg-position',
								'name' => '_zuperla_eutf_page_title_bg_position',
								'id' => '_zuperla_eutf_page_title_bg_position',
								'value' => zuperla_eutf_array_value( $zuperla_eutf_custom_title_options, 'bg_position', 'center-center'),
								'label' => array(
									"title" => esc_html__( 'Background Position', 'zuperla' ),
								),
								'dependency' =>
								'[
									{ "id" : "_zuperla_eutf_page_title_custom", "values" : ["custom"] },
									{ "id" : "_zuperla_eutf_page_title_bg_mode", "values" : ["featured","custom"] },
									{ "id" : "_zuperla_eutf_disable_title", "values" : [""] }
								]',
							)
						);

						zuperla_eutf_print_admin_option(
							array(
								'type' => 'select-pattern-overlay',
								'name' => '_zuperla_eutf_page_title_pattern_overlay',
								'value' => zuperla_eutf_array_value( $zuperla_eutf_custom_title_options, 'pattern_overlay'),
								'label' => esc_html__( 'Pattern Overlay', 'zuperla' ),
								'dependency' =>
								'[
									{ "id" : "_zuperla_eutf_page_title_custom", "values" : ["custom"] },
									{ "id" : "_zuperla_eutf_page_title_bg_mode", "values" : ["featured","custom"] },
									{ "id" : "_zuperla_eutf_disable_title", "values" : [""] }
								]',
							)
						);
						zuperla_eutf_print_admin_option(
							array(
								'type' => 'select-colorpicker',
								'name' => '_zuperla_eutf_page_title_color_overlay',
								'value' => zuperla_eutf_array_value( $zuperla_eutf_custom_title_options, 'color_overlay', 'dark' ),
								'value2' => zuperla_eutf_array_value( $zuperla_eutf_custom_title_options, 'color_overlay_custom', '#000000' ),
								'default_value2' => '#000000',
								'label' => esc_html__( 'Color Overlay', 'zuperla' ),
								'multiple' => 'multi',
								'dependency' =>
								'[
									{ "id" : "_zuperla_eutf_page_title_custom", "values" : ["custom"] },
									{ "id" : "_zuperla_eutf_page_title_bg_mode", "values" : ["featured","custom"] },
									{ "id" : "_zuperla_eutf_disable_title", "values" : [""] }
								]',
							)
						);
						zuperla_eutf_print_admin_option(
							array(
								'type' => 'select-opacity',
								'name' => '_zuperla_eutf_page_title_opacity_overlay',
								'value' => zuperla_eutf_array_value( $zuperla_eutf_custom_title_options, 'opacity_overlay', '0' ),
								'label' => esc_html__( 'Opacity Overlay', 'zuperla' ),
								'dependency' =>
								'[
									{ "id" : "_zuperla_eutf_page_title_custom", "values" : ["custom"] },
									{ "id" : "_zuperla_eutf_page_title_bg_mode", "values" : ["featured","custom"] },
									{ "id" : "_zuperla_eutf_disable_title", "values" : [""] }
								]',
							)
						);

						echo '</div>';
					?>
				</div>

				<?php if( 'product' == $post_type ) { ?>
				<div id="eut-page-option-tab-section-area" class="eut-tab-item">
					<?php

						echo '<div id="_zuperla_eutf_page_section_area">';

						zuperla_eutf_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_zuperla_eutf_area_section_type',
								'id' => '_zuperla_eutf_area_section_type',
								'value' => $zuperla_eutf_area_section_type,
								'options' => array(
									'' => esc_html__( '-- Inherit --', 'zuperla' ),
									'fullwidth-background' => esc_html__( 'No', 'zuperla' ),
									'fullwidth-element' => esc_html__( 'Yes', 'zuperla' ),
								),
								'label' => array(
									'title' => esc_html__( 'Area Full Width', 'zuperla' ),
									'desc' => esc_html__( "Select if you prefer a full-width Area.", 'zuperla' ),
									"info" => $zuperla_eutf_theme_options_info,
								),
							)
						);
						zuperla_eutf_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_zuperla_eutf_area_padding_top_multiplier',
								'id' => '_zuperla_eutf_area_padding_top_multiplier',
								'value' => $zuperla_eutf_area_padding_top_multiplier,
								'options' => $zuperla_eutf_page_padding_selection,
								'label' => array(
									'title' => esc_html__( 'Top Padding', 'zuperla' ),
									'desc' => esc_html__( "Select the space above the area.", 'zuperla' ),
									"info" => $zuperla_eutf_theme_options_info,
								),
							)
						);
						zuperla_eutf_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_zuperla_eutf_area_padding_bottom_multiplier',
								'id' => '_zuperla_eutf_area_padding_bottom_multiplier',
								'value' => $zuperla_eutf_area_padding_bottom_multiplier,
								'options' => $zuperla_eutf_page_padding_selection,
								'label' => array(
									'title' => esc_html__( 'Bottom Padding', 'zuperla' ),
									'desc' => esc_html__( "Select the space below the area.", 'zuperla' ),
									"info" => $zuperla_eutf_theme_options_info,
								),
							)
						);

						zuperla_eutf_print_admin_option(
							array(
								'type' => 'select-image',
								'name' => '_zuperla_eutf_area_image_id',
								'id' => '_zuperla_eutf_area_image_id',
								'value' => $zuperla_eutf_area_image_id,
								'label' => array(
									"title" => esc_html__( 'Custom Image', 'zuperla' ),
									"desc" => esc_html__( 'If selected this image will replace the Feature Image of this area.', 'zuperla' ),
								),
								'width' => 'fullwidth',
							)
						);

						//Custom colors

						zuperla_eutf_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_zuperla_eutf_area_colors_custom',
								'id' => '_zuperla_eutf_area_colors_custom',
								'value' => zuperla_eutf_array_value( $zuperla_eutf_area_colors, 'custom' ),
								'options' => array(
									'' => esc_html__( '-- Inherit --', 'zuperla' ),
									'custom' => esc_html__( 'Custom', 'zuperla' ),
								),
								'label' => array(
									"title" => esc_html__( 'Area Color Options', 'zuperla' ),
									"info" => $zuperla_eutf_area_colors_info,
								),
								'group_id' => '_zuperla_eutf_page_section_area',
								'highlight' => 'highlight',
							)
						);

						zuperla_eutf_print_admin_option(
							array(
								'type' => 'colorpicker',
								'name' => '_zuperla_eutf_area_bg_color',
								'id' => '_zuperla_eutf_area_bg_color',
								'value' => zuperla_eutf_array_value( $zuperla_eutf_area_colors, 'bg_color', '#eeeeee' ),
								'default_value' => '#eeeeee',
								'label' => array(
									"title" => esc_html__( 'Background Color', 'zuperla' ),
								),
								'dependency' =>
								'[
									{ "id" : "_zuperla_eutf_area_colors_custom", "values" : ["custom"] }
								]',
							)
						);
						zuperla_eutf_print_admin_option(
							array(
								'type' => 'colorpicker',
								'name' => '_zuperla_eutf_area_headings_color',
								'id' => '_zuperla_eutf_area_headings_color',
								'value' => zuperla_eutf_array_value( $zuperla_eutf_area_colors, 'headings_color', '#000000' ),
								'default_value' => '#000000',
								'label' => array(
									"title" => esc_html__( 'Headings Color', 'zuperla' ),
								),
								'dependency' =>
								'[
									{ "id" : "_zuperla_eutf_area_colors_custom", "values" : ["custom"] }
								]',
							)
						);
						zuperla_eutf_print_admin_option(
							array(
								'type' => 'colorpicker',
								'name' => '_zuperla_eutf_area_font_color',
								'id' => '_zuperla_eutf_area_font_color',
								'value' => zuperla_eutf_array_value( $zuperla_eutf_area_colors, 'font_color', '#999999' ),
								'default_value' => '#999999',
								'label' => array(
									"title" => esc_html__( 'Font Color', 'zuperla' ),
								),
								'dependency' =>
								'[
									{ "id" : "_zuperla_eutf_area_colors_custom", "values" : ["custom"] }
								]',
							)
						);
						zuperla_eutf_print_admin_option(
							array(
								'type' => 'colorpicker',
								'name' => '_zuperla_eutf_area_link_color',
								'id' => '_zuperla_eutf_area_link_color',
								'value' => zuperla_eutf_array_value( $zuperla_eutf_area_colors, 'link_color', '#FF7D88' ),
								'default_value' => '#FF7D88',
								'label' => array(
									"title" => esc_html__( 'Link Color', 'zuperla' ),
								),
								'dependency' =>
								'[
									{ "id" : "_zuperla_eutf_area_colors_custom", "values" : ["custom"] }
								]',
							)
						);
						zuperla_eutf_print_admin_option(
							array(
								'type' => 'colorpicker',
								'name' => '_zuperla_eutf_area_hover_color',
								'id' => '_zuperla_eutf_area_hover_color',
								'value' => zuperla_eutf_array_value( $zuperla_eutf_area_colors, 'hover_color', '#000000' ),
								'default_value' => '#000000',
								'label' => array(
									"title" => esc_html__( 'Hover Color', 'zuperla' ),
								),
								'dependency' =>
								'[
									{ "id" : "_zuperla_eutf_area_colors_custom", "values" : ["custom"] }
								]',
							)
						);
						zuperla_eutf_print_admin_option(
							array(
								'type' => 'colorpicker',
								'name' => '_zuperla_eutf_area_border_color',
								'id' => '_zuperla_eutf_area_border_color',
								'value' => zuperla_eutf_array_value( $zuperla_eutf_area_colors, 'border_color', '#e0e0e0' ),
								'default_value' => '#e0e0e0',
								'label' => array(
									"title" => esc_html__( 'Border Color', 'zuperla' ),
								),
								'dependency' =>
								'[
									{ "id" : "_zuperla_eutf_area_colors_custom", "values" : ["custom"] }
								]',
							)
						);
						zuperla_eutf_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_zuperla_eutf_area_button_color',
								'id' => '_zuperla_eutf_area_button_color',
								'value' => zuperla_eutf_array_value( $zuperla_eutf_area_colors, 'button_color', 'primary-1' ),
								'options' => $zuperla_eutf_button_color_selection,
								'label' => array(
									"title" => esc_html__( 'Button Color', 'zuperla' ),
								),
								'dependency' =>
								'[
									{ "id" : "_zuperla_eutf_area_colors_custom", "values" : ["custom"] }
								]',
							)
						);
						zuperla_eutf_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_zuperla_eutf_button_hover_color',
								'id' => '_zuperla_eutf_button_hover_color',
								'value' => zuperla_eutf_array_value( $zuperla_eutf_area_colors, 'button_hover_color', 'black' ),
								'options' => $zuperla_eutf_button_color_selection,
								'label' => array(
									"title" => esc_html__( 'Button HoverColor', 'zuperla' ),
								),
								'dependency' =>
								'[
									{ "id" : "_zuperla_eutf_area_colors_custom", "values" : ["custom"] }
								]',
							)
						);

						echo '</div>';
					?>
				</div>
				<?php } ?>

				<div id="eut-page-option-tab-layout" class="eut-tab-item">
					<?php

						echo '<div id="_zuperla_eutf_page_padding">';

						zuperla_eutf_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_zuperla_eutf_padding_top_multiplier',
								'id' => '_zuperla_eutf_padding_top_multiplier',
								'value' => $zuperla_eutf_padding_top_multiplier,
								'options' => $zuperla_eutf_page_padding_selection_extra,
								'label' => array(
									'title' => esc_html__( 'Top Padding', 'zuperla' ),
									'desc' => esc_html__( "Select the space above the content area.", 'zuperla' ),
									"info" => $zuperla_eutf_theme_options_info,
								),
								'group_id' => '_zuperla_eutf_page_padding',
							)
						);
						zuperla_eutf_print_admin_option(
							array(
								'type' => 'textfield',
								'name' => '_zuperla_eutf_padding_top',
								'id' => '_zuperla_eutf_padding_top',
								'value' => $zuperla_eutf_padding_top,
								'label' => array(
									'title' => esc_html__( 'Custom Top Padding', 'zuperla' ),
									'desc' => esc_html__( "You can use px, em, %, etc. or enter just number and it will use pixels.", 'zuperla' ),
								),
								'dependency' =>
								'[
									{ "id" : "_zuperla_eutf_padding_top_multiplier", "values" : ["custom"] }
								]',
							)
						);
						zuperla_eutf_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_zuperla_eutf_padding_bottom_multiplier',
								'id' => '_zuperla_eutf_padding_bottom_multiplier',
								'value' => $zuperla_eutf_padding_bottom_multiplier,
								'options' => $zuperla_eutf_page_padding_selection_extra,
								'label' => array(
									'title' => esc_html__( 'Bottom Padding', 'zuperla' ),
									'desc' => esc_html__( "Select the space below the content area.", 'zuperla' ),
									"info" => $zuperla_eutf_theme_options_info,
								),
								'group_id' => '_zuperla_eutf_page_padding',
							)
						);
						zuperla_eutf_print_admin_option(
							array(
								'type' => 'textfield',
								'name' => '_zuperla_eutf_padding_bottom',
								'id' => '_zuperla_eutf_padding_bottom',
								'value' => $zuperla_eutf_padding_bottom,
								'label' => array(
									'title' => esc_html__( 'Custom Bottom Padding', 'zuperla' ),
									'desc' => esc_html__( "You can use px, em, %, etc. or enter just number and it will use pixels.", 'zuperla' ),
								),
								'dependency' =>
								'[
									{ "id" : "_zuperla_eutf_padding_bottom_multiplier", "values" : ["custom"] }
								]',
							)
						);

						echo '</div>';


						//Layout Option
						zuperla_eutf_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_zuperla_eutf_layout',
								'id' => '_zuperla_eutf_layout',
								'value' => $zuperla_eutf_layout,
								'options' => array(
									'' => esc_html__( '-- Inherit --', 'zuperla' ),
									'none' => esc_html__( 'Full Width', 'zuperla' ),
									'left' => esc_html__( 'Left Sidebar', 'zuperla' ),
									'right' => esc_html__( 'Right Sidebar', 'zuperla' ),
								),
								'label' => array(
									"title" => esc_html__( 'Layout', 'zuperla' ),
									"desc" => esc_html__( 'Select page content and sidebar alignment.', 'zuperla' ),
									"info" => $zuperla_eutf_theme_options_info,
								),
							)
						);

						//Sidebar Option
						zuperla_eutf_print_admin_option_wrapper_start(
							array(
								'type' => 'select',
								'label' => array(
									"title" => esc_html__( 'Sidebar', 'zuperla' ),
									"desc" => esc_html__( 'Select page sidebar.', 'zuperla' ),
									"info" => $zuperla_eutf_theme_options_info,
								),
							)
						);
						zuperla_eutf_print_sidebar_selection( $zuperla_eutf_sidebar, '_zuperla_eutf_sidebar', '_zuperla_eutf_sidebar' );
						zuperla_eutf_print_admin_option_wrapper_end();

						//Fixed Sidebar Option
						zuperla_eutf_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_zuperla_eutf_fixed_sidebar',
								'id' => '_zuperla_eutf_fixed_sidebar',
								'value' => $zuperla_eutf_fixed_sidebar,
								'options' => array(
									'' => esc_html__( '-- Inherit --', 'zuperla' ),
									'no' => esc_html__( 'No', 'zuperla' ),
									'yes' => esc_html__( 'Yes', 'zuperla' ),
								),
								'label' => array(
									"title" => esc_html__( 'Fixed Sidebar', 'zuperla' ),
									"desc" => esc_html__( 'If selected, sidebar will be fixed.', 'zuperla' ),
								),
							)
						);



						//Posts Content Width
						if ( 'post' == $post_type || 'product' == $post_type || 'tribe_events' == $post_type  ) {

							zuperla_eutf_print_admin_option(
								array(
									'type' => 'select',
									'name' => '_zuperla_eutf_post_content_width',
									'id' => '_zuperla_eutf_post_content_width',
									'value' => $zuperla_eutf_post_content_width,
									'options' => array(
										'' => esc_html__( '-- Inherit --', 'zuperla' ),
										'container' => esc_html__( 'Container Size' , 'zuperla' ),
										'large' => esc_html__( 'Large' , 'zuperla' ),
										'medium' => esc_html__( 'Medium' , 'zuperla' ),
										'small' => esc_html__( 'Small' , 'zuperla' ),
									),
									'label' => array(
										"title" => esc_html__( 'Content Width', 'zuperla' ),
										"desc" => esc_html__( 'Select the Content Width (only for Full Width Layout)', 'zuperla' ),
										"info" => $zuperla_eutf_theme_options_info,
									),
								)
							);
						}

						//Background Options
						echo '<div id="_zuperla_eutf_content_skin_options">';

						zuperla_eutf_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_zuperla_eutf_content_skin',
								'id' => '_zuperla_eutf_content_skin',
								'value' => zuperla_eutf_array_value( $zuperla_eutf_content_skin_options, 'skin' ),
								'options' => array(
									'' => esc_html__( '-- Inherit --', 'zuperla' ),
									'dark' => esc_html__( 'Dark' , 'zuperla' ),
									'light' => esc_html__( 'Light' , 'zuperla' ),
									'custom' => esc_html__( 'Custom', 'zuperla' ),
								),
								'label' => array(
									"title" => esc_html__( 'Content Skin', 'zuperla' ),
									"info" => esc_html__( 'Inherit :Background from Theme Options - General Settings, Colors from Appearance > Customize > Colors - Main Content.', 'zuperla' ),
								),
								'group_id' => '_zuperla_eutf_content_skin_options',
								'highlight' => 'highlight',
							)
						);

						zuperla_eutf_print_admin_option(
							array(
								'type' => 'colorpicker',
								'name' => '_zuperla_eutf_content_text_color',
								'id' => '_zuperla_eutf_content_text_color',
								'value' => zuperla_eutf_array_value( $zuperla_eutf_content_skin_options, 'text_color', "#888888" ),
								'label' => array(
									"title" => esc_html__( 'Color', 'zuperla' ),
								),
								'default_value' => '#888888',
								'dependency' =>
								'[
									{ "id" : "_zuperla_eutf_content_skin", "values" : ["custom"] }
								]',
							)
						);
						zuperla_eutf_print_admin_option(
							array(
								'type' => 'colorpicker',
								'name' => '_zuperla_eutf_content_heading_color',
								'id' => '_zuperla_eutf_content_heading_color',
								'value' => zuperla_eutf_array_value( $zuperla_eutf_content_skin_options, 'heading_color','#000000' ),
								'label' => array(
									"title" => esc_html__( 'Heading Color', 'zuperla' ),
								),
								'default_value' => '#000000',
								'dependency' =>
								'[
									{ "id" : "_zuperla_eutf_content_skin", "values" : ["custom"] }
								]',
							)
						);

						zuperla_eutf_print_admin_option(
							array(
								'type' => 'colorpicker',
								'name' => '_zuperla_eutf_content_bg_color',
								'id' => '_zuperla_eutf_content_bg_color',
								'value' => zuperla_eutf_array_value( $zuperla_eutf_content_skin_options, 'background-color', '#ffffff' ),
								'label' => array(
									"title" => esc_html__( 'Background Color', 'zuperla' ),
								),
								'default_value' => '#ffffff',
								'dependency' =>
								'[
									{ "id" : "_zuperla_eutf_content_skin", "values" : ["custom"] }
								]',
							)
						);

						zuperla_eutf_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_zuperla_eutf_content_bg_repeat',
								'id' => '_zuperla_eutf_content_bg_repeat',
								'value' => zuperla_eutf_array_value( $zuperla_eutf_content_skin_options, 'background-repeat' ),
								'options' => array(
									'' => esc_html__( '-- Not selected --', 'zuperla' ),
									'no-repeat' => 'No Repeat',
									'repeat'    => 'Repeat All',
									'repeat-x'  => 'Repeat Horizontally',
									'repeat-y'  => 'Repeat Vertically',
									'inherit'   => 'Inherit',
								),
								'label' => esc_html__( 'Background Repeat', 'zuperla' ),
								'dependency' =>
								'[
									{ "id" : "_zuperla_eutf_content_skin", "values" : ["custom"] }
								]',
							)
						);

						zuperla_eutf_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_zuperla_eutf_content_bg_size',
								'id' => '_zuperla_eutf_content_bg_size',
								'value' => zuperla_eutf_array_value( $zuperla_eutf_content_skin_options, 'background-size' ),
								'options' => array(
									'' => esc_html__( '-- Not selected --', 'zuperla' ),
									'inherit' => 'Inherit',
									'cover'   => 'Cover',
									'contain' => 'Contain',
								),
								'label' => esc_html__( 'Background Size', 'zuperla' ),
								'dependency' =>
								'[
									{ "id" : "_zuperla_eutf_content_skin", "values" : ["custom"] }
								]',
							)
						);

						zuperla_eutf_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_zuperla_eutf_content_bg_attachment',
								'id' => '_zuperla_eutf_content_bg_attachment',
								'value' => zuperla_eutf_array_value( $zuperla_eutf_content_skin_options, 'background-attachment' ),
								'options' => array(
									'' => esc_html__( '-- Not selected --', 'zuperla' ),
									'fixed'   => 'Fixed',
									'scroll'  => 'Scroll',
									'inherit' => 'Inherit',
								),
								'label' => esc_html__( 'Background Attachment', 'zuperla' ),
								'dependency' =>
								'[
									{ "id" : "_zuperla_eutf_content_skin", "values" : ["custom"] }
								]',
							)
						);

						zuperla_eutf_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_zuperla_eutf_content_bg_position',
								'id' => '_zuperla_eutf_content_bg_position',
								'value' => zuperla_eutf_array_value( $zuperla_eutf_content_skin_options, 'background-position' ),
								'options' => array(
									'' => esc_html__( '-- Not selected --', 'zuperla' ),
									'left top'      => 'Left Top',
									'left center'   => 'Left center',
									'left bottom'   => 'Left Bottom',
									'center top'    => 'Center Top',
									'center center' => 'Center Center',
									'center bottom' => 'Center Bottom',
									'right top'     => 'Right Top',
									'right center'  => 'Right center',
									'right bottom'  => 'Right Bottom',
								),
								'label' => esc_html__( 'Background Position', 'zuperla' ),
								'dependency' =>
								'[
									{ "id" : "_zuperla_eutf_content_skin", "values" : ["custom"] }
								]',
							)
						);

						zuperla_eutf_print_admin_option(
							array(
								'type' => 'select-bg-image',
								'name' => '_zuperla_eutf_content_bg_image',
								'id' => '_zuperla_eutf_content_bg_image',
								'value' => zuperla_eutf_array_value( $zuperla_eutf_content_skin_options, 'background-image' ),
								'label' => esc_html__( 'Background Image', 'zuperla' ),
								'width' => 'fullwidth',
								'dependency' =>
								'[
									{ "id" : "_zuperla_eutf_content_skin", "values" : ["custom"] }
								]',
							)
						);

						echo '</div>';



					?>
				</div>
				<div id="eut-page-option-tab-sliding-area" class="eut-tab-item">
					<?php
						//Sidearea Visibility
						zuperla_eutf_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_zuperla_eutf_sidearea_visibility',
								'id' => '_zuperla_eutf_sidearea_visibility',
								'value' => $zuperla_eutf_sidearea_visibility,
								'options' => array(
									'' => esc_html__( '-- Inherit --', 'zuperla' ),
									'no' => esc_html__( 'No', 'zuperla' ),
									'yes' => esc_html__( 'Yes', 'zuperla' ),
								),
								'label' => array(
									"title" => esc_html__( 'Sliding Area Visibility', 'zuperla' ),
									"info" => $zuperla_eutf_theme_options_info,
								),
							)
						);

						//Sidearea Sidebar Option
						zuperla_eutf_print_admin_option_wrapper_start(
							array(
								'type' => 'select',
								'label' => array(
									"title" => esc_html__( 'Sliding Area Sidebar', 'zuperla' ),
									"desc" => esc_html__( 'Select sliding area sidebar.', 'zuperla' ),
									"info" => $zuperla_eutf_theme_options_info,
								),
							)
						);
						zuperla_eutf_print_sidebar_selection( $zuperla_eutf_sidearea_sidebar, '_zuperla_eutf_sidearea_sidebar', '_zuperla_eutf_sidearea_sidebar' );
						zuperla_eutf_print_admin_option_wrapper_end();
					?>
				</div>
				<div id="eut-page-option-tab-bottom-footer-areas" class="eut-tab-item">
					<?php
						//Bottom / Footer Areas Visibility

						zuperla_eutf_print_admin_option_wrapper_start(
							array(
								'type' => 'select',
								'label' => array(
									"title" => esc_html__( 'Bottom Bar Area', 'zuperla' ),
									"desc" => esc_html__( 'Select an area item for your Bottom Bar Area.', 'zuperla' ),
									"info" => esc_html__( 'Inherit : Theme Options - Bottom / Footer Areas - Bottom Bar Area Item.', 'zuperla' ),
								),
							)
						);
						zuperla_eutf_print_area_selection( $zuperla_eutf_bottom_bar_area, 'eut-bottom-bar-area-item', '_zuperla_eutf_bottom_bar_area' );
						zuperla_eutf_print_admin_option_wrapper_end();

						zuperla_eutf_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_zuperla_eutf_footer_widgets_visibility',
								'id' => '_zuperla_eutf_footer_widgets_visibility',
								'value' => $zuperla_eutf_footer_widgets_visibility,
								'options' => array(
									'' => esc_html__( '-- Inherit --', 'zuperla' ),
									'no' => esc_html__( 'No', 'zuperla' ),
									'yes' => esc_html__( 'Yes', 'zuperla' ),
								),
								'label' => array(
									"title" => esc_html__( 'Footer Widgets Visibility', 'zuperla' ),
									"desc" => esc_html__( 'Inherit : Theme Options - Bottom / Footer Areas - Footer Widgets Settings.', 'zuperla' ),
								),
							)
						);

						zuperla_eutf_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_zuperla_eutf_footer_bar_visibility',
								'id' => '_zuperla_eutf_footer_bar_visibility',
								'value' => $zuperla_eutf_footer_bar_visibility,
								'options' => array(
									'' => esc_html__( '-- Inherit --', 'zuperla' ),
									'no' => esc_html__( 'No', 'zuperla' ),
									'yes' => esc_html__( 'Yes', 'zuperla' ),
								),
								'label' => array(
									"title" => esc_html__( 'Footer Bar Visibility', 'zuperla' ),
									"desc" => esc_html__( 'Inherit : Theme Options - Bottom / Footer Areas - Footer Bar Settings.', 'zuperla' ),
								),
							)
						);
					?>
				</div>
				<div id="eut-page-option-tab-extras" class="eut-tab-item">
					<?php

						//Details Option
						if ( 'portfolio' == $post_type) {
							zuperla_eutf_print_admin_option(
								array(
									'type' => 'textfield',
									'name' => '_zuperla_eutf_details_title',
									'id' => '_zuperla_eutf_details_title',
									'value' => $zuperla_eutf_details_title,
									'label' => array(
										'title' => esc_html__( 'Details Title', 'zuperla' ),
										'desc' => esc_html__( 'Enter your details title.', 'zuperla' ),
										'info' => $zuperla_eutf_theme_options_info_text_empty,
									),
									'width' => 'fullwidth',
								)
							);
							zuperla_eutf_print_admin_option(
								array(
									'type' => 'textarea',
									'name' => '_zuperla_eutf_details',
									'id' => '_zuperla_eutf_details',
									'value' => $zuperla_eutf_details,
									'label' => array(
										'title' => esc_html__( 'Details Area', 'zuperla' ),
										'desc' => esc_html__( 'Enter your details area.', 'zuperla' ),
									),
									'width' => 'fullwidth',
								)
							);

							zuperla_eutf_print_admin_option(
								array(
									'type' => 'textfield',
									'name' => '_zuperla_eutf_details_link_text',
									'id' => '_zuperla_eutf_details_link_text',
									'value' => $zuperla_eutf_details_link_text,
									'label' => array(
										'title' => esc_html__( 'Link Text', 'zuperla' ),
										'desc' => esc_html__( 'Enter your details link text.', 'zuperla' ),
										'info' => $zuperla_eutf_theme_options_info_text_empty,
									),
									'width' => 'fullwidth',
								)
							);
							zuperla_eutf_print_admin_option(
								array(
									'type' => 'textfield',
									'name' => '_zuperla_eutf_details_link_url',
									'value' => $zuperla_eutf_details_link_url,
									'label' => array(
										'title' => esc_html__( 'Link URL', 'zuperla' ),
										'desc' => esc_html__( 'Enter the full URL of your link.', 'zuperla' ),
									),
									'width' => 'fullwidth',
								)
							);
							zuperla_eutf_print_admin_option(
								array(
									'type' => 'checkbox',
									'name' => '_zuperla_eutf_details_link_new_window',
									'value' => $zuperla_eutf_details_link_new_window,
									'label' => array(
										'title' => esc_html__( 'Open Link in new window', 'zuperla' ),
										'desc' => esc_html__( 'If selected, link will open in a new window.', 'zuperla' ),
									),
								)
							);
							zuperla_eutf_print_admin_option(
								array(
									'type' => 'textfield',
									'name' => '_zuperla_eutf_details_link_extra_class',
									'value' => $zuperla_eutf_details_link_extra_class,
									'label' => array(
										'title' => esc_html__( 'Link extra class name', 'zuperla' ),
									),
								)
							);
							zuperla_eutf_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_zuperla_eutf_social_bar_layout',
								'id' => '_zuperla_eutf_social_bar_layout',
								'value' => $zuperla_eutf_social_bar_layout,
								'options' => array(
									'' => esc_html__( '-- Inherit --', 'zuperla' ),
									'layout-1' => esc_html__( 'Bottom Layout', 'zuperla' ),
									'layout-2' => esc_html__( 'Side Layout', 'zuperla' ),
								),
								'label' => array(
									"title" => esc_html__( 'Social Layout', 'zuperla' ),
									"desc" => esc_html__( 'Select your social layout.', 'zuperla' ),
									"info" => $zuperla_eutf_theme_options_info,
								),
							)
						);

						}

						if ( 'post' == $post_type || 'portfolio' == $post_type || 'product' == $post_type ) {
							//Backlink page
							zuperla_eutf_print_admin_option_wrapper_start(
								array(
									'type' => 'select',
									'label' => array(
										"title" => esc_html__( 'Backlink', 'zuperla' ),
										"desc" => esc_html__( 'Select your backlink page.', 'zuperla' ),
										"info" => $zuperla_eutf_theme_options_info,
									),
								)
							);
							zuperla_eutf_print_page_selection( $zuperla_eutf_backlink_id, 'eut-backlink-id', '_zuperla_eutf_backlink_id' );
							zuperla_eutf_print_admin_option_wrapper_end();
						}

						//Anchor Navigation Menu Option

						zuperla_eutf_print_admin_option_wrapper_start(
							array(
								'type' => 'select',
								'label' => array(
									"title" => esc_html__( 'Anchor Navigation Menu', 'zuperla' ),
									"desc" => esc_html__( 'Select page anchor navigation menu.', 'zuperla' ),
								),
							)
						);
						zuperla_eutf_print_menu_selection( $zuperla_eutf_anchor_navigation_menu, 'eut-page-navigation-menu', '_zuperla_eutf_anchor_navigation_menu' );
						zuperla_eutf_print_admin_option_wrapper_end();

						//Theme Loader
						zuperla_eutf_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_zuperla_eutf_theme_loader',
								'id' => '_zuperla_eutf_theme_loader',
								'value' => $zuperla_eutf_theme_loader,
								'options' => array(
									'' => esc_html__( '-- Inherit --', 'zuperla' ),
									'no' => esc_html__( 'No', 'zuperla' ),
									'yes' => esc_html__( 'Yes', 'zuperla' ),
								),
								'label' => array(
									"title" => esc_html__( 'Theme Loader Visibility', 'zuperla' ),
									"info" => esc_html__( 'Inherit : Theme Options - General Settings.', 'zuperla' ),
								),
							)
						);
					?>
				</div>
				<div id="eut-page-option-tab-scrolling-sections" class="eut-tab-item">
					<?php

						//Responsive Scrolling Option
						if ( 'page' == $post_type) {

							echo '<div id="_zuperla_eutf_page_scrolling_section">';

							zuperla_eutf_print_admin_option(
								array(
									'type' => 'select',
									'name' => '_zuperla_eutf_scrolling_page',
									'id' => '_zuperla_eutf_scrolling_page',
									'value' => $zuperla_eutf_scrolling_page,
									'options' => array(
										'' => esc_html__( 'Full Page', 'zuperla' ),
										'pilling' => esc_html__( 'Page Pilling', 'zuperla' ),
									),
									'label' => array(
										'title' => esc_html__( 'Scrolling Sections Plugin', 'zuperla' ),
										'desc' => esc_html__( 'Select the scrolling sections plugin you want to use.', 'zuperla' ),
										'info' => esc_html__( 'Note: The following options are available only for Scrolling Full Screen Sections Template.', 'zuperla' ),
									),
									'highlight' => 'highlight',
									'group_id' => '_zuperla_eutf_page_scrolling_section',
								)
							);
							zuperla_eutf_print_admin_option(
								array(
									'type' => 'select',
									'name' => '_zuperla_eutf_scrolling_lock_anchors',
									'id' => '_zuperla_eutf_scrolling_lock_anchors',
									'value' => $zuperla_eutf_scrolling_lock_anchors,
									'options' => array(
										'' => esc_html__( 'URL without /#', 'zuperla' ),
										'no' => esc_html__( 'Allow Anchor Links in URL', 'zuperla' ),
									),
									'label' => array(
										'title' => esc_html__( 'Anchor Links', 'zuperla' ),
										'desc' => esc_html__( 'Select if you want to allow anchor links.', 'zuperla' ),
									),
								)
							);
							zuperla_eutf_print_admin_option(
								array(
									'type' => 'select',
									'name' => '_zuperla_eutf_scrolling_loop',
									'id' => '_zuperla_eutf_scrolling_loop',
									'value' => $zuperla_eutf_scrolling_loop,
									'options' => array(
										'' => esc_html__( 'None', 'zuperla' ),
										'top' => esc_html__( 'Loop Top', 'zuperla' ),
										'bottom' => esc_html__( 'Loop Bottom', 'zuperla' ),
										'both' => esc_html__( 'Loop Top/Bottom', 'zuperla' ),
									),
									'label' => array(
										'title' => esc_html__( 'Loop', 'zuperla' ),
										'desc' => esc_html__( 'Select if you want to loop.', 'zuperla' ),
									),
								)
							);
							zuperla_eutf_print_admin_option(
								array(
									'type' => 'select',
									'name' => '_zuperla_eutf_scrolling_direction',
									'id' => '_zuperla_eutf_scrolling_direction',
									'value' => $zuperla_eutf_scrolling_direction,
									'options' => array(
										'' => esc_html__( 'Vertical', 'zuperla' ),
										'horizontal' => esc_html__( 'Horizontal', 'zuperla' ),
									),
									'label' => array(
										'title' => esc_html__( 'Direction', 'zuperla' ),
										'desc' => esc_html__( 'Select scrolling direction.', 'zuperla' ),
									),
									'dependency' =>
									'[
										{ "id" : "_zuperla_eutf_scrolling_page", "values" : ["pilling"] }
									]',
								)
							);
							zuperla_eutf_print_admin_option(
								array(
									'type' => 'textfield',
									'name' => '_zuperla_eutf_scrolling_speed',
									'id' => '_zuperla_eutf_scrolling_speed',
									'value' => $zuperla_eutf_scrolling_speed,
									'label' => array(
										'title' => esc_html__( 'Speed (ms)', 'zuperla' ),
										'desc' => esc_html__( 'Enter scrolling speed.', 'zuperla' ),
									),
									'default_value' => '1000',

								)
							);
							zuperla_eutf_print_admin_option(
								array(
									'type' => 'select',
									'name' => '_zuperla_eutf_responsive_scrolling',
									'id' => '_zuperla_eutf_responsive_scrolling',
									'value' => $zuperla_eutf_responsive_scrolling,
									'options' => array(
										'' => esc_html__( 'Yes', 'zuperla' ),
										'no' => esc_html__( 'No', 'zuperla' ),
									),
									'label' => array(
										'title' => esc_html__( 'Responsive Scrolling Full Sections', 'zuperla' ),
										'desc' => esc_html__( 'Select if you want to maintain the scrolling feature on devices.', 'zuperla' ),
									),
								)
							);

							echo '</div>';
						}

					?>
				</div>
				<div id="eut-page-option-tab-visibility" class="eut-tab-item">
					<?php

						zuperla_eutf_print_admin_option(
							array(
								'type' => 'checkbox',
								'name' => '_zuperla_eutf_disable_top_bar',
								'id' => '_zuperla_eutf_disable_top_bar',
								'value' => $zuperla_eutf_disable_top_bar,
								'label' => array(
									"title" => esc_html__( 'Disable Top Bar', 'zuperla' ),
									"desc" => esc_html__( 'If selected, top bar will be hidden.', 'zuperla' ),
								),
							)
						);

						zuperla_eutf_print_admin_option(
							array(
								'type' => 'checkbox',
								'name' => '_zuperla_eutf_disable_logo',
								'id' => '_zuperla_eutf_disable_logo',
								'value' => $zuperla_eutf_disable_logo,
								'label' => array(
									"title" => esc_html__( 'Disable Logo', 'zuperla' ),
									"desc" => esc_html__( 'If selected, logo will be disabled.', 'zuperla' ),
								),
							)
						);
						zuperla_eutf_print_admin_option(
							array(
								'type' => 'checkbox',
								'name' => '_zuperla_eutf_disable_menu',
								'id' => '_zuperla_eutf_disable_menu',
								'value' => $zuperla_eutf_disable_menu,
								'label' => array(
									"title" => esc_html__( 'Disable Main Menu', 'zuperla' ),
									"desc" => esc_html__( 'If selected, main menu will be hidden.', 'zuperla' ),
								),
							)
						);

						zuperla_eutf_print_admin_option(
							array(
								'type' => 'checkbox',
								'name' => '_zuperla_eutf_disable_menu_item_search',
								'id' => '_zuperla_eutf_disable_menu_item_search',
								'value' => zuperla_eutf_array_value( $zuperla_eutf_disable_menu_items, 'search'),
								'label' => array(
									"title" => esc_html__( 'Disable Main Menu Item Search', 'zuperla' ),
									"desc" => esc_html__( 'If selected, main menu item will be hidden.', 'zuperla' ),
								),
							)
						);
						zuperla_eutf_print_admin_option(
							array(
								'type' => 'checkbox',
								'name' => '_zuperla_eutf_disable_menu_item_form',
								'id' => '_zuperla_eutf_disable_menu_item_form',
								'value' => zuperla_eutf_array_value( $zuperla_eutf_disable_menu_items, 'form'),
								'label' => array(
									"title" => esc_html__( 'Disable Main Menu Item Contact Form', 'zuperla' ),
									"desc" => esc_html__( 'If selected, main menu item will be hidden.', 'zuperla' ),
								),
							)
						);
						zuperla_eutf_print_admin_option(
							array(
								'type' => 'checkbox',
								'name' => '_zuperla_eutf_disable_menu_item_language',
								'id' => '_zuperla_eutf_disable_menu_item_language',
								'value' => zuperla_eutf_array_value( $zuperla_eutf_disable_menu_items, 'language'),
								'label' => array(
									"title" => esc_html__( 'Disable Main Menu Item Language Selector', 'zuperla' ),
									"desc" => esc_html__( 'If selected, main menu item will be hidden.', 'zuperla' ),
								),
							)
						);
						zuperla_eutf_print_admin_option(
							array(
								'type' => 'checkbox',
								'name' => '_zuperla_eutf_disable_menu_item_cart',
								'id' => '_zuperla_eutf_disable_menu_item_cart',
								'value' => zuperla_eutf_array_value( $zuperla_eutf_disable_menu_items, 'cart'),
								'label' => array(
									"title" => esc_html__( 'Disable Main Menu Item Shopping Cart', 'zuperla' ),
									"desc" => esc_html__( 'If selected, main menu item will be hidden.', 'zuperla' ),
								),
							)
						);
						// zuperla_eutf_print_admin_option(
							// array(
								// 'type' => 'checkbox',
								// 'name' => '_zuperla_eutf_disable_menu_item_login',
								// 'id' => '_zuperla_eutf_disable_menu_item_login',
								// 'value' => zuperla_eutf_array_value( $zuperla_eutf_disable_menu_items, 'login'),
								// 'label' => array(
									// "title" => esc_html__( 'Disable Main Menu Item Login', 'zuperla' ),
									// "desc" => esc_html__( 'If selected, main menu item will be hidden.', 'zuperla' ),
								// ),
							// )
						// );
						zuperla_eutf_print_admin_option(
							array(
								'type' => 'checkbox',
								'name' => '_zuperla_eutf_disable_menu_item_social',
								'id' => '_zuperla_eutf_disable_menu_item_social',
								'value' => zuperla_eutf_array_value( $zuperla_eutf_disable_menu_items, 'social'),
								'label' => array(
									"title" => esc_html__( 'Disable Main Menu Item Social Icons', 'zuperla' ),
									"desc" => esc_html__( 'If selected, main menu item will be hidden.', 'zuperla' ),
								),
							)
						);

						zuperla_eutf_print_admin_option(
							array(
								'type' => 'checkbox',
								'name' => '_zuperla_eutf_disable_breadcrumbs',
								'id' => '_zuperla_eutf_disable_breadcrumbs',
								'value' => $zuperla_eutf_disable_breadcrumbs,
								'label' => array(
									"title" => esc_html__( 'Disable Breadcrumbs', 'zuperla' ),
									"desc" => esc_html__( 'If selected, breadcrumbs items will be hidden.', 'zuperla' ),
								),
							)
						);

						if ( 'page' == $post_type ) {
							if ( zuperla_eutf_woocommerce_enabled() && $post->ID == wc_get_page_id( 'shop' ) ) {
								//Skip
							} else {
								zuperla_eutf_print_admin_option(
									array(
										'type' => 'checkbox',
										'name' => '_zuperla_eutf_disable_content',
										'id' => '_zuperla_eutf_disable_content',
										'value' => $zuperla_eutf_disable_content,
										'label' => array(
											"title" => esc_html__( 'Disable Content Area', 'zuperla' ),
											"desc" => esc_html__( 'If selected, content area will be hidden (including sidebar and comments).', 'zuperla' ),
										),
									)
								);
							}
						}

						if ( 'post' == $post_type ) {
							zuperla_eutf_print_admin_option(
								array(
									'type' => 'checkbox',
									'name' => '_zuperla_eutf_disable_media',
									'id' => '_zuperla_eutf_disable_media',
									'value' => $zuperla_eutf_disable_media,
									'label' => array(
										"title" => esc_html__( 'Disable Media Area', 'zuperla' ),
										"desc" => esc_html__( 'If selected, media area will be hidden.', 'zuperla' ),
									),
								)
							);
						}
						if ( 'portfolio' == $post_type ) {
							zuperla_eutf_print_admin_option(
								array(
									'type' => 'checkbox',
									'name' => '_zuperla_eutf_disable_recent_entries',
									'id' => '_zuperla_eutf_disable_recent_entries',
									'value' => $zuperla_eutf_disable_recent_entries,
									'label' => array(
										"title" => esc_html__( 'Disable Recent Entries', 'zuperla' ),
										"desc" => esc_html__( 'If selected, recent entries area will be hidden.', 'zuperla' ),
									),
								)
							);
						}

						zuperla_eutf_print_admin_option(
							array(
								'type' => 'checkbox',
								'name' => '_zuperla_eutf_disable_back_to_top',
								'id' => '_zuperla_eutf_disable_back_to_top',
								'value' => $zuperla_eutf_disable_back_to_top,
								'label' => array(
									"title" => esc_html__( 'Disable Back to Top', 'zuperla' ),
									"desc" => esc_html__( 'If selected, Back to Top button will be hidden.', 'zuperla' ),
								),
							)
						);

					?>
				</div>
			</div>
		</div>
	</div>

<?php
}

function zuperla_eutf_page_feature_section_box( $post ) {

	wp_nonce_field( 'zuperla_eutf_nonce_feature_save', '_zuperla_eutf_nonce_feature_save' );

	$post_id = $post->ID;
	zuperla_eutf_admin_get_feature_section( $post_id );

}

function zuperla_eutf_generic_options_save_postdata( $post_id , $post ) {

	if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
		return;
	}

	if ( isset( $_POST['_zuperla_eutf_nonce_feature_save'] ) && wp_verify_nonce( $_POST['_zuperla_eutf_nonce_feature_save'], 'zuperla_eutf_nonce_feature_save' ) ) {

		if ( zuperla_eutf_check_permissions( $post_id ) ) {
			zuperla_eutf_admin_save_feature_section( $post_id );
		}

	}

	if ( isset( $_POST['_zuperla_eutf_nonce_page_save'] ) && wp_verify_nonce( $_POST['_zuperla_eutf_nonce_page_save'], 'zuperla_eutf_nonce_page_save' ) ) {

		if ( zuperla_eutf_check_permissions( $post_id ) ) {

			$zuperla_eutf_page_options = array (
				array(
					'name' => 'Description',
					'id' => '_zuperla_eutf_description',
					'html' => true,
				),
				array(
					'name' => 'Details Title',
					'id' => '_zuperla_eutf_details_title',
					'html' => true,
				),
				array(
					'name' => 'Details',
					'id' => '_zuperla_eutf_details',
					'html' => true,
				),
				array(
					'name' => 'Details Link Text',
					'id' => '_zuperla_eutf_details_link_text',
					'html' => true,
				),
				array(
					'name' => 'Details Link URL',
					'id' => '_zuperla_eutf_details_link_url',
				),
				array(
					'name' => 'Details Link New Window',
					'id' => '_zuperla_eutf_details_link_new_window',
				),
				array(
					'name' => 'Details Link Extra Class',
					'id' => '_zuperla_eutf_details_link_extra_class',
				),
				array(
					'name' => 'Social Bar Layout',
					'id' => '_zuperla_eutf_social_bar_layout',
				),

				array(
					'name' => 'Backlink',
					'id' => '_zuperla_eutf_backlink_id',
				),
				array(
					'name' => 'Area Section Type',
					'id' => '_zuperla_eutf_area_section_type',
				),
				array(
					'name' => 'Area Top Padding Multiplier',
					'id' => '_zuperla_eutf_area_padding_top_multiplier',
				),
				array(
					'name' => 'Area Bottom Padding Multiplier',
					'id' => '_zuperla_eutf_area_padding_bottom_multiplier',
				),
				array(
					'name' => 'Area Image ID',
					'id' => '_zuperla_eutf_area_image_id',
				),
				array(
					'name' => 'Top Padding',
					'id' => '_zuperla_eutf_padding_top_multiplier',
				),
				array(
					'name' => 'Bottom Padding',
					'id' => '_zuperla_eutf_padding_bottom_multiplier',
				),
				array(
					'name' => 'Custom Top Padding',
					'id' => '_zuperla_eutf_padding_top',
				),
				array(
					'name' => 'Custom Bottom Padding',
					'id' => '_zuperla_eutf_padding_bottom',
				),
				array(
					'name' => 'Layout',
					'id' => '_zuperla_eutf_layout',
				),
				array(
					'name' => 'Sidebar',
					'id' => '_zuperla_eutf_sidebar',
				),
				array(
					'name' => 'Post Content width',
					'id' => '_zuperla_eutf_post_content_width',
				),
				array(
					'name' => 'Content Skin',
					'id' => '_zuperla_eutf_content_skin',
				),
				array(
					'name' => 'Sidearea Area Visibility',
					'id' => '_zuperla_eutf_sidearea_visibility',
				),
				array(
					'name' => 'Sidearea Sidebar',
					'id' => '_zuperla_eutf_sidearea_sidebar',
				),
				array(
					'name' => 'Fixed Sidebar',
					'id' => '_zuperla_eutf_fixed_sidebar',
				),
				array(
					'name' => 'Header Overlapping',
					'id' => '_zuperla_eutf_header_overlapping',
				),
				array(
					'name' => 'Header Style',
					'id' => '_zuperla_eutf_header_style',
				),
				array(
					'name' => 'Navigation Anchor Menu',
					'id' => '_zuperla_eutf_anchor_navigation_menu',
				),
				array(
					'name' => 'Theme Loader',
					'id' => '_zuperla_eutf_theme_loader',
				),
				array(
					'name' => 'Scrolling Page',
					'id' => '_zuperla_eutf_scrolling_page',
				),
				array(
					'name' => 'Responsive Scrolling',
					'id' => '_zuperla_eutf_responsive_scrolling',
				),
				array(
					'name' => 'Scrolling Lock Anchors',
					'id' => '_zuperla_eutf_scrolling_lock_anchors',
				),
				array(
					'name' => 'Scrolling Direction',
					'id' => '_zuperla_eutf_scrolling_direction',
				),
				array(
					'name' => 'Scrolling Loop',
					'id' => '_zuperla_eutf_scrolling_loop',
				),
				array(
					'name' => 'Scrolling Speed',
					'id' => '_zuperla_eutf_scrolling_speed',
				),
				array(
					'name' => 'Main Navigation Menu',
					'id' => '_zuperla_eutf_main_navigation_menu',
				),
				array(
					'name' => 'Responsive Navigation Menu',
					'id' => '_zuperla_eutf_responsive_navigation_menu',
				),
				array(
					'name' => 'Menu Type',
					'id' => '_zuperla_eutf_menu_type',
				),
				array(
					'name' => 'Responsive Header Overlapping',
					'id' => '_zuperla_eutf_responsive_header_overlapping',
				),
				array(
					'name' => 'Sticky Header Type',
					'id' => '_zuperla_eutf_sticky_header_type',
				),
				array(
					'name' => 'Bottom Bar',
					'id' => '_zuperla_eutf_bottom_bar_area',
				),
				array(
					'name' => 'Footer Widgets',
					'id' => '_zuperla_eutf_footer_widgets_visibility',
				),
				array(
					'name' => 'Footer Bar',
					'id' => '_zuperla_eutf_footer_bar_visibility',
				),
				array(
					'name' => 'Disable Top Bar',
					'id' => '_zuperla_eutf_disable_top_bar',
				),
				array(
					'name' => 'Disable Logo',
					'id' => '_zuperla_eutf_disable_logo',
				),
				array(
					'name' => 'Disable Menu',
					'id' => '_zuperla_eutf_disable_menu',
				),
				array(
					'name' => 'Disable Menu Items',
					'id' => '_zuperla_eutf_disable_menu_items',
				),
				array(
					'name' => 'disable Breadcrumbs',
					'id' => '_zuperla_eutf_disable_breadcrumbs',
				),
				array(
					'name' => 'Disable Title',
					'id' => '_zuperla_eutf_disable_title',
				),
				array(
					'name' => 'Disable Media',
					'id' => '_zuperla_eutf_disable_media',
				),
				array(
					'name' => 'Disable Content',
					'id' => '_zuperla_eutf_disable_content',
				),
				array(
					'name' => 'Disable Recent Entries',
					'id' => '_zuperla_eutf_disable_recent_entries',
				),
				array(
					'name' => 'Disable Back to Top',
					'id' => '_zuperla_eutf_disable_back_to_top',
				),
			);

			$zuperla_eutf_disable_menu_items_options = array (
				array(
					'param_id' => 'search',
					'id' => '_zuperla_eutf_disable_menu_item_search',
					'default' => '',
				),
				array(
					'param_id' => 'form',
					'id' => '_zuperla_eutf_disable_menu_item_form',
					'default' => '',
				),
				array(
					'param_id' => 'language',
					'id' => '_zuperla_eutf_disable_menu_item_language',
					'default' => '',
				),
				array(
					'param_id' => 'cart',
					'id' => '_zuperla_eutf_disable_menu_item_cart',
					'default' => '',
				),
				array(
					'param_id' => 'social',
					'id' => '_zuperla_eutf_disable_menu_item_social',
					'default' => '',
				),
			);

			//Title Options
			$zuperla_eutf_page_title_options = array (
				array(
					'param_id' => 'custom',
					'id' => '_zuperla_eutf_page_title_custom',
					'default' => '',
				),
				array(
					'param_id' => 'height',
					'id' => '_zuperla_eutf_page_title_height',
					'default' => '40',
				),
				array(
					'param_id' => 'min_height',
					'id' => '_zuperla_eutf_page_title_min_height',
					'default' => '200',
				),
				array(
					'param_id' => 'bg_color',
					'id' => '_zuperla_eutf_page_title_bg_color',
					'default' => 'light',
				),
				array(
					'param_id' => 'bg_color_custom',
					'id' => '_zuperla_eutf_page_title_bg_color_custom',
					'default' => '#ffffff',
				),
				array(
					'param_id' => 'subheading_color',
					'id' => '_zuperla_eutf_page_title_subheading_color',
					'default' => 'light',
				),
				array(
					'param_id' => 'subheading_color_custom',
					'id' => '_zuperla_eutf_page_title_subheading_color_custom',
					'default' => '#ffffff',
				),
				array(
					'param_id' => 'title_color',
					'id' => '_zuperla_eutf_page_title_title_color',
					'default' => 'dark',
				),
				array(
					'param_id' => 'title_color_custom',
					'id' => '_zuperla_eutf_page_title_title_color_custom',
					'default' => '#000000',
				),
				array(
					'param_id' => 'caption_color',
					'id' => '_zuperla_eutf_page_title_caption_color',
					'default' => 'dark',
				),
				array(
					'param_id' => 'caption_color_custom',
					'id' => '_zuperla_eutf_page_title_caption_color_custom',
					'default' => '#000000',
				),
				array(
					'param_id' => 'content_bg_color',
					'id' => '_zuperla_eutf_page_title_content_bg_color',
					'default' => 'none',
				),
				array(
					'param_id' => 'content_bg_color_custom',
					'id' => '_zuperla_eutf_page_title_content_bg_color_custom',
					'default' => '#000000',
				),
				array(
					'param_id' => 'container_size',
					'id' => '_zuperla_eutf_page_title_container_size',
					'default' => '',
				),
				array(
					'param_id' => 'content_size',
					'id' => '_zuperla_eutf_page_title_content_size',
					'default' => 'large',
				),
				array(
					'param_id' => 'content_alignment',
					'id' => '_zuperla_eutf_page_title_content_alignment',
					'default' => 'center',
				),
				array(
					'param_id' => 'content_position',
					'id' => '_zuperla_eutf_page_title_content_position',
					'default' => 'center-center',
				),
				array(
					'param_id' => 'content_animation',
					'id' => '_zuperla_eutf_page_title_content_animation',
					'default' => 'fade-in',
				),
				array(
					'param_id' => 'bg_mode',
					'id' => '_zuperla_eutf_page_title_bg_mode',
					'default' => '',
				),
				array(
					'param_id' => 'bg_image_id',
					'id' => '_zuperla_eutf_page_title_bg_image_id',
					'default' => '0',
				),
				array(
					'param_id' => 'bg_position',
					'id' => '_zuperla_eutf_page_title_bg_position',
					'default' => 'center-center',
				),
				array(
					'param_id' => 'pattern_overlay',
					'id' => '_zuperla_eutf_page_title_pattern_overlay',
					'default' => '',
				),
				array(
					'param_id' => 'color_overlay',
					'id' => '_zuperla_eutf_page_title_color_overlay',
					'default' => 'dark',
				),
				array(
					'param_id' => 'color_overlay_custom',
					'id' => '_zuperla_eutf_page_title_color_overlay_custom',
					'default' => '#000000',
				),
				array(
					'param_id' => 'opacity_overlay',
					'id' => '_zuperla_eutf_page_title_opacity_overlay',
					'default' => '0',
				),
			);

			//Content Background Options
			$zuperla_eutf_content_skin_options = array (
				array(
					'param_id' => 'skin',
					'id' => '_zuperla_eutf_content_skin',
					'default' => '',
				),
				array(
					'param_id' => 'text_color',
					'id' => '_zuperla_eutf_content_text_color',
					'default' => '#888888',
				),
				array(
					'param_id' => 'heading_color',
					'id' => '_zuperla_eutf_content_heading_color',
					'default' => '#000000',
				),
				array(
					'param_id' => 'background-color',
					'id' => '_zuperla_eutf_content_bg_color',
					'default' => '#ffffff',
				),
				array(
					'param_id' => 'background-repeat',
					'id' => '_zuperla_eutf_content_bg_repeat',
					'default' => '',
				),
				array(
					'param_id' => 'background-size',
					'id' => '_zuperla_eutf_content_bg_size',
					'default' => '',
				),
				array(
					'param_id' => 'background-attachment',
					'id' => '_zuperla_eutf_content_bg_attachment',
					'default' => '',
				),
				array(
					'param_id' => 'background-position',
					'id' => '_zuperla_eutf_content_bg_position',
					'default' => '',
				),
				array(
					'param_id' => 'background-image',
					'id' => '_zuperla_eutf_content_bg_image',
					'default' => '',
				),
			);

			//Area Colors
			$zuperla_eutf_area_colors = array (
				array(
					'param_id' => 'custom',
					'id' => '_zuperla_eutf_area_colors_custom',
					'default' => '',
				),
				array(
					'param_id'    => 'bg_color',
					'id'          => '_zuperla_eutf_area_bg_color',
					'default'     => '#eeeeee',
				),
				array(
					'param_id'    => 'headings_color',
					'id'          => '_zuperla_eutf_area_headings_color',
					'default'     => '#000000',
				),
				array(
					'param_id'    => 'font_color',
					'id'          => '_zuperla_eutf_area_font_color',
					'default'     => '#999999',
				),
				array(
					'param_id'    => 'link_color',
					'id'          => '_zuperla_eutf_area_link_color',
					'default'     => '#FF7D88',
				),
				array(
					'param_id'    => 'hover_color',
					'id'          => '_zuperla_eutf_area_hover_color',
					'default'     => '#000000',
				),
				array(
					'param_id'    => 'border_color',
					'id'          => '_zuperla_eutf_area_border_color',
					'default'     => '#e0e0e0',
				),
				array(
					'param_id'    => 'button_color',
					'id'          =>'_zuperla_eutf_area_button_color',
					'default'     => 'primary-1',
				),
				array(
					'param_id'    => 'button_hover_color',
					'id'          =>'_zuperla_eutf_button_hover_color',
					'default'     => 'black',
				),
			);

			//Update Single custom fields
			foreach ( $zuperla_eutf_page_options as $value ) {
				$allow_html = ( isset( $value['html'] ) ? $value['html'] : false );
				if( $allow_html ) {
					$new_meta_value = ( isset( $_POST[$value['id']] ) ? wp_filter_post_kses( $_POST[$value['id']] ) : '' );
				} else {
					$new_meta_value = ( isset( $_POST[$value['id']] ) ? sanitize_text_field( $_POST[$value['id']] ) : '' );
				}
				$meta_key = $value['id'];


				$meta_value = get_post_meta( $post_id, $meta_key, true );

				if ( '' != $new_meta_value  && '' == $meta_value ) {
					if ( !add_post_meta( $post_id, $meta_key, $new_meta_value, true ) ) {
						update_post_meta( $post_id, $meta_key, $new_meta_value );
					}
				} elseif ( '' != $new_meta_value && $new_meta_value != $meta_value ) {
					update_post_meta( $post_id, $meta_key, $new_meta_value );
				} elseif ( '' == $new_meta_value && '' != $meta_value ) {
					delete_post_meta( $post_id, $meta_key );
				}
			}

			//Update Menu Items Visibility array
			zuperla_eutf_update_meta_array( $post_id, '_zuperla_eutf_disable_menu_items', $zuperla_eutf_disable_menu_items_options );
			//Update Title Options array
			zuperla_eutf_update_meta_array( $post_id, '_zuperla_eutf_custom_title_options', $zuperla_eutf_page_title_options );
			//Update Content Background array
			zuperla_eutf_update_meta_array( $post_id, '_zuperla_eutf_content_skin_options', $zuperla_eutf_content_skin_options );
			//Update Area Colors array
			zuperla_eutf_update_meta_array( $post_id, '_zuperla_eutf_area_colors', $zuperla_eutf_area_colors );
		}
	}

}

/**
 * Function update meta array
 */
function zuperla_eutf_update_meta_array( $post_id, $param_id, $param_array_options ) {

	$array_options = array();

	if( !empty( $param_array_options ) ) {

		foreach ( $param_array_options as $value ) {

			$meta_key = $value['param_id'];
			$meta_default = $value['default'];

			$allow_html = ( isset( $value['html'] ) ? $value['html'] : false );
			if( $allow_html ) {
				$new_meta_value = ( isset( $_POST[$value['id']] ) ? wp_filter_post_kses( $_POST[$value['id']] ) : $meta_default );
			} else {
				$new_meta_value = ( isset( $_POST[$value['id']] ) ? sanitize_text_field( $_POST[$value['id']] ) : $meta_default );
			}

			if( !empty( $new_meta_value ) ) {
				$array_options[$meta_key] = $new_meta_value;
			}
		}

	}

	if( !empty( $array_options ) ) {
		update_post_meta( $post_id, $param_id, $array_options );
	} else {
		delete_post_meta( $post_id, $param_id );
	}
}

/**
 * Function to check post type permissions
 */

function zuperla_eutf_check_permissions( $post_id ) {

	if ( 'post' == $_POST['post_type'] ) {
		if ( !current_user_can( 'edit_post', $post_id ) ) {
			return false;
		}
	} else {
		if ( !current_user_can( 'edit_page', $post_id ) ) {
			return false;
		}
	}
	return true;
}

/**
 * Function to print menu selector
 */
function zuperla_eutf_print_menu_selection( $menu_id, $id, $name, $default = 'none' ) {

	?>
	<select id="<?php echo esc_attr( $id ); ?>" name="<?php echo esc_attr( $name ); ?>">
		<option value="" <?php selected( '', $menu_id ); ?>>
			<?php
				if ( 'none' == $default ){
					esc_html_e( 'None', 'zuperla' );
				} else {
					esc_html_e( '-- Inherit --', 'zuperla' );
				}
			?>
		</option>
	<?php
		$menus = wp_get_nav_menus();
		if ( ! empty( $menus ) ) {
			foreach ( $menus as $item ) {
	?>
				<option value="<?php echo esc_attr( $item->term_id ); ?>" <?php selected( $item->term_id, $menu_id ); ?>>
					<?php echo esc_html( $item->name ); ?>
				</option>
	<?php
			}
		}
	?>
	</select>
	<?php
}

/**
 * Function to print layout selector
 */
function zuperla_eutf_print_layout_selection( $layout, $id, $name ) {

	$layouts = array(
		'' => esc_html__( '-- Inherit --', 'zuperla' ),
		'none' => esc_html__( 'Full Width', 'zuperla' ),
		'left' => esc_html__( 'Left Sidebar', 'zuperla' ),
		'right' => esc_html__( 'Right Sidebar', 'zuperla' ),
	);

	?>
	<select id="<?php echo esc_attr( $id ); ?>" name="<?php echo esc_attr( $name ); ?>">
	<?php
		foreach ( $layouts as $key => $value ) {
			if ( $value ) {
	?>
				<option value="<?php echo esc_attr( $key ); ?>" <?php selected( $key, $layout ); ?>><?php echo esc_html( $value ); ?></option>
	<?php
			}
		}
	?>
	</select>
	<?php
}

/**
 * Function to print sidebar selector
 */
function zuperla_eutf_print_sidebar_selection( $sidebar, $id, $name ) {
	global $wp_registered_sidebars;

	?>
	<select id="<?php echo esc_attr( $id ); ?>" name="<?php echo esc_attr( $name ); ?>">
		<option value="" <?php selected( '', $sidebar ); ?>><?php echo esc_html__( '-- Inherit --', 'zuperla' ); ?></option>
	<?php
	foreach ( $wp_registered_sidebars as $key => $value ) {
		?>
		<option value="<?php echo esc_attr( $key ); ?>" <?php selected( $key, $sidebar ); ?>><?php echo esc_html( $value['name'] ); ?></option>
		<?php
	}
	?>
	</select>
	<?php
}

/**
 * Function to print page selector
 */
function zuperla_eutf_print_page_selection( $page_id, $id, $name ) {

?>
	<select id="<?php echo esc_attr( $id ); ?>" name="<?php echo esc_attr( $name ); ?>">
		<option value="" <?php selected( '', $page_id ); ?>>
			<?php esc_html_e( '-- Inherit --', 'zuperla' ); ?>
		</option>
<?php
		$pages = get_pages();
		foreach ( $pages as $page ) {
?>
			<option value="<?php echo esc_attr( $page->ID ); ?>" <?php selected( $page->ID, $page_id ); ?>>
				<?php echo esc_html( $page->post_title ); ?>
			</option>
<?php
		}
?>
	</select>
<?php

}


/**
 * Function to print page selector
 */
function zuperla_eutf_print_area_selection( $area_id, $id, $name ) {

?>
	<select id="<?php echo esc_attr( $id ); ?>" name="<?php echo esc_attr( $name ); ?>">
		<option value="" <?php selected( '', $area_id ); ?>>
			<?php esc_html_e( '-- Inherit --', 'zuperla' ); ?>
		</option>
		<option value="none" <?php selected( 'none', $area_id ); ?>>
			<?php esc_html_e( '-- None --', 'zuperla' ); ?>
		</option>
<?php
		$args = array( 'post_type' => 'area-item', 'numberposts' => -1 );
		$posts = get_posts( $args );
		if ( ! empty ( $posts ) ) {
			foreach ( $posts as $post ) {
?>
			<option value="<?php echo esc_attr( $post->ID ); ?>" <?php selected( $post->ID, $area_id ); ?>>
				<?php echo esc_html( $post->post_title ); ?>
			</option>
<?php
			}
		}
		wp_reset_postdata();
?>
	</select>
<?php

}

//Omit closing PHP tag to avoid accidental whitespace output errors.
