<?php
/*
*	'zuperla' Category Meta
*
* 	@author		Euthemians Team
* 	@URI		http://euthemians.com
*/

	//Categories
	add_action('category_edit_form_fields','zuperla_eutf_category_edit_form_fields', 10);
	add_action('post_tag_edit_form_fields','zuperla_eutf_category_edit_form_fields', 10);
	add_action('product_cat_edit_form_fields','zuperla_eutf_category_edit_form_fields', 10);
	add_action('product_tag_edit_form_fields','zuperla_eutf_category_edit_form_fields', 10);
	add_action('edit_term','zuperla_eutf_save_category_fields', 10, 3);

	function zuperla_eutf_category_edit_form_fields( $term ) {
		$zuperla_eutf_term_meta = zuperla_eutf_get_term_meta( $term->term_id, '_zuperla_eutf_custom_title_options' );
		zuperla_eutf_print_category_fields( $zuperla_eutf_term_meta );
	}

	function zuperla_eutf_print_category_fields( $zuperla_eutf_custom_title_options = array() ) {
?>
		<tr class="form-field">
			<td colspan="2">
				<div id="eut-category-title" class="postbox">
<?php

			//Custom Title Option
			zuperla_eutf_print_admin_option(
				array(
					'type' => 'select',
					'name' => 'zuperla_eutf_term_meta[custom]',
					'id' => 'eut-category-title-custom',
					'value' => zuperla_eutf_array_value( $zuperla_eutf_custom_title_options, 'custom' ),
					'options' => array(
						'' => esc_html__( '-- Inherit --', 'zuperla' ),
						'custom' => esc_html__( 'Custom', 'zuperla' ),

					),
					'label' => array(
						"title" => esc_html__( 'Title Options', 'zuperla' ),
					),
					'group_id' => 'eut-category-title',
					'highlight' => 'highlight',
				)
			);

			global $zuperla_eutf_area_height;
			zuperla_eutf_print_admin_option(
				array(
					'type' => 'select',
					'options' => $zuperla_eutf_area_height,
					'name' => 'zuperla_eutf_term_meta[height]',
					'id' => 'eut-category-title-height',
					'value' => zuperla_eutf_array_value( $zuperla_eutf_custom_title_options, 'height', '40' ),
					'label' => array(
						"title" => esc_html__( 'Title Area Height', 'zuperla' ),
					),
					'dependency' =>
					'[
						{ "id" : "eut-category-title-custom", "values" : ["custom"] }
					]',
				)
			);
			zuperla_eutf_print_admin_option(
				array(
					'type' => 'textfield',
					'name' => 'zuperla_eutf_term_meta[min_height]',
					'id' => 'eut-category-title-min-height',
					'value' => zuperla_eutf_array_value( $zuperla_eutf_custom_title_options, 'min_height', '200' ),
					'label' => array(
						"title" => esc_html__( 'Title Area Minimum Height in px', 'zuperla' ),
					),
					'dependency' =>
					'[
						{ "id" : "eut-category-title-custom", "values" : ["custom"] }
					]',
				)
			);

			zuperla_eutf_print_admin_option(
				array(
					'type' => 'select',
					'name' => 'zuperla_eutf_term_meta[container_size]',
					'id' => 'eut-category-title-container-size',
					'options' => array(
						'' => esc_html__( 'Default', 'zuperla' ),
						'large' => esc_html__( 'Large', 'zuperla' ),
					),
					'value' => zuperla_eutf_array_value( $zuperla_eutf_custom_title_options, 'container_size' ),
					'label' => array(
						"title" => esc_html__( 'Container Size', 'zuperla' ),
					),
					'dependency' =>
					'[
						{ "id" : "eut-category-title-custom", "values" : ["custom"] }
					]',
				)
			);

			zuperla_eutf_print_admin_option(
				array(
					'type' => 'select-colorpicker',
					'name' => 'zuperla_eutf_term_meta[bg_color]',
					'id' => 'eut-category-title-bg-color',
					'value' => zuperla_eutf_array_value( $zuperla_eutf_custom_title_options, 'bg_color', 'dark' ),
					'value2' => zuperla_eutf_array_value( $zuperla_eutf_custom_title_options, 'bg_color_custom', '#000000' ),
					'default_value2' => '#000000',
					'label' => array(
						"title" => esc_html__( 'Background Color', 'zuperla' ),
					),
					'dependency' =>
					'[
						{ "id" : "eut-category-title-custom", "values" : ["custom"] }
					]',
					'multiple' => 'multi',
					'type_usage' => 'section-bg',
				)
			);
			zuperla_eutf_print_admin_option(
				array(
					'type' => 'select-colorpicker',
					'name' => 'zuperla_eutf_term_meta[content_bg_color]',
					'id' => 'eut-category-title-content-bg-color',
					'value' => zuperla_eutf_array_value( $zuperla_eutf_custom_title_options, 'content_bg_color', 'none' ),
					'value2' => zuperla_eutf_array_value( $zuperla_eutf_custom_title_options, 'content_bg_color_custom', '#ffffff' ),
					'default_value2' => '#ffffff',
					'label' => array(
						"title" => esc_html__( 'Content Background Color', 'zuperla' ),
					),
					'dependency' =>
					'[
						{ "id" : "eut-category-title-custom", "values" : ["custom"] }
					]',
					'multiple' => 'multi',
					'type_usage' => 'title-content-bg',
				)
			);
			zuperla_eutf_print_admin_option(
				array(
					'type' => 'select-colorpicker',
					'name' => 'zuperla_eutf_term_meta[title_color]',
					'id' => 'eut-category-title-title-color',
					'value' => zuperla_eutf_array_value( $zuperla_eutf_custom_title_options, 'title_color', 'light' ),
					'value2' => zuperla_eutf_array_value( $zuperla_eutf_custom_title_options, 'title_color_custom', '#ffffff' ),
					'default_value2' => '#ffffff',
					'label' => array(
						"title" => esc_html__( 'Title Color', 'zuperla' ),
					),
					'dependency' =>
					'[
						{ "id" : "eut-category-title-custom", "values" : ["custom"] }
					]',
					'multiple' => 'multi',
				)
			);

			zuperla_eutf_print_admin_option(
				array(
					'type' => 'select-colorpicker',
					'name' => 'zuperla_eutf_term_meta[caption_color]',
					'id' => 'eut-category-title-caption_color',
					'value' => zuperla_eutf_array_value( $zuperla_eutf_custom_title_options, 'caption_color', 'light' ),
					'value2' => zuperla_eutf_array_value( $zuperla_eutf_custom_title_options, 'caption_color_custom', '#ffffff' ),
					'default_value2' => '#ffffff',
					'label' => array(
						"title" => esc_html__( 'Description Color', 'zuperla' ),
					),
					'dependency' =>
					'[
						{ "id" : "eut-category-title-custom", "values" : ["custom"] }
					]',
					'multiple' => 'multi',
				)
			);

			zuperla_eutf_print_admin_option(
				array(
					'type' => 'select',
					'name' => 'zuperla_eutf_term_meta[content_size]',
					'id' => 'eut-category-title-content-size',
					'options' => array(
						'large' => esc_html__( 'Large', 'zuperla' ),
						'medium' => esc_html__( 'Medium', 'zuperla' ),
						'small' => esc_html__( 'Small', 'zuperla' ),
					),
					'value' => zuperla_eutf_array_value( $zuperla_eutf_custom_title_options, 'content_size', 'large' ),
					'label' => array(
						"title" => esc_html__( 'Content Size', 'zuperla' ),
					),
					'dependency' =>
					'[
						{ "id" : "eut-category-title-custom", "values" : ["custom"] }
					]',
				)
			);

			zuperla_eutf_print_admin_option(
				array(
					'type' => 'select-align',
					'name' => 'zuperla_eutf_term_meta[content_alignment]',
					'id' => 'eut-category-title-content-alignment',
					'value' => zuperla_eutf_array_value( $zuperla_eutf_custom_title_options, 'content_alignment', 'center' ),
					'label' => array(
						"title" => esc_html__( 'Content Alignment', 'zuperla' ),
					),
					'dependency' =>
					'[
						{ "id" : "eut-category-title-custom", "values" : ["custom"] }
					]',
				)
			);

			global $zuperla_eutf_media_bg_position_selection;
			zuperla_eutf_print_admin_option(
				array(
					'type' => 'select',
					'name' => 'zuperla_eutf_term_meta[content_position]',
					'id' => 'eut-category-title-content_position',
					'value' => zuperla_eutf_array_value( $zuperla_eutf_custom_title_options, 'content_position', 'center-center' ),
					'options' => $zuperla_eutf_media_bg_position_selection,
					'label' => array(
						"title" => esc_html__( 'Content Position', 'zuperla' ),
					),
					'dependency' =>
					'[
						{ "id" : "eut-category-title-custom", "values" : ["custom"] }
					]',
				)
			);

			zuperla_eutf_print_admin_option(
				array(
					'type' => 'select-text-animation',
					'name' => 'zuperla_eutf_term_meta[content_animation]',
					'value' => zuperla_eutf_array_value( $zuperla_eutf_custom_title_options, 'content_animation', 'fade-in' ),
					'label' => esc_html__( 'Content Animation', 'zuperla' ),
					'dependency' =>
					'[
						{ "id" : "eut-category-title-custom", "values" : ["custom"] }
					]',
				)
			);


			zuperla_eutf_print_admin_option(
				array(
					'type' => 'select',
					'name' => 'zuperla_eutf_term_meta[bg_mode]',
					'id' => 'eut-category-title-bg-mode',
					'value' => zuperla_eutf_array_value( $zuperla_eutf_custom_title_options, 'bg_mode'),
					'options' => array(
						'' => esc_html__( 'Color Only', 'zuperla' ),
						'custom' => esc_html__( 'Custom Image', 'zuperla' ),

					),
					'label' => array(
						"title" => esc_html__( 'Background Mode', 'zuperla' ),
					),
					'group_id' => 'eut-category-title',
					'dependency' =>
					'[
						{ "id" : "eut-category-title-custom", "values" : ["custom"] }

					]',
				)
			);
			zuperla_eutf_print_admin_option(
				array(
					'type' => 'select-image',
					'name' => 'zuperla_eutf_term_meta[bg_image_id]',
					'id' => 'eut-category-title-bg-image-id',
					'value' => zuperla_eutf_array_value( $zuperla_eutf_custom_title_options, 'bg_image_id'),
					'label' => array(
						"title" => esc_html__( 'Background Image', 'zuperla' ),
					),
					'width' => 'fullwidth',
					'dependency' =>
					'[
						{ "id" : "eut-category-title-custom", "values" : ["custom"] },
						{ "id" : "eut-category-title-bg-mode", "values" : ["custom"] }

					]',
				)
			);
			zuperla_eutf_print_admin_option(
				array(
					'type' => 'select-bg-position',
					'name' => 'zuperla_eutf_term_meta[bg_position]',
					'id' => 'eut-category-title-bg-position',
					'value' => zuperla_eutf_array_value( $zuperla_eutf_custom_title_options, 'bg_position', 'center-center'),
					'label' => array(
						"title" => esc_html__( 'Background Position', 'zuperla' ),
					),
					'dependency' =>
					'[
						{ "id" : "eut-category-title-custom", "values" : ["custom"] },
						{ "id" : "eut-category-title-bg-mode", "values" : ["custom"] }
					]',
				)
			);

			zuperla_eutf_print_admin_option(
				array(
					'type' => 'select-pattern-overlay',
					'name' => 'zuperla_eutf_term_meta[pattern_overlay]',
					'value' => zuperla_eutf_array_value( $zuperla_eutf_custom_title_options, 'pattern_overlay'),
					'label' => esc_html__( 'Pattern Overlay', 'zuperla' ),
					'dependency' =>
					'[
						{ "id" : "eut-category-title-custom", "values" : ["custom"] },
						{ "id" : "eut-category-title-bg-mode", "values" : ["custom"] }
					]',
				)
			);
			zuperla_eutf_print_admin_option(
				array(
					'type' => 'select-colorpicker',
					'name' => 'zuperla_eutf_term_meta[color_overlay]',
					'value' => zuperla_eutf_array_value( $zuperla_eutf_custom_title_options, 'color_overlay', 'dark' ),
					'value2' => zuperla_eutf_array_value( $zuperla_eutf_custom_title_options, 'color_overlay_custom', '#000000' ),
					'default_value2' => '#000000',
					'label' => esc_html__( 'Color Overlay', 'zuperla' ),
					'multiple' => 'multi',
					'dependency' =>
					'[
						{ "id" : "eut-category-title-custom", "values" : ["custom"] },
						{ "id" : "eut-category-title-bg-mode", "values" : ["custom"] }
					]',
				)
			);
			zuperla_eutf_print_admin_option(
				array(
					'type' => 'select-opacity',
					'name' => 'zuperla_eutf_term_meta[opacity_overlay]',
					'value' => zuperla_eutf_array_value( $zuperla_eutf_custom_title_options, 'opacity_overlay', '0' ),
					'label' => esc_html__( 'Opacity Overlay', 'zuperla' ),
					'dependency' =>
					'[
						{ "id" : "eut-category-title-custom", "values" : ["custom"] },
						{ "id" : "eut-category-title-bg-mode", "values" : ["custom"] }
					]',
				)
			);
?>
			</div>
		</td>
	</tr>
<?php
	}

	//Save Category Meta
	function zuperla_eutf_save_category_fields( $term_id, $tt_id = '', $taxonomy = '' ) {

		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return;
		}

		$custom_meta_tax = array ( 'category', 'post_tag', 'product_cat', 'product_tag' );

		if ( isset( $_POST['zuperla_eutf_term_meta'] ) && in_array( $taxonomy, $custom_meta_tax ) ) {
			$zuperla_eutf_term_meta = zuperla_eutf_get_term_meta( $term_id, '_zuperla_eutf_custom_title_options' );
			$cat_keys = array_keys( $_POST['zuperla_eutf_term_meta'] );
			foreach ( $cat_keys as $key ) {
				if ( isset( $_POST['zuperla_eutf_term_meta'][$key] ) ) {
					$zuperla_eutf_term_meta[$key] = sanitize_text_field( $_POST['zuperla_eutf_term_meta'][$key] );
				}
			}
			zuperla_eutf_update_term_meta( $term_id , '_zuperla_eutf_custom_title_options', $zuperla_eutf_term_meta );
		}
	}

//Omit closing PHP tag to avoid accidental whitespace output errors.
