<!doctype html>
<!--[if lt IE 10]>
<html class="ie9 no-js" <?php language_attributes(); ?>>
<![endif]-->
<!--[if (gt IE 9)|!(IE)]><!-->

<html class="no-js" <?php language_attributes(); ?>> <!--<![endif]-->

	<head>
		<meta charset="<?php echo esc_attr( get_bloginfo( 'charset' ) ); ?>">
		<?php if ( is_singular() && pings_open( get_queried_object() ) ) { ?>
		<!-- allow pinned sites -->
		<link rel="pingback" href="<?php echo esc_url( get_bloginfo( 'pingback_url' ) ); ?>">
		<?php } ?>
		<?php wp_head(); ?>
	</head>

	<?php
		$zuperla_eutf_header_mode = zuperla_eutf_option( 'header_mode', 'default' );
		$header_sticky_type = zuperla_eutf_option( 'header_sticky_type', 'simple' );
		$zuperla_eutf_header_fullwidth = zuperla_eutf_option( 'header_fullwidth', '1' );
		$zuperla_eutf_header_data = zuperla_eutf_get_feature_header_data();
		$zuperla_eutf_header_style = $zuperla_eutf_header_data['header_style'];
		$zuperla_eutf_header_overlapping = $zuperla_eutf_header_data['data_overlap'];
		$zuperla_eutf_responsive_header_overlapping = zuperla_eutf_option( 'responsive_header_overlapping', 'no' );
		$zuperla_eutf_header_position = $zuperla_eutf_header_data['data_header_position'];
		$zuperla_eutf_menu_open_type = zuperla_eutf_option( 'header_menu_open_type', 'toggle' );

		// Theme Layout
		$zuperla_eutf_theme_layout = zuperla_eutf_option( 'theme_layout', 'stretched' );
		$zuperla_eutf_frame_size = zuperla_eutf_option( 'frame_size', 30 );

		//Sticky Header
		$zuperla_eutf_header_sticky_type = zuperla_eutf_option( 'header_sticky_type', 'simple' );
		$zuperla_eutf_header_sticky_height = zuperla_eutf_option( 'header_sticky_shrink_height', '0' );


		if ( is_singular() ) {
			$zuperla_eutf_header_sticky_type = zuperla_eutf_post_meta( '_zuperla_eutf_sticky_header_type', $zuperla_eutf_header_sticky_type );
			$zuperla_eutf_responsive_header_overlapping = zuperla_eutf_post_meta( '_zuperla_eutf_responsive_header_overlapping', $zuperla_eutf_responsive_header_overlapping );
		} else if ( zuperla_eutf_is_woo_shop() ) {
			$zuperla_eutf_header_sticky_type = zuperla_eutf_post_meta_shop( '_zuperla_eutf_sticky_header_type', $zuperla_eutf_header_sticky_type );
			$zuperla_eutf_responsive_header_overlapping = zuperla_eutf_post_meta_shop( '_zuperla_eutf_responsive_header_overlapping', $zuperla_eutf_responsive_header_overlapping );
		}
		$zuperla_eutf_header_sticky_type = zuperla_eutf_visibility( 'header_sticky_enabled' ) ? $zuperla_eutf_header_sticky_type : 'none';
		if( 'simple' == $zuperla_eutf_header_sticky_type && 'default' == $zuperla_eutf_header_mode) {
			$zuperla_eutf_header_sticky_height = zuperla_eutf_option( 'header_height' );
		}
		if( 'simple' == $zuperla_eutf_header_sticky_type && 'logo-top' == $zuperla_eutf_header_mode) {
			$zuperla_eutf_header_sticky_height = zuperla_eutf_option( 'header_bottom_height' );
		}

		$zuperla_eutf_header_menu_mode = zuperla_eutf_option( 'header_menu_mode', 'default' );

		$zuperla_eutf_menu_type = 'classic';

		if ( 'default' == $zuperla_eutf_header_mode ) {
			$zuperla_eutf_logo_align = 'left';
			if ( 'split' == $zuperla_eutf_header_menu_mode  ) {
				$zuperla_eutf_menu_align = 'center';
			} else {
				$zuperla_eutf_menu_align = zuperla_eutf_option( 'menu_align', 'right' );
			}
			$zuperla_eutf_menu_type = zuperla_eutf_option( 'menu_type', 'classic' );
			if ( is_singular() ) {
				$zuperla_eutf_menu_type = zuperla_eutf_post_meta( '_zuperla_eutf_menu_type', $zuperla_eutf_menu_type );
			} else if ( zuperla_eutf_is_woo_shop() ) {
				$zuperla_eutf_menu_type = zuperla_eutf_post_meta_shop( '_zuperla_eutf_menu_type', $zuperla_eutf_menu_type );
			}
		} else if ( 'logo-top' == $zuperla_eutf_header_mode ) {
			$zuperla_eutf_logo_align = zuperla_eutf_option( 'header_top_logo_align', 'center' );
			$zuperla_eutf_menu_align = zuperla_eutf_option( 'header_top_menu_align', 'center' );
			$zuperla_eutf_menu_type = zuperla_eutf_option( 'header_top_logo_menu_type', 'classic' );
			if ( is_singular() ) {
				$zuperla_eutf_menu_type = zuperla_eutf_post_meta( '_zuperla_eutf_menu_type', $zuperla_eutf_menu_type );
			} else if ( zuperla_eutf_is_woo_shop() ) {
				$zuperla_eutf_menu_type = zuperla_eutf_post_meta_shop( '_zuperla_eutf_menu_type', $zuperla_eutf_menu_type );
			}
		} else {
			$zuperla_eutf_header_fullwidth = 0;
			$zuperla_eutf_header_overlapping = 'no';
			$zuperla_eutf_header_sticky_type = 'none';
			$zuperla_eutf_menu_align = zuperla_eutf_option( 'header_side_menu_align', 'left' );
			$zuperla_eutf_logo_align = zuperla_eutf_option( 'header_side_logo_align', 'left' );
		}
		//Header Classes
		$zuperla_eutf_header_classes = array();
		if ( 1 == $zuperla_eutf_header_fullwidth ) {
			$zuperla_eutf_header_classes[] = 'eut-fullwidth';
		}
		if ( 'yes' == $zuperla_eutf_header_overlapping ) {
			$zuperla_eutf_header_classes[] = 'eut-overlapping';
		}
		if ( 'yes' == $zuperla_eutf_responsive_header_overlapping ) {
			$zuperla_eutf_header_classes[] = 'eut-responsive-overlapping';
		}
		if( 'below' == $zuperla_eutf_header_position ) {
			$zuperla_eutf_header_classes[] = 'eut-header-below';
		}
		if( 'advanced-hidden' == $zuperla_eutf_menu_type ){
			$zuperla_eutf_header_classes[] = 'eut-advanced-hidden-menu';
		}
		if ( 'split' == $zuperla_eutf_header_menu_mode ) {
			$zuperla_eutf_header_classes[] = 'eut-header-split-menu';
		}
		$zuperla_eutf_header_class_string = implode( ' ', $zuperla_eutf_header_classes );

		$zuperla_eutf_sidearea_data = zuperla_eutf_get_sidearea_data();
		$zuperla_eutf_sidebar_visibility = $zuperla_eutf_sidearea_data['visibility'];

		//Main Header Classes
		$zuperla_eutf_main_header_classes = array();
		$zuperla_eutf_main_header_classes[] = 'eut-header-' . $zuperla_eutf_header_mode;
		if ( 'side' == $zuperla_eutf_header_mode ) {
			$zuperla_eutf_main_header_classes[] = 'eut-' . $zuperla_eutf_menu_open_type . '-menu';
		} else {
			$zuperla_eutf_main_header_classes[] = 'eut-' . $zuperla_eutf_header_style;
		}
		if ( 'side' != $zuperla_eutf_header_mode || 'none' != $zuperla_eutf_header_sticky_type ) {
			$zuperla_eutf_main_header_classes[] = 'eut-' . $zuperla_eutf_header_sticky_type . '-sticky';
		}
		if( 'yes' ==  $zuperla_eutf_sidebar_visibility ) {
			$zuperla_eutf_main_header_classes[] = 'eut-with-sidearea';
		}
		$zuperla_eutf_header_main_class_string = implode( ' ', $zuperla_eutf_main_header_classes );

		$zuperla_eutf_menu_arrows = zuperla_eutf_option( 'submenu_pointer', 'none' );

		// Main Menu Classes
		$zuperla_eutf_main_menu_classes = array();
		if ( 'side' != $zuperla_eutf_header_mode ) {
			$zuperla_eutf_main_menu_classes[] = 'eut-horizontal-menu';
			if ( 'default' == $zuperla_eutf_header_mode && 'split' == $zuperla_eutf_header_menu_mode  ) {
				$zuperla_eutf_main_menu_classes[] = 'eut-split-menu';
			}
			$zuperla_eutf_main_menu_classes[] = 'eut-position-' . $zuperla_eutf_menu_align;
			if( 'none' != $zuperla_eutf_menu_arrows ) {
				$zuperla_eutf_main_menu_classes[] = 'eut-' . $zuperla_eutf_menu_arrows;
			}
			if ( 'hidden' != $zuperla_eutf_menu_type ){
				$zuperla_eutf_main_menu_classes[] = 'eut-menu-type-' . $zuperla_eutf_menu_type;
			}
		} else {
			$zuperla_eutf_main_menu_classes[] = 'eut-vertical-menu';
			$zuperla_eutf_main_menu_classes[] = 'eut-align-' . $zuperla_eutf_menu_align;
		}
		$zuperla_eutf_main_menu_classes[] = 'eut-main-menu';
		$zuperla_eutf_main_menu_class_string = implode( ' ', $zuperla_eutf_main_menu_classes );

		$zuperla_eutf_main_menu = zuperla_eutf_get_header_nav();


		$zuperla_eutf_header_sticky_devices_enabled = zuperla_eutf_option( 'header_sticky_devices_enabled' );
		$zuperla_eutf_header_sticky_devices = 'no';
		if ( '1' == $zuperla_eutf_header_sticky_devices_enabled ) {
			$zuperla_eutf_header_sticky_devices = 'yes';
		}

	?>

	<body <?php body_class(); ?>>
		<?php wp_body_open(); ?>
		<?php do_action( 'zuperla_eutf_body_top' ); ?>
		<?php if ( 'framed' == $zuperla_eutf_theme_layout ) { ?>
		<div id="eut-frames" data-frame-size="<?php echo esc_attr( $zuperla_eutf_frame_size ); ?>">
			<div class="eut-frame eut-top"></div>
			<div class="eut-frame eut-left"></div>
			<div class="eut-frame eut-right"></div>
			<div class="eut-frame eut-bottom"></div>
		</div>
		<?php } ?>
		<?php zuperla_eutf_print_theme_loader(); ?>
		<?php
			// Theme Wrapper Classes
			$zuperla_eutf_theme_wrapper_classes = array();
			if ( 'side' == $zuperla_eutf_header_mode ) {
				$zuperla_eutf_theme_wrapper_classes[] = 'eut-header-side';
			}
			if( 'below' == $zuperla_eutf_header_position && 'yes' == $zuperla_eutf_header_overlapping ) {
				$zuperla_eutf_theme_wrapper_classes[] = 'eut-feature-below';
			}

			$zuperla_eutf_content_skin = '';
			if ( is_singular() ) {
				$zuperla_eutf_content_skin_options = zuperla_eutf_post_meta( '_zuperla_eutf_content_skin_options' );
				$zuperla_eutf_content_skin = zuperla_eutf_array_value( $zuperla_eutf_content_skin_options, 'skin' );
			} else if ( zuperla_eutf_is_woo_shop() ) {
				$zuperla_eutf_content_skin_options = zuperla_eutf_post_meta_shop( '_zuperla_eutf_content_skin_options' );
				$zuperla_eutf_content_skin = zuperla_eutf_array_value( $zuperla_eutf_content_skin_options, 'skin' );
			}
			if( !empty( $zuperla_eutf_content_skin ) ) {
				$zuperla_eutf_theme_wrapper_classes[] = 'eut-skin-' . esc_attr( $zuperla_eutf_content_skin );
			}
			$zuperla_eutf_theme_wrapper_class_string = implode( ' ', $zuperla_eutf_theme_wrapper_classes );
		?>

		<!-- Theme Wrapper -->
		<div id="eut-theme-wrapper" class="<?php echo esc_attr( $zuperla_eutf_theme_wrapper_class_string ); ?>" data-mask-layer="2">
			<?php
				//Top Bar
				zuperla_eutf_print_header_top_bar();
				//FEATURE Header Below
				if( 'below' == $zuperla_eutf_header_position ) {
					zuperla_eutf_print_header_feature();
				}
			?>

			<!-- HEADER -->
			<header id="eut-header" class="<?php echo esc_attr( $zuperla_eutf_header_class_string ); ?>" data-sticky="<?php echo esc_attr( $zuperla_eutf_header_sticky_type ); ?>" data-sticky-height="<?php echo esc_attr( $zuperla_eutf_header_sticky_height ); ?>" data-devices-sticky="<?php echo esc_attr( $zuperla_eutf_header_sticky_devices ); ?>">
				<div class="eut-wrapper clearfix">

					<!-- Header -->
					<div id="eut-main-header" class="<?php echo esc_attr( $zuperla_eutf_header_main_class_string ); ?>">
					<?php
						if ( 'side' == $zuperla_eutf_header_mode ) {
					?>
						<div class="eut-main-header-wrapper clearfix">
							<div class="eut-content">
								<?php do_action( 'zuperla_eutf_side_logo_before' ); ?>
								<?php zuperla_eutf_print_logo( 'side', $zuperla_eutf_logo_align ); ?>
								<?php do_action( 'zuperla_eutf_side_logo_after' ); ?>
								<?php if ( $zuperla_eutf_main_menu != 'disabled' ) { ?>
								<!-- Main Menu -->
								<nav id="eut-main-menu" class="<?php echo esc_attr( $zuperla_eutf_main_menu_class_string ); ?>">
									<div class="eut-wrapper">
										<?php zuperla_eutf_header_nav( $zuperla_eutf_main_menu ); ?>
									</div>
								</nav>
								<!-- End Main Menu -->
								<?php } ?>
							</div>
						</div>
						<div class="eut-header-elements-wrapper eut-align-<?php echo esc_attr( $zuperla_eutf_menu_align); ?>">
							<?php zuperla_eutf_print_header_elements( $zuperla_eutf_sidearea_data ); ?>
						</div>
						<?php zuperla_eutf_print_side_header_bg_image(); ?>
					<?php
						} else if ( 'logo-top' == $zuperla_eutf_header_mode ) {
						//Log on Top Header
					?>
						<div id="eut-top-header">
							<div class="eut-wrapper clearfix">
								<div class="eut-container">
									<?php do_action( 'zuperla_eutf_top_logo_before' ); ?>
									<?php zuperla_eutf_print_logo( 'logo-top', $zuperla_eutf_logo_align ); ?>
									<?php do_action( 'zuperla_eutf_top_logo_after' ); ?>
								</div>
							</div>
						</div>
						<div id="eut-bottom-header">
							<div class="eut-wrapper clearfix">
								<div class="eut-container">
									<div class="eut-header-elements-wrapper eut-position-right">
								<?php
									if ( 'hidden' == $zuperla_eutf_menu_type && 'disabled' != $zuperla_eutf_main_menu ) {
										zuperla_eutf_print_header_hiddenarea_button();
									}
									zuperla_eutf_print_header_elements();
								?>
									</div>
								<?php
									if ( 'hidden' != $zuperla_eutf_menu_type && $zuperla_eutf_main_menu != 'disabled' ) {
								?>
										<!-- Main Menu -->
										<nav id="eut-main-menu" class="<?php echo esc_attr( $zuperla_eutf_main_menu_class_string ); ?>">
											<div class="eut-wrapper">
												<?php zuperla_eutf_header_nav( $zuperla_eutf_main_menu ); ?>
											</div>
										</nav>
										<!-- End Main Menu -->
								<?php
									}
								?>
								</div>
							</div>
							<?php zuperla_eutf_print_header_sidearea_button( $zuperla_eutf_sidearea_data ); ?>
						</div>
					<?php
						} else {
						//Default Header
					?>
						<div class="eut-wrapper clearfix">
							<div class="eut-container">
							<?php if ( 'default' == $zuperla_eutf_header_menu_mode || 'hidden' == $zuperla_eutf_menu_type || 'disabled' == $zuperla_eutf_main_menu  ) { ?>
								<?php do_action( 'zuperla_eutf_default_logo_before' ); ?>
								<?php zuperla_eutf_print_logo( 'default', $zuperla_eutf_logo_align ); ?>
								<?php do_action( 'zuperla_eutf_default_logo_after' ); ?>
							<?php } ?>
								<?php if ( 'advanced-hidden' == $zuperla_eutf_menu_type && 'disabled' != $zuperla_eutf_main_menu ) { ?>
									<div class="eut-hidden-menu-btn eut-position-right">
										<div class="eut-header-element">
											<a href="#">
												<span class="eut-item">
													<span></span>
													<span></span>
													<span></span>
												</span>
											</a>
										</div>
									</div>
								<?php } ?>
								<div class="eut-header-elements-wrapper eut-position-right">
							<?php
								if ( 'hidden' == $zuperla_eutf_menu_type && 'disabled' != $zuperla_eutf_main_menu ) {
									zuperla_eutf_print_header_hiddenarea_button();
								}
								zuperla_eutf_print_header_elements();
							?>
								</div>
							<?php
								if ( 'hidden' != $zuperla_eutf_menu_type && $zuperla_eutf_main_menu != 'disabled' ) {
							?>
									<!-- Main Menu -->
									<nav id="eut-main-menu" class="<?php echo esc_attr( $zuperla_eutf_main_menu_class_string ); ?>">
										<div class="eut-wrapper">
											<?php zuperla_eutf_header_nav( $zuperla_eutf_main_menu, $zuperla_eutf_header_menu_mode ); ?>
										</div>
									</nav>
									<!-- End Main Menu -->
							<?php
								}
							?>
							</div>
							<?php zuperla_eutf_print_header_sidearea_button( $zuperla_eutf_sidearea_data ); ?>
						</div>
					<?php
						}
					?>

					</div>
					<!-- End Header -->

					<!-- Responsive Header -->
					<div id="eut-responsive-header">
						<div id="eut-main-responsive-header" class="eut-wrapper clearfix">
							<div class="eut-container">
							<?php do_action( 'zuperla_eutf_responsive_logo_before' ); ?>
							<?php zuperla_eutf_print_logo( 'responsive' , 'left' ); ?>
							<?php do_action( 'zuperla_eutf_responsive_logo_after' ); ?>
								<div class="eut-header-elements-wrapper eut-position-right">
								<?php do_action( 'zuperla_eutf_responsive_elements_first' ); ?>
								<!-- Hidden Menu & Side Area Button -->
								<?php
									if ( 'disabled' != $zuperla_eutf_main_menu || zuperla_eutf_check_header_elements_visibility_any() ){
										zuperla_eutf_print_header_hiddenarea_button();
									}
								?>
								<?php zuperla_eutf_print_login_responsive_button(); ?>
								<?php zuperla_eutf_print_cart_responsive_link(); ?>
								<?php zuperla_eutf_print_header_sidearea_button( $zuperla_eutf_sidearea_data, $mode = 'normal' ); ?>
								<?php do_action( 'zuperla_eutf_responsive_elements_last' ); ?>
								</div>
							</div>
						</div>
					</div>
					<!-- End Responsive Header -->
				</div>

				<!-- Zuperla Sticky Header -->
			<?php
				if ( 'side' != $zuperla_eutf_header_mode && 'zuperla' == $zuperla_eutf_header_sticky_type ) {

				// Zuperla Sticky Menu Classes
				$zuperla_eutf_zuperla_sticky_menu_classes = array();

				$zuperla_eutf_zuperla_sticky_menu_classes[] = 'eut-horizontal-menu';
				$zuperla_eutf_zuperla_sticky_menu_classes[] = 'eut-position-' . $zuperla_eutf_menu_align;
				$zuperla_eutf_zuperla_sticky_menu_classes[] = 'eut-main-menu';
				if( 'none' != $zuperla_eutf_menu_arrows ) {
					$zuperla_eutf_zuperla_sticky_menu_classes[] = 'eut-' . $zuperla_eutf_menu_arrows;
				}
				if ( 'hidden' != $zuperla_eutf_menu_type ){
					$zuperla_eutf_zuperla_sticky_menu_classes[] = 'eut-menu-type-' . $zuperla_eutf_menu_type;
				}

				$zuperla_eutf_zuperla_sticky_menu_class_string = implode( ' ', $zuperla_eutf_zuperla_sticky_menu_classes );

			?>
				<div id="eut-zuperla-sticky-header" class="eut-fullwidth">
					<div class="eut-wrapper clearfix">
						<div class="eut-container">

						<?php zuperla_eutf_print_logo( 'zuperla-sticky' , 'left' ); ?>
						<div class="eut-header-elements-wrapper eut-position-right">
							<?php zuperla_eutf_print_header_elements(); ?>
							<?php zuperla_eutf_print_header_sidearea_button( $zuperla_eutf_sidearea_data ); ?>
						</div>
						<?php
							if ( 'hidden' != $zuperla_eutf_menu_type && $zuperla_eutf_main_menu != 'disabled' ) {
						?>
							<!-- Main Menu -->
							<nav id="eut-zuperla-sticky-menu" class="<?php echo esc_attr( $zuperla_eutf_zuperla_sticky_menu_class_string ); ?>">
								<div class="eut-wrapper">
									<?php zuperla_eutf_header_nav( $zuperla_eutf_main_menu ); ?>
								</div>
							</nav>
							<!-- End Main Menu -->
						<?php
							}
						?>

						</div>
					</div>

				</div>
			<?php
				}
			?>
				<!-- End Zuperla Sticky Header -->

			</header>
			<!-- END HEADER -->
			<?php do_action( 'zuperla_eutf_header_after' ); ?>
			<div id="eut-theme-content">

			<?php
				//FEATURE Header Above
				if( 'above' == $zuperla_eutf_header_position ) {
					zuperla_eutf_print_header_feature();
				}


//Omit closing PHP tag to avoid accidental whitespace output errors.
