<?php
/*
 * Plugin Name: Zuperla Extension
 * Description: This plugin extends Visual Composer and adds custom post type capabilities.
 * Author: Euthemians Team
 * Author URI: http://euthemians.com
 * Version: 2.3.9
 * Text Domain: zuperla-extension
 */

if ( ! defined( 'ABSPATH' ) ) exit;

if ( ! defined( 'ZUPERLA_EXT_VERSION' ) ) {
	define( 'ZUPERLA_EXT_VERSION', '2.3.9' );
}

if ( ! defined( 'ZUPERLA_EXT_PLUGIN_DIR_PATH' ) ) {
	define( 'ZUPERLA_EXT_PLUGIN_DIR_PATH', plugin_dir_path( __FILE__ ) );
}

if ( ! defined( 'ZUPERLA_EXT_PLUGIN_DIR_URL' ) ) {
	define( 'ZUPERLA_EXT_PLUGIN_DIR_URL', plugin_dir_url( __FILE__ ) );
}

if ( ! class_exists( 'Zuperla_Extension_Plugin' ) ) {

	class Zuperla_Extension_Plugin {

		/**
		 * @action plugins_loaded
		 * @return Zuperla_Extension_Plugin
		 * @static
		 */
		public static function init()
		{

			static $instance = false;

			if ( ! $instance ) {
				load_plugin_textdomain( 'zuperla-extension' , false , dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
				$instance = new Zuperla_Extension_Plugin;
			}
			return $instance;

		}

		/* Add Visual Composer Plugin*/
		private function __construct() {

			if ( is_user_logged_in() ) {
				add_action( 'admin_enqueue_scripts' , $this->marshal( 'zuperla_ext_vce_extension_add_scripts' ) );
			}
			add_action( 'wp_enqueue_scripts' , $this->marshal( 'zuperla_ext_vce_extension_add_front_end_scripts' ) );

			require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'includes/zuperla-ext-metaboxes.php';
			require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'includes/zuperla-ext-functions.php';
			require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'includes/zuperla-ext-add-param.php';
			require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'includes/zuperla-ext-shortcode-param.php';


			//Shortcodes
			if( function_exists( 'vc_lean_map' ) || function_exists( 'vc_map' ) ) {

				require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'shortcodes/zuperla_title.php';
				require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'shortcodes/zuperla_empty_space.php';
				require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'shortcodes/zuperla_divider.php';
				require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'shortcodes/zuperla_button.php';
				require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'shortcodes/zuperla_quote.php';
				require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'shortcodes/zuperla_dropcap.php';
				require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'shortcodes/zuperla_slogan.php';
				require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'shortcodes/zuperla_callout.php';
				require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'shortcodes/zuperla_progress_bar.php';
				require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'shortcodes/zuperla_pricing_table.php';

				require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'shortcodes/zuperla_message_box.php';
				require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'shortcodes/zuperla_icon.php';
				require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'shortcodes/zuperla_icon_box.php';

				require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'shortcodes/zuperla_image_text.php';
				//require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'shortcodes/zuperla_double_image_text.php';
				require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'shortcodes/zuperla_media_box.php';
				require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'shortcodes/zuperla_single_image.php';
				require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'shortcodes/zuperla_gallery.php';
				require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'shortcodes/zuperla_slider.php';
				require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'shortcodes/zuperla_video.php';

				require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'shortcodes/zuperla_social.php';
				require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'shortcodes/zuperla_social_links.php';
				require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'shortcodes/zuperla_gmap.php';

				require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'shortcodes/zuperla_team.php';
				require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'shortcodes/zuperla_blog.php';
				require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'shortcodes/zuperla_portfolio.php';
				require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'shortcodes/zuperla_blog_leader.php';
				require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'shortcodes/zuperla_testimonial.php';
				require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'shortcodes/zuperla_counter.php';
				require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'shortcodes/zuperla_pie_chart.php';
				require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'shortcodes/zuperla_typed_text.php';
				require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'shortcodes/zuperla_promo.php';
				require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'shortcodes/zuperla_flexible_carousel.php';
				require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'shortcodes/zuperla_countdown.php';
				require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'shortcodes/zuperla_modal.php';
				if ( class_exists( 'woocommerce' ) ) {
					require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'shortcodes/zuperla_products.php';
				}
				if ( class_exists( 'Tribe__Events__Main' ) ) {
					require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'shortcodes/zuperla_events.php';
				}
				require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'shortcodes/zuperla_content_slider.php';
				//require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'shortcodes/zuperla_portfolio_parallax.php';
				require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'shortcodes/zuperla_language_selector.php';
				require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'shortcodes/zuperla_instagram.php';

				if ( function_exists( 'zuperla_eutf_visibility' ) ) {
					$content_manager = zuperla_eutf_visibility( 'vc_content_manager_visibility' );
					if ( $content_manager ) {
						require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'zuperla-templates/zuperla-templates.php';
					}
				}

				require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'shortcodes/zuperla_privacy_gtracking.php';
				require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'shortcodes/zuperla_privacy_gmaps.php';
				require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'shortcodes/zuperla_privacy_gfonts.php';
				require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'shortcodes/zuperla_privacy_video_embeds.php';
				require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'shortcodes/zuperla_privacy_required.php';
				require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'shortcodes/zuperla_privacy_policy_page_link.php';
				require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'shortcodes/zuperla_privacy_preferences_link.php';

			}

		}

		public function Zuperla_Extension_Plugin() {
			$this->__construct();
		}

		public function zuperla_ext_vce_extension_add_scripts( $hook ) {
			wp_enqueue_style('zuperla-ext-vc-elements', ZUPERLA_EXT_PLUGIN_DIR_URL .'assets/css/zuperla-ext-vc-elements.css', array(), time(), 'all');
			wp_enqueue_style('zuperla-ext-vc-custom-fields', ZUPERLA_EXT_PLUGIN_DIR_URL .'assets/css/zuperla-ext-vc-custom-fields.css', array(), time(), 'all');
			wp_enqueue_style('zuperla-ext-vc-simple-line-icons', ZUPERLA_EXT_PLUGIN_DIR_URL .'assets/css/simple-line-icons.css', array(), '2.2.3', 'all');
			wp_enqueue_style('zuperla-ext-vc-elegant-line-icons', ZUPERLA_EXT_PLUGIN_DIR_URL .'assets/css/et-line-icons.css', array(), '1.0.0', 'all');
		}

		public function zuperla_ext_vce_extension_add_front_end_scripts() {
			wp_register_style( 'zuperla-ext-vc-simple-line-icons', ZUPERLA_EXT_PLUGIN_DIR_URL .'assets/css/simple-line-icons.css', array(), '2.2.3', 'all' );
			wp_register_style( 'zuperla-ext-vc-elegant-line-icons', ZUPERLA_EXT_PLUGIN_DIR_URL .'assets/css/et-line-icons.css', array(), '1.0.0', 'all' );
		}

		public function marshal( $method_name ) {
			return array( &$this , $method_name );
		}
	}

	/**
	 * Initialize the Visual Composer Extension Plugin
	 */
	add_action( 'init' , array( 'Zuperla_Extension_Plugin' , 'init' ), 12 );


	/**
	 * Initialize Custom Post Types
	 */
	function zuperla_ext_vce_rewrite_flush() {
		zuperla_ext_vce_register_custom_post_init();
		flush_rewrite_rules();
	}
	register_activation_hook( __FILE__, 'zuperla_ext_vce_rewrite_flush' );

	function zuperla_ext_vce_register_custom_post_init() {
		require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'includes/zuperla-portfolio-post-type.php';
		require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'includes/zuperla-testimonial-post-type.php';
		require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'includes/zuperla-area-item-post-type.php';
	}
	add_action( 'init', 'zuperla_ext_vce_register_custom_post_init', 9 );

	function zuperla_ext_vce_body_class( $classes ){
		$zuperla_ext_ver = 'eut-vce-ver-' . ZUPERLA_EXT_VERSION;
		return array_merge( $classes, array( $zuperla_ext_ver ) );
	}
	add_filter( 'body_class', 'zuperla_ext_vce_body_class' );

	require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'includes/zuperla-ext-global-functions.php';

	/**
	 * Widgets
	 */
	function zuperla_ext_register_widgets() {
		require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'widgets/eut-widget-contact-info.php';
		require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'widgets/eut-widget-latest-comments.php';
		require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'widgets/eut-widget-latest-portfolio.php';
		require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'widgets/eut-widget-latest-posts.php';
		require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'widgets/eut-widget-social-list.php';
		require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'widgets/eut-widget-social.php';
		require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'widgets/eut-widget-sticky.php';
		register_widget( 'Zuperla_Ext_Widget_Contact_Info' );
		register_widget( 'Zuperla_Ext_Widget_Latest_Comments' );
		register_widget( 'Zuperla_Ext_Widget_Latest_Portfolio' );
		register_widget( 'Zuperla_Ext_Widget_Latest_Posts' );
		register_widget( 'Zuperla_Ext_Widget_Social_List' );
		register_widget( 'Zuperla_Ext_Widget_Social' );
		register_widget( 'Zuperla_Ext_Widget_Sticky' );

	}
	add_action( 'widgets_init', 'zuperla_ext_register_widgets' );
	
	/**
	 *Admin Menu
	 */
	require_once ZUPERLA_EXT_PLUGIN_DIR_PATH . 'includes/admin/zuperla-ext-admin-functions.php';	
}

//Omit closing PHP tag to avoid accidental whitespace output errors.