<?php
/**
 * Euthemians Social List Networking
 * A widget that displays social networking links.
 * @author		Euthemians Team
 * @URI			http://euthemians.com
 */

class Zuperla_Ext_Widget_Social_List extends WP_Widget {

	function __construct() {
		$widget_ops = array(
			'classname' => 'eut-widget eut-element eut-social-list',
			'description' => esc_html__( 'A widget that displays social list networking links', 'zuperla-extension' ),
		);
		$control_ops = array(
			'width' => 400,
			'height' => 600,
			'id_base' => 'eut-widget-social-list',
		);
		parent::__construct( 'eut-widget-social-list', '(Euthemians) ' . esc_html__( 'List Social Networking', 'zuperla-extension' ), $widget_ops, $control_ops );
	}

	function zuperla_ext_widget_social_list() {
		$this->__construct();
	}

	function widget( $args, $instance ) {

		global $zuperla_ext_social_list_extended;

		//Our variables from the widget settings.
		extract( $args );

		echo $before_widget; // XSS OK

		// Display the widget title
		$title = apply_filters( 'widget_title', $instance['title'] );
		if ( $title ) {
			echo $before_title . esc_html( $title ) . $after_title; // XSS OK
		}

		$list_type = zuperla_ext_vce_array_value( $instance, 'list_type', 'vertical' );
		$font_size = zuperla_ext_vce_array_value( $instance, 'font_size', 'link-text' );
		$list_align = zuperla_ext_vce_array_value( $instance, 'list_align', 'left' );

		$social_list_classes = array();
		$social_list_classes[] = 'eut-' . $list_type;
		if( 'left' != $list_align ) {
			$social_list_classes[] = 'eut-align-' . $list_align;
		}
		$social_list_class_string = implode( ' ', $social_list_classes );

		$social_font_size_classes = array();
		$social_font_size_classes[] = 'eut-' . $font_size;
		$social_font_size_class_string = implode( ' ', $social_font_size_classes );

	?>

		<ul class="<?php echo esc_attr( $social_list_class_string ); ?>">
		<?php
		foreach ( $zuperla_ext_social_list_extended as $social_item ) {

			$social_item_url = zuperla_ext_vce_array_value( $instance, $social_item['url'] );

			if ( ! empty( $social_item_url ) ) {

				if ( 'skype' == $social_item['id'] ) {
		?>
					<li>
						<a href="<?php echo esc_url( $social_item_url, array( 'skype', 'http', 'https' ) ); ?>" class="<?php echo esc_attr( $social_font_size_class_string ); ?>">
							<span><?php echo esc_attr( $social_item['title'] ); ?></span>
						</a>
					</li>
		<?php
				} else {
		?>
					<li>
						<a href="<?php echo esc_url( $social_item_url ); ?>" class="<?php echo esc_attr( $social_font_size_class_string ); ?>" target="_blank" rel="noopener noreferrer">
							<span><?php echo esc_attr( $social_item['title'] ); ?></span>
						</a>
					</li>
		<?php
				}
			}
		}
		?>
		</ul>


	<?php

		echo $after_widget; // XSS OK
	}

	//Update the widget

	function update( $new_instance, $old_instance ) {

		global $zuperla_ext_social_list_extended;
		$instance = $old_instance;

		//Strip tags from title to remove HTML
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['list_type'] = strip_tags( $new_instance['list_type'] );
		$instance['font_size'] = strip_tags( $new_instance['font_size'] );
		$instance['list_align'] = strip_tags( $new_instance['list_align'] );


		foreach ( $zuperla_ext_social_list_extended as $social_item ) {
			$instance[ $social_item['url'] ] = strip_tags( $new_instance[ $social_item['url'] ] );
		}


		return $instance;
	}

	function form( $instance ) {

		global $zuperla_ext_social_list_extended;

		//Set up some default widget settings.
		$defaults = array(
			'title' => '',
			'list_type' => 'vertical',
			'font_size' => 'link-text',
			'list_align' => 'left',
		);

		$instance = wp_parse_args( (array) $instance, $defaults );

		$list_type = zuperla_ext_vce_array_value( $instance, 'list_type');
		$font_size = zuperla_ext_vce_array_value( $instance, 'font_size');
		$list_align = zuperla_ext_vce_array_value( $instance, 'list_align');

		?>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php echo esc_html__( 'Title:', 'zuperla-extension' ); ?></label>
			<input id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" value="<?php echo esc_attr( $instance['title'] ); ?>" style="width:100%;" />
		</p>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'list_type' ) ); ?>"><?php echo esc_html__( 'List Type:', 'zuperla-extension' ); ?></label>
			<select name="<?php echo esc_attr( $this->get_field_name( 'list_type' ) ); ?>" style="width:100%;">
				<option value="vertical" <?php selected( "vertical", $list_type ); ?>><?php echo esc_html__( 'Vertical', 'zuperla-extension' ); ?></option>
				<option value="horizontal" <?php selected( "horizontal", $list_type ); ?>><?php echo esc_html__( 'Horizontal', 'zuperla-extension' ); ?></option>
			</select>
		</p>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'font_size' ) ); ?>"><?php echo esc_html__( 'Font Size:', 'zuperla-extension' ); ?></label>
			<select name="<?php echo esc_attr( $this->get_field_name( 'font_size' ) ); ?>" style="width:100%;">
				<option value="link-text" <?php selected( "link-text", $font_size ); ?>><?php echo esc_html__( 'Link Text', 'zuperla-extension' ); ?></option>
				<option value="small-text" <?php selected( "small-text", $font_size ); ?>><?php echo esc_html__( 'Small Text', 'zuperla-extension' ); ?></option>
				<option value="paragraph-text" <?php selected( "paragraph-text", $font_size ); ?>><?php echo esc_html__( 'Paragraph Text', 'zuperla-extension' ); ?></option>
				<option value="leader-text" <?php selected( "leader-text", $font_size ); ?>><?php echo esc_html__( 'Leader Text', 'zuperla-extension' ); ?></option>
			</select>
		</p>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'list_align' ) ); ?>"><?php echo esc_html__( 'Align:', 'zuperla-extension' ); ?></label>
			<select name="<?php echo esc_attr( $this->get_field_name( 'list_align' ) ); ?>" style="width:100%;">
				<option value="left" <?php selected( "left", $list_align ); ?>><?php echo esc_html__( 'Left', 'zuperla-extension' ); ?></option>
				<option value="center" <?php selected( "center", $list_align ); ?>><?php echo esc_html__( 'Center', 'zuperla-extension' ); ?></option>
				<option value="right" <?php selected( "right", $list_align ); ?>><?php echo esc_html__( 'Right', 'zuperla-extension' ); ?></option>
			</select>
		</p>
		<p>
				<em><?php echo esc_html__( 'Note: Make sure you include the full URL (i.e. http://www.samplesite.com)', 'zuperla-extension' ); ?></em>
				<br>
				 <?php echo esc_html__( 'If you do not want a social to be visible, simply delete the supplied URL.', 'zuperla-extension' ); ?>
		</p>

		<?php
		foreach ( $zuperla_ext_social_list_extended as $social_item ) {

			$social_item_url = zuperla_ext_vce_array_value( $instance, $social_item['url'] );
		?>
				<p>
					<label for="<?php echo esc_attr( $this->get_field_id( $social_item['url'] ) ); ?>"><?php echo esc_html( $social_item['title'] ); ?>:</label>
					<input style="width: 100%;" id="<?php echo esc_attr( $this->get_field_id( $social_item['url'] ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( $social_item['url'] ) ); ?>" value="<?php echo esc_attr( $social_item_url ); ?>" />
				</p>

		<?php
		}
		?>

	<?php
	}
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
