<?php
/**
 * Social Share Shortcode
 */

if( !function_exists( 'zuperla_ext_vce_social_shortcode' ) ) {

	function zuperla_ext_vce_social_shortcode( $atts, $content ) {

		$output = $data = $el_class = '';

		extract(
			shortcode_atts(
				array(
					'social_email' => '',
					'social_facebook' => '',
					'social_twitter' => '',
					'social_linkedin' => '',
					'social_reddit' => '',
					'social_pinterest' => '',
					'social_tumblr' => '',
					'likes' => '',
					'animation' => '',
					'inherit_align' => 'iherit',
					'shape_color' => 'primary-1',
					'icon_size' => 'medium',
					'icon_shape' => 'no-shape',
					'shape_type' => 'simple',
					'icon_color' => 'primary-1',
					'animation_delay' => '200',
					'animation_duration' => 'normal',
					'margin_bottom' => '',
					'el_class' => '',
				),
				$atts
			)
		);


		$social_classes = array( 'eut-element', 'eut-social', 'eut-icon-type', 'eut-align-' . $inherit_align );

		if ( !empty( $animation ) ) {
			array_push( $social_classes, 'eut-animated-item' );
			array_push( $social_classes, $animation);
			array_push( $social_classes, 'eut-duration-' . $animation_duration );
			$data = ' data-delay="' . esc_attr( $animation_delay ) . '"';
		}
		if ( !empty( $el_class ) ) {
			array_push( $social_classes, $el_class);
		}
		$social_class_string = implode( ' ', $social_classes );

		$social_shape_classes = array();

		array_push( $social_shape_classes, 'eut-' . $icon_size );
		array_push( $social_shape_classes, 'eut-' . $icon_shape );

		if ( 'no-shape' != $icon_shape ) {
			array_push( $social_shape_classes, 'eut-with-shape' );
			array_push( $social_shape_classes, 'eut-' . $shape_type );
			if ( 'outline' != $shape_type ) {
				array_push( $social_shape_classes, 'eut-bg-' . $shape_color );
			} else {
				array_push( $social_shape_classes, 'eut-text-' . $shape_color );
				array_push( $social_shape_classes, 'eut-text-hover-' . $shape_color );
			}
		}

		$social_shape_class_string = implode( ' ', $social_shape_classes );


		$style = zuperla_ext_vce_build_margin_bottom_style( $margin_bottom );

		$zuperla_ext_permalink = get_permalink();
		$zuperla_ext_title = get_the_title();
		$page_email_string = 'mailto:?subject=' . $zuperla_ext_title . '&body=' . $zuperla_ext_title . ': ' . $zuperla_ext_permalink;

		$image_size = 'large';
		if ( has_post_thumbnail() ) {
			$post_thumbnail_id = get_post_thumbnail_id( get_the_ID() );
			$attachment_src = wp_get_attachment_image_src( $post_thumbnail_id, $image_size );
			$zuperla_ext_image_url = $attachment_src[0];
		} else {
			$zuperla_ext_image_url = get_template_directory_uri() . '/images/empty/' . $image_size . '.jpg';
		}

		ob_start();

		?>
			<div class="<?php echo esc_attr( $social_class_string ); ?>" style="<?php echo $style; ?>"<?php echo $data; ?>>
				<ul>
					<?php if ( !empty( $social_email  ) ) { ?>
					<li><a href="<?php echo esc_url( $page_email_string ); ?>" title="<?php echo esc_attr( $zuperla_ext_title ); ?>" class="<?php echo esc_attr( $social_shape_class_string ); ?> eut-social-share-email"><i class="eut-text-<?php echo esc_attr( $icon_color ); ?> fa fa-envelope"></i></a></li>
					<?php } ?>
					<?php if ( !empty( $social_facebook ) ) { ?>
					<li><a href="<?php echo esc_url( $zuperla_ext_permalink ); ?>" title="<?php echo esc_attr( $zuperla_ext_title ); ?>" class="<?php echo esc_attr( $social_shape_class_string ); ?> eut-social-share-facebook"><i class="eut-text-<?php echo esc_attr( $icon_color ); ?> fa fa-facebook"></i></a></li>
					<?php } ?>
					<?php if ( !empty( $social_twitter ) ) { ?>
					<li><a href="<?php echo esc_url( $zuperla_ext_permalink ); ?>" title="<?php echo esc_attr( $zuperla_ext_title ); ?>" class="<?php echo esc_attr( $social_shape_class_string ); ?> eut-social-share-twitter"><i class="eut-text-<?php echo esc_attr( $icon_color ); ?> fa fa-twitter"></i></a></li>
					<?php } ?>
					<?php if ( !empty( $social_linkedin ) ) { ?>
					<li><a href="<?php echo esc_url( $zuperla_ext_permalink ); ?>" title="<?php echo esc_attr( $zuperla_ext_title ); ?>" class="<?php echo esc_attr( $social_shape_class_string ); ?> eut-social-share-linkedin"><i class="eut-text-<?php echo esc_attr( $icon_color ); ?> fa fa-linkedin"></i></a></li>
					<?php } ?>
					<?php if ( !empty( $social_reddit ) ) { ?>
					<li><a href="<?php echo esc_url( $zuperla_ext_permalink ); ?>" title="<?php echo esc_attr( $zuperla_ext_title ); ?>" class="<?php echo esc_attr( $social_shape_class_string ); ?> eut-social-share-reddit"><i class="eut-text-<?php echo esc_attr( $icon_color ); ?> fa fa-reddit"></i></a></li>
					<?php } ?>
					<?php if ( !empty( $social_pinterest  ) ) { ?>
					<li><a href="<?php echo esc_url( $zuperla_ext_permalink ); ?>" title="<?php echo esc_attr( $zuperla_ext_title ); ?>" class="<?php echo esc_attr( $social_shape_class_string ); ?> eut-social-share-pinterest" data-pin-img="<?php echo esc_url( $zuperla_ext_image_url ); ?>" ><i class="eut-text-<?php echo esc_attr( $icon_color ); ?> fa fa-pinterest"></i></a></li>
					<?php } ?>
					<?php if ( !empty( $social_tumblr  ) ) { ?>
					<li><a href="<?php echo esc_url( $zuperla_ext_permalink ); ?>" title="<?php echo esc_attr( $zuperla_ext_title ); ?>" class="<?php echo esc_attr( $social_shape_class_string ); ?> eut-social-share-tumblr"><i class="eut-text-<?php echo esc_attr( $icon_color ); ?> fa fa-tumblr"></i></a></li>
					<?php } ?>

					<?php if ( !empty( $likes ) && function_exists( 'zuperla_eutf_likes' ) ) {
						global $post;
						$post_id = $post->ID;
					?>
					<li><a href="#" class="<?php echo esc_attr( $social_shape_class_string ); ?> eut-like-counter-link" data-post-id="<?php echo esc_attr( $post_id ); ?>"><i class="eut-text-<?php echo esc_attr( $icon_color ); ?> fa fa-heart"></i><span class="eut-like-counter"><?php echo zuperla_eutf_likes( $post_id, 'number' ); ?></span></a></li>
					<?php } ?>

				</ul>
			</div>
		<?php

		return ob_get_clean();

	}
	add_shortcode( 'zuperla_social', 'zuperla_ext_vce_social_shortcode' );

}

/**
 * Add shortcode to Visual Composer
 */

if( !function_exists( 'zuperla_ext_vce_social_shortcode_params' ) ) {
	function zuperla_ext_vce_social_shortcode_params( $tag ) {
		return array(
			"name" => esc_html__( "Social Share", "zuperla-extension" ),
			"description" => esc_html__( "Place your preferred social", "zuperla-extension" ),
			"base" => $tag,
			"class" => "",
			"icon"      => "icon-wpb-eut-social",
			"category" => esc_html__( "Content", "js_composer" ),
			"params" => array(
				array(
					"type" => 'checkbox',
					"heading" => esc_html__( "E-mail", "zuperla-extension" ),
					"param_name" => "social_email",
					"description" => esc_html__( "Share with E-mail", "zuperla-extension" ),
					"value" => array( esc_html__( "Show E-mail social share", "zuperla-extension" ) => 'yes' ),
				),
				array(
					"type" => 'checkbox',
					"heading" => esc_html__( "Facebook", "zuperla-extension" ),
					"param_name" => "social_facebook",
					"description" => esc_html__( "Share in Facebook", "zuperla-extension" ),
					"value" => array( esc_html__( "Show Facebook social share", "zuperla-extension" ) => 'yes' ),
				),
				array(
					"type" => 'checkbox',
					"heading" => esc_html__( "Twitter", "zuperla-extension" ),
					"param_name" => "social_twitter",
					"description" => esc_html__( "Share in Twitter", "zuperla-extension" ),
					"value" => array( esc_html__( "Show Twitter social share", "zuperla-extension" ) => 'yes' ),
				),
				array(
					"type" => 'checkbox',
					"heading" => esc_html__( "Linkedin", "zuperla-extension" ),
					"param_name" => "social_linkedin",
					"description" => esc_html__( "Share in Linkedin", "zuperla-extension" ),
					"value" => array( esc_html__( "Show Linkedin social share", "zuperla-extension" ) => 'yes' ),
				),
				array(
					"type" => 'checkbox',
					"heading" => esc_html__( "reddit", "zuperla-extension" ),
					"param_name" => "social_reddit",
					"description" => esc_html__( "Submit in reddit", "zuperla-extension" ),
					"value" => array( esc_html__( "Show reddit social share", "zuperla-extension" ) => 'yes' ),
				),
				array(
					"type" => 'checkbox',
					"heading" => esc_html__( "Pinterest", "zuperla-extension" ),
					"param_name" => "social_pinterest",
					"description" => esc_html__( "Submit in Pinterest (Featured Image is used as image)", "zuperla-extension" ),
					"value" => array( esc_html__( "Show Pinterest social share", "zuperla-extension" ) => 'yes' ),
				),
				array(
					"type" => 'checkbox',
					"heading" => esc_html__( "Tumblr", "zuperla-extension" ),
					"param_name" => "social_tumblr",
					"description" => esc_html__( "Submit in Tumblr", "zuperla-extension" ),
					"value" => array( esc_html__( "Show Tumblr social share", "zuperla-extension" ) => 'yes' ),
				),
				array(
					"type" => 'checkbox',
					"heading" => esc_html__( "(Euthemians) Likes", "zuperla-extension" ),
					"param_name" => "likes",
					"description" => esc_html__( "(Euthemians) Likes", "zuperla-extension" ),
					"value" => array( esc_html__( "Show (Euthemians) Likes", "zuperla-extension" ) => 'yes' ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Icon size", "zuperla-extension" ),
					"param_name" => "icon_size",
					"value" => array(
						esc_html__( "Large", "zuperla-extension" ) => 'large',
						esc_html__( "Medium", "zuperla-extension" ) => 'medium',
						esc_html__( "Small", "zuperla-extension" ) => 'small',
					),
					"std" => 'medium',
					"description" => '',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Icon Color", "zuperla-extension" ),
					"param_name" => "icon_color",
					"param_holder_class" => "eut-colored-dropdown",
					"value" => array(
						esc_html__( "Primary 1", "zuperla-extension" ) => 'primary-1',
						esc_html__( "Primary 2", "zuperla-extension" ) => 'primary-2',
						esc_html__( "Primary 3", "zuperla-extension" ) => 'primary-3',
						esc_html__( "Primary 4", "zuperla-extension" ) => 'primary-4',
						esc_html__( "Primary 5", "zuperla-extension" ) => 'primary-5',
						esc_html__( "Primary 6", "zuperla-extension" ) => 'primary-6',
						esc_html__( "Green", "zuperla-extension" ) => 'green',
						esc_html__( "Orange", "zuperla-extension" ) => 'orange',
						esc_html__( "Red", "zuperla-extension" ) => 'red',
						esc_html__( "Blue", "zuperla-extension" ) => 'blue',
						esc_html__( "Aqua", "zuperla-extension" ) => 'aqua',
						esc_html__( "Purple", "zuperla-extension" ) => 'purple',
						esc_html__( "Black", "zuperla-extension" ) => 'black',
						esc_html__( "Grey", "zuperla-extension" ) => 'grey',
						esc_html__( "White", "zuperla-extension" ) => 'white',
					),
					"description" => esc_html__( "Color of the social icon.", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Icon shape", "zuperla-extension" ),
					"param_name" => "icon_shape",
					"value" => array(
						esc_html__( "None", "zuperla-extension" ) => 'no-shape',
						esc_html__( "Square", "zuperla-extension" ) => 'square',
						esc_html__( "Round", "zuperla-extension" ) => 'round',
						esc_html__( "Circle", "zuperla-extension" ) => 'circle',
					),
					"description" => '',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Shape Color", "zuperla-extension" ),
					"param_name" => "shape_color",
					"param_holder_class" => "eut-colored-dropdown",
					"value" => array(
						esc_html__( "Primary 1", "zuperla-extension" ) => 'primary-1',
						esc_html__( "Primary 2", "zuperla-extension" ) => 'primary-2',
						esc_html__( "Primary 3", "zuperla-extension" ) => 'primary-3',
						esc_html__( "Primary 4", "zuperla-extension" ) => 'primary-4',
						esc_html__( "Primary 5", "zuperla-extension" ) => 'primary-5',
						esc_html__( "Primary 6", "zuperla-extension" ) => 'primary-6',
						esc_html__( "Green", "zuperla-extension" ) => 'green',
						esc_html__( "Orange", "zuperla-extension" ) => 'orange',
						esc_html__( "Red", "zuperla-extension" ) => 'red',
						esc_html__( "Blue", "zuperla-extension" ) => 'blue',
						esc_html__( "Aqua", "zuperla-extension" ) => 'aqua',
						esc_html__( "Purple", "zuperla-extension" ) => 'purple',
						esc_html__( "Black", "zuperla-extension" ) => 'black',
						esc_html__( "Grey", "zuperla-extension" ) => 'grey',
						esc_html__( "White", "zuperla-extension" ) => 'white',
					),
					"description" => esc_html__( "Color of the shape.", "zuperla-extension" ),
					"dependency" => array( 'element' => "icon_shape", 'value' => array( 'square', 'round', 'circle' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Shape type", "zuperla-extension" ),
					"param_name" => "shape_type",
					"value" => array(
						esc_html__( "Simple", "zuperla-extension" ) => 'simple',
						esc_html__( "Outline", "zuperla-extension" ) => 'outline',
					),
					"description" => esc_html__( "Select shape type.", "zuperla-extension" ),
					"dependency" => array( 'element' => "icon_shape", 'value' => array( 'square', 'round', 'circle' ) ),
				),
				zuperla_ext_vce_add_inherit_align(),
				zuperla_ext_vce_add_animation(),
				zuperla_ext_vce_add_animation_delay(),
				zuperla_ext_vce_add_animation_duration(),
				zuperla_ext_vce_add_margin_bottom(),
				zuperla_ext_vce_add_el_class(),
			),
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'zuperla_social', 'zuperla_ext_vce_social_shortcode_params' );
} else if( function_exists( 'vc_map' ) ) {
	$attributes = zuperla_ext_vce_social_shortcode_params( 'zuperla_social' );
	vc_map( $attributes );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
