<?php
/**
 * Dropcap Shortcode
 */

if( !function_exists( 'zuperla_ext_vce_dropcap_shortcode' ) ) {

	function zuperla_ext_vce_dropcap_shortcode( $atts, $content ) {

		$output = $style = $data = $el_class = '';

		extract(
			shortcode_atts(
				array(
					'dropcap_style' => '1',
					'color' => 'primary-1',
					'animation' => '',
					'animation_delay' => '200',
					'animation_duration' => 'normal',
					'margin_bottom' => '',
					'el_class' => '',
				),
				$atts
			)
		);


		$style = zuperla_ext_vce_build_margin_bottom_style( $margin_bottom );

		$dropcap_classes = array( 'eut-element', 'eut-dropcap' );

		if ( !empty( $animation ) ) {
			array_push( $dropcap_classes, 'eut-animated-item' );
			array_push( $dropcap_classes, $animation);
			array_push( $dropcap_classes, 'eut-duration-' . $animation_duration );
			$data = ' data-delay="' . esc_attr( $animation_delay ) . '"';
		}

		if ( !empty ( $el_class ) ) {
			array_push( $dropcap_classes, $el_class);
		}
		$dropcap_class_string = implode( ' ', $dropcap_classes );

		if ( !empty( $content ) ) {

			$dropcap_char = mb_substr( $content, 0, 1, 'UTF8' );
			$dropcap_content = mb_substr( $content, 1, mb_strlen( $content ) , 'UTF8' );
			$output .= '<div class="' . esc_attr( $dropcap_class_string ) . '" style="' . $style . '"' . $data .'>';
			if ( '1' == $dropcap_style ) {
			$output .= '  <p><span class="eut-style-' . esc_attr( $dropcap_style ) . ' eut-text-' . esc_attr( $color ) . '">' . $dropcap_char . '</span>' . $dropcap_content . '</p>';
			} else {
			$output .= '  <p><span class="eut-style-' . esc_attr( $dropcap_style ) . ' eut-bg-' . esc_attr( $color ) . '">' . $dropcap_char . '</span>' . $dropcap_content . '</p>';
			}
			$output .= '</div>';

		}


		return $output;
	}
	add_shortcode( 'zuperla_dropcap', 'zuperla_ext_vce_dropcap_shortcode' );

}

/**
 * Add shortcode to Visual Composer
 */

if( !function_exists( 'zuperla_ext_vce_dropcap_shortcode_params' ) ) {
	function zuperla_ext_vce_dropcap_shortcode_params( $tag ) {
		return array(
			"name" => esc_html__( "Dropcap", "zuperla-extension" ),
			"description" => esc_html__( "Two separate styles for your dropcaps", "zuperla-extension" ),
			"base" => $tag,
			"class" => "",
			"icon"      => "icon-wpb-eut-dropcap",
			"category" => esc_html__( "Content", "js_composer" ),
			"params" => array(
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Style", "zuperla-extension" ),
					"param_name" => "dropcap_style",
					"value" => array(
						esc_html__( "Style 1", "zuperla-extension" ) => '1',
						esc_html__( "Style 2", "zuperla-extension" ) => '2',
					),
					"description" => esc_html__( "Style of the dropcap.", "zuperla-extension" ),
				),
				array(
					"type" => "textarea",
					"heading" => esc_html__( "Text", "zuperla-extension" ),
					"param_name" => "content",
					"value" => "Sample Text",
					"description" => esc_html__( "Type your dropcap text.", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Dropcap Color", "zuperla-extension" ),
					"param_name" => "color",
					"param_holder_class" => "eut-colored-dropdown",
					"value" => array(
						esc_html__( "Primary 1", "zuperla-extension" ) => 'primary-1',
						esc_html__( "Primary 2", "zuperla-extension" ) => 'primary-2',
						esc_html__( "Primary 3", "zuperla-extension" ) => 'primary-3',
						esc_html__( "Primary 4", "zuperla-extension" ) => 'primary-4',
						esc_html__( "Primary 5", "zuperla-extension" ) => 'primary-5',
						esc_html__( "Primary 6", "zuperla-extension" ) => 'primary-6',
						esc_html__( "Green", "zuperla-extension" ) => 'green',
						esc_html__( "Orange", "zuperla-extension" ) => 'orange',
						esc_html__( "Red", "zuperla-extension" ) => 'red',
						esc_html__( "Blue", "zuperla-extension" ) => 'blue',
						esc_html__( "Aqua", "zuperla-extension" ) => 'aqua',
						esc_html__( "Purple", "zuperla-extension" ) => 'purple',
						esc_html__( "Black", "zuperla-extension" ) => 'black',
						esc_html__( "Grey", "zuperla-extension" ) => 'grey',
					),
					"description" => esc_html__( "First character background color", "zuperla-extension" ),
				),
				zuperla_ext_vce_add_animation(),
				zuperla_ext_vce_add_animation_delay(),
				zuperla_ext_vce_add_animation_duration(),
				zuperla_ext_vce_add_margin_bottom(),
				zuperla_ext_vce_add_el_class(),
			),
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'zuperla_dropcap', 'zuperla_ext_vce_dropcap_shortcode_params' );
} else if( function_exists( 'vc_map' ) ) {
	$attributes = zuperla_ext_vce_dropcap_shortcode_params( 'zuperla_dropcap' );
	vc_map( $attributes );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
