<?php
/**
 * Blog Shortcode
 */

if( !function_exists( 'zuperla_ext_vce_blog_shortcode' ) ) {

	function zuperla_ext_vce_blog_shortcode( $atts, $content ) {

		$output = $allow_filter = $el_class = $data_string = '';

		extract(
			shortcode_atts(
				array(
					'title' => '',
					'text_style' => 'none',
					'align' => 'left',
					'heading_tag' => 'h3',
					'heading' => 'h3',
					'custom_font_family' => '',
					'categories' => '',
					'exclude_posts' => '',
					'include_posts' => '',
					'blog_mode' => 'blog-large',
					'blog_shadow_style' => 'shadow-mode',
					'carousel_layout' => 'layout-1',
					'blog_media_area' => 'yes',
					'blog_image_mode' => 'landscape-large-wide',
					'blog_grid_image_mode' => 'landscape',
					'blog_masonry_image_mode' => 'medium',
					'carousel_image_mode' => 'landscape',
					'post_title_heading_tag' => 'h2',
					'post_title_heading' => 'auto',
					'carousel_style' => '1',
					'carousel_bg_color' => 'black',
					'carousel_bg_opacity' => '40',
					'blog_image_prio' => '',
					'columns_large_screen' => '3',
					'columns' => '3',
					'columns_tablet_landscape' => '2',
					'columns_tablet_portrait' => '2',
					'columns_mobile' => '1',
					'item_gutter' => 'yes',
					'gutter_size' => '40',
					'auto_excerpt' => '',
					'excerpt_length' => '55',
					'excerpt_more' => '',
					'hide_author' => '',
					'hide_date' => '',
					'hide_comments' => '',
					'hide_like' => '',
					'hide_excerpt' => '',
					'posts_per_page' => '10',
					'order_by' => 'date',
					'order' => 'DESC',
					'disable_pagination' => '',
					'blog_filter' => '',
					'filter_style' => 'simple',
					'filter_shape' => 'square',
					'filter_color' => 'primary-1',
					'blog_filter_align' => 'left',
					'filter_order_by' => '',
					'filter_order' => 'ASC',
					'item_spinner' => 'no',
					'items_per_page' => '4',
					'slideshow_speed' => '3000',
					'loop' => 'yes',
					'auto_play' => 'yes',
					'navigation_type' => '1',
					'navigation_color' => 'dark',
					'pause_hover' => 'no',
					'carousel_pagination' => 'no',
					'carousel_pagination_speed' => '400',
					'animation' => '',
					'margin_bottom' => '',
					'el_class' => '',
				),
				$atts
			)
		);

		$style = zuperla_ext_vce_build_margin_bottom_style( $margin_bottom );

		$blog_classes = array( 'eut-element' );


		switch( $blog_mode ) {

			case 'masonry':
				$data_string .= 'data-columns="' . esc_attr( $columns ) . '" data-columns-large-screen="' . esc_attr( $columns_large_screen ) . '" data-columns-tablet-landscape="' . esc_attr( $columns_tablet_landscape ) . '" data-columns-tablet-portrait="' . esc_attr( $columns_tablet_portrait ) . '" data-columns-mobile="' . esc_attr( $columns_mobile ) . '" data-layout="masonry" data-spinner="' . esc_attr( $item_spinner ) . '"';
				if ( 'yes' == $item_gutter ) {
					$data_string .= ' data-gutter-size="' . esc_attr( $gutter_size ) . '"';
				}
				break;
			case 'grid':
				$data_string .= 'data-columns="' . esc_attr( $columns ) . '" data-columns-large-screen="' . esc_attr( $columns_large_screen ) . '" data-columns-tablet-landscape="' . esc_attr( $columns_tablet_landscape ) . '" data-columns-tablet-portrait="' . esc_attr( $columns_tablet_portrait ) . '" data-columns-mobile="' . esc_attr( $columns_mobile ) . '" data-layout="fitRows" data-spinner="' . esc_attr( $item_spinner ) . '"';
				if ( 'yes' == $item_gutter ) {
					$data_string .= ' data-gutter-size="' . esc_attr( $gutter_size ) . '"';
				}
				break;
			case 'carousel':
				$blog_classes[] = 'eut-carousel';
				$blog_classes[] = 'eut-' . $carousel_layout;
				$blog_classes[] = 'eut-carousel-style-' . $carousel_style ;
				if ( 'yes' == $item_gutter ) {
					$blog_classes[] = 'eut-with-gap';
				}
				$disable_pagination = 'yes';
				break;
			default:
				$data_string .= '';
				break;
		}

		array_push( $blog_classes, zuperla_ext_vce_get_blog_class( $blog_mode ) );
		if ( !empty ( $el_class ) ) {
			array_push( $blog_classes, $el_class);
		}

		if ( 'shadow-mode' == $blog_shadow_style && ( 'masonry' == $blog_mode || 'grid' == $blog_mode ) ) {
			array_push( $blog_classes, 'eut-with-shadow' );
		}

		$blog_class_string = implode( ' ', $blog_classes );

		$paged = 1;

		if ( 'yes' != $disable_pagination ) {
			if ( get_query_var( 'paged' ) ) {
				$paged = get_query_var( 'paged' );
			} elseif ( get_query_var( 'page' ) ) {
				$paged = get_query_var( 'page' );
			}
		}

		$exclude_ids = array();
		if( !empty( $exclude_posts ) ){
			$exclude_ids = explode( ',', $exclude_posts );
		}

		$include_ids = array();
		if( !empty( $include_posts ) ){
			$include_ids = explode( ',', $include_posts );
			$args = array(
				'post_type' => 'post',
				'post_status'=>'publish',
				'posts_per_page' => $posts_per_page,
				'post__in' => $include_ids,
				'paged' => $paged,
				'ignore_sticky_posts' => 1,
				'orderby' => $order_by,
				'order' => $order,
			);
			$blog_filter = 'no';
		} else {
			$args = array(
				'post_type' => 'post',
				'post_status'=>'publish',
				'posts_per_page' => $posts_per_page,
				'post__not_in' => $exclude_ids,
				'cat' => $categories,
				'paged' => $paged,
				'ignore_sticky_posts' => 1,
				'orderby' => $order_by,
				'order' => $order,
			);
		}

		$query = new WP_Query( $args );

		$blog_category_ids = array();

		if( ! empty( $categories ) ) {
			$blog_category_ids = explode( ",", $categories );
		}
		if ( 'carousel' != $blog_mode ) {
			$allow_filter = 'yes';
		}
		$category_prefix = '.category-';

		$image_atts = array();

		ob_start();

		if ( $query->have_posts() ) :

?>
		<div class="<?php echo esc_attr( $blog_class_string ); ?>" style="<?php echo $style; ?>" <?php echo $data_string; ?>>
<?php
		//Category Filter
		if ( 'yes' == $blog_filter && 'yes' == $allow_filter ) {

			$filter_classes = array( 'eut-filter' );

			array_push( $filter_classes, 'eut-filter-style-' . $filter_style );
			array_push( $filter_classes, 'eut-align-' . $blog_filter_align);
			array_push( $filter_classes, 'eut-link-text');

			if ( 'button' == $filter_style ) {
				array_push( $filter_classes, 'eut-link-text');
				array_push( $filter_classes, 'eut-filter-shape-' . $filter_shape );
				array_push( $filter_classes, 'eut-filter-color-' . $filter_color );
			}

			$filter_class_string = implode( ' ', $filter_classes );

			$category_filter_list = array();
			$category_filter_array = array();
			$all_string =  apply_filters( 'zuperla_eutf_vce_blog_string_all_categories', esc_html__( 'All', 'zuperla-extension' ) );
			$category_filter_string = '<li data-filter="*" class="selected"><span>' . $all_string . '</span></li>';
			$category_filter_add = false;
			while ( $query->have_posts() ) : $query->the_post();

				if ( $blog_categories = get_the_terms( get_the_ID(), 'category' ) ) {

					foreach($blog_categories as $category_term){
						$category_filter_add = false;
						if ( !in_array($category_term->term_id, $category_filter_list) ) {
							if( ! empty( $blog_category_ids ) ) {
								if ( in_array($category_term->term_id, $blog_category_ids) ) {
									$category_filter_add = true;
								}
							} else {
								$category_filter_add = true;
							}
							if ( $category_filter_add ) {
								$category_filter_list[] = $category_term->term_id;
								if ( 'title' == $filter_order_by ) {
									$category_filter_array[$category_term->name] = $category_term;
								} elseif ( 'slug' == $filter_order_by )  {
									$category_filter_array[$category_term->slug] = $category_term;
								} else {
									$category_filter_array[$category_term->term_id] = $category_term;
								}
							}
						}
					}
				}

			endwhile;


			if ( count( $category_filter_array ) > 1 ) {
				if ( '' != $filter_order_by ) {
					if ( 'ASC' == $filter_order ) {
						ksort( $category_filter_array );
					} else {
						krsort( $category_filter_array );
					}
				}
				foreach($category_filter_array as $category_filter){
					$term_class = sanitize_html_class( $category_filter->slug, $category_filter->term_id );
					if ( is_numeric( $term_class ) || ! trim( $term_class, '-' ) ) {
						$term_class = $category_filter->term_id;
					}

					$category_filter_string .= '<li data-filter="' . $category_prefix . $term_class . '"><span>' . $category_filter->name . '</span></li>';
				}
		?>
				<div class="<?php echo esc_attr( $filter_class_string ); ?>">
					<ul>
						<?php echo $category_filter_string; ?>
					</ul>
				</div>
		<?php
			}
		}

		$image_size = 'zuperla-eutf-small-rect-horizontal';

		if ( 'grid' == $blog_mode || 'blog-small' == $blog_mode ) {
			$blog_image_mode = $blog_grid_image_mode;
		} else if ( 'masonry' == $blog_mode ) {
			$blog_image_mode = $blog_masonry_image_mode;
		}

		if ( 'blog-large' == $blog_mode || 'blog-small' == $blog_mode ) {
?>
			<div class="eut-standard-container">
<?php
		} else if ( 'carousel' == $blog_mode ) {
			$data_string = ' data-items="' . esc_attr( $items_per_page ) . '" data-slider-speed="' . esc_attr( $slideshow_speed ) . '" data-slider-pause="' . esc_attr( $pause_hover ) . '"';
			$data_string .= ' data-pagination-speed="' . esc_attr( $carousel_pagination_speed ) . '"';
			$data_string .= ' data-pagination="' . esc_attr( $carousel_pagination ) . '"';
			$data_string .= ' data-slider-loop="' . esc_attr( $loop ) . '"';
			$data_string .= ' data-slider-autoplay="' . esc_attr( $auto_play ) . '"';

			if ( 'yes' == $item_gutter ) {
				$data_string .= ' data-gutter-size="' . esc_attr( $gutter_size ) . '"';
			}

			if( 'square' == $carousel_image_mode ) {
				$image_size = 'zuperla-eutf-small-square';
			} elseif( 'portrait' == $carousel_image_mode ) {
				$image_size = 'zuperla-eutf-small-rect-vertical';
			} else {
				$image_size = 'zuperla-eutf-small-rect-horizontal';
			}

			//Carousel Navigation
			if( 'layout-2' == $carousel_layout ){
				echo '<div class="eut-carousel-info-wrapper eut-align-' . esc_attr( $align ) . '">';
				echo '  <div class="eut-carousel-info">';
				if( !empty( $title ) ){
					$title_classes = array( 'eut-title' );
					$title_classes[]  = 'eut-' . $heading;
					if ( !empty( $custom_font_family ) ) {
						$title_classes[]  = 'eut-' . $custom_font_family;
					}
					$title_class_string = implode( ' ', $title_classes );
					echo'    <' . tag_escape( $heading_tag ) .' class="' . esc_attr( $title_class_string ) . '">' . $title . '</' . tag_escape( $heading_tag ) .'>';
				}
				if ( !empty( $content ) ) {
					echo '    <p class="eut-description eut-' . esc_attr( $text_style ) . '">' . zuperla_ext_vce_unautop( $content ) . '</p>';
				}
				echo '  </div>';
				echo zuperla_ext_vce_element_navigation( $navigation_type, $navigation_color, 'carousel' );
				echo '</div>';
			}
			echo '  <div class="eut-carousel-wrapper">';
			if( 'layout-1' == $carousel_layout ){
				echo zuperla_ext_vce_element_navigation( $navigation_type, $navigation_color, 'carousel' );
			}

			?>

			<div class="eut-blog eut-blog-carousel eut-carousel-element owl-carousel"<?php echo $data_string; ?>>
<?php
		} else {
?>
			<div class="eut-isotope-container">
<?php
		}

		$zuperla_ext_isotope_start = $zuperla_ext_isotope_end = '';
		if ( 'blog-large' != $blog_mode && 'blog-small' != $blog_mode ) {
			if ( !empty( $animation ) ) {
				$zuperla_ext_isotope_start = '<div class="eut-blog-item-inner eut-isotope-item-inner ' . esc_attr( $animation ) . '">';
			} else {
				$zuperla_ext_isotope_start = '<div class="eut-blog-item-inner eut-isotope-item-inner">';
			}
			$zuperla_ext_isotope_end = '</div>';
		} else {
			if ( !empty( $animation ) ) {
				$zuperla_ext_isotope_start = '<div class="eut-blog-item-inner eut-isotope-item-inner eut-animated-item ' . esc_attr( $animation ) . '" data-delay="200">';
			} else {
				$zuperla_ext_isotope_start = '<div class="eut-blog-item-inner eut-isotope-item-inner">';
			}
			$zuperla_ext_isotope_end = '</div>';
		}


		while ( $query->have_posts() ) : $query->the_post();

			$post_format = get_post_format();
			$bg_post_mode = zuperla_ext_vce_is_post_bg( $blog_mode, $post_format );

			if ( 'link' == $post_format || 'quote' == $post_format ) {
				$zuperla_ext_post_class = zuperla_ext_vce_get_post_class( $blog_mode, 'eut-style-2' );
			} else {
				if ( $bg_post_mode ) {
					$zuperla_ext_post_class = zuperla_ext_vce_get_post_class( $blog_mode, 'eut-style-2' );
				} else {
					$zuperla_ext_post_class = zuperla_ext_vce_get_post_class( $blog_mode );
				}
			}

			if ( 'carousel' == $blog_mode ) {

				if ( '1' == $carousel_style ) {


?>
				<div class="eut-carousel-item">
					<article <?php post_class( 'eut-post-item' ); ?> itemscope itemType="http://schema.org/BlogPosting">
						<?php
							if ( 'yes' == $blog_media_area ) {
								zuperla_ext_vce_print_carousel_media( $carousel_image_mode, $image_atts );
							}
						?>
						<div class="eut-post-content">
							<ul class="eut-post-meta">
								<?php
									if ( 'yes' != $hide_author ) {
										zuperla_ext_vce_print_post_author_by( $blog_mode );
									}
									if ( 'yes' != $hide_date ) {
										zuperla_ext_vce_print_post_date( 'list' );
									}
									if ( 'yes' != $hide_comments ) {
										zuperla_ext_vce_print_post_comments();
									}
									if( 'yes' != $hide_like && function_exists( 'zuperla_eutf_print_like_counter' ) ) {
										zuperla_eutf_print_like_counter();
									}
								?>
							</ul>
							<?php zuperla_ext_vce_print_post_title( $blog_mode, $post_format, $post_title_heading_tag, $post_title_heading ); ?>
							<?php zuperla_ext_vce_print_structured_data(); ?>
							<?php
								if ( 'yes' != $hide_excerpt ) {
									zuperla_ext_vce_print_post_excerpt( $blog_mode, $post_format, $auto_excerpt, $excerpt_length, $excerpt_more );
								}
							?>
						</div>
					</article>
				</div>
<?php
				} else {
?>
				<div class="eut-carousel-item">
					<article <?php post_class( 'eut-post-item' ); ?> itemscope itemType="http://schema.org/BlogPosting">
						<?php
							$bg_options = array(
								'bg_color' => $carousel_bg_color,
								'bg_opacity' => $carousel_bg_opacity,
								'mode' => 'image',
								'image_size' => $image_size,
							);
							zuperla_ext_vce_post_bg_image_container( $bg_options );
						?>
						<div class="eut-post-content-wrapper">
							<div class="eut-post-content eut-align-center">
								<div class="eut-post-container">
									<?php if ( 'yes' != $hide_date ) { ?>
									<div class="eut-post-date eut-text-light">
										<?php zuperla_ext_vce_print_post_date(); ?>
									</div>
									<?php } ?>
									<?php zuperla_ext_vce_print_post_title( $blog_mode, $post_format, $post_title_heading_tag, $post_title_heading ); ?>
									<?php zuperla_ext_vce_print_structured_data(); ?>
									<ul class="eut-post-meta eut-text-light">
										<?php
											if ( 'yes' != $hide_author ) {
												zuperla_ext_vce_print_post_author_by( $blog_mode );
											}
											if ( 'yes' != $hide_comments ) {
												zuperla_ext_vce_print_post_comments();
											}
											if( 'yes' != $hide_like && function_exists( 'zuperla_eutf_print_like_counter' ) ) {
												zuperla_eutf_print_like_counter();
											}
										?>
									</ul>
								</div>
							</div>
						</div>
					</article>
				</div>
<?php
				}
			} else {
?>
			<article <?php post_class( $zuperla_ext_post_class ); ?> itemscope itemType="http://schema.org/BlogPosting">
				<?php echo $zuperla_ext_isotope_start; ?>

					<?php if ( 'link' != $post_format && 'quote' != $post_format ) { ?>
						<?php
							if ( $bg_post_mode ) {
								zuperla_ext_vce_print_post_bg_media( $blog_mode, $post_format );
							} else {
								if ( 'yes' == $blog_media_area ) {
									zuperla_ext_vce_print_post_feature_media( $blog_mode, $post_format, $blog_image_mode, $blog_image_prio, $image_atts );
								}
							}
						?>
						<div class="eut-post-content-wrapper">
							<div class="eut-post-content">
								<div class="eut-post-header">
									<?php if ( $bg_post_mode &&  'video' == $post_format ) { ?>
									<?php zuperla_ext_vce_print_post_video_popup(); ?>
									<?php } ?>
									<?php zuperla_ext_vce_print_structured_data(); ?>
									<?php if ( 'yes' != $hide_date || 'yes' != $hide_author || 'yes' != $hide_comments || 'yes' != $hide_like ) { ?>
										<ul class="eut-post-meta">
										<?php
											if ( 'yes' != $hide_author ) {
												zuperla_ext_vce_print_post_author_by( $blog_mode );
											}
											if ( 'yes' != $hide_date ) {
												zuperla_ext_vce_print_post_date( 'list' );
											}
											if ( 'yes' != $hide_comments ) {
												zuperla_ext_vce_print_post_comments();
											}
											if( 'yes' != $hide_like && function_exists( 'zuperla_eutf_print_like_counter' ) ) {
												zuperla_eutf_print_like_counter();
											}
										?>
										</ul>
									<?php } ?>
									<?php zuperla_ext_vce_print_post_title( $blog_mode, $post_format, $post_title_heading_tag, $post_title_heading ); ?>
								</div>
								<?php zuperla_ext_vce_print_post_excerpt( $blog_mode, $post_format, $auto_excerpt, $excerpt_length, $excerpt_more ); ?>
							</div>
						</div>
					<?php
					 } else {
				 	?>
						<?php zuperla_ext_vce_print_post_loop( $blog_mode, $post_format, $post_title_heading_tag, $post_title_heading, $auto_excerpt, $excerpt_length, $excerpt_more ); ?>
						<?php zuperla_ext_vce_print_structured_data(); ?>
					<?php }?>

				<?php echo $zuperla_ext_isotope_end; ?>
			</article>

<?php
			}

		endwhile;
			if ( 'carousel' == $blog_mode ) {
				echo '</div>';
			}
?>
			</div>
<?php
			if ( 'yes' != $disable_pagination ) {
				$total = $query->max_num_pages;
				$big = 999999999; // need an unlikely integer
				if( $total > 1 )  {
					 echo '<div class="eut-pagination eut-pagination-text eut-heading-color">';

					 if( get_option('permalink_structure') ) {
						 $format = 'page/%#%/';
					 } else {
						 $format = '&paged=%#%';
					 }
					 echo paginate_links(array(
						'base'			=> str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
						'format'		=> $format,
						'current'		=> max( 1, $paged ),
						'total'			=> $total,
						'mid_size'		=> 2,
						'type'			=> 'list',
						'prev_text'	=> '<i class="eut-icon-nav-left"></i>',
						'next_text'	=> '<i class="eut-icon-nav-right"></i>',
						'add_args' => false,
					 ));
					 echo '</div>';
				}
			}
?>
		</div>
<?php
		else :
		endif;

		wp_reset_postdata();

		return ob_get_clean();


	}
	add_shortcode( 'zuperla_blog', 'zuperla_ext_vce_blog_shortcode' );

}

/**
 * Add shortcode to Visual Composer
 */

if( !function_exists( 'zuperla_ext_vce_blog_shortcode_params' ) ) {
	function zuperla_ext_vce_blog_shortcode_params( $tag ) {
		return array(
			"name" => esc_html__( "Blog", "zuperla-extension" ),
			"description" => esc_html__( "Display a Blog element in multiple styles", "zuperla-extension" ),
			"base" => $tag,
			"class" => "",
			"icon"      => "icon-wpb-eut-blog",
			"category" => esc_html__( "Content", "js_composer" ),
			"params" => array(
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Blog Mode", "zuperla-extension" ),
					"param_name" => "blog_mode",
					"admin_label" => true,
					'value' => array(
						esc_html__( 'Large Media', 'zuperla-extension' ) => 'blog-large',
						esc_html__( 'Small Media', 'zuperla-extension' ) => 'blog-small',
						esc_html__( 'Masonry' , 'zuperla-extension' ) => 'masonry',
						esc_html__( 'Grid' , 'zuperla-extension' ) => 'grid',
						esc_html__( 'Carousel' , 'zuperla-extension' ) => 'carousel',
					),
					"description" => esc_html__( "Select your Blog Mode.", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Media Area Visibility", "zuperla-extension" ),
					"param_name" => "blog_media_area",
					"value" => array(
						esc_html__( "Yes", "zuperla-extension" ) => 'yes',
						esc_html__( "No", "zuperla-extension" ) => 'no',
					),
					"std" => 'yes',
					"description" => esc_html__( "Select if you want to enable/disable media area", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Image Size", "zuperla-extension" ),
					"param_name" => "blog_image_mode",
					'value' => array(
						esc_html__( 'Landscape Large Wide Crop', 'zuperla-extension' ) => 'landscape-large-wide',
						esc_html__( 'Landscape Medium Crop', 'zuperla-extension' ) => 'landscape-medium',
						esc_html__( 'Resize ( Extra Extra Large )' , 'zuperla-extension' ) => 'extra-extra-large',
						esc_html__( 'Resize ( Large )', 'zuperla-extension' ) => 'large',
						esc_html__( 'Resize ( Medium Large )', 'zuperla-extension' ) => 'medium_large',
						esc_html__( 'Resize ( Medium )', 'zuperla-extension' ) => 'medium',
					),
					'std' => '',
					"description" => esc_html__( "Select your Blog Image Size.", "zuperla-extension" ),
					"dependency" => array( 'element' => "blog_mode", 'value' => array( 'blog-large' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Grid Image Size", "zuperla-extension" ),
					"param_name" => "blog_grid_image_mode",
					'value' => array(
						esc_html__( 'Square Small Crop', 'zuperla-extension' ) => 'square',
						esc_html__( 'Landscape Small Crop', 'zuperla-extension' ) => 'landscape',
						esc_html__( 'Landscape Medium Crop', 'zuperla-extension' ) => 'landscape-medium',
						esc_html__( 'Portrait Small Crop', 'zuperla-extension' ) => 'portrait',
						esc_html__( 'Portrait Medium Crop', 'zuperla-extension' ) => 'portrait-medium',
						esc_html__( 'Resize ( Large )', 'zuperla-extension' ) => 'large',
						esc_html__( 'Resize ( Medium Large )', 'zuperla-extension' ) => 'medium_large',
						esc_html__( 'Resize ( Medium )', 'zuperla-extension' ) => 'medium',
					),
					'std' => 'landscape',
					"description" => esc_html__( "Select your Blog Grid Image Size.", "zuperla-extension" ),
					"dependency" => array( 'element' => "blog_mode", 'value' => array( 'blog-small', 'grid' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Masonry Image Size", "zuperla-extension" ),
					"param_name" => "blog_masonry_image_mode",
					'value' => array(
						esc_html__( 'Resize ( Large )', 'zuperla-extension' ) => 'large',
						esc_html__( 'Resize ( Medium Large )', 'zuperla-extension' ) => 'medium_large',
						esc_html__( 'Resize ( Medium )', 'zuperla-extension' ) => 'medium',
					),
					'std' => 'medium',
					"description" => esc_html__( "Select your Blog Masonry Image Size.", "zuperla-extension" ),
					"dependency" => array( 'element' => "blog_mode", 'value' => array( 'masonry' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Carousel Image Size", "zuperla-extension" ),
					"param_name" => "carousel_image_mode",
					'value' => array(
						esc_html__( 'Square Small Crop', 'zuperla-extension' ) => 'square',
						esc_html__( 'Landscape Small Crop', 'zuperla-extension' ) => 'landscape',
						esc_html__( 'Portrait Small Crop', 'zuperla-extension' ) => 'portrait',
					),
					'std' => 'landscape',
					"description" => esc_html__( "Select your Carousel Image Size.", "zuperla-extension" ),
					"dependency" => array( 'element' => "blog_mode", 'value' => array( 'carousel' ) ),
				),
				array(
					"type" => 'checkbox',
					"heading" => esc_html__( "Featured Image Priority", "zuperla-extension" ),
					"param_name" => "blog_image_prio",
					"description" => esc_html__( "Featured image is displayed instead of media element", "zuperla-extension" ),
					"value" => array( esc_html__( "Featured Image Priority", "zuperla-extension" ) => 'yes' ),
					"dependency" => array( 'element' => "blog_mode", 'value' => array( 'blog-large', 'blog-small','grid', 'masonry' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Large Screen Columns", "zuperla-extension" ),
					"param_name" => "columns_large_screen",
					"value" => array( '2', '3', '4', '5' ),
					"std" => '3',
					"description" => esc_html__( "Select your Blog Columns.", "zuperla-extension" ),
					"dependency" => array( 'element' => "blog_mode", 'value' => array( 'grid', 'masonry' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Columns", "zuperla-extension" ),
					"param_name" => "columns",
					"value" => array( '2', '3', '4', '5' ),
					"std" => '3',
					"description" => esc_html__( "Select your Blog Columns.", "zuperla-extension" ),
					"dependency" => array( 'element' => "blog_mode", 'value' => array( 'grid', 'masonry' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Tablet Landscape Columns", "zuperla-extension" ),
					"param_name" => "columns_tablet_landscape",
					"value" => array( '2', '3', '4' ),
					"std" => '2',
					"description" => esc_html__( "Select responsive column on tablet devices, landscape orientation.", "zuperla-extension" ),
					"dependency" => array( 'element' => "blog_mode", 'value' => array( 'grid', 'masonry' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Tablet Portrait Columns", "zuperla-extension" ),
					"param_name" => "columns_tablet_portrait",
					"value" => array( '2', '3', '4' ),
					"std" => '2',
					"description" => esc_html__( "Select responsive column on tablet devices, portrait orientation.", "zuperla-extension" ),
					"dependency" => array( 'element' => "blog_mode", 'value' => array( 'grid', 'masonry' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Mobile Columns", "zuperla-extension" ),
					"param_name" => "columns_mobile",
					"value" => array( '1', '2' ),
					"std" => '1',
					"description" => esc_html__( "Select responsive column on mobile devices.", "zuperla-extension" ),
					"dependency" => array( 'element' => "blog_mode", 'value' => array( 'grid', 'masonry' ) ),
				),
				array(
					"type" => 'checkbox',
					"heading" => esc_html__( "Auto excerpt", "zuperla-extension" ),
					"param_name" => "auto_excerpt",
					"description" => esc_html__( "Adds automatic excerpt to all posts in Large Media style. If auto excerpt is not selected, blog will show all content, a desired 'cut-off' point can be inserted in each post with more quicktag.", "zuperla-extension" ),
					"value" => array( esc_html__( "Activate auto excerpt.", "zuperla-extension" ) => 'yes' ),
					"dependency" => array( 'element' => "blog_mode", 'value' => array( 'blog-large' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Gutter between images", "zuperla-extension" ),
					"param_name" => "item_gutter",
					"value" => array(
						esc_html__( "Yes", "zuperla-extension" ) => 'yes',
						esc_html__( "No", "zuperla-extension" ) => 'no',
					),
					"description" => esc_html__( "Add gutter among items.", "zuperla-extension" ),
					"dependency" => array( 'element' => "blog_mode", 'value' => array( 'grid', 'masonry', 'carousel' ) ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Gutter Size", "zuperla-extension" ),
					"param_name" => "gutter_size",
					"value" => '40',
					"dependency" => array( 'element' => "item_gutter", 'value' => array( 'yes' ) ),
				),
				array(
					"type" => 'textfield',
					"heading" => esc_html__( "Excerpt length", "zuperla-extension" ),
					"param_name" => "excerpt_length",
					"description" => esc_html__( "Type how many words you want to display in your post excerpts.", "zuperla-extension" ),
					"value" => '55',
					"dependency" => array( 'element' => "blog_mode", 'value' => array( 'blog-large', 'blog-small','grid', 'masonry', 'carousel' ) ),
				),
				array(
					"type" => 'checkbox',
					"heading" => esc_html__( "Read more", "zuperla-extension" ),
					"param_name" => "excerpt_more",
					"description" => esc_html__( "Adds a read more button after the excerpt or more quicktag", "zuperla-extension" ),
					"value" => array( esc_html__( "Add more button", "zuperla-extension" ) => 'yes' ),
					"dependency" => array( 'element' => "blog_mode", 'value' => array( 'blog-large', 'blog-small','grid', 'masonry' ) ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Posts per Page", "zuperla-extension" ),
					"param_name" => "posts_per_page",
					"value" => "10",
					"description" => esc_html__( "Enter how many posts per page you want to display.", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Items per page", "zuperla-extension" ),
					"param_name" => "items_per_page",
					"value" => array( '3', '4', '5' ),
					"description" => esc_html__( "Number of items per page", "zuperla-extension" ),
					"dependency" => array( 'element' => "blog_mode", 'value' => array( 'carousel' ) ),
					"std" => '4',
				),
				zuperla_ext_vce_add_order_by(),
				zuperla_ext_vce_add_order(),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "CSS Animation", "zuperla-extension"),
					"param_name" => "animation",
					"value" => array(
						esc_html__( "No", "zuperla-extension" ) => '',
						esc_html__( "Fade In", "zuperla-extension" ) => "eut-fade-in",
						esc_html__( "Fade In Up", "zuperla-extension" ) => "eut-fade-in-up",
						esc_html__( "Fade In Down", "zuperla-extension" ) => "eut-fade-in-down",
						esc_html__( "Fade In Left", "zuperla-extension" ) => "eut-fade-in-left",
						esc_html__( "Fade In Right", "zuperla-extension" ) => "eut-fade-in-right",
						esc_html__( "Zoom In", "zuperla-extension" ) => "eut-zoom-in",
					),
					"dependency" => array( 'element' => "blog_mode", 'value' => array( 'blog-large', 'blog-small','grid', 'masonry' ) ),
					"description" => esc_html__("Select type of animation if you want this element to be animated when it enters into the browsers viewport. Note: Works only in modern browsers.", "zuperla-extension" ),
					"std" => '',
				),
				zuperla_ext_vce_add_margin_bottom(),
				zuperla_ext_vce_add_el_class(),
				//Navigation
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Carousel Layout", "zuperla-extension" ),
					"param_name" => "carousel_layout",
					"value" => array(
						esc_html__( "Classic", "zuperla-extension" ) => 'layout-1',
						esc_html__( "Top Navigation with Title/Text", "zuperla-extension" ) => 'layout-2',
					),
					"description" => 'Select your layout for Carousel Element',
					"dependency" => array( 'element' => "blog_mode", 'value' => array( 'carousel' ) ),
					"group" => esc_html__( "Navigation", "zuperla-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Carousel Title", "zuperla-extension" ),
					"param_name" => "title",
					"value" => "Sample Title",
					"description" => esc_html__( "Enter your carousel title here.", "zuperla-extension" ),
					"save_always" => true,
					"dependency" => array( 'element' => "carousel_layout", 'value' => array( 'layout-2' ) ),
					"group" => esc_html__( "Navigation", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Carousel Title Tag", "zuperla-extension" ),
					"param_name" => "heading_tag",
					"value" => array(
						esc_html__( "h1", "zuperla-extension" ) => 'h1',
						esc_html__( "h2", "zuperla-extension" ) => 'h2',
						esc_html__( "h3", "zuperla-extension" ) => 'h3',
						esc_html__( "h4", "zuperla-extension" ) => 'h4',
						esc_html__( "h5", "zuperla-extension" ) => 'h5',
						esc_html__( "h6", "zuperla-extension" ) => 'h6',
						esc_html__( "div", "zuperla-extension" ) => 'div',
					),
					"description" => esc_html__( "Title Tag for SEO", "zuperla-extension" ),
					"std" => 'h3',
					"dependency" => array( 'element' => "carousel_layout", 'value' => array( 'layout-2' ) ),
					"group" => esc_html__( "Navigation", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Carousel Title Size/Typography", "zuperla-extension" ),
					"param_name" => "heading",
					"value" => array(
						esc_html__( "h1", "zuperla-extension" ) => 'h1',
						esc_html__( "h2", "zuperla-extension" ) => 'h2',
						esc_html__( "h3", "zuperla-extension" ) => 'h3',
						esc_html__( "h4", "zuperla-extension" ) => 'h4',
						esc_html__( "h5", "zuperla-extension" ) => 'h5',
						esc_html__( "h6", "zuperla-extension" ) => 'h6',
						esc_html__( "Leader Text", "zuperla-extension" ) => 'leader-text',
						esc_html__( "Subtitle Text", "zuperla-extension" ) => 'subtitle-text',
						esc_html__( "Small Text", "zuperla-extension" ) => 'small-text',
						esc_html__( "Link Text", "zuperla-extension" ) => 'link-text',
					),
					"description" => esc_html__( "Carousel Title size and typography, defined in Theme Options - Typography Options", "zuperla-extension" ),
					"std" => 'h3',
					"dependency" => array( 'element' => "carousel_layout", 'value' => array( 'layout-2' ) ),
					"group" => esc_html__( "Navigation", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Carousel Title Custom Font Family", "zuperla-extension" ),
					"param_name" => "custom_font_family",
					"value" => array(
						esc_html__( "Same as Typography", "zuperla-extension" ) => '',
						esc_html__( "Custom Font Family 1", "zuperla-extension" ) => 'custom-font-1',
						esc_html__( "Custom Font Family 2", "zuperla-extension" ) => 'custom-font-2',
						esc_html__( "Custom Font Family 3", "zuperla-extension" ) => 'custom-font-3',
						esc_html__( "Custom Font Family 4", "zuperla-extension" ) => 'custom-font-4',

					),
					"description" => esc_html__( "Select a different font family, defined in Theme Options - Typography Options - Extras - Custom Font Family", "zuperla-extension" ),
					"std" => '',
					"dependency" => array( 'element' => "carousel_layout", 'value' => array( 'layout-2' ) ),
					"group" => esc_html__( "Navigation", "zuperla-extension" ),
				),
				array(
					"type" => "textarea",
					"heading" => esc_html__( "Carousel Text", "zuperla-extension" ),
					"param_name" => "content",
					"value" => "",
					"description" => esc_html__( "Type your text.", "zuperla-extension" ),
					"dependency" => array( 'element' => "carousel_layout", 'value' => array( 'layout-2' ) ),
					"group" => esc_html__( "Navigation", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Carousel Text Style", "zuperla-extension" ),
					"param_name" => "text_style",
					"value" => array(
						esc_html__( "None", "zuperla-extension" ) => '',
						esc_html__( "Leader", "zuperla-extension" ) => 'leader-text',
						esc_html__( "Subtitle", "zuperla-extension" ) => 'subtitle',
					),
					"description" => 'Select your text style',
					"dependency" => array( 'element' => "carousel_layout", 'value' => array( 'layout-2' ) ),
					"group" => esc_html__( "Navigation", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Carousel Alignment", "zuperla-extension" ),
					"param_name" => "align",
					"value" => array(
						esc_html__( "Left", "zuperla-extension" ) => 'left',
						esc_html__( "Right", "zuperla-extension" ) => 'right',
						esc_html__( "Center", "zuperla-extension" ) => 'center',
					),
					"description" => '',
					"dependency" => array( 'element' => "carousel_layout", 'value' => array( 'layout-2' ) ),
					"group" => esc_html__( "Navigation", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Navigation Type", "zuperla-extension" ),
					"param_name" => "navigation_type",
					'value' => array(
						esc_html__( 'Style 1' , 'zuperla-extension' ) => '1',
						esc_html__( 'No Navigation' , 'zuperla-extension' ) => '0',
					),
					"description" => esc_html__( "Select your Navigation type.", "zuperla-extension" ),
					"dependency" => array( 'element' => "blog_mode", 'value' => array( 'carousel' ) ),
					"group" => esc_html__( "Navigation", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Navigation Color", "zuperla-extension" ),
					"param_name" => "navigation_color",
					'value' => array(
						esc_html__( 'Dark' , 'zuperla-extension' ) => 'dark',
						esc_html__( 'Light' , 'zuperla-extension' ) => 'light',
					),
					"description" => esc_html__( "Select the background Navigation color.", "zuperla-extension" ),
					"dependency" => array( 'element' => "blog_mode", 'value' => array( 'carousel' ) ),
					"group" => esc_html__( "Navigation", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Carousel Pagination", "zuperla-extension" ),
					"param_name" => "carousel_pagination",
					"value" => array(
						esc_html__( "No", "zuperla-extension" ) => 'no',
						esc_html__( "Yes", "zuperla-extension" ) => 'yes',
					),
					"std" => 'no',
					"dependency" => array( 'element' => "blog_mode", 'value' => array( 'carousel' ) ),
					"group" => esc_html__( "Navigation", "zuperla-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Carousel Pagination Speed", "zuperla-extension" ),
					"param_name" => "carousel_pagination_speed",
					"value" => '400',
					"description" => esc_html__( "Pagination Speed in ms.", "zuperla-extension" ),
					"dependency" => array( 'element' => "blog_mode", 'value' => array( 'carousel' ) ),
					"group" => esc_html__( "Navigation", "zuperla-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Slideshow Speed", "zuperla-extension" ),
					"param_name" => "slideshow_speed",
					"value" => '3000',
					"description" => esc_html__( "Slideshow Speed in ms.", "zuperla-extension" ),
					"dependency" => array( 'element' => "blog_mode", 'value' => array( 'carousel' ) ),
					"group" => esc_html__( "Navigation", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Loop", "zuperla-extension" ),
					"param_name" => "loop",
					"value" => array(
						esc_html__( "Yes", "zuperla-extension" ) => 'yes',
						esc_html__( "No", "zuperla-extension" ) => 'no',
					),
					"dependency" => array( 'element' => "blog_mode", 'value' => array( 'carousel' ) ),
					"group" => esc_html__( "Navigation", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Autoplay", "zuperla-extension" ),
					"param_name" => "auto_play",
					"value" => array(
						esc_html__( "Yes", "zuperla-extension" ) => 'yes',
						esc_html__( "No", "zuperla-extension" ) => 'no',
					),
					"dependency" => array( 'element' => "blog_mode", 'value' => array( 'carousel' ) ),
					"group" => esc_html__( "Navigation", "zuperla-extension" ),
				),
				array(
					"type" => 'checkbox',
					"heading" => esc_html__( "Pause on Hover", "zuperla-extension" ),
					"param_name" => "pause_hover",
					"value" => array( esc_html__( "If selected, carousel will be paused on hover", "zuperla-extension" ) => 'yes' ),
					"dependency" => array( 'element' => "blog_mode", 'value' => array( 'carousel' ) ),
					"group" => esc_html__( "Navigation", "zuperla-extension" ),
				),
				//Titles & Styles
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Blog Style", "zuperla-extension" ),
					"param_name" => "blog_shadow_style",
					'value' => array(
						esc_html__( 'With Shadow', 'zuperla-extension' ) => 'shadow-mode',
						esc_html__( 'Without Shadow', 'zuperla-extension' ) => 'no-shadow-mode',
					),
					"description" => esc_html__( "Select your Blog Style.", "zuperla-extension" ),
					"dependency" => array( 'element' => "blog_mode", 'value' => array( 'grid', 'masonry' ) ),
					"group" => esc_html__( "Titles & Styles", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Post Title Tag", "zuperla-extension" ),
					"param_name" => "post_title_heading_tag",
					"value" => array(
						esc_html__( "h1", "zuperla-extension" ) => 'h1',
						esc_html__( "h2", "zuperla-extension" ) => 'h2',
						esc_html__( "h3", "zuperla-extension" ) => 'h3',
						esc_html__( "h4", "zuperla-extension" ) => 'h4',
						esc_html__( "h5", "zuperla-extension" ) => 'h5',
						esc_html__( "h6", "zuperla-extension" ) => 'h6',
						esc_html__( "div", "zuperla-extension" ) => 'div',
					),
					"description" => esc_html__( "Post Title Tag for SEO", "zuperla-extension" ),
					"std" => 'h2',
					"group" => esc_html__( "Titles & Styles", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Post Title Size/Typography", "zuperla-extension" ),
					"param_name" => "post_title_heading",
					"value" => array(
						esc_html__( "Auto", "zuperla-extension" ) => 'auto',
						esc_html__( "h1", "zuperla-extension" ) => 'h1',
						esc_html__( "h2", "zuperla-extension" ) => 'h2',
						esc_html__( "h3", "zuperla-extension" ) => 'h3',
						esc_html__( "h4", "zuperla-extension" ) => 'h4',
						esc_html__( "h5", "zuperla-extension" ) => 'h5',
						esc_html__( "h6", "zuperla-extension" ) => 'h6',
						esc_html__( "Leader Text", "zuperla-extension" ) => 'leader-text',
						esc_html__( "Subtitle Text", "zuperla-extension" ) => 'subtitle-text',
						esc_html__( "Small Text", "zuperla-extension" ) => 'small-text',
						esc_html__( "Link Text", "zuperla-extension" ) => 'link-text',
					),
					"description" => esc_html__( "Post Title size and typography, defined in Theme Options - Typography Options", "zuperla-extension" ),
					"std" => 'auto',
					"group" => esc_html__( "Titles & Styles", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Carousel Style", "zuperla-extension" ),
					"param_name" => "carousel_style",
					'value' => array(
						esc_html__( 'Content below image', 'zuperla-extension' ) => '1',
						esc_html__( 'Content inside image', 'zuperla-extension' ) => '2',
					),
					'std' => '1',
					"description" => esc_html__( "Select your Carousel Style.", "zuperla-extension" ),
					"dependency" => array( 'element' => "blog_mode", 'value' => array( 'carousel' ) ),
					"group" => esc_html__( "Titles & Styles", "zuperla-extension" ),
				),
				array(
					"type" => 'checkbox',
					"heading" => esc_html__( "Hide Excerpt", "zuperla-extension" ),
					"param_name" => "hide_excerpt",
					"description" => esc_html__( "If selected, blog overview will not show excerpt.", "zuperla-extension" ),
					"value" => array( esc_html__( "Hide Excerpt.", "zuperla-extension" ) => 'yes' ),
					"dependency" => array( 'element' => "carousel_style", 'value' => array( '1' ) ),
					"group" => esc_html__( "Titles & Styles", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Carousel Background Color", "zuperla-extension" ),
					"param_name" => "carousel_bg_color",
					"param_holder_class" => "eut-colored-dropdown",
					"value" => array(
						esc_html__( "Primary 1", "zuperla-extension" ) => 'primary-1',
						esc_html__( "Primary 2", "zuperla-extension" ) => 'primary-2',
						esc_html__( "Primary 3", "zuperla-extension" ) => 'primary-3',
						esc_html__( "Primary 4", "zuperla-extension" ) => 'primary-4',
						esc_html__( "Primary 5", "zuperla-extension" ) => 'primary-5',
						esc_html__( "Primary 6", "zuperla-extension" ) => 'primary-6',
						esc_html__( "Green", "zuperla-extension" ) => 'green',
						esc_html__( "Orange", "zuperla-extension" ) => 'orange',
						esc_html__( "Red", "zuperla-extension" ) => 'red',
						esc_html__( "Blue", "zuperla-extension" ) => 'blue',
						esc_html__( "Aqua", "zuperla-extension" ) => 'aqua',
						esc_html__( "Purple", "zuperla-extension" ) => 'purple',
						esc_html__( "Black", "zuperla-extension" ) => 'black',
						esc_html__( "Grey", "zuperla-extension" ) => 'grey',
					),
					'std' => 'black',
					"description" => esc_html__( "This affects the Background of the item.", "zuperla-extension" ),
					"dependency" => array( 'element' => "carousel_style", 'value' => array( '2' ) ),
					"group" => esc_html__( "Titles & Styles", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Carousel Background Opacity", "zuperla-extension" ),
					"param_name" => "carousel_bg_opacity",
					"value" => array( '0', '10', '20', '30', '40', '50', '60', '70', '80', '90', '100' ),
					"std" => '40',
					"description" => esc_html__( "Choose the opacity for the overlay.", "zuperla-extension" ),
					"dependency" => array( 'element' => "carousel_style", 'value' => array( '2' ) ),
					"group" => esc_html__( "Titles & Styles", "zuperla-extension" ),
				),
				array(
					"type" => 'checkbox',
					"heading" => esc_html__( "Enable Loader", "zuperla-extension" ),
					"param_name" => "item_spinner",
					"description" => esc_html__( "If selected, this will enable a graphic spinner before load.", "zuperla-extension" ),
					"value" => array( esc_html__( "Enable Loader.", "zuperla-extension" ) => 'yes' ),
					"dependency" => array( 'element' => "blog_mode", 'value' => array( 'grid', 'masonry' ) ),
					"group" => esc_html__( "Extras", "zuperla-extension" ),
				),
				array(
					"type" => 'checkbox',
					"heading" => esc_html__( "Disable Pagination", "zuperla-extension" ),
					"param_name" => "disable_pagination",
					"description" => esc_html__( "If selected, pagination will not be shown.", "zuperla-extension" ),
					"value" => array( esc_html__( "Disable Pagination.", "zuperla-extension" ) => 'yes' ),
					"dependency" => array( 'element' => "blog_mode", 'value' => array( 'blog-large', 'blog-small','grid', 'masonry' ) ),
					"group" => esc_html__( "Extras", "zuperla-extension" ),
				),
				array(
					"type" => 'checkbox',
					"heading" => esc_html__( "Hide Author", "zuperla-extension" ),
					"param_name" => "hide_author",
					"description" => esc_html__( "If selected, blog overview will not show author.", "zuperla-extension" ),
					"value" => array( esc_html__( "Hide Author.", "zuperla-extension" ) => 'yes' ),
					"group" => esc_html__( "Extras", "zuperla-extension" ),
				),
				array(
					"type" => 'checkbox',
					"heading" => esc_html__( "Hide Date", "zuperla-extension" ),
					"param_name" => "hide_date",
					"description" => esc_html__( "If selected, blog overview will not show date.", "zuperla-extension" ),
					"value" => array( esc_html__( "Hide Date.", "zuperla-extension" ) => 'yes' ),
					"group" => esc_html__( "Extras", "zuperla-extension" ),
				),
				array(
					"type" => 'checkbox',
					"heading" => esc_html__( "Hide Comments", "zuperla-extension" ),
					"param_name" => "hide_comments",
					"description" => esc_html__( "If selected, blog overview will not show comments.", "zuperla-extension" ),
					"value" => array( esc_html__( "Hide Comments.", "zuperla-extension" ) => 'yes' ),
					"group" => esc_html__( "Extras", "zuperla-extension" ),
				),
				array(
					"type" => 'checkbox',
					"heading" => esc_html__( "Hide Like", "zuperla-extension" ),
					"param_name" => "hide_like",
					"description" => esc_html__( "If selected, blog overview will not show like.", "zuperla-extension" ),
					"value" => array( esc_html__( "Hide Like.", "zuperla-extension" ) => 'yes' ),
					"group" => esc_html__( "Extras", "zuperla-extension" ),
				),
				array(
					"type" => 'dropdown',
					"heading" => esc_html__( "Filter", "zuperla-extension" ),
					"param_name" => "blog_filter",
					"value" => array(
						esc_html__( "No", "zuperla-extension" ) => '',
						esc_html__( "Yes", "zuperla-extension" ) => 'yes',
					),
					"description" => esc_html__( "If selected, an isotope filter will be displayed.", "zuperla-extension" ) . " " . esc_html__( "Enable Blog Filter ( Only for All or Multiple Categories )", "zuperla-extension" ),
					"dependency" => array( 'element' => "blog_mode", 'value' => array( 'blog-large', 'blog-small','grid', 'masonry' ) ),
					"group" => esc_html__( "Filters", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Filter Order By", "zuperla-extension" ),
					"param_name" => "filter_order_by",
					"value" => array(
						esc_html__( "Default ( Unordered )", "zuperla-extension" ) => '',
						esc_html__( "ID", "zuperla-extension" ) => 'id',
						esc_html__( "Slug", "zuperla-extension" ) => 'slug',
						esc_html__( "Title", "zuperla-extension" ) => 'title',
					),
					"description" => '',
					"dependency" => array( 'element' => "blog_filter", 'value' => array( 'yes' ) ),
					"group" => esc_html__( "Filters", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Filter Order", "zuperla-extension" ),
					"param_name" => "filter_order",
					"value" => array(
						esc_html__( "Ascending", "zuperla-extension" ) => 'ASC',
						esc_html__( "Descending", "zuperla-extension" ) => 'DESC',
					),
					"dependency" => array( 'element' => "blog_filter", 'value' => array( 'yes' ) ),
					"description" => '',
					"group" => esc_html__( "Filters", "zuperla-extension" ),
				),

				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Filter Style", "zuperla-extension" ),
					"param_name" => "filter_style",
					"value" => array(
						esc_html__( "Simple", "zuperla-extension" ) => 'simple',
						esc_html__( "Button", "zuperla-extension" ) => 'button',

					),
					"dependency" => array( 'element' => "blog_filter", 'value' => array( 'yes' ) ),
					"group" => esc_html__( "Filters", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Filter Shape", "zuperla-extension" ),
					"param_name" => "filter_shape",
					"value" => array(
						esc_html__( "Square", "zuperla-extension" ) => 'square',
						esc_html__( "Round", "zuperla-extension" ) => 'round',
						esc_html__( "Extra Round", "zuperla-extension" ) => 'extra-round',
					),
					"dependency" => array( 'element' => "filter_style", 'value' => array( 'button' ) ),
					"group" => esc_html__( "Filters", "zuperla-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Filter Color", "zuperla-extension" ),
					"param_name" => "filter_color",
					"param_holder_class" => "eut-colored-dropdown",
					"value" => array(
						esc_html__( "Primary 1", "zuperla-extension" ) => 'primary-1',
						esc_html__( "Primary 2", "zuperla-extension" ) => 'primary-2',
						esc_html__( "Primary 3", "zuperla-extension" ) => 'primary-3',
						esc_html__( "Primary 4", "zuperla-extension" ) => 'primary-4',
						esc_html__( "Primary 5", "zuperla-extension" ) => 'primary-5',
						esc_html__( "Primary 6", "zuperla-extension" ) => 'primary-6',
						esc_html__( "Green", "zuperla-extension" ) => 'green',
						esc_html__( "Orange", "zuperla-extension" ) => 'orange',
						esc_html__( "Red", "zuperla-extension" ) => 'red',
						esc_html__( "Blue", "zuperla-extension" ) => 'blue',
						esc_html__( "Aqua", "zuperla-extension" ) => 'aqua',
						esc_html__( "Purple", "zuperla-extension" ) => 'purple',
						esc_html__( "Black", "zuperla-extension" ) => 'black',
						esc_html__( "Grey", "zuperla-extension" ) => 'grey',
						esc_html__( "White", "zuperla-extension" ) => 'white',
					),
					"dependency" => array( 'element' => "filter_style", 'value' => array( 'button' ) ),
					"group" => esc_html__( "Filters", "zuperla-extension" ),
				),

				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Filter Alignment", "zuperla-extension" ),
					"param_name" => "blog_filter_align",
					"value" => array(
						esc_html__( "Left", "zuperla-extension" ) => 'left',
						esc_html__( "Right", "zuperla-extension" ) => 'right',
						esc_html__( "Center", "zuperla-extension" ) => 'center',
					),
					"description" => '',
					"dependency" => array( 'element' => "blog_filter", 'value' => array( 'yes' ) ),
					"group" => esc_html__( "Filters", "zuperla-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__("Exclude Posts", "zuperla-extension" ),
					"param_name" => "exclude_posts",
					"value" => '',
					"description" => esc_html__( "Type the post ids you want to exclude separated by comma ( , ).", "zuperla-extension" ),
					"group" => esc_html__( "Categories", "zuperla-extension" ),
				),
				array(
					"type" => "zuperla_ext_multi_checkbox",
					"heading" => esc_html__("Categories", "zuperla-extension" ),
					"param_name" => "categories",
					"value" => zuperla_ext_vce_get_post_categories(),
					"description" => esc_html__( "Select all or multiple categories.", "zuperla-extension" ),
					"group" => esc_html__( "Categories", "zuperla-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__("Include Specific Posts", "zuperla-extension" ),
					"param_name" => "include_posts",
					"value" => '',
					"description" => esc_html__( "Type the specific post ids you want to include separated by comma ( , ). Note: If you define specific post ids, Exclude Posts and Categories will have no effect.", "zuperla-extension" ),
					"group" => esc_html__( "Categories", "zuperla-extension" ),
				),
			),
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'zuperla_blog', 'zuperla_ext_vce_blog_shortcode_params' );
} else if( function_exists( 'vc_map' ) ) {
	$attributes = zuperla_ext_vce_blog_shortcode_params( 'zuperla_blog' );
	vc_map( $attributes );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
