<?php
/*
*	Testimonial Post Type Registration
*
* 	@author		Euthemians Team
* 	@URI		http://euthemians.com
*/

if ( ! class_exists( 'Zuperla_Testimonial_Post_Type' ) ) {
	class Zuperla_Testimonial_Post_Type {

		function __construct() {

			// Adds the testimonial post type and taxonomies
			$this->zuperla_ext_testimonial_init();

			// Manage Columns for testimonial overview
			add_filter( 'manage_edit-testimonial_columns',  array( &$this, 'zuperla_ext_testimonial_edit_columns' ) );
			add_action( 'manage_posts_custom_column', array( &$this, 'zuperla_ext_testimonial_custom_columns' ), 10, 2 );

		}

		function zuperla_ext_testimonial_init() {


			$labels = array(
				'name' => esc_html_x( 'Testimonial Items', 'Testimonial General Name', 'zuperla-extension' ),
				'singular_name' => esc_html_x( 'Testimonial Item', 'Testimonial Singular Name', 'zuperla-extension' ),
				'add_new' => esc_html__( 'Add New', 'zuperla-extension' ),
				'add_new_item' => esc_html__( 'Add New Testimonial Item', 'zuperla-extension' ),
				'edit_item' => esc_html__( 'Edit Testimonial Item', 'zuperla-extension' ),
				'new_item' => esc_html__( 'New Testimonial Item', 'zuperla-extension' ),
				'view_item' => esc_html__( 'View Testimonial Item', 'zuperla-extension' ),
				'search_items' => esc_html__( 'Search Testimonial Items', 'zuperla-extension' ),
				'not_found' =>  esc_html__( 'No Testimonial Items found', 'zuperla-extension' ),
				'not_found_in_trash' => esc_html__( 'No Testimonial Items found in Trash', 'zuperla-extension' ),
				'parent_item_colon' => '',
			);

			$category_labels = array(
				'name' => esc_html__( 'Testimonial Categories', 'zuperla-extension' ),
				'singular_name' => esc_html__( 'Testimonial Category', 'zuperla-extension' ),
				'search_items' => esc_html__( 'Search Testimonial Categories', 'zuperla-extension' ),
				'all_items' => esc_html__( 'All Testimonial Categories', 'zuperla-extension' ),
				'parent_item' => esc_html__( 'Parent Testimonial Category', 'zuperla-extension' ),
				'parent_item_colon' => esc_html__( 'Parent Testimonial Category:', 'zuperla-extension' ),
				'edit_item' => esc_html__( 'Edit Testimonial Category', 'zuperla-extension' ),
				'update_item' => esc_html__( 'Update Testimonial Category', 'zuperla-extension' ),
				'add_new_item' => esc_html__( 'Add New Testimonial Category', 'zuperla-extension' ),
				'new_item_name' => esc_html__( 'New Testimonial Category Name', 'zuperla-extension' ),
			);

			$args = array(
				'labels' => $labels,
				'public' => true,
				'publicly_queryable' => true,
				'show_ui' => true,
				'query_var' => true,
				'rewrite' => true,
				'capability_type' => 'post',
				'hierarchical' => false,
				'menu_position' => 5,
				'menu_icon' => 'dashicons-testimonial',
				'supports' => array( 'title', 'editor', 'author', 'thumbnail' ),
				'rewrite' => array( 'slug' => 'testimonial', 'with_front' => false ),
			  );

			register_post_type( 'testimonial' , $args );

			register_taxonomy(
				'testimonial_category',
				array( 'testimonial' ),
				array(
					'hierarchical' => true,
					'label' => esc_html__( 'Testimonial Categories', 'zuperla-extension' ),
					'labels' => $category_labels,
					'show_in_nav_menus' => false,
					'show_tagcloud' => false,
					'rewrite' => true,
				)
			);
			register_taxonomy_for_object_type( 'testimonial_category', 'testimonial' );

		}

		function zuperla_ext_testimonial_edit_columns( $columns ) {
			$columns['cb'] = "<input type=\"checkbox\" />";
			$columns['title'] = esc_html__( 'Title', 'zuperla-extension' );
			$columns['testimonial_thumbnail'] = esc_html__( 'Featured Image', 'zuperla-extension' );
			$columns['author'] = esc_html__( 'Author', 'zuperla-extension' );
			$columns['testimonial_category'] = esc_html__( 'Testimonial Categories', 'zuperla-extension' );
			$columns['date'] = esc_html__( 'Date', 'zuperla-extension' );
			return $columns;
		}

		function zuperla_ext_testimonial_custom_columns( $column, $post_id ) {

			switch ( $column ) {
				case "testimonial_thumbnail":
					if ( has_post_thumbnail( $post_id ) ) {
						$thumbnail_id = get_post_thumbnail_id( $post_id );
						$attachment_src = wp_get_attachment_image_src( $thumbnail_id, array( 80, 80 ) );
						$thumb = $attachment_src[0];
					} else {
						$thumb = get_template_directory_uri() . '/includes/images/no-image.jpg';
					}
					echo '<img class="attachment-80x80" width="80" height="80" alt="testimonial image" src="' . esc_url( $thumb ) . '">';
					break;
				case 'testimonial_category':
					echo get_the_term_list( $post_id, 'testimonial_category', '', ', ','' );
				break;
			}
		}

	}
	new Zuperla_Testimonial_Post_Type;
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
