<?php
/*
*	Area Item Post Type Registration
*
* 	@author		Euthemians Team
* 	@URI		http://euthemians.com
*/

if ( ! class_exists( 'Zuperla_Area_Post_Type' ) ) {
	class Zuperla_Area_Post_Type {

		function __construct() {

			// Adds the area post type and taxonomies
			$this->zuperla_ext_area_init();

			// Manage Columns for area overview
			add_filter( 'manage_edit-area_columns',  array( &$this, 'zuperla_ext_area_edit_columns' ) );

		}

		function zuperla_ext_area_init() {


			$labels = array(
				'name' => esc_html_x( 'Area Items', 'Area General Name', 'zuperla-extension' ),
				'singular_name' => esc_html_x( 'Area Item', 'Area Singular Name', 'zuperla-extension' ),
				'add_new' => esc_html__( 'Add New', 'zuperla-extension' ),
				'add_new_item' => esc_html__( 'Add New Area Item', 'zuperla-extension' ),
				'edit_item' => esc_html__( 'Edit Area Item', 'zuperla-extension' ),
				'new_item' => esc_html__( 'New Area Item', 'zuperla-extension' ),
				'view_item' => esc_html__( 'View Area Item', 'zuperla-extension' ),
				'search_items' => esc_html__( 'Search Area Items', 'zuperla-extension' ),
				'not_found' =>  esc_html__( 'No Area Items found', 'zuperla-extension' ),
				'not_found_in_trash' => esc_html__( 'No Area Items found in Trash', 'zuperla-extension' ),
				'parent_item_colon' => '',
			);

			$args = array(
				'labels' => $labels,
				'public' => true,
				'publicly_queryable' => true,
				'exclude_from_search' => true,
				'show_in_nav_menus' => false,
				'show_ui' => true,
				'query_var' => true,
				'rewrite' => true,
				'capability_type' => 'post',
				'hierarchical' => false,
				'menu_position' => 5,
				'menu_icon' => 'dashicons-media-text',
				'supports' => array( 'title', 'editor', 'author', 'thumbnail' ),
				'rewrite' => array( 'slug' => 'area-item', 'with_front' => false ),
			  );

			register_post_type( 'area-item' , $args );


		}

		function zuperla_ext_area_edit_columns( $columns ) {
			$columns['cb'] = "<input type=\"checkbox\" />";
			$columns['title'] = esc_html__( 'Title', 'zuperla-extension' );
			$columns['author'] = esc_html__( 'Author', 'zuperla-extension' );
			$columns['date'] = esc_html__( 'Date', 'zuperla-extension' );
			return $columns;
		}

	}
	new Zuperla_Area_Post_Type;
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
